import { check_permission } from '../v1.0.0/models/UserModel';
import sendResponse from '../services/response';

export const check_admin_permission = (type,permission) => {
    return (req, res, next) => {
        const body = req.body;
        if(req.headers.usertype == 'admin'){
            check_permission(body).then((result: any) => {
                const permissions = result.data.rows
                //console.log(permissions)
                const value = permissions.filter(element => element.module_name == type)
                if (value[0][permission])
                    next()
                else
                    sendResponse(res, 400, 0, 'Permission denied', {}, '')
            }).catch(error => sendResponse(res, error.code, 0, error.message, error.data, ''))
        }else next()
    }
};