import sendResponse from '../services/response';
import { get_user_status } from '../v1.0.0/models/UserModel';

export const decodeJWT = () => {
    return (req, res, next) => {
        //check user have permission
        // console.log(res.user)
        get_user_status(req.user.userid).then(status => {
            if (status == 0) {
                sendResponse(res, 400, 0, 'Permission denied', {}, '')
            } else {
                if (req.user.hasOwnProperty('userid')) {
                    if (req.route.methods.hasOwnProperty("post") || req.route.methods.hasOwnProperty("put")) {
                        req.body['userid'] = req.user.userid;
                    }
                    else if (req.route.methods.hasOwnProperty("get") || req.route.methods.hasOwnProperty("delete")) {
                        req.query['userid'] = req.user.userid;
                        req.body['userid'] = req.user.userid;
                    }
                }
                next();
            }
        })
    }
};