/* import * as azureStorage from 'azure-storage'; */
var azureStorage = require('azure-storage');
import * as security_config from '../config/security-config';
import { deleteMedicalRecordsFromDb } from '../v1.0.0/models/ExpertPatientModel';
const { StorageSharedKeyCredential,
    generateBlobSASQueryParameters,
    BlobSASPermissions, SASProtocol, ContainerSASPermissions } = require("@azure/storage-blob");
const sharedKeyCredential = new StorageSharedKeyCredential(security_config.BLOB_STORAGE_ACCOUNT, security_config.BLOB_STORAGE_KEY);

export let blobStorageUploadImage = (body) => {
    return new Promise((resolve, reject) => {
        const blobService = azureStorage.createBlobService(security_config.BLOB_STORAGE_ACCOUNT, security_config.BLOB_STORAGE_KEY);
        let buffer = Buffer.from(body.data, 'base64');
        blobService.createBlockBlobFromText(body.containerName, body.blobName, buffer, (error, result, response) => {
            if (!error) {
                console.log(result.name + ' uploaded to ' + result.container + ' successfully');
                resolve(result)
            }
            else {
                console.log('error: ' + error);
                reject(error)
            }
        });
    })
}

export let blobStorageTempUrl = (body) => {
    return new Promise((resolve, reject) => {
        try {
            const blobService = azureStorage.createBlobService(security_config.BLOB_STORAGE_ACCOUNT, security_config.BLOB_STORAGE_KEY);
            const startDate = new Date();
            const expiryDate = new Date(startDate);
            expiryDate.setMinutes(startDate.getMinutes() + 60);
            startDate.setMinutes(startDate.getMinutes() - 5);
            const sharedAccessPolicy = {
                AccessPolicy: {
                    Permissions: azureStorage.BlobUtilities.SharedAccessPermissions.READ,
                    Start: startDate,
                    Expiry: expiryDate
                }
            };
            const token = blobService.generateSharedAccessSignature(body.containerName, body.blobName, sharedAccessPolicy);
            resolve(blobService.getUrl(body.containerName, body.blobName, token));
        } catch (e) {
            reject(e)
        }
    })
}


export const mediaUploadBlobStorage = (file, containerName, blobName) => {
    return new Promise((resolve, reject) => {
        const blobService = azureStorage.createBlobService(security_config.BLOB_STORAGE_ACCOUNT, security_config.BLOB_STORAGE_KEY);
        //let buffer = Buffer.from(body.data, 'base64');
        let buffer = Buffer.from(file.data)
        //blobService.createBlockBlobFromText(body.containerName, body.blobName, buffer, (error, result, response) => {
        blobService.createBlockBlobFromText(containerName, blobName, buffer, (error, result, response) => {
            if (!error) {
                console.log(result.name + ' uploaded to ' + result.container + ' successfully');
                resolve(result)
            }
            else {
                console.log('error: ' + error);
                reject(error)
            }
        });
    })
}

export let getSESToken = (_body) => {
    return new Promise(async (resolve, reject) => {
        try {
            var permissions = azureStorage.BlobUtilities.SharedAccessPermissions.READ +
                azureStorage.BlobUtilities.SharedAccessPermissions.WRITE;

            const sasToken = await generateSasToken(_body.containerName, _body.blobName, permissions);
            //const sasToken = await generateSasToken(_body.containerName, _body.blobName, "rawcdl");
            resolve(sasToken);
        } catch (e) {
            console.log(e)
            reject(e)
        }
    })
}

export let deleteMedicalRecords = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            try {
                const blobService = azureStorage.createBlobService(security_config.BLOB_STORAGE_ACCOUNT, security_config.BLOB_STORAGE_KEY);
                _body.blobNames.forEach(blobName => {
                    console.log(blobName)
                    blobService.deleteBlobIfExists('medical-records', blobName, (err, result) => {
                        if (err) {
                            console.log(err);
                            resolve("fail");
                        } else {
                            console.log("Medical record was deleted successfully.");
                            resolve("success");
                        }
                    });
                });
            } catch (e) {
                reject(e)
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export let generateSasToken = (container, blobName, permissions) => {
    return new Promise((resolve, reject) => {
        try {
            //var AzureWebJobsStorage = "DefaultEndpointsProtocol=https;AccountName=mhmstorage;AccountKey=yQfWx4lS4mQYJxGZErbeCKcZMjEdU3X10NHpk1lfmg/kRoOJQiQKmvUnQsiTtuhStzUQB4PiL9cbCh0j8tjNRw=="
            var blobService = azureStorage.createBlobService(security_config.BLOB_STORAGE_ACCOUNT, security_config.BLOB_STORAGE_KEY);
            //var blobService = azureStorage.createBlobService(AzureWebJobsStorage);

            // Create a SAS token that expires in an hour
            // Set start time to five minutes ago to avoid clock skew.
            var startDate = new Date();
            startDate.setMinutes(startDate.getMinutes() - 5);
            var expiryDate = new Date(startDate);
            expiryDate.setMinutes(startDate.getMinutes() + 60);

            permissions = permissions || azureStorage.BlobUtilities.SharedAccessPermissions.READ;

            var sharedAccessPolicy = {
                AccessPolicy: {
                    ServiceVersion: '2019-02-02',
                    Permissions: permissions,
                    Start: startDate,
                    Expiry: expiryDate
                }
            };

            var sasToken = blobService.generateSharedAccessSignature(container, blobName, sharedAccessPolicy);
            console.log(sasToken)
            resolve(sasToken)
            /*  return {
                 token: sasToken,
                 uri: blobService.getUrl(container, blobName, sasToken, true)
             }; */
        } catch (e) {
            reject(e)
        }
    })
}