const nodemailer = require('nodemailer');
import { add_logs } from '../v1.0.0/models/LogModel';

let transporter = nodemailer.createTransport({
    host: process.env.MAIL_HOST,
    port: process.env.MAIL_PORT,
    secure: false, // true for 465, false for other ports
    auth: {
        user: process.env.MAIL_USERNAME, // generated ethereal user
        pass: process.env.MAIL_PASSWORD // generated ethereal password
    }
});

// Send Email d
export const send_email = (email, subject, text) => {
    var mailOptions = {
        from: 'admin@myhealingmate.com',
        to: email,
        cc: process.env.CC_MAIL,
        subject: subject,
        html: text,

    };
    transporter.sendMail(mailOptions, function (error, info) {
        if (error) {
            add_logs('Email Failed', { "email": email, "subject": subject, "message": error }, 'Email', 0)
            console.log(error + 'Error in Email sending');
        } else {
            add_logs('Email Success', { "email": email, "subject": subject, "message": info.response }, 'Email', 0)
            console.log(info.response + 'Email sent successfully');
        }
    });
}