import * as admin from 'firebase-admin';
// // var serviceAccount = require("../config/serviceAccountKey");
import serviceAccountKey from '../config/serviceAccountKey';

const serviceAccount = {
  project_id: serviceAccountKey.project_id,
  client_email: serviceAccountKey.client_email,
  privateKey: serviceAccountKey.private_key,
  client_id: serviceAccountKey.client_id,
  private_key_id: serviceAccountKey.private_key_id
}

admin.initializeApp({
  credential: admin.credential.cert(serviceAccount),
  databaseURL: "https://mhm-test-179e8-default-rtdb.firebaseio.com"
});

// // var app = admin.initializeApp();

// export const sendFirebaseNotification = async(message) => {
//   return new Promise((resolve, reject) => {
//     console.log("_________");
//     admin.messaging().send(message)
//       .then((response) => {
//         resolve({ code: 200, message: "Successfully sent message:", data: response });
//       })
//       .catch((error) => {
//         reject({ code: 400, message: "Error sending message", data: error });
//       });
//   })
// }

export const listenForNotificationRequests = async () => {
  let ref = admin.database().ref();
  var requests = ref.child('notificationRequests');
  requests.on('child_added', function(requestSnapshot) {
    var request = requestSnapshot.val();
    console.log('firebase chat request',request)
    requestSnapshot.ref.remove();
    ;
  }, function(error) {
    console.error(error);
  });
};

export const sendFirebaseNotification = async (message) => {
  return new Promise((resolve, reject) => {
    (async () => {
      try {
        console.log("_________");
        admin.messaging().send(message)
          .then((response) => {
            console.log("+++++++");
            resolve({ code: 200, message: "Successfully sent message:", data: response });
          })
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}