import { GraphQLClient, gql } from 'graphql-request';
/*
** This method returns a promise
** which gets resolved or rejected based
** on the result from the API
*/

export const get_Artical_Video_CMS = async (url: string, condition: string) => {
    let query = gql`query Conditions($cond: String) {
    conditions(where: {title: $cond}) {
        title
        type
        categories {
            id
            title
            sub_title
            articles {
                id
                title
                description
                featured
                published_at
            }
            videos {
                id
                title
                description
                url
                published_at
            }
        }
      }
    }`
    let variables = {
        "cond": condition
    }
    const client = new GraphQLClient(process.env.STRAPI_URL + '/graphql', { headers: {} })
    let data = await client.request(query, variables);
    return data;
}