import * as security_config from '../config/security-config';
import * as sendGrid from '@sendgrid/mail';
import { ByocTrunkContext } from 'twilio/lib/rest/voice/v1/byocTrunk';

sendGrid.setApiKey(security_config.SENDGRID_APIKEY);

export let sendGridEmail = async (body) => {
    let templates = {
        invite_admin: security_config.INVITE_ADMIN,
        otp_mail: security_config.SEND_OTP,
        mhm_registration: security_config.MHM_REGISTRATION,
        invite: security_config.INVITE,
    };
    const emailOptions = {
        to: body.to,
        from: 'admin@myhealingmate.com',
        templateId: templates[body.templateName],
        dynamic_template_data: {
            set_password_url: body.set_password_url,
            description: body.description,
            button_label: body.button_label,
            title: body.title,
            otp: body.otp,
            name:body.name
        }
    };
    try {
        let data = await sendGrid.send(emailOptions);
    } catch (error) {
        console.log("Error ", error)
        throw new Error(error)
    }
}