1
export default {
    "securitySchemes": {
        "bearerAuth": {
            "type": 'http',
            "scheme": 'bearer',
            "bearerFormat": 'JWT',
            "name": "Authorization"
        }
    },
    "schemas": {
        "LIST_EXPERTS": {
            "required": [
            ],
            "properties": {

            },
            "example": {
            }
        },
        "LIST_EXPERT_DETAILS": {
            "required": [
                "expertId"
            ],
            "properties": {
                "expertId": {
                    "type": "integer"
                }
            },
            "example": {
                "expertId": 346
            }
        },
        "LIST_PHYSICIAN_AVAILABLE_TIME": {
            "required": [
                "physicianId",
                "dateTimeStamp"
            ],
            "properties": {
                "physicianId": {
                    "type": "number"
                },
                "dateTimeStamp": {
                    "type": "string"
                }
            },
            "example": {
                "physicianId": 5,
                "dateTimeStamp": "1624336800"
            }
        },
        "BOOK_APPOINTMENT": {
            "required": [
                "patientID",
                "physicianID",
                "appointmentTimestamp",
                "disease",
                "physicianTimeManagementId"

            ],
            "properties": {
                "patientID": {
                    "type": "number"
                },
                "physicianID": {
                    "type": "number"
                },
                "appointmentTimestamp": {
                    "type": "string"
                },
                "disease": {
                    "type": "string"
                },
                "physicianTimeManagementId": {
                    "type": "string"
                }
            },
            "example": {
                "patientID": 347,
                "physicianID": 348,
                "appointmentTimestamp": 1622446893,
                "disease": "heartache",
                "physicianTimeManagementId": 1
            }
        },
        "RESCHEDULE_APPOINTMENT_BY_PATIENT": {
            "required": [
                "consultationRequestId",
                "appointmentTimestamp",
                "physicianTimeManagementId"

            ],
            "properties": {
                "consultationRequestId": {
                    "type": "number"
                },
                "appointmentTimestamp": {
                    "type": "number"
                },
                "physicianTimeManagementId": {
                    "type": "number"
                }
            },
            "example": {
                "consultationRequestId": 5,
                "appointmentTimestamp": 1622112667,
                "physicianTimeManagementId": 4

            }
        },
        "CANCEL_APPOINTMENT_BY_PATIENT": {
            "required": [
                "consultationRequestId",
                "requestRejectReasonid",
                "before24hours"

            ],
            "properties": {
                "consultationRequestId": {
                    "type": "number"
                },
                "requestRejectReasonid": {
                    "type": "string"
                },
                "before24hours": {
                    "type": "boolean",
                }
            },
            "example": {
                "consultationRequestId": 5,
                "requestRejectReasonid": 1,
                "before24hours": true
            }
        },
        "UPCOMING_APPOINTMENTS_BY_PATIENT": {
            "required": [
            ],
            "properties": {
            },
            "example": {
            }
        },
        "INITIATE_PAYMENT": {
            "required": [
                "amount",
                "currency",
                "description",
                "appointmentId",
                "userType",
                "patientFirstName",
                "patientLastName",
                "patientDob",
                "careGiverFirstName",
                "careGiverLastName",
                "relationship"
            ],
            "properties": {
                "amount": {
                    "type": "number"
                },
                "currency": {
                    "type": "number"
                },
                "description": {
                    "type": "string",
                },
                "appointmentId": {
                    "type": "string",
                },
                "userType": {
                    "type": "string",
                },
                "patientFirstName": {
                    "type": "string",
                },
                "patientLastName": {
                    "type": "string",
                },
                "patientDob": {
                    "type": "number",
                },
                "careGiverFirstName": {
                    "type": "string",
                },
                "careGiverLastName": {
                    "type": "string",
                },
                "relationship": {
                    "type": "string",
                },
            },
            "example": {
                "amount": 100,
                "currency": "INR",
                "description": "xxsdd",
                "appointmentId": 129,
                "userType": "caregiver",
                "patientFirstName": "Jhon",
                "patientLastName": "Amith",
                "patientDob": "09.08.2002",
                "careGiverFirstName": "Jake",
                "careGiverLastName": "Gyllenhall",
                "relationship": "uncle"
            }
        },
        "GET_PATIENT_MEDICAL_RECORDS": {
            "required": [

            ],
            "properties": {

            },
            "example": {

            }
        },
        "MEMBER_CONDITIONS": {
            "required": [
                "condition",
                "limit",
                "offset"
            ],
            "properties": {
                "limit": {
                    "type": "number"
                },
                "condition": {
                    "type": "string"
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "consultationRequestId": 5,
                "requestRejectReasonid": 1,
                "before24hours": true
            }
        },
        "RESET_FIREBASETOKEN": {
            "required": [
                "userId",
                "oldToken",
                "newToken"
            ],
            "properties": {
                "userId": {
                    "type": "number"
                },
                "oldToken": {
                    "type": "string"
                },
                "newToken": {
                    "type": "string",
                }
            },
            "example": {
                "userId": 366,
                "oldToken": "oldToken",
                "newToken": "newToken"
            }
        },
        "PAST_APPOINTMENTS_BY_PATIENT": {
            "required": [

            ],
            "properties": {

            },
            "example": {

            }
        },
        "SAVE_MEDICAL_REPORTS": {
            "required": [
                "medical_records",
                "record_types"
            ],
            "properties": {
                "consultationRequestId": {
                    "type": "number"
                },
                "requestRejectReasonid": {
                    "type": "string"
                },
                "before24hours": {
                    "type": "boolean",
                }
            },
            "example": {
                "medical_records": ["medical-records/MRI_Scan.jpg", "medical-records/X-ray_report.pdf"],
                "record_types": ["report", "prescription"]

            }
        },
        "FEEDBACK": {
            "required": [
                "feedback",
                "feedback_type",
                "appointment_id"
            ],
            "properties": {
                "feedback": {
                    "type": "string"
                },
                "feedback_type": {
                    "type": "string"
                },
                "appointment_id": {
                    "type": "number",
                }
            },
            "example": {
                "feedback": "Good call",
                "feedback_type": "feedback",
                "appointment_id": 20
            }
        },
        "GETSESTOKEN": {
            "required": [
                "containerName",
                "blobName"

            ],
            "properties": {
                "containerName": {
                    "type": "string"
                },
                "blobName": {
                    "type": "string"
                }
            },
            "example": {
                "containerName": "medical-records",
                "blobName": "medical-records/124.pdf"
            }
        },
        "DELETE_MEDICAL_RECORDS": {
            "required": [
                "blobNames",
                "record_ids"
            ],
            "properties": {
                "blobNames": {
                    "type": "string"
                },
                "record_ids": {
                    "type": "number"
                }
            },
            "example": {
                "blobNames": ["medical-records/s1_copy.pdf", "medical-records/49_copy.pdf"],
                "record_ids": [1, 2]
            }
        },
        "INSTANT_REFUND": {
            "required": [
                "consultationRequestId"
            ],
            "properties": {
                "consultationRequestId": {
                    "type": "number"
                }
            },
            "example": {
                "consultationRequestId": 260
            }
        },
        "REFUND_OR_REPORT": {
            "required": [
                "appointmentId",
                "reason",
                "type"
            ],
            "properties": {
                "appointmentId": {
                    "type": "NUMBER"
                },
                "reason": {
                    "type": "string"
                },
                "type": {
                    "type": "string",
                }
            },
            "example": {
                "appointmentId": 260,
                "reason": "My consultation was not completed",
                "type": "refund"
            }
        },
        "START_CONSULTATION_PATIENT": {
            "required": [
                "appointmentid",
                "type"
            ],
            "properties": {
                "appointmentid": {
                    "type": "number"
                },
                "type": {
                    "type": "string"
                }
            },
            "example": {
                "appointmentid": 7,
                "type": "video"
            }
        },
        "END_CALL_BY_PATIENT": {
            "required": [
                "appointmentid"
            ],
            "properties": {
                "appointmentid": {
                    "type": "number"
                }
            },
            "example": {
                "appointmentid": 7
            }
        },
        "ADD_MEDICAL_REPORTS_TO_CONSULTATION": {
            "required": [
                "consultationRequestId",
                "medical_records"
            ],
            "properties": {
                "consultationRequestId": {
                    "type": "number"
                },
                "medical_records": {
                    "type": "string"
                }
            },
            "example": {
                "consultationRequestId": 337,
                "medical_records": [
                    "medical-records/MRI_Scan.jpg",
                    "medical-records/X-ray_report.pdf",
                    "medical-records/scan6.pdf"
                ]

            }
        },
        "IMAGETEMPURL": {
            "required": [
                "containerName",
                "blobName"
            ],
            "properties": {
                "containerName": {
                    "type": "string"
                },
                "blobName": {
                    "type": "string"
                }
            },
            "example": {
                "containerName": "private",
                "blobName": "prescription/2580a36e-8626-4f71-9b44-15b47f98fa39.pdf"

            }
        },
        "PAST_APPOINTMENT_DETAILS": {
            "required": [
                "appointmentId"
            ],
            "properties": {
                "appointmentId": {
                    "type": "number",
                }
            },
            "example": {
                "appointmentId": 18
            }
        },
        "DISCONNECTED_CALL_DATA": {
            "required": [
                "appointmentid",
                "user_type",
                "Call_end_time"
            ],
            "properties": {
                "user_type": {
                    "type": "string"
                },
                "Call_end_time": {
                    "type": "string"
                },
                "appointmentid": {
                    "type": "number",
                }
            },
            "example": {
                "appointmentid": 9,
                "user_type": "patient",
                "Call_end_time": "1627560874"
            }
        },
        "EDIT_MEDICAL_REPORTS": {
            "required": [
                "record_id",
                "record_type"
            ],
            "properties": {
                "record_id": {
                    "type": "number"
                },
                "record_type": {
                    "type": "string"
                }
            },
            "example": {
                "record_id": 1,
                "record_type": "prescription"

            }
        },
        "VIEW_REFUND_STATUS": {
            "required": [
                "appointmentId"

            ],
            "properties": {
                "appointmentId": {
                    "type": "number",
                }
            },
            "example": {
                "appointmentId": 664
            }
        },
        "GET_PATIENT_RECORDS_FOR_CONSULT": {
            "required": [
                "consultationId"
            ],
            "properties": {
                "consultationId": {
                    "type": "number",
                }
            },
            "example": {
                "consultationId": 6

            }
        },
        "ADD_CLINIC": {
            "required": [
                "clinicName",
                "clinicType",
                "address",
                "streetName",
                "cityName",
                "districtName",
                "state",
                "zipCode",
                "Mhm_fee_percent",
                "tax_percentage",
                "clinicImages",
                "clinicLogo",
                "location",
                "descriptiion",
                "manager"

            ],
            "properties": {
                "clinicName": {
                    "type": "number",
                },
                "clinicType": {
                    "type": "string",
                },
                "address": {
                    "type": "string",
                },
                "streetName": {
                    "type": "string",
                },
                "cityName": {
                    "type": "string",
                },
                "districtName": {
                    "type": "string",
                },
                "state": {
                    "type": "string",
                },
                "zipCode": {
                    "type": "number",
                },
                "Mhm_fee_percent": {
                    "type": "number",
                },
                "clinicImages": {
                    "type": "string",
                },
                "tax_percentage": {
                    "type": "number",
                },
                "clinicLogo": {
                    "type": "string",
                },
                "location": {
                    "type": "number",
                },
                "descriptiion": {
                    "type": "string",
                },
                "phone": {
                    "type": "number",
                },
                "manager": {
                    "type": "number",
                }
            },
            "example": {
                "clinicName": "Vivek Clinic",
                "clinicType": "General",
                "address": "TestClinic",
                "streetName": "Street",
                "cityName": "City",
                "districtName": "Kochi",
                "state": "Kerala",
                "zipCode": 123456,
                "Mhm_fee_percent": 15,
                "tax_percentage": 15,
                "countryId": 1,
                "clinicImages": [
                    "GP-education.jpg"
                ],
                "clinicLogo": "6e5ae5a153d13b789b170c0edf9fc1d8.png",
                "location": {
                    "latitude": 9.59175,
                    "longitude": 76.53191
                },
                "descriptiion": "test description",
                "phone": "+919995848050",
                "manager": {
                    "email": "sreerag.dileep+123@cabotsolutions.com",
                    "firstName": "Sreerag",
                    "lastName": "Dileep",
                    "gender": "male",
                    "dob": "1996-06-15",
                    "phone": "+919995848050",
                    "countryId": 1,
                    "profileImage": "profileimage.jpg"
                }
            }
        },
        "ADD_MANAGER": {
            "required": [
                "email",
                "firstName",
                "lastName",
                "gender",
                "dob",
                "phone",
                "countryId",
                "profileImage",
                "clinicId"
            ],
            "properties": {
                "email": {
                    "type": "string",
                },
                "firstName": {
                    "type": "string",
                },
                "lastName": {
                    "type": "string",
                },
                "gender": {
                    "type": "string",
                },
                "dob": {
                    "type": "number",
                },
                "phone": {
                    "type": "string",
                },
                "countryId": {
                    "type": "number",
                },
                "profileImage": {
                    "type": "string",
                },
                "clinicId": {
                    "type": "number",
                }
            },
            "example": {
                "email": "sreerag.dileep+143@cabotsolutions.com",
                "firstName": "Sreerag",
                "lastName": "Dileep",
                "gender": "male",
                "dob": "1996-06-15",
                "phone": "+919994448050",
                "countryId": 1,
                "profileImage": "profileimage.jpg",
                "clinicId": 2

            }
        },
        "EXPERT_SIGNIN": {
            "required": [
                "email",
                "password",
                "userType",
                "firebase_token"
            ],
            "properties": {
                "email": {
                    "type": "string"
                },
                "password": {
                    "type": "string",
                    "minLength": 3,
                    "maxLength": 30
                },
                "firebase_token": {
                    "type": "string"
                },
                "userType": {
                    "type": "string",
                    "enum": [
                        "physician",
                        "manager",
                    ]
                }
            },
            "examples": {
                "physician": {
                    "value": {
                        "email": "joe.george@cabotsolutions.com",
                        "password": "Password",
                        "userType": "physician",
                        "firebase_token": "asfashbausvaubsuyasbahsbabsuabia"
                    }
                },
                "manager": {
                    "value": {
                        "email": "joe.george@cabotsolutions.com",
                        "password": "Password",
                        "userType": "manager",
                        "firebase_token": "asfashbausvaubsuyasbahsbabsuabia"
                    }
                },
            }
        },
        "LIST_CLINICDETAILS": {
            "required": [
                "clinicId"
            ],
            "properties": {
                "clinicId": {
                    "type": "number",
                }
            },
            "example": {
                "clinicId": 6
            }
        },
        "EDIT_CLINICDETAILS": {
            "required": [
                "clinic_id",
                "clinicLogo",
                "description",
                "MhmTaxPercent",
                "TaxPercent"

            ],
            "properties": {
                "clinic_id": {
                    "type": "number",
                },
                "clinicLogo": {
                    "type": "string",
                },
                "description": {
                    "type": "string",
                },
                "MhmTaxPercent": {
                    "type": "number",
                },
                "TaxPercent": {
                    "type": "number",
                }
            },
            "example": {
                "clinic_id": 7,
                "clinicLogo": "logodummy.jpg",
                "description": "test description",
                "MhmTaxPercent": 15,
                "TaxPercent": 15
            }
        },
        "EXPERT_FORGOTPASSWORD": {
            "required": [
                "email",
                "userType"

            ],
            "properties": {
                "email": {
                    "type": "string",
                },
                "userType": {
                    "type": "string",
                }
            },
            "example": {
                "physician": {
                    "value": {
                        "email": "joe.george@cabotsolutions.com",
                        "userType": "physician"
                    }
                },
                "manager": {
                    "value": {
                        "email": "joe.george@cabotsolutions.com",
                        "userType": "manager"
                    }
                },
            }
        },
        "EXPERT_CHANGEPASSWORD": {
            "required": [
                "userid",
                "currentPassword",
                "newPassword",
                "confirmPassword"

            ],
            "properties": {
                "userid": {
                    "type": "number",
                },
                "currentPassword": {
                    "type": "string",
                },
                "newPassword": {
                    "type": "string",
                },
                "confirmPassword": {
                    "type": "string",
                }
            },
            "example": {
                "userid": "2",
                "currentPassword": "Password@2",
                "newPassword": "Password@",
                "confirmPassword": "Password@1"
            }
        },
        "ADD_DEPARTMENT": {
            "required": [
                "clinicId",
                "departmentType",
                "departmentName",
                "departmentDescription",
                "departmentIndexId",
                "departmentImages",
                "departmentLogo"
            ],
            "properties": {
                "clinicId": {
                    "type": "number",
                },
                "departmentType": {
                    "type": "string",
                },
                "departmentDescription": {
                    "type": "string",
                },
                "departmentIndexId": {
                    "type": "number",
                },
                "departmentImages": {
                    "type": "string",
                },
                "departmentLogo": {
                    "type": "string",
                }
            },
            "example": {
                "clinicId": 1,
                "departmentType": "open",
                "departmentName": "Test department",
                "departmentDescription": "Test department",
                "departmentIndexId": 2,
                "departmentImages": ["dummyimage.jpg"],
                "departmentLogo": "dummylogo.jpg"

            }
        },
        "ADD_PHYSICIAN": {
            "required": [
                "email",
                "firstName",
                "lastName",
                "gender",
                "dob",
                "phone",
                "departmentId",
                "profile_image",
                "qualification",
                "experience",
                "registraionNumber",
                "registraionCouncil",
                "registraionYear",
                "specialisation",
                "speciality",
                "medicalSchool",
                "address1",
                "address2",
                "state",
                "pincode",
                "firstVisitPay",
                "followUpPay",
                "expertDocument",
                "consultationDuration"

            ],
            "properties": {
                "email": {
                    "type": "string",
                },
                "firstName": {
                    "type": "string",
                },
                "lastName": {
                    "type": "string",
                },
                "gender": {
                    "type": "string",
                },
                "dob": {
                    "type": "number",
                },
                "phone": {
                    "type": "number",
                },
                "departmentId": {
                    "type": "string",
                },
                "profile_image": {
                    "type": "string",
                },
                "qualification": {
                    "type": "string",
                },
                "experience": {
                    "type": "number",
                },
                "registraionNumber": {
                    "type": "number",
                },
                "registraionCouncil": {
                    "type": "string",
                },
                "registraionYear": {
                    "type": "string",
                },
                "specialisation": {
                    "type": "string",
                },
                "speciality": {
                    "type": "string",
                },
                "medicalSchool": {
                    "type": "string",
                },
                "address1": {
                    "type": "string",
                },
                "address2": {
                    "type": "string",
                },
                "state": {
                    "type": "string",
                },
                "pincode": {
                    "type": "number",
                },
                "firstVisitPay": {
                    "type": "number",
                },
                "followUpPay": {
                    "type": "number",
                },
                "expertDocument": {
                    "type": "string",
                },
                "consultationDuration": {
                    "type": "number",
                }
            },
            "example": {
                "email": "sreerag.dileep+909@cabotsolutions.com",
                "firstName": "Hamsa",
                "lastName": "Koya",
                "gender": "male",
                "dob": "1996-06-15",
                "phone": "1234567890",
                "departmentId": 1,
                "profile_image": "dummy.jpg",
                "qualification": "MBBS",
                "experience": 3,
                "registraionNumber": "ID256",
                "registraionCouncil": "Registration Council",
                "registraionYear": "2000",
                "specialisation": "General Surgery",
                "speciality": "Radiation Oncology",
                "medicalSchool": "Maharashtra Medical college",
                "address1": "Healtour clinic",
                "address2": "Aarthi rd, Mumbai",
                "state": "Navi Mumbai",
                "pincode": 685965,
                "firstVisitPay": 600,
                "followUpPay": null,
                "expertDocument": "test document.txt",
                "consultationDuration": 30
            }
        },
        "GET_PHYSICIAN_DETAILS_BY_ID": {
            "required": [
                "userId"
            ],
            "properties": {
                "userId": {
                    "type": "number",
                }
            },
            "example": {
                "userId": 19
            }
        },
        "LIST_EXPERTS_BY_DEPARTMENT": {
            "required": [
                "departmentId",
                "limit",
                "offset"
            ],
            "properties": {
                "departmentId": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "departmentId": 1,
                "limit": 2,
                "offset": 0
            }
        },
        "LIST_DEPARTMENTINDICES": {
            "required": [
            ],
            "properties": {

            },
            "example": {
            }
        },
        "LIST_DEPARTMENTS_BY_CLINIC": {
            "required": [
                "clinicId",
                "limit",
                "offset",
                "search_key"

            ],
            "properties": {
                "clinicId": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "search_key": {
                    "type": "string",
                }
            },
            "example": {
                "clinicId": 1,
                "limit": 2,
                "offset": 0,
                "search_key": "ent"
            }
        },
        "LIST_EXPERTS_BY_CLINIC": {
            "required": [
                "clinicId",
                "limit",
                "offset",
                "search_key"
            ],
            "properties": {
                "clinicId": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "search_key": {
                    "type": "string",
                }
            },
            "example": {
                "clinicId": 2,
                "limit": 10,
                "offset": 0,
                "search_key": "x"
            }
        },
        "UPDATE_EXPERT_BIO": {
            "required": [
                "expertId",
                "bio",
                "sign"
            ],
            "properties": {
                "expertId": {
                    "type": "number",
                },
                "bio": {
                    "type": "string",
                },
                "sign": {
                    "type": "string",
                }
            },
            "example": {
                "expertId": 342,
                "bio": "dummy bio",
                "sign": "dummysign.jpg"
            }
        },
        "UPDATE_EXPERT_ADDRESS": {
            "required": [
                "expertId",
                "address_line1",
                "address_line2",
                "state_name",
                "pincode"

            ],
            "properties": {
                "expertId": {
                    "type": "number",
                },
                "address_line1": {
                    "type": "string",
                },
                "address_line2": {
                    "type": "string",
                },
                "state_name": {
                    "type": "string",
                },
                "pincode": {
                    "type": "number",
                }
            },
            "example": {
                "expertId": 342,
                "address_line1": "Vivek's Clinic",
                "address_line2": "peringotukara, Thrissur",
                "state_name": "Kerala",
                "pincode": "680565"

            }
        },
        "UPDATE_PROFILE_IMAGE": {
            "required": [
                "expertId",
                "profile_image"
            ],
            "properties": {
                "expertId": {
                    "type": "number",
                },
                "profile_image": {
                    "type": "string",
                }
            },
            "example": {
                "expertId": 342,
                "profile_image": "newProfile.jpg"
            }
        },
        "EDIT_PHYSICIAN": {
            "required": [
                "expertId",
                "email",
                "firstName",
                "lastName",
                "gender",
                "dob",
                "phone",
                "departmentId",
                "profile_image",
                "qualification",
                "experience",
                "registraionNumber",
                "registraionCouncil",
                "registraionYear",
                "specialisation",
                "speciality",
                "medicalSchool",
                "address1",
                "address2",
                "state",
                "pincode",
                "firstVisitPay",
                "followUpPay",
                "expertDocument",
                "consultationDuration"

            ],
            "properties": {
                "email": {
                    "type": "string",
                },
                "firstName": {
                    "type": "string",
                },
                "lastName": {
                    "type": "string",
                },
                "gender": {
                    "type": "string",
                },
                "dob": {
                    "type": "number",
                },
                "phone": {
                    "type": "number",
                },
                "departmentId": {
                    "type": "string",
                },
                "profile_image": {
                    "type": "string",
                },
                "qualification": {
                    "type": "string",
                },
                "experience": {
                    "type": "number",
                },
                "registraionNumber": {
                    "type": "number",
                },
                "registraionCouncil": {
                    "type": "string",
                },
                "registraionYear": {
                    "type": "string",
                },
                "specialisation": {
                    "type": "string",
                },
                "speciality": {
                    "type": "string",
                },
                "medicalSchool": {
                    "type": "string",
                },
                "address1": {
                    "type": "string",
                },
                "address2": {
                    "type": "string",
                },
                "state": {
                    "type": "string",
                },
                "pincode": {
                    "type": "number",
                },
                "firstVisitPay": {
                    "type": "number",
                },
                "followUpPay": {
                    "type": "number",
                },
                "expertDocument": {
                    "type": "string",
                },
                "consultationDuration": {
                    "type": "number",
                },
                "expertId": {
                    "type": "number",
                }
            },
            "example": {
                "expertId": 340,
                "email": "sreerag.dileep+909@cabotsolutions.com",
                "firstName": "Hamsa",
                "lastName": "Koya",
                "gender": "male",
                "dob": "1996-06-15",
                "phone": "1234567890",
                "departmentId": 1,
                "profile_image": "dummy.jpg",
                "qualification": "MBBS",
                "experience": 3,
                "registraionNumber": "ID256",
                "registraionCouncil": "Registration Council",
                "registraionYear": "2000",
                "specialisation": "General Surgery",
                "speciality": "Radiation Oncology",
                "medicalSchool": "Maharashtra Medical college",
                "address1": "Healtour clinic",
                "address2": "Aarthi rd, Mumbai",
                "state": "Navi Mumbai",
                "pincode": 685965,
                "firstVisitPay": 600,
                "followUpPay": null,
                "expertDocument": "test document.txt",
                "consultationDuration": 30
            }
        },
        "DELETE_PHYSICIAN": {
            "required": [
                "expertId"
            ],
            "properties": {
                "expertId": {
                    "type": "number",
                }
            },
            "example": {
                "expertId": 340
            }
        },
        "LIST_PATIENTS_BY_EXPERT_ID": {
            "required": [
                "expertId",
                "limit",
                "offset",
                "search_key"
            ],
            "properties": {
                "expertId": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "search_key": {
                    "type": "string",
                }
            },
            "example": {
                "expertId": 340,
                "limit": 2,
                "offset": 0,
                "search_key": "j"
            }
        },
        "GET_PHYSICIAN_DETAILS_BY_SECTION": {
            "required": [
                "userId",
                "section"
            ],
            "properties": {
                "userId": {
                    "type": "number",
                },
                "section": {
                    "type": "string",
                }
            },
            "example": {
                "professional_details": {
                    "value": {
                        "userId": 340,
                        "section": "professional_details"
                    }
                },
                "address_details": {
                    "value": {
                        "userId": 340,
                        "section": "address_details"
                    }
                },
                "payment_details": {
                    "value": {
                        "userId": 340,
                        "section": "payment_details"
                    }
                }
            }
        },
        "GET_DEPARTMENT_DETAILS_BY_ID": {
            "required": [
                "departmentId"
            ],
            "properties": {
                "departmentId": {
                    "type": "number",
                }
            },
            "example": {
                "departmentId": 8
            }
        },
        "EDIT_DEPARTMENT": {
            "required": [
                "departmentId",
                "departmentName",
                "departmentDescription",
                "departmentIndexId",
                "departmentImages",
                "departmentLogo"
            ],
            "properties": {
                "departmentId": {
                    "type": "string",
                },
                "departmentName": {
                    "type": "string",
                },
                "departmentDescription": {
                    "type": "string",
                },
                "departmentIndexId": {
                    "type": "number",
                },
                "departmentImages": {
                    "type": "string",
                },
                "departmentLogo": {
                    "type": "string",
                }
            },
            "example": {
                "departmentId": 7,
                "departmentName": "Pediatric department",
                "departmentDescription": "Department which handle pediatric procedures.",
                "departmentImages": [
                    "71niXI3lxlL._AC_SY679_.jpg0.8595913736289941622201136381.jpeg"
                ],
                "departmentIndexId": 2,
                "departmentLogo": "71niXI3lxlL._AC_SY679_.jpg0.8595913736289941622201136381.jpeg"
            }
        },
        "DELETE_DEPARTMENT": {
            "required": [
                "departmentId"
            ],
            "properties": {
                "departmentId": {
                    "type": "number",
                }
            },
            "example": {
                "departmentId": 7
            }
        },
        "LIST_PATIENTS_BY_CLINIC_ID": {
            "required": [
                "clinicId",
                "limit",
                "offset",
                "search_key"
            ],
            "properties": {
                "clinicId": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "search_key": {
                    "type": "string",
                }
            },
            "example": {
                "clinicId": 2,
                "limit": 2,
                "offset": 0,
                "search_key": "joe"
            }
        },
        "GET_PATIENT_MEDICAL_PROFILE": {
            "required": [
                "patientId"
            ],
            "properties": {
                "patientId": {
                    "type": "number",
                }
            },
            "example": {
                "patientId": 213
            }
        },
        "LIST_APPOINTMENTS_BY_PHYSICIAN": {
            "required": [
                "appointmentFilter",
                "physicianId",
                "limit",
                "offset"
            ],
            "properties": {
                "appointmentFilter": {
                    "type": "string",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "physicianId": {
                    "type": "number",
                }
            },
            "examples": {
                "Today": {
                    "value": {
                        "appointmentFilter": "TODAY",
                        "appointmentFromDate": "2021-06-12",
                        "appointmentToDate": "2021-06-15",
                        "physicianId": 5,
                        "searchKey": "vinu",
                        "limit": 5,
                        "offset": 0
                    }
                },
                "Upcoming": {
                    "value": {
                        "appointmentFilter": "UPCOMING",
                        "appointmentFromDate": "2021-06-12",
                        "appointmentToDate": "2021-06-15",
                        "physicianId": 5,
                        "searchKey": "vinu",
                        "limit": 5,
                        "offset": 0
                    },
                    "Past": {
                        "value": {
                            "appointmentFilter": "PAST",
                            "appointmentFromDate": "2021-06-12",
                            "appointmentToDate": "2021-06-15",
                            "physicianId": 5,
                            "searchKey": "vinu",
                            "limit": 5,
                            "offset": 0
                        }
                    },
                    "Cancelled": {
                        "value": {
                            "appointmentFilter": "CANCELLED",
                            "appointmentFromDate": "2021-06-12",
                            "appointmentToDate": "2021-06-15",
                            "physicianId": 5,
                            "searchKey": "vinu",
                            "limit": 5,
                            "offset": 0
                        }
                    }
                }
            }
        },
        "GET_PATIENT_PAST_APPOINTMENTS": {
            "required": [
                "patientId",
                "limit",
                "offset"
            ],
            "properties": {
                "patientId": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "patientId": 261,
                "limit": 2,
                "offset": 0
            }
        },
        "ADD_CONSULTATION_NOTES": {
            "required": [
                "consultationId",
                "section",
                "content"

            ],
            "properties": {
                "consultationId": {
                    "type": "number",
                },
                "section": {
                    "type": "string",
                },
                "content": {
                    "type": "string",
                }
            },
            "example": {
                "consultationId": 4,
                "section": "presentingComplaint",
                "content": "Sample Presenting Complaint"
            }
        },
        "GET_CONSULTATION_NOTES_SUMMARY": {
            "required": [
                "consultationId"
            ],
            "properties": {
                "consultationId": {
                    "type": "number",
                }
            },
            "example": {
                "consultationId": 6
            }
        },
        "UPCOIMNG_APPOINTMENTS_PATIENT_DETAILS": {
            "required": [
                "patientId",
                "limit",
                "offset"
            ],
            "properties": {
                "patientId": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },

            },
            "example": {
                "patientId": 261,
                "limit": 2,
                "offset": 0
            }
        },
        "EXPERT_ADD_TIME_SLOTS": {
            "required": [
                "expertId",
                "duration",
                "available_dates",
                "time_slots"
            ],
            "properties": {
                "expertId": {
                    "type": "number",
                },
                "duration": {
                    "type": "number",
                }
            },
            "example": {
                "expertId": 261,
                "duration": 30,
                "available_dates": [1611139111, 1611139885],
                "time_slots": [{ "start_time": 1611139885, "end_time": 1611139785 }, { "start_time": 1611139885, "end_time": 1611139785 }]

            }
        },
        "EXPERT_LIST_TIME_SLOTS_BY_DATE": {
            "required": [
                "expertId",
                "dayTimeStamp"
            ],
            "properties": {
                "expertId": {
                    "type": "number",
                },
                "dayTimeStamp": {
                    "type": "number",
                }
            },
            "example": {
                "expertId": 261,
                "dayTimeStamp": 1611139985
            }
        },
        "EXPERT_EDIT_TIME_SLOTS": {
            "required": [
                "expertId",
                "dayTimeStamp",
                "duration",
                "availableTime"
            ],
            "properties": {
                "expertId": {
                    "type": "number",
                },
                "dayTimeStamp": {
                    "type": "number",
                },
                "duration": {
                    "type": "number",
                }
            },
            "example": {
                "expertId": 261,
                "dayTimeStamp": 1611139111,
                "duration": 30,
                "availableTime": [
                    {
                        "physicianTimeManagementId": 2,     //edit time slot with id 2
                        "startTimeStamp": 1599535800,
                        "endTimeStamp": 1599548400,
                        "Times": [1599548410, 1599548420]
                    },
                    {
                        "startTimeStamp": 1599585300,      //add new time slot 
                        "endTimeStamp": 1599598900
                    },
                    {
                        "physicianTimeManagementId": 3.   //delete time slot with id 3
                    }
                ]

            }
        },
        "GET_PATIENT_MEDICAL_RECORDS_WEB": {
            "required": [
                "patientId"
            ],
            "properties": {
                "patientId": {
                    "type": "number",
                }
            },
            "example": {
                "patientId": 14
            }
        },
        "VIEW_TIMESLOTS_IN_CALENDER": {
            "required": [
                "expertId",
                "startDay",
                "endDay"

            ],
            "properties": {
                "expertId": {
                    "type": "number",
                },
                "startDay": {
                    "type": "number",
                },
                "endDay": {
                    "type": "number",
                },
            },
            "example": {
                "expertId": 261,
                "startDay": 1623908435,
                "endDay": 1624254035
            }
        },
        "START_CONSULTATION_EXPERT": {
            "required": [
                "appointmentid",
                "type"
            ],
            "properties": {
                "appointmentid": {
                    "type": "number",
                },
                "type": {
                    "type": "string",
                }
            },
            "example": {
                "appointmentid": 7,
                "type": "video"
            }
        },
        "REJECT_CONSULTATION_BY_EXPERT": {
            "required": [
                "appointmentid",
                "reason"
            ],
            "properties": {
                "appointmentid": {
                    "type": "number",
                },
                "reason": {
                    "type": "string",
                }
            },
            "example": {
                "appointmentid": 4,
                "reason": "Not Available"
            }
        },
        "INVITE_PATIENT": {
            "required": [
                "patientName",
                "description",
                "phone",
                "email"
            ],
            "properties": {
                "patientName": {
                    "type": "string",
                },
                "description": {
                    "type": "string",
                },
                "phone": {
                    "type": "string",
                },
                "email": {
                    "type": "string",
                }
            },
            "example": {
                "patientName": "Sreerag Dileep",
                "description": "Dr. Sudhy Sukumaran has invited you to use MyHealingMate app for medical consultations.",
                "phone": "+919995848050",
                "email": "sreerag.dileep@cabotsolutions.com"
            }
        },
        "SUBMIT_PRESCRIPTION": {
            "required": [
                "consultationId",
                "physicianID",
                "patientID",
                "patient_first_name",
                "patient_last_name",
                "gender",
                "patient_dob",
                "expert_first_name",
                "expert_last_name",
                "qualification",
                "address_line1",
                "address_line2",
                "state_name",
                "registraion_number",
                "sign",
                "clinicName",
                "clinicAddress",
                "clinicLogo",
                "clinicPhone",
                "consultationStartTimestamp",
                "consultationEndTimestamp",
                "case_history",
                "presenting_complaint",
                "treatment_advice"

            ],
            "properties": {
                "consultationId": {
                    "type": "number",
                }
            },
            "example": {
                "consultationId": 6,
                "physicianID": 344,
                "patientID": 261,
                "patient_first_name": "uuio",
                "patient_last_name": "xxz",
                "gender": "male",
                "patient_dob": "2000-01-01",
                "expert_first_name": "Karim",
                "expert_last_name": "Lala",
                "qualification": "MBBS",
                "address_line1": "Healtour clinic",
                "address_line2": "Aarthi rd, Mumbai",
                "state_name": "Navi Mumbai",
                "registraion_number": "ID256",
                "sign": "ggtg",
                "clinicName": "Happy Clinic",
                "clinicAddress": "TestClinic",
                "clinicLogo": "6e5ae5a153d13b789b170c0edf9fc1d8.png",
                "clinicPhone": "919876543210",
                "consultationStartTimestamp": 1622868010,
                "consultationEndTimestamp": 1622868010,
                "case_history": "Undergone surgery for heart treatment",
                "presenting_complaint": "Voimiting, had alcohol history had undergone surgery for heart treatment.",
                "treatment_advice": "Voimiting, had alcohol history had undergone surgery for heart treatment"

            }
        },
        "LIST_ALL_ISSUES_REPORTED": {
            "required": [
                "limit",
                "offset",
                "issuesFromDate",
                "issuesToDate",
                "type"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "searchKey": {
                    "type": "string",
                },
                "sortKey": {
                    "type": "string",
                },
                "sortOrder": {
                    "type": "string",
                },
                "issuesFromDate": {
                    "type": "string",
                },
                "issuesToDate": {
                    "type": "string",
                },
                "type": {
                    "type": "string",
                },
            },
            "example": {
                "limit": 5,
                "offset": 0,
                "searchKey": "Suresh",
                "sortKey": "complaint_id",
                "sortOrder": "ASC",
                "issuesFromDate": "2021-07-26",
                "issuesToDate": "2021-07-27",
                "type": "refund"
            }
        },
        "END_CALL": {
            "required": [
                "appointmentid"
            ],
            "properties": {
                "appointmentid": {
                    "type": "number",
                }
            },
            "example": {
                "appointmentid": 7
            }
        },
        "APPROVE_REFUND": {
            "required": [
                "patientID",
                "consultationRequestId",
            ],
            "properties": {
                "patientID": {
                    "type": "number",
                },
                "consultationRequestId": {
                    "type": "number",
                }
            },
            "example": {
                "patientID": 7,
                "consultationRequestId": 7,
            }
        },
        "GET_COMPAINT_DETAILS_BY_ID": {
            "required": [
                "complaint_id"
            ],
            "properties": {
                "complaint_id": {
                    "type": "number",
                }
            },
            "example": {
                "complaint_id": 10
            }
        },
        "REPLY_TO_ISSUE": {
            "required": [
                "reply",
                "complaint_id"
            ],
            "properties": {
                "complaint_id": {
                    "type": "number",
                },
                "reply": {
                    "type": "string",
                }
            },
            "example": {
                "reply": "will check",
                "complaint_id": 5
            }
        },
        "MOVE_ISSUE_TO_REFUND": {
            "required": [
                "complaint_id"
            ],
            "properties": {
                "complaint_id": {
                    "type": "number",
                }
            },
            "example": {
                "complaint_id": 5
            }
        },
        "REJECT_REFUND": {
            "required": [
                "appointmentId",
                "reason"
            ],
            "properties": {
                "appointmentId": {
                    "type": "number",
                },
                "reason": {
                    "type": "string",
                }
            },
            "example": {
                "reason": "We looked in to your situation, as per MHM policy we can not refund for this appointment",
                "appointmentId": 670
            }
        },
        "REGISTER": {
            "required": [
                "email",
                "phone",
                "type",
                "firebase_token"
            ],
            "properties": {
                "appointmentId": {
                    "phone": "number",
                },
                "email": {
                    "type": "string",
                },
                "type": {
                    "phone": "string",
                },
                "firebase_token": {
                    "phone": "string",
                }
            },
            "example": {
                "email": "sreerag.dileep+321@cabotsolutions.com",
                "phone": "+919895805022",
                "type": "email",
                "firebase_token": "token"
            }
        },
        "CHECK_OTP": {
            "required": [
                "otp"
            ],
            "properties": {
                "otp": {
                    "type": "number",
                }
            },
            "example": {
                "otp": "950522"
            }
        },
        "USER_LOGIN": {
            "required": [
                "email",
                "phone",
                "type",
                "firebase_token"
            ],
            "properties": {
                "appointmentId": {
                    "phone": "number",
                },
                "email": {
                    "type": "string",
                },
                "type": {
                    "phone": "string",
                },
                "firebase_token": {
                    "phone": "string",
                }
            },
            "example": {
                "email": "sreerag.dileep+321@cabotsolutions.com",
                "phone": "+919895805022",
                "type": "email",
                "firebase_token": "token"
            }
        },
        "COMMENT_ADD": {
            "required": [
                "parent_id",
                "comment",
                "type",
                "pseudo_name"
            ],
            "properties": {
                "parent_id": {
                    "type": "number",
                },
                "comment": {
                    "type": "string",
                },
                "type": {
                    "type": "string",
                },
                "pseudo_name": {
                    "type": "string",
                },
            },
            "example": {
                "parent_id": "21",
                "comment": "Heyy new comment",
                "type": "feeds",
                "pseudo_name": "xxx"
            }
        },
        "COMMENT_LIST": {
            "required": [
                "parent_id",
                "type",
                "limit",
                "offset",
                "user_id"
            ],
            "properties": {
                "parent_id": {
                    "type": "number",
                },
                "type": {
                    "type": "string",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "user_id": {
                    "type": "number",
                }
            },
            "example": {
                "parent_id": "2",
                "type": "article",
                "limit": 5,
                "offset": 0,
                "user_id": 14
            }
        },
        "SOCIAL_LOGIN": {
            "required": [
                "email",
                "phone",
                "type",
                "firebase_token",
                "auth_token"
            ],
            "properties": {
                "appointmentId": {
                    "phone": "number",
                },
                "email": {
                    "type": "string",
                },
                "type": {
                    "phone": "string",
                },
                "firebase_token": {
                    "phone": "string",
                },
                "auth_token": {
                    "phone": "string",
                }
            },
            "example": {
                "email": "sreerag.dileep+321@cabotsolutions.com",
                "phone": "+919895805022",
                "type": "email",
                "firebase_token": "token",
                "auth_token": "43534d5345f3cfdgwerct345tft5f4gcrew"
            }
        },
        "COMMENT_UPDATE": {
            "required": [
                "comment_id",
                "comment"
            ],
            "properties": {
                "comment_id": {
                    "type": "number",
                },
                "comment": {
                    "type": "string",
                }
            },
            "example": {
                "comment_id": "5",
                "comment": "ccccssscc"
            }
        },
        "COMMENT_DELETE": {
            "required": [
                "comment_id"

            ],
            "properties": {
                "comment_id": {
                    "type": "number",
                }
            },
            "example": {
                "comment_id": "5"
            }
        },
        "OTP_RESEND": {
            "required": [
                "email",
                "phone",
                "type"
            ],
            "properties": {
                "appointmentId": {
                    "phone": "number",
                },
                "email": {
                    "type": "string",
                },
                "type": {
                    "phone": "string",
                }
            },
            "example": {
                "email": "sreerag.dileep+321@cabotsolutions.com",
                "phone": "+919895805022",
                "type": "email"
            }
        },
        "LIST_PROFILE": {
            "required": [
                "user_id"
            ],
            "properties": {
                "user_id": {
                    "type": "number",
                }
            },
            "example": {
                "user_id": "57"
            }
        },
        "UPDATE_USER_PROFILE": {
            "required": [
                "user_id",
                "pseudo_name",
                "postal_code",
                "gender",
                "dob",
                "first_name",
                "last_name",
                "email",
                "phone",
                "address",
                "profile_image",
                "user_type",
                "banner_image",
                "occupation",
                "education",
                "marital_status",
                "nationality",
                "living_status",
                "interest_areas",
                "hobbies",
                "your_expectation"
            ],
            "properties": {
                "user_id": {
                    "type": "number",
                }
            },
            "example": {
                "user_id": 30,
                "pseudo_name": "pppppppppp",
                "postal_code": "43242",
                "gender": "f",
                "dob": 234234,
                "first_name": "ffffffff",
                "last_name": "ggggggg",
                "email": "anoop.u@cabotsolutions.com",
                "phone": "3333333333",
                "address": "qqqqqqqqqq",
                "profile_image": "ccccccc.jpg",
                "user_type": "qqqqqqqqqqq",
                "banner_image": "dfresf",
                "occupation": "dfresf",
                "education": "dftrsf",
                "marital_status": "dfgfsf",
                "nationality": "dfsytf",
                "living_status": "dfsf",
                "interest_areas": "dfsf",
                "hobbies": "qqqqqqqqqqqqq",
                "your_expectation": "ccccccccccccccc"
            }
        },
        "CONDITION_ADD": {
            "required": [
                "condition_id",
                "condition",
                "user_id",
                "is_primary",
                "treatment_id",
                "treatment"
            ],
            "properties": {
                "condition_id": {
                    "type": "number",
                },
                "condition": {
                    "type": "string",
                },
                "user_id": {
                    "type": "number",
                },
                "is_primary": {
                    "type": "number",
                },
                "treatment_id": {
                    "type": "number",
                },
                "treatment": {
                    "type": "string",
                }
            },
            "example": {
                "condition_id": 1158,
                "condition": "qqqqq",
                "user_id": "2",
                "is_primary": "1",
                "treatment_id": 12,
                "treatment": "dfasfsfds"
            }
        },
        "DELETE_CONDITION": {
            "required": [
                "condition_id",
                "user_id"
            ],
            "properties": {
                "condition_id": {
                    "type": "number",
                },
                "user_id": {
                    "type": "number",
                }
            },
            "example": {
                "condition_id": 12,
                "user_id": "2"
            }
        },
        "CONDITION_MAP_LIST": {
            "required": [
                "user_id"
            ],
            "properties": {
                "user_id": {
                    "type": "number",
                }
            },
            "example": {
                "user_id": "57"
            }
        },
        "LIKE_ADD": {
            "required": [
                "user_id",
                "type_id",
                "type_name"
            ],
            "properties": {
                "user_id": {
                    "type": "number",
                },
                "type_id": {
                    "type": "number",
                },
                "type_name": {
                    "type": "string",
                }
            },
            "example": {
                "user_id": "1",
                "type_id": "4",
                "type_name": "Article"
            }
        },
        "UPLOADIMAGE": {
            "required": [
                "uploadData",
                "containerName"
            ],
            "properties": {

            },
            "example": {
                "uploadData": [
                    {
                        "blobName": "neutral-face.jpeg",
                        "data": "/9j/4AAQSkZJRCjiBBxTTSVFAgAAAAAAABD+hBT8+ZThT0wzygAAAAAAABR2MuPuwxzzpN/cYgAAAAAAABTdeQhTujwqgedhOAAAAAH0ah9AW3x7i57yq82HG6lCiIXN51m2C3VwLwVEa2S8y9A1rrmEu2cxuTV7uomtiZLcHdsoK/Qyidgj7YY/pUNMi9p4DmKUVBqtQrXo4gWrq0p5OEhsAJrzMBUvzK9LnuoUpZc46BhmIvcCkpOIJaqvWglFYHFalJsWwlPYWzV6lVYHWaoHn3Gjc2VFtwZgI1vLMsDVA5JaOwOHxKgaY83D0Gt6ZxuBpuMmbLGY7XiziM8hUslCdTRNn5INcWdbyykIhdlXmpRls+IGkV9k3LgeKiuFvpiHce4qO5wofGk2gGHMJpMrDh5hG6WMaHlpAyeBFskWlpW4RIpFDH6Gf/Z"
                    }
                ], "containerName": "private"
            }
        },
        "CHECK_LIKE": {
            "required": [
                "user_id",
                "type_id",
                "type_name"
            ],
            "properties": {
                "user_id": {
                    "type": "number",
                },
                "type_id": {
                    "type": "number",
                },
                "type_name": {
                    "type": "string",
                }
            },
            "example": {
                "user_id": "1",
                "type_id": "4",
                "type_name": "Article"
            }
        },
        "SUPER_USER_LOGIN": {
            "required": [
                "email",
                "password",
                "firebase_token"
            ],
            "properties": {
                "email": {
                    "type": "string",
                },
                "password": {
                    "type": "string",
                },
                "firebase_token": {
                    "type": "string",
                }
            },
            "example": {
                "email": "admin@mhm.com",
                "password": "admin",
                "firebase_token": "asfashbausvaubsuyasbahsbabsuabia"
            }
        },
        "GET_USER_PRIVACY": {
            "required": [
                "user_id"
            ],
            "properties": {
                "user_id": {
                    "type": "number",
                }
            },
            "example": {
                "user_id": "1"
            }
        },
        "UPDATE_USER_PRIVACY": {
            "required": [
                "id",
                "privacy_status"
            ],
            "properties": {
                "id": {
                    "type": "string",
                },
                "privacy_status": {
                    "type": "string",
                }
            },
            "example": {
                "id": "5",
                "privacy_status": "1"
            }
        },
        "CREATE_POST": {
            "required": [
                "content",
                "feeling",
                "image",
                "featured",
                "type",
                "community_id",
                "user_type",
                "content_privacy"
            ],
            "properties": {

            },
            "example": {
                "content": "Learning this information ahead of time can help your child share what he or she needs to stay calm during the unpleasant experience. You may want to explain to your child that unpleasant things have to be done to help him or her get better. But remind your child that this procedure is not happening because he or she did anything wrong. A social worker, nurse, child life specialist, or another member of the health care team can help you find the right words to explain the medical procedures to your child. Preparing yourself It is natural to feel upset ",
                "feeling": "medicated",
                "image": ["https://mhmstorage.blob.core.windows.net/public/uploads/0_d700400caa.jpeg",
                    "https://mhmstorage.blob.core.windows.net/public/uploads/Brain_Aneurysm_Treatment_1024x685_0e51eae541.jpeg"],
                "featured": false,
                "type": "feeds",
                "community_id": "2",
                "user_type": "admin",
                "content_privacy": "healing_mates"
            }
        },
        "EDIT_POST": {
            "required": [
                "post_id",
                "content",
                "feeling",
                "image",
                "featured",
                "type",
                "community_id"
            ],
            "properties": {
                "post_id": {
                    "type": "number",
                }
            },
            "example": {
                "post_id": "7",
                "content": "Hi post",
                "feeling": "happy",
                "image": ["asdff.png"],
                "featured": false,
                "type": "feeds",
                "community_id": "2"
            }
        },
        "DELETE_POST": {
            "required": [
                "post_id"
            ],
            "properties": {
                "post_id": {
                    "type": "number",
                }
            },
            "example": {
                "post_id": "7"
            }
        },
        "LIST_POSTS": {
            "required": [
                "limit",
                "offset"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "limit": 5,
                "offset": 0
            }
        },
        "GET_ALL_Firebase_Token": {
            "required": [
                "req_user_id"
            ],
            "properties": {
                "req_user_id": {
                    "type": "number",
                }
            },
            "example": {
                "req_user_id": 787
            }
        },
        "GET_ALL_REACTIONS": {
            "required": [
                "feed_id"
            ],
            "properties": {
                "feed_id": {
                    "type": "number",
                }
            },
            "example": {
                "feed_id": 8
            }
        },
        "SHARE_POST": {
            "required": [
                "feed_id",
                "pseudo_name"
            ],
            "properties": {
                "feed_id": {
                    "type": "number",
                },
                "pseudo_name": {
                    "type": "string",
                }
            },
            "example": {
                "feed_id": 8,
                "pseudo_name": "xxx"
            }
        },
        "CREATE_TESTIMONIAL": {
            "required": [
                "author_name",
                "description",
                "media",
                "created_on",
                "thumbnail",
                "publish_status",
                "media_type"
            ],
            "properties": {
                "author_name": {
                    "type": "string",
                },
                "description": {
                    "type": "string",
                },
                "media": {
                    "type": "string",
                },
                "created_on": {
                    "type": "number",
                },
                "thumbnail": {
                    "type": "string",
                },
                "publish_status": {
                    "type": "string",
                },
                "media_type": {
                    "type": "string",
                }
            },
            "example": {
                "author_name": "dummy name2",
                "description": "dummy description",
                "media": "media name",
                "created_on": 1613975400,
                "thumbnail": "thumbnail name",
                "publish_status": "True",
                "media_type": "image"
            }
        },
        "EDIT_TESTIMONIAL": {
            "required": [
                "id",
                "author_name",
                "description",
                "media",
                "created_on",
                "thumbnail",
                "publish_status",
                "media_type"
            ],
            "properties": {
                "id": {
                    "type": "number",
                },
                "author_name": {
                    "type": "string",
                },
                "description": {
                    "type": "string",
                },
                "media": {
                    "type": "string",
                },
                "created_on": {
                    "type": "number",
                },
                "thumbnail": {
                    "type": "string",
                },
                "publish_status": {
                    "type": "string",
                },
                "media_type": {
                    "type": "string",
                }
            },
            "example": {
                "id": "16",
                "author_name": "dummy name2",
                "description": "dummy description",
                "media": "media name",
                "created_on": 1613975400,
                "thumbnail": "thumbnail name",
                "publish_status": "True",
                "media_type": "image"
            }
        },
        "DELETE_TESTIMONIAL": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": 8
            }
        },
        "SEARCH_TESTIMONIAL": {
            "required": [
                "key"
            ],
            "properties": {
                "key": {
                    "type": "string",
                }
            },
            "example": {
                "key": "kri"
            }
        },
        "PUBLISH_TESTIMONIAL": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": 8
            }
        },
        "LIST_TESTIMONIALS": {
            "required": [
                "limit",
                "offset"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "limit": 5,
                "offset": 0
            }
        },
        "CREATE_ADVERTISEMENT": {
            "required": [
                "company_name",
                "created_on",
                "publish_status",
                "description",
                "media",
                "thumbnail",
                "media_type"
            ],
            "properties": {
                "company_name": {
                    "type": "string",
                },
                "created_on": {
                    "type": "number",
                },
                "publish_status": {
                    "type": "string",
                },
                "description": {
                    "type": "string",
                },
                "media": {
                    "type": "string",
                },
                "thumbnail": {
                    "type": "string",
                },
                "media_type": {
                    "type": "string",
                }
            },
            "example": {
                "company_name": "sreerag",
                "created_on": 1613975400,
                "publish_status": "0",
                "description": "This is a dummy text",
                "media": "media link for sreerag edited",
                "thumbnail": "thumbnail link for sreerag",
                "media_type": "video"
            }
        },
        "EDIT_ADVERTISEMENT": {
            "required": [
                "id",
                "company_name",
                "created_on",
                "publish_status",
                "description",
                "media",
                "thumbnail",
                "media_type"
            ],
            "properties": {
                "id": {
                    "type": "number",
                },
                "company_name": {
                    "type": "string",
                },
                "created_on": {
                    "type": "number",
                },
                "publish_status": {
                    "type": "string",
                },
                "description": {
                    "type": "string",
                },
                "media": {
                    "type": "string",
                },
                "thumbnail": {
                    "type": "string",
                },
                "media_type": {
                    "type": "string",
                }
            },
            "example": {
                "id": 9,
                "company_name": "sreerag",
                "created_on": 1613975400,
                "publish_status": "0",
                "description": "This is a dummy text",
                "media": "media link for sreerag edited",
                "thumbnail": "thumbnail link for sreerag",
                "media_type": "video"
            }
        },
        "LIST_ADVERTISEMENTS": {
            "required": [
                "limit",
                "offset"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "limit": 5,
                "offset": 0
            }
        },
        "DELETE_ADVERTISEMENT": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": 8
            }
        },
        "SEARCH_ADVERTISEMENTS": {
            "required": [
                "key"
            ],
            "properties": {
                "key": {
                    "type": "string",
                }
            },
            "example": {
                "key": "kri"
            }
        },
        "PUBLISH_ADVERTISEMENT": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": 8
            }
        },
        "CONDITION_UPDATE": {
            "required": [
                "condition_id",
                "condition",
                "user_id",
                "is_primary",
                "treatment_id",
                "treatment"
            ],
            "properties": {
                "condition_id": {
                    "type": "number",
                },
                "condition": {
                    "type": "string",
                },
                "user_id": {
                    "type": "number",
                },
                "is_primary": {
                    "type": "string",
                },
                "treatment_id": {
                    "type": "number",
                },
                "treatment": {
                    "type": "string",
                },
            },
            "example": {
                "condition_id": 9,
                "condition": "uuuuuuuuuuuuuuuuu",
                "user_id": "15",
                "is_primary": "1",
                "treatment_id": 34,
                "treatment": "dfsfdsf"
            }
        },
        "ADD_ROLES": {
            "required": [
                "name",
                "description",
                "permissions"
            ],
            "properties": {
                "name": {
                    "type": "string",
                },
                "description": {
                    "type": "string",
                }
            },
            "example": {
                "name": "Super admin",
                "description": "Test description comes here",
                "permissions": [{ "id": 1, "create": true, "update": true, "view": true, "delete": true, "publish": false }, { "id": 2, "create": true, "update": true, "view": true, "delete": false, "publish": false }]
            }
        },
        "EDIT_ROLES": {
            "required": [
                "id",
                "name",
                "description",
                "permissions"
            ],
            "properties": {
                "id": {
                    "type": "number",
                },
                "name": {
                    "type": "string",
                },
                "description": {
                    "type": "string",
                }
            },
            "example": {
                "id": 23,
                "name": "Super admin",
                "description": "Test description comes here",
                "permissions": [{ "id": 1, "create": true, "update": true, "view": true, "delete": true, "publish": false }, { "id": 2, "create": true, "update": true, "view": true, "delete": false, "publish": false }]
            }
        },
        "GLOBAL_SEARCH": {
            "required": [
                "search_string"
            ],
            "properties": {
                "search_string": {
                    "type": "string",
                }
            },
            "example": {
                "search_string": "clinic"
            }
        },
        "CREATE_TAG": {
            "required": [
                "tag_name"
            ],
            "properties": {
                "tag_name": {
                    "type": "string",
                }
            },
            "example": {
                "tag_name": "support"
            }
        },
        "EDIT_TAG": {
            "required": [
                "id",
                "tag_name"
            ],
            "properties": {
                "id": {
                    "type": "number",
                },
                "tag_name": {
                    "type": "string",
                }
            },
            "example": {
                "id": "47",
                "tag_name": "care"
            }
        },
        "DELETE_TAG": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": "47"
            }
        },
        "PUBLISH_TAG": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": "47"
            }
        },
        "UNPUBLISH_TAG": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": "47"
            }
        }, "ADD_REACTION": {
            "required": [
                "reaction_type",
                "feed_id",
                "reaction_status",
                "content_type",
                "pseudo_name"
            ],
            "properties": {
                "reaction_type": {
                    "type": "string",
                },
                "feed_id": {
                    "type": "number",
                },
                "reaction_status": {
                    "type": "string",
                },
                "content_type": {
                    "type": "string",
                },
                "pseudo_name": {
                    "type": "string",
                },
            },
            "example": {
                "reaction_type": "applause",
                "feed_id": "4",
                "reaction_status": true,
                "content_type": "feed",
                "pseudo_name": "xxx"
            }
        },
        "DELETE_REACTION": {
            "required": [
                "feed_id"
            ],
            "properties": {
                "feed_id": {
                    "type": "number",
                }
            },
            "example": {
                "feed_id": "11"
            }
        },
        "SEARCH_POST": {
            "required": [
                "search_string",
                "sort_key",
                "order_by",
                "limit",
                "offset"
            ],
            "properties": {
                "search_string": {
                    "type": "string",
                },
                "sort_key": {
                    "type": "string",
                },
                "order_by": {
                    "type": "string",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "search_string": "can",
                "sort_key": "created_date",
                "order_by": "DESC",
                "limit": 5,
                "offset": 0
            }
        },
        "REPORT_POST": {
            "required": [
                "post_id",
                "report_type",
                "report_text"
            ],
            "properties": {
                "post_id": {
                    "type": "number",
                },
                "report_type": {
                    "type": "string",
                },
                "report_text": {
                    "type": "string",
                },
            },
            "example": {
                "post_id": 4,
                "report_type": "spam",
                "report_text": ""
            }
        },
        "REPLY_POST": {
            "required": [
                "post_id",
                "reply"
            ],
            "properties": {
                "post_id": {
                    "type": "number",
                },
                "reply": {
                    "type": "string",
                }
            },
            "example": {
                "post_id": 13,
                "reply": "heyy post reply from admin"
            }
        },
        "VIEW_POSTS": {
            "required": [
                "search_string",
                "sort_key",
                "order_by",
                "limit",
                "offset"
            ],
            "properties": {
                "search_string": {
                    "type": "string",
                },
                "sort_key": {
                    "type": "string",
                },
                "order_by": {
                    "type": "string",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "search_string": "can",
                "sort_key": "created_date",
                "order_by": "DESC",
                "limit": 5,
                "offset": 0
            }
        },
        "ADD_ADMINUSERS": {
            "required": [
                "first_name",
                "last_name",
                "email",
                "role_id"
            ],
            "properties": {
                "first_name": {
                    "type": "string",
                },
                "last_name": {
                    "type": "string",
                },
                "email": {
                    "type": "string",
                },
                "role_id": {
                    "type": "number",
                }
            },
            "example": {
                "first_name": "Joe",
                "last_name": "Davis",
                "email": "joedavis999@gmail.com",
                "role_id": 1
            }
        },
        "EDIT_ADMINUSERS": {
            "required": [
                "first_name",
                "last_name",
                "email",
                "password",
                "role_id",
                "admin_user_id"
            ],
            "properties": {
                "first_name": {
                    "type": "string",
                },
                "last_name": {
                    "type": "string",
                },
                "email": {
                    "type": "string",
                },
                "role_id": {
                    "type": "number",
                },
                "password": {
                    "type": "string",
                },
                "admin_user_id": {
                    "type": "number",
                }
            },
            "example": {
                "first_name": "Joe",
                "last_name": "Davis",
                "email": "joedavis999@gmail.com",
                "password": "cabot@1234",
                "role_id": 1,
                "admin_user_id": 1
            }
        },
        "CONNECT": {
            "required": [
                "user_id2",
                "pseudo_name"
            ],
            "properties": {
                "user_id2": {
                    "type": "number",
                },
                "pseudo_name": {
                    "type": "string",
                }
            },
            "example": {
                "user_id2": 123,
                "pseudo_name": "xxx"
            }
        },
        "ACCEPT_REJECT_CONNECTION": {
            "required": [
                "user_id2",
                "pseudo_name",
                "connection_status",
            ],
            "properties": {
                "user_id2": {
                    "type": "number",
                },
                "pseudo_name": {
                    "type": "string",
                },
                "connection_status": {
                    "type": "number",
                }
            },
            "example": {
                "user_id2": 123,
                "pseudo_name": "xxx",
                "connection_status": 1,
            }
        },
        "MY_CONNECTIONS": {
            "required": [
                "limit",
                "offset"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                }
            },
            "example": {
                "limit": 5,
                "offset": 0
            }
        },
        "MEMBER_CONDITIONS_FILTER": {
            "required": [
                "min_age",
                "max_age",
                "gender",
                "location",
                "conditions",
                "treatments",
                "limit",
                "offset"
            ],
            "properties": {
                "min_age": {
                    "type": "number",
                },
                "max_age": {
                    "type": "number",
                },
                "gender": {
                    "type": "string",
                },
                "location": {
                    "type": "string",
                },
                "conditions": {
                    "type": "string",
                },
                "treatments": {
                    "type": "string",
                },
                "offset": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                }
            },
            "example": {
                "min_age": 0,
                "max_age": 35,
                "gender": "",
                "location": "",
                "conditions": ["Thyroid", "pancreatic"],
                "treatments": [""],
                "limit": 10,
                "offset": 0
            }
        },
        "RESET_PASSWORD": {
            "required": [
                "token",
                "new_password",
                "confirm_password"
            ],
            "properties": {
                "token": {
                    "type": "string",
                },
                "new_password": {
                    "type": "string",
                },
                "confirm_password": {
                    "type": "string",
                }
            },
            "example": {
                "token": "GSHHJ&*87",
                "new_password": "HJSJKHSKH",
                "confirm_password": "HJSJKHSKH"
            }
        },
        "FORGOT_PASSWORD": {
            "required": [
                "email"
            ],
            "properties": {
                "email": {
                    "type": "string",
                }
            },
            "example": {
                "email": "test@test.com"
            }
        },
        "CHANGE_PASSWORD": {
            "required": [
                "old_password",
                "new_password",
                "confirm_password"
            ],
            "properties": {
                "old_password": {
                    "type": "string",
                },
                "new_password": {
                    "type": "string",
                },
                "confirm_password": {
                    "type": "string",
                }
            },
            "example": {
                "old_password": "GSHHJ&*87",
                "new_password": "HJSJKHSKH",
                "confirm_password": "HJSJKHSKH"
            }
        },
        "LIST_TAGS": {
            "required": [
                "limit",
                "offset",
                "search_key",
                "sort_by",
                "sort_order"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "search_key": {
                    "type": "string",
                },
                "sort_by": {
                    "type": "string",
                },
                "sort_order": {
                    "type": "string",
                }
            },
            "example": {
                "limit": 5,
                "offset": 0,
                "search_key": "can",
                "sort_by": "id",
                "sort_order": "asc"
            }
        },
        "COMMENT_LIST_ADMIN": {
            "required": [
                "parent_id",
                "limit",
                "offset",
                "order_by",
                "order",
                "search_key"
            ],
            "properties": {
                "parent_id": {
                    "type": "number",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "order_by": {
                    "type": "string",
                },
                "order": {
                    "type": "string",
                },
                "search_key": {
                    "type": "string",
                }
            },
            "example": {
                "parent_id": "24",
                "limit": "3",
                "offset": "0",
                "order_by": "c.id",
                "order": "ASC",
                "search_key": "hey"
            }
        },
        "MEMBER_CONNECTIONS": {
            "required": [
                "limit",
                "offset",
                "user_id"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "user_id": {
                    "type": "number",
                }
            },
            "example": {
                "user_id": 214,
                "limit": 10,
                "offset": 0
            }
        },
        "MEMBER_CONNECTIONS_SEARCH": {
            "required": [
                "search_string",
                "limit",
                "offset",
                "user_id"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "user_id": {
                    "type": "number",
                },
                "search_string": {
                    "type": "string",
                }
            },
            "example": {
                "search_string": "Boss",
                "user_id": 214,
                "limit": 10,
                "offset": 0
            }
        },
        "CREATE_TREATMENT": {
            "required": [
                "treatment_name"
            ],
            "properties": {
                "treatment_name": {
                    "type": "string",
                }
            },
            "example": {
                "treatment_name": "test treatment"
            }
        },
        "EDIT_TREATMENT": {
            "required": [
                "treatment_name",
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                },
                "treatment_name": {
                    "type": "string",
                }
            },
            "example": {
                "treatment_name": "test treatment edited",
                "id": "17"
            }
        },
        "DELETE_TREATMENT": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": "17"
            }
        },
        "PUBLISH_TREATMENT": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": "17"
            }
        },
        "UNPUBLISH_TREATMENT": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": "17"
            }
        },
        "LIST_TREATMENTS": {
            "required": [
                "search_key",
                "limit",
                "offset",
                "sort_by",
                "sort_order"
            ],
            "properties": {
                "search_key": {
                    "type": "number",
                },
                "limit": {
                    "type": "string",
                },
                "offset": {
                    "type": "string",
                },
                "sort_by": {
                    "type": "string",
                },
                "sort_order": {
                    "type": "string",
                }
            },
            "example": {
                "search_key": "an",
                "limit": "2",
                "offset": "0",
                "sort_by": "id",
                "sort_order": "asc"
            }
        },
        "COMMENT_ADD_REACTION": {
            "required": [
                "reaction_type",
                "content_type",
                "feed_id",
                "comment_id",
                "reaction_status",
                "pseudo_name"
            ],
            "properties": {
                "reaction_type": {
                    "type": "string",
                },
                "content_type": {
                    "type": "string",
                },
                "feed_id": {
                    "type": "number",
                },
                "comment_id": {
                    "type": "number",
                },
                "reaction_status": {
                    "type": "string",
                },
                "pseudo_name": {
                    "type": "string",
                }
            },
            "example": {
                "reaction_type": "like",
                "content_type": "comment",
                "feed_id": "17",
                "comment_id": "229",
                "reaction_status": true,
                "pseudo_name": "xxx"
            }
        },
        "GET_USERLIST": {
            "required": [
                "type",
                "sort_by",
                "sort_order",
                "limit",
                "offset",
                "search_key"
            ],
            "properties": {
                "type": {
                    "type": "string",
                },
                "sort_by": {
                    "type": "string",
                },
                "sort_order": {
                    "type": "string",
                },
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "search_key": {
                    "type": "string",
                }
            },
            "example": {
                "type": "other",
                "sort_by": "id",
                "sort_order": "asc",
                "limit": "5",
                "offset": "0",
                "search_key": "gh"
            }
        },
        "MY_POSTS": {
            "required": [
                "limit",
                "offset",
                "user_id"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "user_id": {
                    "type": "number"
                }
            },
            "example": {
                "limit": 5,
                "offset": 0,
                "user_id": 214
            }
        },
        "ADMIN_GLOBAL_SEARCH": {
            "required": [
                "search_string"
            ],
            "properties": {
                "search_string": {
                    "type": "string",
                }
            },
            "example": {
                "search_string": "Thyroid"
            }
        },
        "GET_POST_DETAILS_BY_ID": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": "5"
            }
        },
        "ENDUSERACTIVESESSION": {
            "required": [
                "firebase_token"
            ],
            "properties": {
                "firebase_token": {
                    "type": "string",
                }
            },
            "example": {
                "firebase_token": "ek4VNkRLgxmZNbETtwPWRH:APA91bH6ZqIUob2INPj2DRpx9XohBj8XA0Euyjbv3B4WPcnJeCAZQnCcCT6z__l8iNXeDZJSJc4TVL1hV7MKtFFGG2SFaEzNWpVPd21Hemz7Lt2NOhRs9Dekpj7rzTz4FY3xCi9MtPpc"
            }
        },
        "LIST_NOTIFICATIONS": {
            "required": [
                "limit",
                "offset",
                "search_key"
            ],
            "properties": {
                "limit": {
                    "type": "number",
                },
                "offset": {
                    "type": "number",
                },
                "search_key": {
                    "type": "string"
                }
            },
            "example": {
                "limit": "5",
                "offset": "0",
                "search_key": "a"
            }
        },
        "ANALYTICS": {
            "required": [
            ],
            "properties": {
            },
            "example": {
            }
        },
        "COMMENT_PUBLISH_STATUS_CHANGE": {
            "required": [
                "publish_status",
                "comment_id",
                "unpublish_reason"
            ],
            "properties": {
                "publish_status": {
                    "type": "string",
                },
                "comment_id": {
                    "type": "string",
                },
                "unpublish_reason": {
                    "type": "string"
                }
            },
            "example": {
                "publish_status": true,
                "comment_id": "31",
                "unpublish_reason": ""
            }
        },
        "READ_NOTIFICATION": {
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "number",
                }
            },
            "example": {
                "id": "67"
            }
        },
        "BLOCK_UNBLOCK_USER": {
            "required": [
                "user_id",
                "status"
            ],
            "properties": {
                "user_id": {
                    "type": "number",
                },
                "status": {
                    "type": "number",
                }
            },
            "example": {
                "user_id": 212,
                "status": 0
            }
        },
        "CHECK_EXISTING_PSEUDONAME": {
            "required": [
                "pseudo_name"
            ],
            "properties": {
                "pseudo_name": {
                    "type": "string",
                }
            },
            "example": {
                "pseudo_name": "sree"
            }
        },
        "REGISTER_HELINGMATE": {
            "required": [
                "first_name",
                "last_name",
                "address",
                "gender",
                "dob",
                "pseudo_name",
                "postal_code",
                "profile_image",
                "nationality",
                "phone",
                "email",
                "banner_image",
                "occupation",
                "education",
                "marital_status",
                "living_status",
                "interest_areas",
                "hobbies",
                "your_expectation",
                "cancer_category"
            ],
            "properties": {
                "first_name": {
                    "type": "string",
                },
                "last_name": {
                    "type": "string",
                },
                "address": {
                    "type": "string",
                },
                "gender": {
                    "type": "string",
                },
                "dob": {
                    "type": "string",
                },
                "pseudo_name": {
                    "type": "string",
                },
                "postal_code": {
                    "type": "string",
                },
                "profile_image": {
                    "type": "string",
                },
                "nationality": {
                    "type": "string",
                },
                "phone": {
                    "type": "string",
                },
                "email": {
                    "type": "string",
                },
                "banner_image": {
                    "type": "string",
                },
                "occupation": {
                    "type": "string",
                },
                "education": {
                    "type": "string",
                },
                "marital_status": {
                    "type": "string",
                },
                "living_status": {
                    "type": "string",
                },
                "interest_areas": {
                    "type": "string",
                },
                "hobbies": {
                    "type": "string",
                },
                "your_expectation": {
                    "type": "string",
                },
                "cancer_category": {
                    "type": "string",
                }
            },
            "example": {
                "first_name": "Raj",
                "last_name": "Singh",
                "address": "Nashik",
                "gender": "Female",
                "dob": "1998-09-21",
                "pseudo_name": "priya0101",
                "postal_code": "422101",
                "profile_image": "",
                "nationality": "india",
                "phone": "+918888135626",
                "email": "ashutoshjagtap4922@gmail.com",
                "banner_image": "",
                "occupation": "Private Job",
                "education": "Bachelor's Degree",
                "marital_status": "Single",
                "living_status": "Family",
                "interest_areas": "travel",
                "hobbies": "Cooking",
                "your_expectation": "",
                "cancer_category": "paediatric"
            }
        }
    }
}
