1
export default {
    "/api": {
        "get": {
            "tags": [
                "API"
            ],
            "summary": "API to check if Server is ready",
            "responses": {
                "200": {
                    "description": "Listed Succesfuly"
                }
            }
        }
    },
    "/api/list_experts": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "List experts for patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_EXPERTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_expert_details": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Get expert details for patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_EXPERT_DETAILS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: Invalid Input"
                },
                "422": {
                    "description": "Error: Validation failed"
                }
            }
        }
    },
    "/api/list_physician_available_time": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "List physician available times for a day",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_PHYSICIAN_AVAILABLE_TIME"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "200": {
                    "description": "Manager signup Successfully"
                },
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/book_appointment": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Book appointment for an expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/BOOK_APPOINTMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "200": {
                    "description": "SuperAdmin Successfully"
                },
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },

    "/api/reschedule_appointment_by_patient": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Reschedule appointment by patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/RESCHEDULE_APPOINTMENT_BY_PATIENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "401": {
                    "description": "Error: Unauthorised or Invalid Refresh token"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/cancel_appointment_by_patient": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Cancel appointment by patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CANCEL_APPOINTMENT_BY_PATIENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/upcoming_appointments_by_patient": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Upcoming apointments for patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UPCOMING_APPOINTMENTS_BY_PATIENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/initiate_payment": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "initiate payment for appointment",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/INITIATE_PAYMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_patient_medical_records": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Get medical records for patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_PATIENT_MEDICAL_RECORDS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/member_conditions": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Get conditions for a patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/MEMBER_CONDITIONS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/reset_firebaseToken": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Reset firebase token for notification",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/RESET_FIREBASETOKEN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/past_appointments_by_patient": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "View past appointments of patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/PAST_APPOINTMENTS_BY_PATIENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/save_medial_reports": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Save medical records for patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/SAVE_MEDICAL_REPORTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/feedback": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Submit feedback after consultation",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/FEEDBACK"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/getSESToken": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Generate SES token for media access",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GETSESTOKEN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_medical_records": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Delete uploaded medical records by patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_MEDICAL_RECORDS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/instant_refund": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Process instant refund for patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/INSTANT_REFUND"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/refund_or_report": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Submit Refund request or report issue",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/REFUND_OR_REPORT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/start_consultation_patient": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Start consultation by patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/START_CONSULTATION_PATIENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/end_call_by_patient": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "End consultation by patient",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/END_CALL_BY_PATIENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/add_medical_reports_to_consultation": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Add medical records for consultation",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_MEDICAL_REPORTS_TO_CONSULTATION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/past_appointments_details": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Get past appointment details",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/PAST_APPOINTMENT_DETAILS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/imageTempUrl": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Generate temp url for prescription",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/IMAGETEMPURL"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/disconnected_call_data": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Save call data on network disconnection",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DISCONNECTED_CALL_DATA"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_medical_reports": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Edit medical record type",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_MEDICAL_REPORTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/view_refund_status": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "View reund status after request",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/VIEW_REFUND_STATUS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_patient_records_for_consult": {
        "post": {
            "tags": [
                "EXPERT_MOBILE"
            ],
            "summary": "Get medical records uploaded for consultation",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_PATIENT_RECORDS_FOR_CONSULT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/add_clinic": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Add new clinic",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_CLINIC"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/add_manager": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Add manager for clinic",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_MANAGER"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/expert_signin": {
        "post": {
            "tags": [
                "AUTHENTICATION"
            ],
            "summary": "Expert or clinic admin signin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EXPERT_SIGNIN"
                        },
                        "examples": {
                            "physician": {
                                "value": {
                                    "email": "joe.george@cabotsolutions.com",
                                    "password": "Password",
                                    "userType": "physician",
                                    "firebase_token": "asfashbausvaubsuyasbahsbabsuabia"
                                }
                            },
                            "manager": {
                                "value": {
                                    "email": "joe.george@cabotsolutions.com",
                                    "password": "Password",
                                    "userType": "manager",
                                    "firebase_token": "asfashbausvaubsuyasbahsbabsuabia"
                                }
                            }
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_clinicDetails": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Get clinic details by id",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_CLINICDETAILS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_clinicDetails": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Edit clinic details by manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_CLINICDETAILS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/expert_forgotpassword": {
        "post": {
            "tags": [
                "AUTHENTICATION"
            ],
            "summary": "Forgot password",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EXPERT_FORGOTPASSWORD"
                        },
                        "examples": {
                            "physician": {
                                "value": {
                                    "email": "joe.george@cabotsolutions.com",
                                    "userType": "physician"
                                }
                            },
                            "manager": {
                                "value": {
                                    "email": "joe.george@cabotsolutions.com",
                                    "userType": "manager"
                                }
                            }
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/expert_changepassword": {
        "post": {
            "tags": [
                "AUTHENTICATION"
            ],
            "summary": "Change password for Clinic manager or expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EXPERT_CHANGEPASSWORD"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/add_department": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Add department to clinic by manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_DEPARTMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/add_physician": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Add experts to clinic by manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_PHYSICIAN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_physician_details_by_id": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Get expert details by id",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_PHYSICIAN_DETAILS_BY_ID"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_experts_by_department": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "List experts under a department",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_EXPERTS_BY_DEPARTMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_departmentIndices": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "List department indices",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_DEPARTMENTINDICES"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_departments_by_clinic": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "List departments under clinis",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_DEPARTMENTS_BY_CLINIC"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_experts_by_clinic": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "List experts under clinic",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_EXPERTS_BY_CLINIC"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/update_expert_bio": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Update expert bio by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UPDATE_EXPERT_BIO"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/update_expert_address": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Update expert address by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UPDATE_EXPERT_ADDRESS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/update_profile_image": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Update expert profile image by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UPDATE_PROFILE_IMAGE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_physician": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Edit expert details by clinic manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_PHYSICIAN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_physician": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Delete expert by clinic manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_PHYSICIAN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_patients_by_expert_id": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "List patients for expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_PATIENTS_BY_EXPERT_ID"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_physician_details_by_section": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Get Expert details by section",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_PHYSICIAN_DETAILS_BY_SECTION"
                        },
                        "examples": {
                            "professional_details": {
                                "value": {
                                    "userId": 340,
                                    "section": "professional_details"
                                }
                            },
                            "address_details": {
                                "value": {
                                    "userId": 340,
                                    "section": "address_details"
                                }
                            },
                            "payment_details": {
                                "value": {
                                    "userId": 340,
                                    "section": "payment_details"
                                }
                            }
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_department_details_by_id": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Get department details by id",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_DEPARTMENT_DETAILS_BY_ID"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_department": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Edit department details by clinic manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_DEPARTMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_department": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Delete department by clinic manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_DEPARTMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_patients_by_clinic_id": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "List patients under the clinic",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_PATIENTS_BY_CLINIC_ID"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_patient_medical_profile": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Get patient medical profile for expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_PATIENT_MEDICAL_PROFILE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_appointments_by_physician": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "List appointments for expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_APPOINTMENTS_BY_PHYSICIAN"
                        },
                        "examples": {
                            "Today": {
                                "value": {
                                    "appointmentFilter": "TODAY",
                                    "appointmentFromDate": "2021-06-12",
                                    "appointmentToDate": "2021-06-15",
                                    "physicianId": 5,
                                    "searchKey": "vinu",
                                    "limit": 5,
                                    "offset": 0
                                }
                            },
                            "Upcoming": {
                                "value": {
                                    "appointmentFilter": "UPCOMING",
                                    "appointmentFromDate": "2021-06-12",
                                    "appointmentToDate": "2021-06-15",
                                    "physicianId": 5,
                                    "searchKey": "vinu",
                                    "limit": 5,
                                    "offset": 0
                                }
                            },
                            "Past": {
                                "value": {
                                    "appointmentFilter": "PAST",
                                    "appointmentFromDate": "2021-06-12",
                                    "appointmentToDate": "2021-06-15",
                                    "physicianId": 5,
                                    "searchKey": "vinu",
                                    "limit": 5,
                                    "offset": 0
                                }
                            },
                            "Cancelled": {
                                "value": {
                                    "appointmentFilter": "CANCELLED",
                                    "appointmentFromDate": "2021-06-12",
                                    "appointmentToDate": "2021-06-15",
                                    "physicianId": 5,
                                    "searchKey": "vinu",
                                    "limit": 5,
                                    "offset": 0
                                }
                            }
                        }
                    },
                    "description": "Json data"
                },
                "responses": {
                    "200": {
                        "description": "Listed Succesfuly"
                    },
                    "400": {
                        "description": "Error: Validation failed"
                    },
                    "403": {
                        "description": "Error: User not authorised to perform this action"
                    },
                    "422": {
                        "description": "Error: Invalid Input"
                    }
                }
            }
        }
    },
    "/api/get_patient_past_appointments": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Get patient past appointments for expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_PATIENT_PAST_APPOINTMENTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/add_consultation_notes": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Add consultation notes by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_CONSULTATION_NOTES"
                        },
                        "examples": {
                            "caseHistory": {
                                "value": {
                                    "consultationId": 4,
                                    "section":"caseHistory",
                                    "content":"Sample content"                                  
                                }
                            },
                            "presentingComplaint": {
                                "value": {
                                    "consultationId": 4,
                                    "section":"presentingComplaint",
                                    "content":"Sample content"
                                }
                            },
                            "treatmentAdvice": {
                                "value": {
                                    "consultationId": 4,
                                    "section":"treatmentAdvice",
                                    "content":"Sample content"
                                  
                                }
                            }
                        }
                    }
                }
            },
            "description": "Json data"
        },
        "responses": {
            "200": {
                "description": "Listed Succesfuly"
            },
            "400": {
                "description": "Error: Validation failed"
            },
            "403": {
                "description": "Error: User not authorised to perform this action"
            },
            "422": {
                "description": "Error: Invalid Input"
            }
        }
    },
    "/api/get_consultation_notes_summary": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Get datas for prescription page for expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_CONSULTATION_NOTES_SUMMARY"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/upcoming_appointments_patient_details": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "List upcoming appointments with patient for expert in Patient details page",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UPCOIMNG_APPOINTMENTS_PATIENT_DETAILS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/expert_add_time_slots": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Add available times by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EXPERT_ADD_TIME_SLOTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/expert_list_time_slots_by_date": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "List expert added timelosts",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EXPERT_LIST_TIME_SLOTS_BY_DATE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/expert_edit_time_slots": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Edit timeslots for a day by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EXPERT_EDIT_TIME_SLOTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_patient_medical_records_web": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Get Patient previous medical records for expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_PATIENT_MEDICAL_RECORDS_WEB"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/view_timeslots_in_calender": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Get expert available timeslots for calender view",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/VIEW_TIMESLOTS_IN_CALENDER"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/start_consultation_expert": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Start consultation by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/START_CONSULTATION_EXPERT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/reject_Consultation_by_expert": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Reject consultation by expert with reason",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/REJECT_CONSULTATION_BY_EXPERT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/invite_patient": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Invite patient by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/INVITE_PATIENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/submit_prescription": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Generate prescription and sent to patient by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/SUBMIT_PRESCRIPTION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_all_issues_reported": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "List all refund requests reported by patient for clinic manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_ALL_ISSUES_REPORTED"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/end_call": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "End consultation by expert",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/END_CALL"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/approve_refund": {
        "post": {
            "tags": [
                "EXPERT_WEB"
            ],
            "summary": "Approve refund by clinic manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/APPROVE_REFUND"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_complaint_details_by_id": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Get refund request or issue reported details by id",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_COMPAINT_DETAILS_BY_ID"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/reply_to_issue": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Reply to reported issue by Clinic manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/REPLY_TO_ISSUE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/move_issue_to_refund": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Move issue to refund table by clinic admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/MOVE_ISSUE_TO_REFUND"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/reject_refund": {
        "post": {
            "tags": [
                "EXPERT_CLINIC_WEB"
            ],
            "summary": "Reject refund request by clinic manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/REJECT_REFUND"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/register": {
        "post": {
            "tags": [
                "AUTHENTICATION"
            ],
            "summary": "Register user with email or phone",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/REGISTER"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/check_otp": {
        "post": {
            "tags": [
                "AUTHENTICATION"
            ],
            "summary": "OTP verification",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CHECK_OTP"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/user_login": {
        "post": {
            "tags": [
                "AUTHENTICATION"
            ],
            "summary": "User login using email or phone",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/USER_LOGIN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/comment_add": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Add comment to post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/  "
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/comment_list": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "List comments for a post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/COMMENT_LIST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/social_login": {
        "post": {
            "tags": [
                "AUTHENTICATION"
            ],
            "summary": "Social media login for user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/SOCIAL_LOGIN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/comment_update": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Edit comment for a post by user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/COMMENT_UPDATE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/comment_delete": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Delete comment for a post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/COMMENT_DELETE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/otp_resend": {
        "post": {
            "tags": [
                "AUTHENTICATION"
            ],
            "summary": "Resend OTP for verification",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/OTP_RESEND"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_profile": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "List profile details of a user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_PROFILE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/update_user_profile": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Update profile details of a user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UPDATE_USER_PROFILE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/condition_add": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Add medical conditions of a user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CONDITION_ADD"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_condition": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Delete medical conditions of a user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_CONDITION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/condition_map_list": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "List medical conditions of a user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CONDITION_MAP_LIST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/like_add": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Add reaction to a post by user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIKE_ADD"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/uploadImage": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Upload imaage by user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UPLOADIMAGE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/check_like": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Check reaction status",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CHECK_LIKE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/super_user_login": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Community Admin login",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/SUPER_USER_LOGIN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_user_privacy": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Get user profile privacy list",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_USER_PRIVACY"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/update_user_privacy": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Upate profile privacy by user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UPDATE_USER_PRIVACY"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/create_post": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Create new post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CREATE_POST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_post": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Edit post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_POST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_post": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Delete post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_POST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_posts": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "List posts",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_POSTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_all_reactions": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Get all reactions for a post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_ALL_REACTIONS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/user_firebase_token": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Get all active firebase token to send notification",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_ALL_Firebase_Token"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/share_post": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Share a post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/SHARE_POST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/create_testimonial": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Add testinomial by community Admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CREATE_TESTIMONIAL"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_testimonial": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Edit testimonial by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_TESTIMONIAL"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_testimonial": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Delete testimonial by community Admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_TESTIMONIAL"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/search_testimonial": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Search Testimonials",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/SEARCH_TESTIMONIAL"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/publish_testimonial": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Publish Testimonial by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/PUBLISH_TESTIMONIAL"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_testimonials": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "List Testimonials",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_TESTIMONIALS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/create_advertisement": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Create Advertisement by community Admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CREATE_ADVERTISEMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_advertisement": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Edit Advertisement buy community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_ADVERTISEMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_advertisements": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "List Advertisements",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_ADVERTISEMENTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_advertisement": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Delete advertisement by community Admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_ADVERTISEMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {               
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/search_advertisements": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Search advertisements",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/SEARCH_ADVERTISEMENTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {    
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/publish_advertisement": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Publish Advertisement by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/PUBLISH_ADVERTISEMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/condition_update": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Edit condition by user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CONDITION_UPDATE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/roles": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Add roles for community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_ROLES"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        },
        "put": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Edit roles for community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_ROLES"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        },
        "delete": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Delete roles for community admin",
            "parameters": [
                {
                    "name": "id",
                    "in": "query",
                    "required": true,
                    "example": 23,
                    "schema": {
                    "type": "integer"
                    }
                }
            ],
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/global_search": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Community admin global search",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GLOBAL_SEARCH"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/create_tag": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Create tag by community manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CREATE_TAG"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_tag": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Edit tag by community manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_TAG"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_tag": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Delete tag by coommunity manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_TAG"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/publish_tag": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Publish tag by coommunity manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/PUBLISH_TAG"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/unpublish_tag": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "UnPublish tag by coommunity manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UNPUBLISH_TAG"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/add_reaction": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Add reaction to post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_REACTION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_reaction": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Delete reaction for post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_REACTION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/search_post": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Search posts by community manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/SEARCH_POST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/report_post": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Report post by community manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/REPORT_POST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/reply_post": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Reply to post by community manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/REPLY_POST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/view_posts": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "View posts by community manager",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/VIEW_POSTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/adminUsers": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Add  community admin users",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADD_ADMINUSERS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        },
        "put": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Edit community admin users",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_ADMINUSERS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        },
        "delete": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Delete community admin users",
            "parameters": [
                {
                    "name": "admin_user_id",
                    "in": "query",
                    "required": true,
                    "example": 2,
                    "schema": {
                    "type": "integer"
                    }
                }
            ],
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/connect": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "sent connection request to other app users",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CONNECT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/accept_reject_connection": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Accept or Reject connection request",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ACCEPT_REJECT_CONNECTION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/my_connections": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "List connections of a user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/MY_CONNECTIONS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/member_conditions_filter": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Filter members with conditions",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/MEMBER_CONDITIONS_FILTER"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/reset_password": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Reset password for community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/RESET_PASSWORD"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/forgot_password": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Forgot password for comunity admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/FORGOT_PASSWORD"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/change_password": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Change password for community Admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CHANGE_PASSWORD"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_tags": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "List tags",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_TAGS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/comment_list_admin": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "List comments for a post by Admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/COMMENT_LIST_ADMIN"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api//member_connections": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "List member connections",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/MEMBER_CONNECTIONS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/member_connections_search": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Search in maember connections",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/MEMBER_CONNECTIONS_SEARCH"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/create_treatment": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Add new treatment by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CREATE_TREATMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/edit_treatment": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Edit treatment by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/EDIT_TREATMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/delete_treatment": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Delete treatment by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/DELETE_TREATMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/publish_treatment": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Publish treatment by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/PUBLISH_TREATMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/unpublish_treatment": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Un-Publish treatment by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/UNPUBLISH_TREATMENT"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_treatments": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "List treatment by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_TREATMENTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/comment_add_reaction": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Add reaction to comment",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/COMMENT_ADD_REACTION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_userlist": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Get list of users for community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_USERLIST"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/my_posts": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "List posts by a user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/MY_POSTS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/admin_global_search": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Global search by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ADMIN_GLOBAL_SEARCH"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/get_post_details_by_id": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Get details of a post",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/GET_POST_DETAILS_BY_ID"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/endUserActiveSession": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Add reaction to comment",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ENDUSERACTIVESESSION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/list_notifications": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "List notifications",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/LIST_NOTIFICATIONS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/analytics": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Analytics",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/ANALYTICS"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/comment_publish_status_change": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Publish or unpublish comment by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/COMMENT_PUBLISH_STATUS_CHANGE"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/read_notification": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Read notification",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/READ_NOTIFICATION"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/block_unblock_user": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Block or unblock user by community admin",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/BLOCK_UNBLOCK_USER"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/check_existing_pseudoname": {
        "post": {
            "tags": [
                "COMMUNITY_MOBILE"
            ],
            "summary": "Check whether a pseudoname already exists for a user or not",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/CHECK_EXISTING_PSEUDONAME"
                        }
                    }
                },
                "description": "Json data"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
    "/api/register_helingmate_profile": {
        "post": {
            "tags": [
                "COMMUNITY_WEB"
            ],
            "summary": "Register new helingmate by admin user",
             "parameters": [],
            "security": [
                {
                "bearerAuth": []
                }
            ],
            "requestBody": {
                "content": {
                    "application/json": {
                        "schema": {
                            "$ref": "#/components/schemas/REGISTER_HELINGMATE"
                        }
                    }
                },
                "description": "Register new helingmate by admin user"
            },
            "responses": {
                "400": {
                    "description": "Error: Validation failed"
                },
                "403": {
                    "description": "Error: User not authorised to perform this action"
                },
                "422": {
                    "description": "Error: Invalid Input"
                }
            }
        }
    },
}
    
   