import sendResponse from '../../services/response';
import { blobStorageUpload, blobStorage_TempUrl, mediaUpload, 
    get_image_url, get_ses_token, medical_records_delete } from '../models/BlobStorageModel';

// upload image to blob
export const uploadImage = (req, res) => {
    let body = req.body;
    blobStorageUpload(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// create temp url for media
export const imageTempUrl = (req, res) => {
    let body = req.body;
    blobStorage_TempUrl(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// upload image
export const media_upload = (req, res) => {
    mediaUpload(req).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get images
export const get_images = (req, res) => {
    const body = req.body;
    get_image_url(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// getSESToken
export const getSESToken = (req, res) => {
    const body = req.body;
    get_ses_token(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
