import { connect_members, acc_rej_connection, 
    my_connections_list, conditions_members, 
    filter_conditions_members, connections_member, 
    search_member_connections, conditions_members_v1, filter_conditions_members_v1 } from '../models/ConnectionModel';
import sendResponse from '../../services/response';

// Send connection request
export const connect = (req, res) => {
    const body = req.body;
    connect_members(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Accept or reject connection
export const accept_reject_connection = (req, res) => {
    const body = req.body;
    acc_rej_connection(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//My connections
export const my_connections = (req, res) => {
    const body = req.body;
    my_connections_list(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//Get all conditions along with members list
export const member_conditions = (req, res) => {
    const body = req.body;
    conditions_members_v1(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//Members list with filter on conditions, treatments, age, gender
export const member_conditions_filter = (req, res) => {
    const body = req.body;
    filter_conditions_members_v1(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//List connections of a member
export const member_connections = (req, res) => {
    const body = req.body;
    connections_member(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//Search in member connections
export const member_connections_search = (req, res) => {
    const body = req.body;
    search_member_connections(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


