import sendResponse from '../../services/response';
import { add_clinic_manager, clinic_add, edit_clinic_details, list_clinic_details } from '../models/ExpertClinicModel'

// add clinic
export const add_clinic = (req, res) => {
    const body = req.body;
    if (body.user.user_type == "manager"
        || body.user.user_type == "expert_admin") {
        clinic_add(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
            .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
    } else {
        res.status(403).json({ status: 0, message: "User not authorised to perform this action" })
    }
}

// list clinic details
export const list_clinicDetails = (req, res) => {
    const body = req.body;
    list_clinic_details(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// edit clinic details
export const edit_clinicDetails = (req, res) => {
    const body = req.body;
    edit_clinic_details(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// add clinic manager
export const add_manager = (req, res) => {
    const body = req.body;
    add_clinic_manager(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
