import sendResponse from '../../services/response';
import { get_medical_profile, get_past_appointments, 
    list_patients, list_patients_by_clinic, patient_data, 
    upcoming_appointments, patient_medical_records, 
    get_patient_medical_data, 
    invite_patient_by_expert,medical_reports_save,
    medical_reports_add_to_consultation, 
    deleteMedicalRecordsFromDb,
    editMedicalRecords} from '../models/ExpertPatientModel';


// list patients by expert id
export const list_patients_by_expert_id = (req, res) => {
    const body = req.body;
    list_patients(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// list patients by clinic id
export const list_patients_by_clinic_id = (req, res) => {
    const body = req.body;
    list_patients_by_clinic(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get patient medical profile
export const get_patient_medical_profile = (req, res) => {
    const body = req.body;
    get_medical_profile(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get patient past appointments
export const get_patient_past_appointments = (req, res) => {
    const body = req.body;
    get_past_appointments(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// upcoming appointments
export const upcoming_appointments_patient_details = (req, res) => {
    const body = req.body;
    upcoming_appointments(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get patient data
export const get_patient_data = (req, res) => {
    const body = req.body;
    patient_data (body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get patient data
export const get_patient_medical_records = (req, res) => {
    const body = req.body;
    patient_medical_records(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get patient data
export const get_patient_medical_records_web = (req, res) => {
    const body = req.body;
    get_patient_medical_data(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// invite patient
export const invite_patient = (req, res) => {
    const body = req.body;
    invite_patient_by_expert(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
    .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
// Save medical reports of patient
export const save_medial_reports = (req, res) => {
    const body = req.body;
    medical_reports_save(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//Add medical records to consultation
export const add_medical_reports_to_consultation = (req, res) => {
    const body = req.body;
    medical_reports_add_to_consultation(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Delete medical reports of patient
export const delete_medical_records = (req, res) => {
    const body = req.body;
    deleteMedicalRecordsFromDb(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


// Edit medical reports of patient
export const edit_medical_reports = (req, res) => {
    const body = req.body;
   editMedicalRecords(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}