import sendResponse from '../../services/response';
import { payment_initiate, list_cards_for_patient, 
    success_hook_payment, refund_initiate, 
    refund_request, send_refund, success_hook_refund, 
    refund_reject, refund_status_view,issue_to_refund, reply_issue } from '../models/ExpertPaymentModel';

// Initiate payment by patient
export const initiate_payment = (req, res) => {
    const body = req.body;
    payment_initiate(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// List cards of a patient
export const patient_list_cards = (req, res) => {
    const body = req.body;
    list_cards_for_patient(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Hook called on successfull payment
export const payment_success_hook = (req, res) => {
    const body = req.body;
    success_hook_payment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Initiate refund request
export const initiate_refund = (req, res) => {
    const body = req.body;
    refund_initiate(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// initiate refund request
export const refund_or_report = (req, res) => {
    const body = req.body;
    refund_request(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// instant refund 
export const instant_refund = (req, res) => {
    const body = req.body;
    send_refund(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Hook called on successfull refund
export const refund_success_hook = (req, res) => {
    const body = req.body;
    success_hook_refund(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Move issue to refund
export const move_issue_to_refund = (req, res) => {
    const body = req.body;
    issue_to_refund(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Reply to issue
export const reply_to_issue = (req, res) => {
    const body = req.body;
    reply_issue(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
    .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Reject a refund by clinic admin
export const reject_refund = (req, res) => {
    const body = req.body;
    refund_reject(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// View Refund status by patient
export const view_refund_status = (req, res) => {
    const body = req.body;
    refund_status_view(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
