import sendResponse from '../../services/response';
import { physician_add, physician_details_by_id, 
    physician_list, fetch_physician_details, 
    list_experts_by_department_id, search_expert, 
    list_experts_by_clinic_id, add_expert_bio_details, 
    update_expertAddress, update_profileImage, physician_available_time_list,physician_edit, physician_delete, 
    physician_details_by_section, appointments_list } from '../models/ExpertPhysicianModel'

// add physician
export const add_physician = (req, res) => {
    const body = req.body;
    physician_add(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// add physician
export const list_experts = (req, res) => {
    const body = req.body;
        physician_list(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
            .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get physician details by id
export const get_physician_details_by_id = (req, res) => {
    const body = req.body;
    physician_details_by_id(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
}

// get physician details
export const get_expert_details = (req, res) => {
    const body = req.body;
        fetch_physician_details(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
            .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// list experts by department
export const list_experts_by_department = (req, res) => {
    const body = req.body;
    list_experts_by_department_id(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Search Experts
export const expert_search = (req, res) => {
    const body = req.body;
    search_expert(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// list experts by clinic
export const list_experts_by_clinic = (req, res) => {
    const body = req.body;
    list_experts_by_clinic_id(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// update expert bio
export const update_expert_bio = (req, res) => {
    const body = req.body;
    add_expert_bio_details(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// update expert address
export const update_expert_address = (req, res) => {
    const body = req.body;
    update_expertAddress(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// update profile image
export const update_profile_image = (req, res) => {
    const body = req.body;
    update_profileImage(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// edit physician
export const edit_physician = (req, res) => {
    const body = req.body;
    physician_edit(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
// List physician Available times
export const list_physician_available_time = (req, res) => {
    const body = req.body;
    physician_available_time_list(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// delete physician
export const delete_physician = (req, res) => {
    const body = req.body;
    physician_delete(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get physician details by id
export const get_physician_details_by_section = (req, res) => {
    const body = req.body;
    physician_details_by_section(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
    .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//List all appointments fro physician with filter
export const list_appointments = (req, res) => {
    const body = req.body;
    appointments_list(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
    .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
