import { add_post, post_edit, post_delete, post_list,feeds, reaction_add, 
    post_share , all_reactions, search_global, details_post, moderate_post_content } from '../models/FeedsModel';
import sendResponse from '../../services/response';

// Add Post
export const create_post = (req, res) => {
    const body = req.body;
    add_post(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Edit Post
export const edit_post = (req, res) => {
    const body = req.body;
    post_edit(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Delete Post
export const delete_post = (req, res) => {
    const body = req.body;
    post_delete(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// List Post
export const list_posts = (req, res) => {
    const body = req.body;
    feeds(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Add reaction for a Post
export const add_reaction = (req, res) => {
    const body = req.body;
    reaction_add(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Get all reactions for a Post
export const get_all_reactions = (req, res) => {
    const body = req.body;
    all_reactions(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Share a Post
export const share_post = (req, res) => {
    const body = req.body;
    post_share(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//Global search
export const global_search = (req, res) => {
    const body = req.body;
    search_global(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Post Details
export const post_details = (req, res) => {
    const body = req.body;
    details_post(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// content moderation
export const content_moderation = (req, res) => {
    const body = req.body;
    moderate_post_content(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}