import sendResponse from '../../services/response';
import {create_new_advertisement,update_advertisement,list_advertisement_entries,search_advertisement_entries,delete_advertisement_entry,publish_advertisement_entry} from '../models/ManageAdvertisementsModel'

// create advertisement
export const create_advertisement = (req, res) => {
    const body = req.body;
    create_new_advertisement(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// edit advertisement
export const edit_advertisement = (req, res) => {
    const body = req.body;
    update_advertisement(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// list advertisements
export const list_advertisements = (req, res) => {
    const body = req.body;
    list_advertisement_entries(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// delete advertisement
export const delete_advertisement = (req, res) => {
    const body = req.body;
    delete_advertisement_entry(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


// search advertisement
export const search_advertisements = (req, res) => {
    const body = req.body;
    search_advertisement_entries(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//publish advertisement
export const publish_advertisement = (req, res) => {
    const body = req.body;
    publish_advertisement_entry(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}