import sendResponse from '../../services/response';
import { countTreatments, create_new_treatment, deleteTreatment, editTreatment, listTreatments, publishTreatment, unpublishTreatment } from '../models/ManageTreatmentsModel';

//add treatment
export const create_treatment = (req, res) => {
    const body = req.body;
    create_new_treatment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//delete treatment
export const delete_treatment = (req, res) => {
    const body = req.body;
    deleteTreatment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//edit treatment
export const edit_treatment = (req, res) => {
    const body = req.body;
    editTreatment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//publish treatment
export const publish_treatment = (req, res) => {
    const body = req.body;
    publishTreatment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//unpublish treatment
export const unpublish_treatment = (req, res) => {
    const body = req.body;
    unpublishTreatment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//list treatment
export const list_treatments = (req, res) => {
    const body = req.body;
    countTreatments(body).then((countresponse: any) => 
    listTreatments(body).then((response: any) => sendResponse(res, response.code, 1, response.message,{ count:countresponse.data,data:response.data}, ''))
    .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, '')))
}