import {
    change_post_status, post_report, post_reply,
    view_all_posts, post_search, global_search_admin, get_post_details, admin_analytics
} from '../models/PostModel';
import { post_list, feeds } from '../models/FeedsModel'
import sendResponse from '../../services/response';
import { list_posts } from './FeedsController';

// Approve/ reject Post
export const approve_reject_post = (req, res) => {
    const body = req.body;
    change_post_status(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
// Report Post
export const report_post = (req, res) => {
    const body = req.body;
    post_report(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
// Reply Post
export const reply_post = (req, res) => {
    const body = req.body;
    post_reply(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
// View all Posts filtered by featured/spam/reported
export const view_posts = (req, res) => {
    const body = req.body;
    view_all_posts(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Search Posts
export const search_posts = (req, res) => {
    const body = req.body;
    post_search(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// My Posts when user take his profile
export const my_posts = (req, res) => {
    const body = req.body;
    feeds(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Global search for admin
export const admin_global_search = (req, res) => {
    const body = req.body;
    global_search_admin(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get Post details
export const get_post_details_by_id = (req, res) => {
    const body = req.body;
    get_post_details(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
// Dashboard analytics
export const analytics = (req, res) => {
    const body = req.body;
    admin_analytics(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}
