import { add_roles, edit_roles, delete_role, get_role, get_role_detail, get_module } from '../models/RolesModel';
import sendResponse from '../../services/response';

// Add Role
export const create_roles = (req, res) => {
    const body = req.body;
    add_roles(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Edit Role
export const update_roles = (req, res) => {
    const body = req.body;
    edit_roles(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Delete Role
export const delete_roles = (req, res) => {
    const body = req.query;
    delete_role(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Get Role
export const get_roles = (req, res) => {
    const body = req.query;
    get_role(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Get Role details
export const get_role_details = (req, res) => {
    const body = req.params;
    get_role_detail(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Get modules
export const get_modules = (req, res) => {
    const body = req.params;
    get_module(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}