import query from '../query/query';
import { database } from '../../config/dbConfig';

// Add Condition
export const add_condition = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try { 
                const userid = _body.userid
                //check if user already added condition(validation)
                const queryChk = `SELECT id FROM conditions WHERE user_id=${userid}`;
                const condExists = await client.query(queryChk);
                if(condExists.rowCount > 0){
                    reject({ code: 400, message: "User already added conditions. Please update", data: {} });  
                }else{
                    let secConditions = {}
                    let secTreatments = {}
                    //remove duplicate conditions and treatments
                    var filteredCond = _body.filter(function(currentObject) {
                        //filter treatments
                        if(currentObject.condition == 'null'){
                            if (currentObject.treatment in secTreatments){
                                return false;
                            }else{
                                secTreatments[currentObject.treatment] = true;
                                return true;
                            }
                        }
                        //filter conditions
                        else if (currentObject.condition in secConditions) {
                            return false;
                        } else {
                            secConditions[currentObject.condition] = true;
                            return true;
                        }
                    });
                    filteredCond.forEach(async function (item) {
                        if (item.condition == "" || item.condition == null) {
                            reject({ code: 400, message: "Conditions can not be empty.", data: {} });
                        }else{
                            const add_condition = {
                                name: 'add_condition',
                                text: query.add_condition,
                                values: [item.condition_id,
                                    item.condition, 
                                    item.user_id, 1, 
                                    item.is_primary, 
                                    item.treatment_id, 
                                    currentTime, 
                                    item.treatment]
                            }
                            await client.query(add_condition);
                            // const add_condition = {
                            //     name: 'add_condition',
                            //     text: query.add_condition,
                            //     values: [_body.condition_id, _body.condition, userid, 1, _body.is_primary, _body.treatment_id, currentTime, _body.treatment]
                            // }
                            // await client.query(add_condition);
                        }     
                    })
                    resolve({ code: 200, message: "Condition has been successfully added", data: {} });
                }
            } catch (e) {
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// List Condition
export const list_condition = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const list_condition = {
                    name: 'list_condition',
                    text: query.list_condition,
                    values: [_body.user_id, 1]
                }
                const condition_details = await client.query(list_condition);
                resolve({ code: 200, message: "Condition relaton has been successfully fetched", data: condition_details.rows });
            } catch (e) {
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Delete Condition
export const condition_delete = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const condition_delete = {
                    name: 'condition_delete',
                    text: query.condition_delete,
                    values: ["0", _body.condition_id, _body.user_id]
                }
                const condition_details = await client.query(condition_delete);
                resolve({ code: 200, message: "Condition has been successfully deleted", data: {} });
            } catch (e) {
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// Edit Condition
export const condition_edit = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                let secConditions = {}
                let secTreatments = {}
                //remove duplicate conditions and treatments
                var filteredCond = _body.filter(function(currentObject) {
                    //filter treatments
                    if(currentObject.condition == 'null'){
                        if (currentObject.treatment in secTreatments){
                            return false;
                        }else{
                            secTreatments[currentObject.treatment] = true;
                            return true;
                        }
                    }
                    //filter conditions
                    else if (currentObject.condition in secConditions) {
                        return false;
                    } else {
                        secConditions[currentObject.condition] = true;
                        return true;
                    }
                });
                const condition_delete_by_userid = {
                    name: 'condition_delete_by_userid',
                    text: query.condition_delete_by_userid,
                    values: [_body[0].user_id]
                }
                await client.query(condition_delete_by_userid);
                filteredCond.forEach(async function (item) {
                    const add_condition = {
                        name: 'add_condition',
                        text: query.add_condition,
                        values: [item.condition_id,
                            item.condition, 
                            item.user_id, 1, 
                            item.is_primary, 
                            item.treatment_id, 
                            currentTime, 
                            item.treatment]
                    }
                    await client.query(add_condition);
                })
                resolve({ code: 200, message: "Condition has been successfully updated", data: {} });
            } catch (e) {
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}