import query from '../query/query';
import { database, pool } from '../../config/dbConfig';
import { getUserLiveTokens, remove_notification } from './notificationModel';
const superagent = require('superagent');
//Connection Request

export const connect_members = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                if (_body.userid == _body.user_id2) {
                    reject({ code: 400, message: "You can not connect with yourself!.", data: {} });
                } else {
                    //check connection request already done
                    const chk_connection = {
                        name: 'chk_connection',
                        text: query.chk_connection,
                        values: [_body.userid, _body.user_id2]
                    }
                    var chk_connection_details = await client.query(chk_connection);
                    //no connection request done
                    if (chk_connection_details.rowCount == 0) {
                        const connect_members = {
                            name: 'connect_members',
                            text: query.connect_members,
                            values: [_body.userid, _body.user_id2, 2, currentTime] //status : 0-not connected, 1-connected, 2-requested
                        }
                        var connect_details = await client.query(connect_members);
                    }
                    //already connected or requested
                    else if (chk_connection_details.rows[0].status > 0) {
                        reject({ code: 400, message: "Connection request already sent.", data: {} });
                    } else if (chk_connection_details.rows[0].status == 0) {
                        //if connection is rejected then update the status only
                        const connect_members_u = {
                            name: 'connect_members_u',
                            text: query.acc_rej_connection,
                            values: [_body.user_id2, _body.userid, 2, currentTime]
                        }
                        var connect_update = await client.query(connect_members_u);
                    }
                    if (connect_details || connect_update) {
                        if (_body.pseudo_name) {
                            const notificationTitle = "New connection request from " + _body.pseudo_name
                            const type = "connection_request";
                            const data = {}
                            getUserLiveTokens(_body.user_id2, notificationTitle, _body.userid, type, data)
                        }
                        resolve({ code: 200, message: "Connecion Request has been successfully added", data: {} })
                    } else {
                        reject({ code: 400, message: "Failed. Please try again.", data: {} });
                    }
                }

            } catch (e) {
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Accept or reject connection

export const acc_rej_connection = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const connect_members = {
                    name: 'connect_members',
                    text: query.acc_rej_connection,
                    values: [_body.user_id2, _body.userid, _body.connection_status, currentTime]
                }
                var connect_details = await client.query(connect_members);
                if (connect_details) {
                    if (_body.pseudo_name) {
                        if (_body.connection_status == 1) {
                            const notificationTitle = _body.pseudo_name + " accepted your connection request";
                            const type = "connection_response";
                            const data = {}
                            getUserLiveTokens(_body.user_id2, notificationTitle, _body.userid, type, data)
                        }
                        remove_notification(_body)
                    }
                    resolve({ code: 200, message: "Connecion has been successfully updated", data: {} })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}



//My connections with pagination

export const my_connections_list = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const my_connections = {
                    name: 'my_connections',
                    text: query.my_connections,
                    values: [_body.userid, _body.limit, _body.offset]
                }
                var connect_details = await client.query(my_connections);
                connect_details.rows.forEach(element => {
                    if (element.user_id1 == _body.userid) {
                        element.friend_id = element.user_id2
                    } else element.friend_id = element.user_id1
                    if (element.location == "" || element.location == null || element.location == "{}") {
                    
                    }
                    else {
                        element.location = JSON.parse(element.location).city;
                    }
                })
                if (connect_details) {
                    resolve({ code: 200, message: "Connecions has been successfully listed", data: connect_details.rows })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Get all conditions along with members list
export const conditions_members = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let finalData = {}
            let promises = []
            let users = []
            const client = await database().connect();
            try {
                const query = `SELECT u.id, u.pseudo_name,u.first_name,u.last_name, 
                u.profile_image, u.nationality, u.location, c.condition, 
                c.treatment_id, c.user_id, u.gender,
                (SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=c.user_id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=c.user_id) as connected)
                FROM conditions c 
                LEFT JOIN users u ON u.id = c.user_id
                WHERE u.id !=${_body.userid} AND c.is_primary=${1}
                ORDER BY u.first_name ASC`
                const limit = _body.limit ? _body.limit : 100;
                const offset = _body.offset ? _body.offset : 0;
                var condition_details = await client.query(query);
                condition_details.rows.forEach((item, index) => {
                    let allUsers = {
                        user_id: item.user_id,
                        condition: item.condition,
                        pseudo_name: item.pseudo_name,
                        first_name: item.first_name,
                        last_name: item.last_name,
                        profile_image: item.profile_image,
                        nationality: item.nationality,
                        location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                        gender: item.gender,
                        connection_status: item.status == null ? 0 : parseInt(item.status)
                    }
                    if (!finalData[item.condition]) {
                        let data = {
                            condition_group: item.condition,
                            users: [{
                                user_id: item.user_id,
                                condition: item.condition,
                                pseudo_name: item.pseudo_name,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                profile_image: item.profile_image,
                                nationality: item.nationality,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                gender: item.gender,
                                connection_status: item.status == null ? 0 : parseInt(item.status)
                            }],
                        }
                        finalData[item.condition] = data;
                    } else {
                        finalData[item.condition].users.push({
                            user_id: item.user_id,
                            condition: item.condition,
                            pseudo_name: item.pseudo_name,
                            first_name: item.first_name,
                            last_name: item.last_name,
                            profile_image: item.profile_image,
                            nationality: item.nationality,
                            location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                            gender: item.gender,
                            connection_status: item.status == null ? 0 : parseInt(item.status)
                        })
                    }
                    users.push(allUsers)
                })
                var finalResult = Object.keys(finalData).map((key) => finalData[key]);
                //limit number of users per condition
                finalResult.forEach((item, index) => {
                    finalResult[index]['users'].splice(0, item['users'].length - limit)
                    //remove duplicates
                    let ids = finalResult[index]['users'].map(o => o.user_id)
                    let uniqueMembers = finalResult[index]['users'].filter(({ user_id }, index) => !ids.includes(user_id, index + 1))
                    finalResult[index]['users'] = uniqueMembers
                })
                users.sort(function (a, b) {
                    if (a.pseudo_name) {
                        if (a.pseudo_name?.toUpperCase() < b.pseudo_name?.toUpperCase()) { return -1; }
                        if (a.pseudo_name?.toUpperCase() > b.pseudo_name?.toUpperCase()) { return 1; }
                        return 0;
                    }
                })
                //remove duplicates
                let idsU = users.map(o => o.user_id)
                let uniqueUsers = users.filter(({ user_id }, index) => !idsU.includes(user_id, index + 1))
                finalResult.unshift({
                    condition_group: "All",
                    users: uniqueUsers
                })

                if (condition_details) {
                    resolve({ code: 200, message: "Condition members has been successfully listed", data: finalResult })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Get all conditions along with members list
export const filter_conditions_members = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let promises = []
            let finalData = {}
            var condStr = ""
            var treatStr = ""
            var limitStr = (_body.conditions?.length > 1 ||
                _body.treatments?.length > 1) ? `LIMIT ${_body.limit} OFFSET ${_body.offset}` : "";
            if (_body.conditions && _body.conditions.length > 0) {
                _body.conditions.forEach(item => {
                    condStr = condStr + ` LOWER(c.condition) LIKE LOWER('%${item}%') OR `
                });
            }

            if (_body.treatments && _body.treatments.length > 0) {
                _body.treatments.forEach(item => {
                    treatStr = treatStr + ` LOWER(c.treatment) LIKE LOWER('%${item}%') OR `
                });
            }
            var newCondStr = '(' + condStr.slice(0, -3) + ')'
            var newtreatStr = '(' + treatStr.slice(0, -3) + ')'
            var newGendStr = _body.gender ? `AND gender='${_body.gender}'` : ''; //NOT(gender IS NOT NULL)
            var locStr = _body.location ? `AND LOWER(location) LIKE LOWER('%${_body.location}%')` : '';
            const client = await database().connect();
            try {
                const filter_conditions = `SELECT c.condition, c.treatment_id, 
                c.user_id, u.id as userid, u.pseudo_name,u.first_name,
                u.last_name, u.profile_image, u.gender, u.nationality, u.location,
                (SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=c.user_id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=c.user_id) as connected) 
                FROM conditions c 
                LEFT JOIN users u ON c.user_id = u.id
                WHERE  date_part('year',age(dob)) >= ${_body.min_age ? _body.min_age : 0} AND date_part('year',age(dob)) < ${_body.max_age ? _body.max_age : 100} ${newGendStr} ${locStr} AND ${newCondStr} AND ${newtreatStr} AND c.is_primary=${1}
                ORDER BY u.first_name ASC ${limitStr}`;
                var condition_details = await client.query(filter_conditions);
                condition_details.rows.forEach((item, index) => {
                    if (!finalData[item.condition]) {
                        let data = {
                            condition_group: item.condition,
                            users: [{
                                user_id: item.user_id,
                                condition: item.condition,
                                pseudo_name: item.pseudo_name,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                profile_image: item.profile_image,
                                nationality: item.nationality,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                gender: item.gender,
                                connection_status: item.status == null ? 0 : parseInt(item.status)
                            }],
                        }
                        finalData[item.condition] = data;
                    } else {
                        if (!finalData[item.condition].users.some(function (el) {
                            return el.user_id === item.user_id
                        })) {
                            finalData[item.condition].users.push({
                                user_id: item.user_id,
                                condition: item.condition,
                                pseudo_name: item.pseudo_name,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                profile_image: item.profile_image,
                                nationality: item.nationality,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                gender: item.gender,
                                connection_status: item.status == null ? 0 : parseInt(item.status)
                            })
                        }
                    }
                })
                var finalResult = Object.keys(finalData).map((key) => finalData[key]);
                if (condition_details) {
                    resolve({ code: 200, message: "Members has been successfully fetched", data: finalResult })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//List connections of a member
export const connections_member = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `SELECT c.user_id1, c.user_id2, u.pseudo_name, u2.pseudo_name as u2_pseudo, u.profile_image, u2.profile_image as u2_profile_image, u.nationality,u.location,
                (SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=u.id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=u.id) as connected),
                (SELECT SUM(status) as status2 from(SELECT status FROM connections WHERE user_id1=u2.id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=u2.id) as connected)
                FROM connections c
                LEFT JOIN users u ON u.id=c.user_id2
                LEFT JOIN users u2 ON u2.id=c.user_id1
                WHERE c.status=1  AND (c.user_id1=${_body.user_id} OR c.user_id2=${_body.user_id}) AND u.id!=${_body.userid} AND u2.id!=${_body.userid} ORDER BY u.first_name ASC LIMIT ${_body.limit} OFFSET ${_body.offset}`
                var connect_details = await client.query(query);
                connect_details.rows.forEach(item => {
                    if (item.user_id1 === _body.user_id) {
                        item.pseudo_name = item.pseudo_name
                        item.profile_image = item.profile_image
                        item.connected = item.status == null || item.status == "" ? 0 : parseInt(item.status)
                    } else {
                        item.pseudo_name = item.u2_pseudo
                        item.profile_image = item.u2_profile_image
                        item.connected = item.status2 == null || item.status2 == "" ? 0 : parseInt(item.status2)
                    }
                    if (item.location == "" || item.location == null || item.location == "{}") {
                    }
                    else {
                        item.location = JSON.parse(item.location).city;
                    }
                    delete (item.u2_pseudo)
                    delete (item.status)
                    delete (item.status2)
                    delete (item.u2_profile_image)
                })
                if (connect_details) {
                    resolve({ code: 200, message: "Connecions has been successfully listed", data: connect_details.rows })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Check a user is connected with another user
export const chk_user_connected = (userid1, userid2) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                //check connection request already done
                const chk_connected = {
                    name: 'chk_connected',
                    text: query.chk_connected,
                    values: [userid1, userid2]
                }
                var chk_connection_details = await client.query(chk_connected);
                chk_connection_details.rows[0].status > 0 ? resolve(1) : resolve(0)
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Search in member connections
export const search_member_connections = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let promises = []
            const client = await database().connect();
            try {
                const nullCond = !_body.search_string ? `OR NOT(u.first_name IS NOT NULL)` : ``;
                const member_connections_search = `SELECT c.user_id1, c.user_id2,u.pseudo_name, u.first_name, u.last_name, u.profile_image, u.nationality, u.location FROM connections c
                LEFT JOIN users u ON c.user_id2 = u.id
                WHERE c.user_id1=${_body.user_id} AND c.status=1 AND ( LOWER(u.first_name) LIKE LOWER('%${_body.search_string}%') OR LOWER(u.last_name) LIKE LOWER('%${_body.search_string}%') ${nullCond}) ORDER BY u.first_name ASC LIMIT ${_body.limit} OFFSET ${_body.offset}`;
                var member_connections = await client.query(member_connections_search);
                member_connections.rows.forEach((item, index) => {
                    if (item.location == "" || item.location == null || item.location == "{}") {

                    }
                    else {
                        item.location = JSON.parse(item.location).city;
                    }
                    //check the current user is connected with the member connection
                    promises.push(
                        chk_user_connected(_body.userid, item.user_id2).then(res => {
                            return res;
                        })
                    )
                })
                const results = await Promise.all(promises)
                member_connections.rows.forEach((item, index) => {
                    member_connections.rows[index].connected = results[index]
                })
                if (member_connections) {
                    resolve({ code: 200, message: "Connecions has been successfully listed", data: member_connections.rows })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//Get connection status  between two users
export const chk_connection_status = (userid1, userid2, client) => {
    return new Promise((resolve, reject) => {
        (async () => {
            try {
                //check connection request already done
                const chk_connected = {
                    name: 'chk_connected',
                    text: query.chk_connected,
                    values: [userid1, userid2]
                }
                var chk_connection_details = await client.query(chk_connected);
                chk_connection_details.rows[0].status ? resolve(chk_connection_details.rows[0].status) : resolve(0)
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Get all conditions along with members list
export const conditions_members_v1 = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let finalData = {}
            var conditions = []
            let defaultData = []
            let users = []
            const client = await database().connect();
            try {
                const limit = _body.limit ? _body.limit : 5;
                const offset = _body.offset ? _body.offset : 0;
                if (_body.condition) {
                    var query = `SELECT u.id, u.pseudo_name,u.first_name,u.last_name, 
                    u.profile_image, u.nationality, u.location, c.condition, 
                    c.treatment_id, c.user_id, u.gender,
                    (SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=c.user_id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=c.user_id) as connected)
                    FROM conditions c 
                    LEFT JOIN users u ON u.id = c.user_id
                    WHERE c.condition='${_body.condition}' AND u.id !=${_body.userid} AND c.is_primary=${1}
                    ORDER BY u.pseudo_name ASC LIMIT ${limit} OFFSET ${offset}`;
                    var condition_details = await client.query(query);
                    if (condition_details.rowCount > 0) {
                        condition_details.rows.forEach(item => {
                            if (!finalData[item.condition]) {
                                let data = {
                                    condition_group: item.condition,
                                    users: [{
                                        user_id: item.user_id,
                                        condition: item.condition,
                                        pseudo_name: item.pseudo_name? item.pseudo_name : item.first_name,
                                        first_name: item.first_name,
                                        last_name: item.last_name,
                                        profile_image: item.profile_image,
                                        nationality: item.nationality,
                                        location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                        gender: item.gender,
                                        connection_status: item.status == null ? 0 : parseInt(item.status)
                                    }],
                                }
                                finalData[item.condition] = data;
                            } else {
                                finalData[item.condition].users.push({
                                    user_id: item.user_id,
                                    condition: item.condition,
                                    pseudo_name: item.pseudo_name? item.pseudo_name : item.first_name,
                                    first_name: item.first_name,
                                    last_name: item.last_name,
                                    profile_image: item.profile_image,
                                    nationality: item.nationality,
                                    location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                    gender: item.gender,
                                    connection_status: item.status == null ? 0 : parseInt(item.status)
                                })
                            }
                        })
                        var finalResult = Object.keys(finalData).map((key) => finalData[key]);
                        finalResult.forEach((item, index) => {
                            //remove duplicates
                            let ids = finalResult[index]['users'].map(o => o.user_id)
                            let uniqueMembers = finalResult[index]['users'].filter(({ user_id }, index) => !ids.includes(user_id, index + 1))
                            //remove connected members
                            uniqueMembers = uniqueMembers.filter(user => user.connection_status != 1)
                            finalResult[index]['users'] = uniqueMembers
                        })
                    } else {
                        resolve({ code: 200, message: "No results found", data: {} })
                    }
                } else {
                    var query = `SELECT u.id, u.pseudo_name,u.first_name,u.last_name, 
                    u.profile_image, u.nationality, u.location, c.condition, 
                    c.treatment_id, c.user_id, u.gender,
                    (SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=c.user_id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=c.user_id) as connected)
                    FROM users u
                    LEFT JOIN conditions c ON u.id = c.user_id 
                    WHERE u.id !=${_body.userid} AND c.is_primary=${1}
                    ORDER BY u.pseudo_name ASC LIMIT ${limit} OFFSET ${offset}`;
                    var condition_details = await client.query(query);

                    //get the conditions from strapi
                    const results:any = await getStrapiConditons();
                    results.forEach(element => {
                        conditions.push(element.title)
                    });
                    /* const query2 = `SELECT DISTINCT condition from conditions c WHERE c.is_primary=${1}`
                    const conditions_only = await client.query(query2);
                    conditions_only.rows.forEach(item => {
                        conditions.push(item.condition)
                    }) */
                    condition_details.rows.forEach(item => {
                        let allUsers = {
                            user_id: item.user_id,
                            condition: item.condition,
                            pseudo_name: item.pseudo_name ? item.pseudo_name : item.first_name,
                            first_name: item.first_name,
                            last_name: item.last_name,
                            profile_image: item.profile_image,
                            nationality: item.nationality,
                            location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                            gender: item.gender,
                            connection_status: item.status == null ? 0 : parseInt(item.status)
                        }
                        users.push(allUsers)
                    })
                    users.forEach((item, index) => {
                        //remove duplicates
                        let ids = users.map(o => o.user_id)
                        let uniqueMembers = users.filter(({ user_id }, index) => !ids.includes(user_id, index + 1))
                        users = uniqueMembers
                    })
                    //remove connected members
                    users = users.filter(user => user.connection_status != 1)
                    defaultData.push({
                        condition_group: "All",
                        conditions: conditions,
                        users
                    })
                    finalResult = defaultData;
                }
                if (condition_details) {
                    resolve({ code: 200, message: "Condition members has been successfully listed", data: finalResult })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Age, gender, location only filter
export const filter_conditions_members_v1 = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let finalData = {}
            var condStr = ""
            var treatStr = ""
            var limitStr = `LIMIT ${_body.limit ? _body.limit : 5} OFFSET ${_body.offset ? _body.offset : 0}`;
            if (Array.isArray(_body.conditions) && !_body.conditions[0]) {
                // fetch conditions for age and gender, location filter
                var conditions:any = await filter_conditions_age_gender_location(_body);
                if(conditions.code === 400){
                    resolve({ code: 200, message: conditions.message, data: []})
                }else resolve({ code: 200, message: "Conditions has been successfully fetched", data: conditions})
            }
            if (_body.conditions && _body.conditions.length > 0) {
                _body.conditions.forEach(item => {
                    condStr = condStr + ` LOWER(c.condition) LIKE LOWER('%${item}%') OR `
                });
            }

            if (_body.treatments && _body.treatments.length > 0) {
                _body.treatments.forEach(item => {
                    treatStr = treatStr + ` LOWER(c.treatment) LIKE LOWER('%${item}%') OR `
                });
            }
            var newCondStr = '(' + condStr.slice(0, -3) + ')'
            var newtreatStr = '(' + treatStr.slice(0, -3) + ')'
            var newGendStr = _body.gender ? `AND gender='${_body.gender}'` : ''; //NOT(gender IS NOT NULL)
            var locStr = _body.location ? `AND LOWER(location) LIKE LOWER('%${_body.location}%')` : '';
            const client = await database().connect();
            try {
                const filter_conditions = `SELECT c.condition, c.treatment_id, 
                    c.user_id, u.id as userid, u.pseudo_name,u.first_name,
                    u.last_name, u.profile_image, u.gender, u.nationality, u.location,
                    (SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=c.user_id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=c.user_id) as connected) 
                    FROM conditions c 
                    LEFT JOIN users u ON c.user_id = u.id
                    WHERE  date_part('year',age(dob)) >= ${_body.min_age ? _body.min_age : 0} AND date_part('year',age(dob)) < ${_body.max_age ? _body.max_age : 100} ${newGendStr} ${locStr} AND ${newCondStr} AND ${newtreatStr} AND c.is_primary=${1} AND u.id!=${_body.userid} 
                    ORDER BY u.pseudo_name ASC ${limitStr}`;

                var condition_details = await client.query(filter_conditions);
                condition_details.rows.forEach((item, index) => {
                    if (!finalData[item.condition]) {
                        let data = {
                            condition_group: item.condition,
                            users: [{
                                user_id: item.user_id,
                                condition: item.condition,
                                pseudo_name: item.pseudo_name,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                profile_image: item.profile_image,
                                nationality: item.nationality,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                gender: item.gender,
                                connection_status: item.status == null ? 0 : parseInt(item.status)
                            }],
                        }
                        finalData[item.condition] = data;
                    } else {
                        if (!finalData[item.condition].users.some(function (el) {
                            return el.user_id === item.user_id
                        })) {
                            finalData[item.condition].users.push({
                                user_id: item.user_id,
                                condition: item.condition,
                                pseudo_name: item.pseudo_name,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                profile_image: item.profile_image,
                                nationality: item.nationality,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                gender: item.gender,
                                connection_status: item.status == null ? 0 : parseInt(item.status)
                            })
                        }
                    }
                })
                var finalResult = Object.keys(finalData).map((key) => finalData[key]);
                if (condition_details) {
                    resolve({ code: 200, message: "Members has been successfully fetched", data: finalResult})
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const filter_conditions_age_gender_location = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let conditions = []
            let users = []
            let defaultData = []
            var newGendStr = _body.gender ? `AND gender='${_body.gender}'` : '';
            var locStr = _body.location ? `AND LOWER(location) LIKE LOWER('%${_body.location}%')` : '';
            var limitStr = `LIMIT ${_body.limit ? _body.limit : 5} OFFSET ${_body.offset ? _body.offset : 0}`;
            const client = await database().connect();
            try {
                const query = `SELECT c.condition,
                c.user_id, u.id as userid, u.pseudo_name, u.first_name,
                u.last_name, u.profile_image, u.gender, u.nationality, u.location,
                (SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=c.user_id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=c.user_id) as connected) 
                FROM conditions c 
                LEFT JOIN users u ON u.id = c.user_id
                WHERE date_part('year',age(dob)) >= ${_body.min_age ? _body.min_age : 0} AND date_part('year',age(dob)) < ${_body.max_age ? _body.max_age : 100} ${newGendStr} ${locStr} AND c.is_primary=${1} AND u.id!=${_body.userid} 
                ORDER BY u.pseudo_name ASC ${limitStr}`;
                var conditions_details = await client.query(query);
                if (conditions_details.rowCount > 0) {
                    conditions_details.rows.forEach(item => {
                        conditions.push(item.condition);
                        let allUsers = {
                            user_id: item.user_id,
                            condition: item.condition,
                            pseudo_name: item.pseudo_name ? item.pseudo_name : item.first_name,
                            first_name: item.first_name,
                            last_name: item.last_name,
                            profile_image: item.profile_image,
                            nationality: item.nationality,
                            location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                            gender: item.gender,
                            connection_status: item.status == null ? 0 : parseInt(item.status)
                        }
                        users.push(allUsers)
                    })
                    users.forEach((item, index) => {
                        //remove duplicates
                        let ids = users.map(o => o.user_id)
                        let uniqueMembers = users.filter(({ user_id }, index) => !ids.includes(user_id, index + 1))
                        users = uniqueMembers
                    })
                    var filtered = conditions.filter(function (value, index, array) {
                        return array.indexOf(value) == index;
                    });
                    filtered.sort()
                    defaultData.push({
                        condition_group: "All",
                        conditions: filtered,
                        users
                    })
                    resolve(defaultData)
                } else {
                    resolve({ code: 400, message: "No results found"})
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

function getStrapiConditons(){
    return new Promise((resolve, reject)=>{
        superagent
        .get(process.env.STRAPI_URL + "conditions")
        .end((err, res) => {
            if (err) {
                console.log(err)
                reject(err)
            } else {
                const result = JSON.parse(res.text);
                const conditions_filter = result.filter(item => item.type == "Primary");
                resolve(conditions_filter);
            }
        })
    })
}