import query from '../query/query';
import { database, expertDb } from '../../config/dbConfig';
import * as dotenv from 'dotenv'
dotenv.config()
import * as jwt from 'jsonwebtoken';
import * as config from '../../config/security-config';
import * as crypto from 'crypto';
import * as password from 'secure-random-password';
import { send_sms } from '../../services/smsService';
import { sendGridEmail } from '../../services/sendGridEmail'
const saltRounds = process.env.SALT_ROUNDS;
import readHtml from '../../services/readHtml';
import * as handlebars from 'handlebars';
import { getUserLiveTokens } from './notificationModel';
import * as bcrypt from 'bcrypt';
import * as security_config from '../../config/security-config';
import { ConversationList } from 'twilio/lib/rest/conversations/v1/conversation';
import { hashfunction } from './ExpertUserModel'
import { add_logs } from './LogModel';

//Add clinic by super admin
export const clinic_add = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const expert_user_chk_email_or_phone = {
                    name: 'expert_user_chk_email_or_phone',
                    text: query.expert_user_chk_email_or_phone,
                    values: [_body.manager.email, _body.manager.phone, 'manager']
                }
                var user_status = await client.query(expert_user_chk_email_or_phone);
                if (user_status.rows.length != 0) {
                    reject({ code: 400, message: "Manager email or Phone already exists", data: {} });
                }
                else {
                    //create new clinic
                    const clinic_add = {
                        name: 'clinic_add',
                        text: query.clinic_add,
                        values: [_body.clinicName, _body.address,
                        _body.clinicType, _body.clinicImages ? _body.clinicImages : [],
                        _body.clinicLogo, currentTime, true, _body.description, _body.phone,_body.mhm_fee_percent,_body.tax_percentage]
                    }
                    const clinic_details = await client.query(clinic_add);
                    if (clinic_details) {
                        var clinicId = clinic_details.rows[0].clinic_id
                    }
                    //create new manager for the clinic
                    let password_gen = password.randomPassword({ length: 20, characters: [password.lower, password.upper, password.digits] })
                    hashfunction(password_gen).then(async (result: any) => {
                        const expert_user_register = {
                            name: 'expert_user_register',
                            text: query.expert_user_register,
                            values: [_body.manager.email, _body.manager.firstName,
                            _body.manager.lastName, _body.manager.gender, _body.manager.dob,
                            _body.manager.phone, 'manager', currentTime, result.hash, 1, _body.firstName, clinicId, null, _body.manager.profileImage]
                        }
                        const user_details = await client.query(expert_user_register);
                        const mailData = { to: _body.manager.email, templateName: "invite_admin", set_password_url: process.env.EXPERT_ADMIN_SET_PASSWORD_URL + password_gen+'&id='+user_details.rows[0].id, title: "Welcome to the team!", description: "You are invited to take up the Manager responsibility of MyHealingMate clinic management platform. ", button_label: "Set Password" }
                        sendGridEmail(mailData)
                        resolve({ code: 200, message: "Clinic created with manager!", data: { clinicId: clinicId } });
                    })
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//list clinic details
export const list_clinic_details = (_body) => {
    return new Promise((resolve, reject) => {
        ;
        (async () => {
            const clinicDetails = []
            const client = await database().connect()
            try {
                const get_clinic_details = {
                    name: 'get_clinic_details',
                    text: query.get_clinic_details,
                    values: [_body.clinicId, _body.userid]
                }
                const clinic_details = await client.query(get_clinic_details);
                if (clinic_details.rows.length > 0) {
                    clinic_details.rows.forEach(item => {
                        var imageArray = [];
                        var imageFinalArray = [];
                        if (item.clinicImages != null) {
                            var clinicImageModified = item.clinicImages;
                            var intermediateString = clinicImageModified.replace('{', '');
                            var intermediateString2 = intermediateString.replace('}', '');
                            var finalString = intermediateString2.split('"').join('');
                            imageArray = finalString.split(",");
                            imageArray.forEach(item => {
                                imageFinalArray.push(item)
                            });
                        }
                        const departmentDetails = {
                            clinic_id: item.clinic_id,
                            clinicName: item.clinicName,
                            address: item.address,
                            clinicType: item.clinicType,
                            clinicImages: imageFinalArray,
                            clinicLogo: item.clinicLogo,
                            MhmTaxPercent: item.mhm_tax_percentage,
                            TaxPercent: item.tax_percentage,
                            description: item.description,
                            phone: item.phone,
                            first_name: item.first_name,
                            last_name: item.last_name
                        }
                        clinicDetails.push(departmentDetails)
                    })
                    resolve({ code: 200, message: "Clinic details fetched", data: clinicDetails });
                }
                else {
                    resolve({ code: 200, message: "Invalid clinic id / User not manager for this clinic", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//edit clinic details
export const edit_clinic_details = (_body) => {
    return new Promise((resolve, reject) => {
        ;
        (async () => {
            const client = await database().connect()
            try {
                const edit_clinic_details = {
                    name: 'edit_clinic_details',
                    text: query.edit_clinic_details,
                    values: [_body.clinic_id, _body.clinicLogo, _body.description,_body.MhmTaxPercent,_body.TaxPercent]
                }              
                const clinic_details = await client.query(edit_clinic_details);
                if (clinic_details.rows.length > 0) {
                    resolve({ code: 200, message: "Clinic details edited", data: clinic_details.rows[0] });
                }
                else {
                    resolve({ code: 200, message: "operation failed", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//Add manager by super Admin
export const add_clinic_manager = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const expert_user_chk_email_or_phone = {
                    name: 'expert_user_chk_email_or_phone',
                    text: query.expert_user_chk_email_or_phone,
                    values: [_body.email, _body.phone, 'manager']
                }
                var user_status = await client.query(expert_user_chk_email_or_phone);
                if (user_status.rows.length != 0) {
                    reject({ code: 400, message: "Manager email or Phone already exists", data: {} });
                }
                else {
                    //create new manager for the clinic
                    let password_gen = password.randomPassword({ length: 20, characters: [password.lower, password.upper, password.digits] })
                    hashfunction(password_gen).then(async (result: any) => {
                        const expert_user_register = {
                            name: 'expert_user_register',
                            text: query.expert_user_register,
                            values: [_body.email, _body.firstName,
                            _body.lastName, _body.gender, _body.dob,
                            _body.phone, 'manager', currentTime, result.hash, 1, _body.firstName, _body.clinicId, null, _body.profileImage]
                        }
                        const user_details = await client.query(expert_user_register);
                        const mailData = { to: _body.email, templateName: "invite_admin", set_password_url: process.env.EXPERT_ADMIN_SET_PASSWORD_URL + password_gen+'&id='+user_details.rows[0].id, title: "Welcome to the team!", description: "You are invited to take up the Manager responsibility of MyHealingMate clinic management platform. ", button_label: "Set Password" }
                        sendGridEmail(mailData)
                        resolve({ code: 200, message: "Manager Created Succesfully!", data: {id:user_details.rows[0].id} });
                    })
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}