import query from '../query/query';
import { database, expertDb } from '../../config/dbConfig';
import * as dotenv from 'dotenv'
dotenv.config()
import * as jwt from 'jsonwebtoken';
import * as config from '../../config/security-config';
import * as crypto from 'crypto';
import * as password from 'secure-random-password';
import { send_sms } from '../../services/smsService';
import { sendGridEmail } from '../../services/sendGridEmail'
const saltRounds = process.env.SALT_ROUNDS;
import readHtml from '../../services/readHtml';
import * as handlebars from 'handlebars';
import { getUserLiveTokens, getUserLiveTokensByType } from './notificationModel';
import * as bcrypt from 'bcrypt';
import * as security_config from '../../config/security-config';
import { add_logs } from './LogModel';
const { RtcTokenBuilder, RtmTokenBuilder, RtcRole, RtmRole } = require('agora-access-token');
import { generatePdf } from './pdfGenerator'
import { blobStorageUpload } from './BlobStorageModel';

//Book an appointment
export const appointment_book = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                //check patient exists
                const queryPatient = `SELECT id,first_name,last_name, dob from users where id=${_body.patientID} AND status='1'`;
                const patient_details = await client.query(queryPatient);
                if (patient_details.rows[0].dob && patient_details.rows[0].dob != null) {
                    var date = new Date(patient_details.rows[0].dob);
                    var dob = date.getFullYear() + '-' + (date.getMonth() + 1) + '-' + date.getDate();
                    var year = dob.split("-")[0]
                    var month = dob.split("-")[1]
                    var day = dob.split("-")[2]
                    if (parseInt(month) < 10) {
                        var month = '0' + month
                    }
                    if (parseInt(day) < 10) {
                        var day = '0' + day
                    }
                    var parsedDate = year + '-' + month + '-' + day
                } else parsedDate = ""

                if (patient_details.rowCount == 0) {
                    reject({ code: 400, message: "patient does not exist.", data: {} });
                } else {
                    //check physician exists
                    const queryPhysician =
                        `SELECT u.id, first_name, last_name, profile_image, first_visit_pay as fees,
                        cl.tax_percentage, department_id from users u
                     LEFT JOIN physician_details pd ON pd.physician_id = u.id
                     LEFT JOIN clinic cl ON cl.clinic_id = u.clinic_id
                     where u.id=${_body.physicianID} AND user_type='physician'`;
                    const physician_details = await client.query(queryPhysician);
                    if (physician_details.rowCount == 0) {
                        reject({ code: 400, message: "physician does not exist.", data: {} });
                    } else {
                        //TODO: disallow booking on the same slot for a physician
                        const queryDuplicateAppointment = 
                        `SELECT count(*) FROM "consultationRequest" cr WHERE 
                        cr."appointmentTimestamp"= ${_body.appointmentTimestamp} AND cr."physicianTimeManagementId"= ${_body.physicianTimeManagementId}`;
                        const checkDuplicateAppointment:any = await client.query(queryDuplicateAppointment);
                        console.log(checkDuplicateAppointment.rows[0].count)
                        if (checkDuplicateAppointment.rows[0].count > 0) {
                            reject({ code: 400, message: "An appointment already booked for the timeslot", data: {} });
                        } else {
                            //find physician department
                            var departmentId = physician_details.rows[0].department_id
                            var profileImage = physician_details.rows[0].profile_image
                            var firstName = physician_details.rows[0].first_name
                            var lastName = physician_details.rows[0].last_name
                            var fees = physician_details.rows[0].fees
                            var tax_percentage = physician_details.rows[0].tax_percentage ? physician_details.rows[0].tax_percentage : 0;
                            const cr_add = {
                                name: 'cr_add',
                                text: query.cr_add,
                                values: [_body.physicianID, departmentId, _body.patientID,
                                _body.appointmentTimestamp, _body.physicianTimeManagementId,
                                    'pending', currentTime, _body.disease]
                            }
                            const cr_details = await client.query(cr_add);
                            if (cr_details) {
                                //prepare response data 
                                var tax = fees * (tax_percentage / 100);
                                var processing_fee = fees * .02;
                                var subtotal = fees + processing_fee + tax;
                                const response = {
                                    "appointmentId": cr_details.rows[0].consultationRequestId,
                                    "profile_image": profileImage,
                                    "firstName": firstName,
                                    "lastName": lastName,
                                    "dob": parsedDate,
                                    "patientFirstName": patient_details.rows[0].first_name,
                                    "patientLastName": patient_details.rows[0].last_name,
                                    "fees": fees,
                                    "appointmentTimestamp": _body.appointmentTimestamp,
                                    "created_date": cr_details.rows[0].created_on,
                                    "tax": tax,
                                    "processing_fee": processing_fee,
                                    "subTotal": fees
                                }
                                add_logs('Book appointment', `Userid ${_body.user.userid} has accessed Bookappointement API`, 11, _body.user.userid)
                                resolve({ code: 200, message: "Appointment booked successfully!", data: response })
                            } else {
                                reject({ code: 400, message: "Failed. Please try again.", data: {} });
                            }
                        }                        
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Reschedule appointment by patient
export const appointment_reschedule = (_body) => { console.log(_body)
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                //check the constulation Request Id exists
                const query1 = `SELECT cr."consultationRequestId", cr.status,cr."physicianID",u.first_name,u.last_name,u.gender FROM  "consultationRequest" cr LEFT JOIN users u on cr."patientID"=u.id  WHERE
                cr."consultationRequestId"=${_body.consultationRequestId} AND cr."patientID"=${_body.user.userid}`;
                const cr_details = await client.query(query1)
                console.log("cr_details",cr_details.rows)
                if (cr_details.rowCount == 0) {
                    reject({ code: 400, message: "Invalid consultation Request Id.", data: {} });
                }
                else if (cr_details.rowCount > 0) {
                        //TODO: disallow booking on the same slot for a physician
                        const queryDuplicateAppointment = 
                        `SELECT count(*) FROM "consultationRequest" cr WHERE 
                        cr."appointmentTimestamp"= ${_body.appointmentTimestamp} AND cr."physicianTimeManagementId"= ${_body.physicianTimeManagementId}`;
                        const checkDuplicateAppointment:any = await client.query(queryDuplicateAppointment);
                        console.log(checkDuplicateAppointment.rows[0].count)
                        if (checkDuplicateAppointment.rows[0].count > 0) {
                            reject({ code: 400, message: "An appointment already booked for the timeslot", data: {} });
                        } else {
                            // if exists update the constulationRequest with status reschduledByPatient
                        const query2 = `UPDATE "consultationRequest" 
                        SET "appointmentTimestamp"=${_body.appointmentTimestamp}, status='reschduledByPatient', updated_on=${currentTime},"physicianTimeManagementId"=${_body.physicianTimeManagementId}
                        WHERE "consultationRequestId"=${_body.consultationRequestId} RETURNING "consultationRequestId"`;
                        const cr_details_update = await client.query(query2);
                        console.log("cr_details_update",cr_details_update.rows)
                        if (cr_details_update) {
                            //send notification
                        if (cr_details.rows[0].gender == 'Male') {
                            var notificationTitle = `${cr_details.rows[0].first_name} ${cr_details.rows[0].last_name} rescheduled his appointment`
                        }
                        else {
                            var notificationTitle = `${cr_details.rows[0].first_name} ${cr_details.rows[0].last_name} rescheduled her appointment`

                        }
                        const type = "appointment_reschedule";
                        const data = { appointmentid: cr_details.rows[0].consultationRequestId.toString() };
                        getUserLiveTokens(cr_details.rows[0].physicianID, notificationTitle, _body.user.userid, type, data);
                        add_logs('Reschedule appointment', `Userid ${_body.user.userid} has rescheduled his appointment`, 11, _body.user.userid)
                        resolve({ code: 200, message: "Appointment rescheduled successfully!", data: {} })
                        }
                        else{
                        add_logs('Reschedule appointment', `Userid ${_body.user.userid} failed to reschedule his appointment`, 11, _body.user.userid)
                        reject({ code: 400, message: "Appointment reschedule request failed.", data: {} });
                        }
                    }
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Cancel appointment by patient
export const appointment_cancel = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                //check the constulation Request Id exists
                const query1 = `SELECT cr."consultationRequestId", cr.status,cr."physicianID",u.first_name as patient_first_name,u.last_name as patient_last_name,u.gender,u1.first_name as expert_first_name,u1.last_name as expert_last_name FROM  "consultationRequest" cr LEFT JOIN users u on cr."patientID"=u.id LEFT JOIN users u1 on cr."physicianID"=u1.id  WHERE
                cr."consultationRequestId"=${_body.consultationRequestId} AND cr."patientID"=${_body.user.userid}`;
                const cr_details = await client.query(query1)
                if (cr_details.rowCount == 0) {
                    reject({ code: 400, message: "Invalid consultation Request Id.", data: {} });
                }
                else if (cr_details.rowCount > 0) {
                    var consultationRequestId = cr_details.rows[0].consultationRequestId
                    var consultationStatus = cr_details.rows[0].status
                    // if exists update the constulationRequest with status reschduledByPatient
                    const query2 = `UPDATE "consultationRequest" 
                    SET status='cancelByPatient', updated_on=${currentTime} 
                    WHERE "consultationRequestId"=${_body.consultationRequestId} AND "patientID"=${_body.user.userid}`;
                    const cr_details_update = await client.query(query2);
                    if (cr_details_update) {
                    }
                    //update appointement (if status is accepted)table with status reschduledByPatient
                    if (consultationStatus == 'accepted') {
                        const query3 = `UPDATE appointment 
                        SET status='cancelByPatient', updated_on=${currentTime} 
                        WHERE "consultationRequestId"=${consultationRequestId}`;
                        const appointment_update = await client.query(query3);
                        if (appointment_update) {
                        }
                    }
                    //send notification
                    const type = "appointment_cancelled";
                    const data = { appointmentid: cr_details.rows[0].consultationRequestId.toString() };
                    if (cr_details.rows[0].gender == 'Male') {
                        var notificationTitle = `${cr_details.rows[0].patient_first_name} ${cr_details.rows[0].patient_last_name} cancelled his appointment`
                    }
                    else {
                        var notificationTitle = `${cr_details.rows[0].patient_first_name} ${cr_details.rows[0].patient_last_name} cancelled her appointment`
                    }
                    if (_body.before24hours) {
                        if (cr_details.rows[0].gender == 'Male') {
                            var notificationTitleAdmin = (_body.before24hours == true) ? `A patient ${cr_details.rows[0].patient_first_name} ${cr_details.rows[0].patient_last_name} has cancelled his appointment with Dr. ${cr_details.rows[0].expert_first_name} ${cr_details.rows[0].expert_last_name}. Refund is processed for this patient` : `A patient ${cr_details.rows[0].patient_first_name} ${cr_details.rows[0].patient_last_name} has cancelled his appointment with Dr. ${cr_details.rows[0].expert_first_name} ${cr_details.rows[0].expert_last_name}`
                        }
                        else {
                            var notificationTitleAdmin = (_body.before24hours == true) ? `A patient ${cr_details.rows[0].patient_first_name} ${cr_details.rows[0].patient_last_name} has cancelled her appointment with Dr. ${cr_details.rows[0].expert_first_name} ${cr_details.rows[0].expert_last_name}. Refund is processed for this patient` : `A patient ${cr_details.rows[0].patient_first_name} ${cr_details.rows[0].patient_last_name} has cancelled her appointment with Dr. ${cr_details.rows[0].expert_first_name} ${cr_details.rows[0].expert_last_name}`
                        }
                        getUserLiveTokensByType('manager', notificationTitleAdmin, _body.userid, type, data);
                    }
                    getUserLiveTokens(cr_details.rows[0].physicianID, notificationTitle, _body.user.userid, type, data);
                    add_logs('Cancel appointment', `Userid ${_body.user.userid} has accessed appointment_cancel API`, 11, _body.user.userid)
                    resolve({ code: 200, message: "Appointment cancelled successfully!", data: {} })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Upcoming appointments by patient
export const appointments_upcoming = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTimeT = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                var currentTime1 = new Date();
                var utcDate = Date.UTC(currentTime1.getUTCFullYear(), currentTime1.getUTCMonth(), currentTime1.getUTCDate(),
                    currentTime1.getUTCHours(), currentTime1.getUTCMinutes()) / 1000;
                var tempDate = new Date(utcDate * 1000)
                tempDate.setHours(0)
                tempDate.setMinutes(0)
                var originalDate = tempDate;
                var ISTdate = new Date(originalDate).getTime() - (5.5 * 60 * 60 * 1000);
                var appointmentDate = ISTdate / 1000;
                let finalData = []
                const query = `SELECT cr."appointmentTimestamp", cr."physicianID", cr."patientID", 
                cr.created_on, cr."consultationRequestId" as "appointmentId", cr.status, cr."requestRejectReason",cr.medical_records_for_consultation,
                c.clinic_id,c."clinicName",c.tax_percentage, pd.qualification, pd.speciality, pd.first_visit_pay,
                u.profile_image, u.first_name, u.last_name, ptm."startTimeStamp", ptm."endTimeStamp",ptm.duration,p.refund_status
                FROM "consultationRequest" cr
                LEFT JOIN users u ON u.id = cr."physicianID"
                LEFT JOIN physician_details pd ON pd.physician_id = cr."physicianID"
                LEFT JOIN clinic c ON c.clinic_id = u.clinic_id
                LEFT JOIN physiciantimemanagement ptm ON ptm."physicianTimeManagementId" = cr."physicianTimeManagementId"
                LEFT JOIN payment p ON p.consultationrequestid = cr."consultationRequestId"
                WHERE cr."patientID"=${_body.user.userid} AND ptm."startDay">=${appointmentDate} AND cr.status IN('paymentCompleted', 'onGoing', 'reschduledByPatient', 'cancelByPatient', 'rejected') AND p.payment_status = true
                ORDER BY cr."appointmentTimestamp" ASC`;
                const appoint_details = await client.query(query);
                if (appoint_details.rowCount == 0) {
                    reject({ code: 400, message: "No appointments found.", data: {} });
                } else if (appoint_details.rowCount > 0) {
                    //TODO: find the card and card type of the patient paid
                    // Show the processing_fee according to the card
                    //Indian cards : 2% , outside india: 3%, American express : 3.5% etc.
                    //prepare the data 
                    appoint_details.rows.forEach(item => {
                        // var total_amount = item.tax_percentage ? item.first_visit_pay + (item.first_visit_pay * item.tax_percentage / 100) : item.first_visit_pay;
                        // var procesing_fee = item.first_visit_pay * .02;
                        var total_amount=item.first_visit_pay;
                        var procesing_fee = item.first_visit_pay * .10;
                        var refund_amount = total_amount - procesing_fee;
                        let data = {
                            "profile_image": item.profile_image,
                            "firstName": item.first_name,
                            "lastName": item.last_name,
                            "qualification": item.qualification,
                            "speciality": item.speciality,
                            "appointmentId": item.appointmentId,
                            "physicianId": item.physicianID,
                            "created_on": item.created_on,
                            "appointmentTimestamp": item.appointmentTimestamp,
                            "startTimeStamp": item.startTimeStamp,
                            "endTimeStamp": item.endTimeStamp,
                            "clinicName": item.clinicName,
                            "status": item.status,
                            "total_amount": total_amount,
                            "processing_fee": procesing_fee,
                            "refund_amount": refund_amount,
                            "refund_status": (item.refund_status == 'refunded') ? true : false,
                            "requestRejectReason": item.requestRejectReason,
                            "duration": item.duration,
                            "uploadedReports": item.medical_records_for_consultation ? true : false
                        }
                        finalData.push(data)
                    })
                    add_logs('Upcoming appointment', `Userid ${_body.user.userid} has accessed appointment_upcoming API`, 11, _body.user.userid)
                    resolve({ code: 200, message: "Upcoming appointments listed successfully!", data: finalData })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const rtc_TokenGenration_for_call = (_body) => {
    return new Promise((resolve, reject) => {
        let role = RtcRole.PUBLISHER
        var channelName = '';
        channelName = randomName();
        if (!_body.userId) {
            reject({ code: 400, message: "UserId is required", data: {} });
        }
        try {
            var key = RtcTokenBuilder.buildTokenWithUid('2c9f7fc32d4c45f5aa31315eb0f1b83d', 'bf772498d14941a6b4662ad4f2d0a14b', channelName, _body.userId, role);
            resolve({ code: 200, message: "Token Generated", data: { "channelName": channelName, "token": key } });
        }
        catch (e) {
            console.log(e);
            reject({ code: 400, message: "Unable to connect Agora server. Please try again.", data: {} });
        }
    })
}
const randomName = () => {
    var result = '';
    var name = '';
    var characters = 'abcdefghijklmnopqrstuvwxyz';
    var charactersLength = characters.length;
    for (var i = 0; i < 3; i++) {
        var result = '';
        for (var j = 0; j < 4; j++) {
            result += characters.charAt(Math.floor(Math.random() *
                charactersLength));
        }
        name += (i != 2) ? result + "-" : result;
    }
    return name;
}

// add consultation notes by section
export const add_consultation_notes_by_section = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                if (_body.section == "caseHistory") {
                    var query = `UPDATE consultation SET case_history='${_body.content}' WHERE "consultationId"=${_body.consultationId} RETURNING "consultationId",case_history`;
                }
                else if (_body.section == "presentingComplaint") {
                    var query = `UPDATE consultation SET presenting_complaint='${_body.content}' WHERE "consultationId"=${_body.consultationId} RETURNING "consultationId",presenting_complaint`;
                }
                else if (_body.section == "treatmentAdvice") {
                    var query = `UPDATE consultation SET treatment_advice='${_body.content}' WHERE "consultationId"=${_body.consultationId} RETURNING "consultationId",treatment_advice`;
                }
                else {
                    reject({ code: 400, message: "invalid section name", data: {} });
                }

                const consultationNotes = await client.query(query);
                if (consultationNotes) {
                    resolve({ code: 200, message: "Consultation notes added successfully", data: consultationNotes.rows[0] })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// get consultation summary for prescription
export const Get_consultation_summary = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const consultation_summary = {
                    name: 'consultation_summary',
                    text: query.consultation_summary,
                    values: [_body.consultationId]
                }
                const prescription = await client.query(consultation_summary);
                if (prescription) {
                    resolve({ code: 200, message: "Prescription details fetched successfully", data: prescription.rows[0] });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// get consultation summary for prescription
export const patient_records_for_consult = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const get_patient_records_for_consult = {
                    name: 'get_patient_records_for_consult',
                    text: query.get_patient_records_for_consult,
                    values: [_body.consultationId]
                }
                const records = await client.query(get_patient_records_for_consult);
                if (records) {
                    var recordArray = [];
                    var recordFinalArray = [];
                    if (records.rows[0].medical_records_for_consultation != null) {
                        var departmentImageModified = records.rows[0].medical_records_for_consultation;
                        var intermediateString = departmentImageModified.replace('{', '');
                        var intermediateString2 = intermediateString.replace('}', '');
                        var finalString = intermediateString2.split('"').join('');
                        recordArray = finalString.split(",");
                        recordArray.forEach(item => {
                            recordFinalArray.push(item)
                        });
                    }
                    resolve({ code: 200, message: "Patient records fetched successfully", data: recordFinalArray });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// start consultation for Expert
export const expert_start_consultation = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            const currentTime = Math.floor(Date.now() / 1000);
            let role = RtcRole.PUBLISHER
            const connection_details = await set_channel_name(_body);
            const channelName = connection_details["channelname"];
            const consultationId = connection_details["consultationId"]
            const status = connection_details["status"]
            if (status == "ended") {
                reject({ code: 400, message: "Consultation ended", data: {} });
            }
            let expirationTimeInSeconds = 3600
            let privilegeExpiredTs = currentTime + expirationTimeInSeconds
            try {
                var key = RtcTokenBuilder.buildTokenWithUid(process.env.APP_ID, process.env.APP_CERTIFICATE, channelName, _body.user.userid, role, privilegeExpiredTs);
                var data = { "appointmentid": _body.appointmentid.toString() };
                var startSetup = await expert_consultation_notification(_body, data, status);
                const patient_details = `SELECT first_name,last_name,profile_image,id FROM users WHERE id= (SELECT "patientID" FROM "consultationRequest" WHERE "consultationRequestId"=${_body.appointmentid} )`
                const records = await client.query(patient_details);
                call_log(_body.user.userid, 'started', 'physician', _body.appointmentid)
                add_logs('Expert Initiated Consultation', `Expert with id : ${_body.userid} has initiated consultation`, 11, _body.user.userid)
                resolve({ code: 200, message: "Token Generated", data: { "consultationId": consultationId, "channelName": channelName, "token": key, "patientId": records.rows[0].id, "patientFirstName": records.rows[0].first_name, "patientLastName": records.rows[0].last_name, "patientProfileImage": records.rows[0].profile_image } });
            }
            catch (e) {
                console.log(e);
                reject({ code: 400, message: "Unable to connect Agora server. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// expert Consultation setup
export const expert_consultation_notification = (_body, notificationData, status) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const participants_query = `SELECT cr."patientID",u.first_name,u.last_name,cr.status FROM "consultationRequest" cr LEFT JOIN users u ON u.id=cr."physicianID" WHERE cr."consultationRequestId"= ${_body.appointmentid}`
                const records = await client.query(participants_query);
                const first_joined_check=`SELECT log_id FROM call_logs WHERE appointment_id =${_body.appointmentid} AND call_status='started' AND user_type ='physician'`;
                const first_joined_checked = await client.query(first_joined_check);
                var joined_first_time=(first_joined_checked.rowCount==0)?true:false;
                if (records.rows.length != 0) {
                    if (records.rows[0].status == "completed") {
                        resolve("ended");
                    }
                    else if (status == "onGoing"&&!joined_first_time) {
                        const notificationTitle = `Dr.${records.rows[0].first_name} ${records.rows[0].last_name} rejoined for consultation.`
                        const type = "rejoined_call";
                        const data = notificationData;
                        getUserLiveTokens(records.rows[0].patientID, notificationTitle, _body.user.userid, type, data);
                        resolve("success");
                    }
                    else {
                        const notificationTitle = `Dr.${records.rows[0].first_name} ${records.rows[0].last_name} joined for consultation. Please Join.`
                        const type = "incoming_call";
                        const data = notificationData;
                        getUserLiveTokens(records.rows[0].patientID, notificationTitle, _body.user.userid, type, data);
                        resolve("success");
                    }
                }
                else {
                    resolve("failed");
                }

            } catch (e) {
                console.log(e);
                reject("fail");
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// start consultation for Patient
export const patient_start_consultation = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect();
            let role = RtcRole.PUBLISHER
            const connection_details = await set_channel_name(_body);
            const channelName = connection_details["channelname"];
            const consultationId = connection_details["consultationId"]
            const status = connection_details["status"]
            if (status == "ended") {
                reject({ code: 400, message: "Consultation ended", data: {} });
            }
            let expirationTimeInSeconds = 3600
            let privilegeExpiredTs = currentTime + expirationTimeInSeconds
            try {
                var key = RtcTokenBuilder.buildTokenWithUid(process.env.APP_ID, process.env.APP_CERTIFICATE, channelName, _body.userid, role, privilegeExpiredTs);
                var data = { "appointmentid": _body.appointmentid.toString() };
                var startSetup = await patient_consultation_notification(_body, data, status);
                const physician_details = `SELECT first_name,last_name,profile_image FROM users WHERE id= (SELECT "physicianID" FROM "consultationRequest" WHERE "consultationRequestId"=${_body.appointmentid} )`
                const records = await client.query(physician_details);
                call_log(_body.userid, 'started', 'patient', _body.appointmentid)
                add_logs('Patient Initiated Consultation', `Patient with id : ${_body.userid} has initiated consultation`, 11, _body.userid)
                resolve({ code: 200, message: "Token Generated", data: { "consultationId": consultationId, "channelName": channelName, "token": key, "physicianFirstName": records.rows[0].first_name, "physicianLastName": records.rows[0].last_name, "physicianProfileImage": records.rows[0].profile_image } });
            }
            catch (e) {
                console.log(e);
                reject({ code: 400, message: "Unable to connect Agora server. Please try again.", data: {} });
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// patient Consultation setup
export const patient_consultation_notification = (_body, notificationData, status) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const participants_query = `SELECT cr."physicianID",u.first_name,u.last_name,ue.first_name as expert_first_name,ue.last_name as expert_last_name,ue.phone,cr.status FROM "consultationRequest" cr LEFT JOIN users u ON u.id=cr."patientID" LEFT JOIN users ue ON ue.id=cr."physicianID" WHERE cr."consultationRequestId"= ${_body.appointmentid}`
                const records = await client.query(participants_query);
                const first_joined_check=`SELECT log_id FROM call_logs  WHERE appointment_id =${_body.appointmentid} AND call_status='started' AND user_type ='patient'`;
                const first_joined_checked = await client.query(first_joined_check);
                var joined_first_time=(first_joined_checked.rowCount==0)?true:false;
                if (records.rows.length != 0) {
                    if (records.rows[0].status == "completed") {
                        resolve("ended");
                    }
                    else if (status == "onGoing"&&!joined_first_time) {
                        const notificationTitle = `${records.rows[0].first_name} ${records.rows[0].last_name} rejoined for consultation.`
                        const type = "rejoined_call";
                        const data = notificationData;
                        getUserLiveTokens(records.rows[0].physicianID, notificationTitle, _body.userid, type, data);
                        resolve("success");
                    }
                    else {
                        const notificationTitle = `${records.rows[0].first_name} ${records.rows[0].last_name} joined for consultation. Please Join.`
                        const type = "incoming_call_from_patient";
                        const data = notificationData;
                        getUserLiveTokens(records.rows[0].physicianID, notificationTitle, _body.userid, type, data);
                        if (records.rows[0].phone) {
                            var title = `Hi ${records.rows[0].expert_first_name} ${records.rows[0].expert_last_name}, ${records.rows[0].first_name} ${records.rows[0].last_name} joined for consultation on MyHealingMate platform. Please Join.`
                            send_sms(title, records.rows[0].phone, '');
                        }
                        resolve("success");
                    }
                }
                else {
                    resolve("failed");
                }

            } catch (e) {
                console.log(e);
                reject("fail");
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// set channel name
export const set_channel_name = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const check_consultation_entry = `SELECT channel_name,"consultationId" FROM consultation WHERE "appointmentId" =${_body.appointmentid}`
                const consulation_entry = await client.query(check_consultation_entry);
                if (consulation_entry.rows.length == 0) {
                    var channelname = await randomName()
                    const add_consultation = `INSERT INTO consultation("appointmentId","consultationStartTimestamp",created_on, updated_on, "consultation_type",channel_name) values (${_body.appointmentid},${currentTime},${currentTime},${currentTime},${"'" + _body.type + "'"},${"'" + channelname + "'"}) RETURNING "consultationId", created_on`
                    const status = await client.query(add_consultation);
                    if (status) {
                        var status_type = "onGoing"
                        const update_consultation_status = `UPDATE "consultationRequest" SET status='${status_type}' WHERE "consultationRequestId"= ${_body.appointmentid}`
                        const consultaion_status = await client.query(update_consultation_status);
                        if (consultaion_status) {
                            resolve({ "channelname": channelname, "consultationId": status.rows[0].consultationId, "status": "started" });
                        }
                        else {
                            reject("fail");
                        }
                    }
                    else {
                        reject("fail");
                    }
                }
                else {
                    const check_consultation_status = `SELECT status FROM "consultationRequest" WHERE "consultationRequestId"=${_body.appointmentid}`
                    const consulation_status = await client.query(check_consultation_status);
                    if (consulation_status.rows[0].status == "completed") {
                        resolve({ "channelname": consulation_entry.rows[0].channel_name, "consultationId": consulation_entry.rows[0].consultationId, "status": "ended" });
                    }
                    else {
                        resolve({ "channelname": consulation_entry.rows[0].channel_name, "consultationId": consulation_entry.rows[0].consultationId, "status": "onGoing" });
                    }
                }

            } catch (e) {
                console.log(e);
                reject("fail");
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}



// cancl appointment by expert
export const expert_reject_appointment = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const query1 = `SELECT cr."consultationRequestId", cr.status,cr."appointmentTimestamp",u.first_name as patient_first_name ,u.last_name as patient_last_name,u1.first_name as expert_first_name,u1.last_name as expert_last_name FROM  "consultationRequest" cr LEFT JOIN users u ON u.id=cr."patientID" LEFT JOIN users u1 ON u1.id=cr."physicianID" WHERE
                cr."consultationRequestId"=${_body.appointmentid} AND cr."physicianID"=${_body.user.userid}`;
                const cr_details = await client.query(query1)
                if (cr_details.rowCount == 0) {
                    reject({ code: 400, message: "Invalid consultation Request Id.", data: {} });
                }
                else if (cr_details.rowCount > 0) {
                    const cancel_appointment_by_expert = {
                        name: 'cancel_appointment_by_expert',
                        text: query.cancel_appointment_by_expert,
                        values: ['rejected', currentTime, _body.reason, _body.appointmentid]
                    }
                    const records = await client.query(cancel_appointment_by_expert);
                    if (records) {
                        const notificationTitle = `Your Appointment with Dr. ${cr_details.rows[0].expert_first_name} ${cr_details.rows[0].expert_last_name} is cancelled by the expert`;
                        const notificationTitleAdmin = `Dr. ${cr_details.rows[0].expert_first_name} ${cr_details.rows[0].expert_last_name} has cancelled appointment with ${cr_details.rows[0].patient_first_name} ${cr_details.rows[0].patient_last_name}`;
                        const type = "appointment_status";
                        const data = { appointmentid: _body.appointmentid.toString(), reason: _body.reason.toString() };
                        getUserLiveTokens(records.rows[0].patientID, notificationTitle, _body.user.userid, type, data);
                        getUserLiveTokensByType('manager', notificationTitleAdmin, _body.userid, type, data);
                        add_logs('Expert Rejected Consultation', `Expert with id : ${_body.user.userid} has initiated consultation`, 11, _body.user.userid)
                        resolve({ code: 200, message: "Appointment cancelled succesfully", data: records.rows[0] });
                    }
                }
                else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Past appointments of patient
export const appointments_past = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                let finalData = []
                const query = `SELECT cr."appointmentTimestamp", cr."physicianID", cr."patientID", 
                cr.created_on, cr."consultationRequestId" as "appointmentId", cr.status,
                c.clinic_id,c."clinicName", pd.qualification, pd.speciality,p.refund_status,
                u.profile_image, u.first_name, u.last_name
                FROM "consultationRequest" cr
                LEFT JOIN users u ON u.id = cr."physicianID"
                LEFT JOIN physician_details pd ON pd.physician_id = cr."physicianID"
                LEFT JOIN clinic c ON c.clinic_id = u.clinic_id
                LEFT JOIN payment p ON p.consultationrequestid = cr."consultationRequestId"
                WHERE cr."patientID"=${_body.user.userid} AND cr."appointmentTimestamp" < ${currentTime} AND cr.status <> 'pending'
                ORDER BY created_on DESC`;
                const appoint_details = await client.query(query);
                if (appoint_details.rowCount == 0) {
                    reject({ code: 400, message: "No appointments found.", data: {} });
                } else if (appoint_details.rowCount > 0) {
                    appoint_details.rows.forEach(item => {
                        let data = {
                            "profile_image": item.profile_image,
                            "firstName": item.first_name,
                            "lastName": item.last_name,
                            "qualification": item.qualification,
                            "speciality": item.speciality,
                            "appointmentId": item.appointmentId,
                            "physicianId": item.physicianID,
                            "created_on": item.created_on,
                            "appointmentTimestamp": item.appointmentTimestamp,
                            "clinicName": item.clinicName,
                            "status": item.status == 'paymentCompleted' ? 'Not completed' : item.status,
                            "refund_status": (item.refund_status != 'na') ? true : false
                        }
                        finalData.push(data)
                    })
                    add_logs('Past appointments', `Userid ${_body.user.userid} has accessed appointment_past API`, 11, _body.user.userid)
                    resolve({ code: 200, message: "Past appointments listed successfully!", data: finalData })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//Pdf generation
export const prescription_to_pdf = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                if (_body.consultationId && _body.physicianID && _body.patientID && _body.patient_first_name && _body.patient_last_name && _body.expert_first_name && _body.expert_last_name && _body.qualification && _body.address_line1 && _body.address_line2 && _body.state_name && _body.registraion_number && _body.sign && _body.clinicName && _body.clinicAddress && _body.clinicLogo && _body.clinicPhone && _body.consultationStartTimestamp && _body.consultationEndTimestamp) {
                    const page = await generatePdf(_body);
                    if (page["status"] == "success") {
                        var blobName = page["data"].uploadData[0].blobName
                        const bloblink = await blobStorageUpload(page["data"])
                        var query = `UPDATE "consultation" SET prescription='${blobName}' WHERE "consultationId"= ${_body.consultationId}`;
                        const prescription_to_pdf = await client.query(query);
                        if (prescription_to_pdf) {
                            const notificationTitle = `Dr. ${_body.expert_first_name} ${_body.expert_last_name} has sent you the prescription summary click here to view it.`
                            const type = "prescription_added";
                            const data = { "prescription": blobName.toString() };
                            getUserLiveTokens(_body.patientID, notificationTitle, _body.physicianID, type, data);
                            add_logs('Expert Added Prescription', `Expert with id : ${_body.physicianID} has added prescription`, 11, _body.physicianID)
                            resolve({ code: 200, message: "Prescription submitted Succesfully!", data: { "prescription": blobName } })
                        }
                        else {
                            reject({ code: 400, message: "Failed. Please try again.", data: {} });
                        }
                    }
                    else {
                        reject({ code: 400, message: "Error in pdf generation", data: {} });
                    }
                }
                else {
                    reject({ code: 400, message: "Please provide all values", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//end consultation by expert
export const end_consultation = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const check_completed = `SELECT status,(SELECT "consultationId" FROM "consultation" WHERE "appointmentId"= ${_body.appointmentid}) FROM "consultationRequest" WHERE "consultationRequestId"= ${_body.appointmentid}`
                const complete_status = await client.query(check_completed);
                if (complete_status.rows[0].status == 'completed') {
                    call_log(_body.user.userid, 'ended', 'physician', _body.appointmentid)
                    add_logs('Consultation ended', `physician with id : ${_body.user.userid} has ended consultation`, 11, _body.user.userid)
                    resolve({ code: 200, message: "Consultation ended Succesfully!", data: { "consultationId": complete_status.rows[0].consultationId } })
                }
                else {
                    const consultation = `UPDATE consultation SET "consultationEndTimestamp"= ${currentTime}  WHERE "appointmentId"= ${_body.appointmentid} returning "consultationId"`
                    const consultation_records = await client.query(consultation);
                    if (consultation_records) {
                        var status_type = "completed"
                        const end_call = `UPDATE "consultationRequest" SET status=${"'" + status_type + "'"} WHERE "consultationRequestId"= ${_body.appointmentid}`
                        const records = await client.query(end_call);
                        if (records) {
                            call_log(_body.user.userid, 'ended', 'physician', _body.appointmentid)
                            add_logs('Consultation ended', `physician with id : ${_body.user.userid} has ended consultation`, 11, _body.user.userid)
                            resolve({ code: 200, message: "Consultation ended Succesfully!", data: { "consultationId": consultation_records.rows[0].consultationId } })
                        }
                        else {
                            reject({ code: 400, message: "Failed. Please try again.", data: {} });
                        }
                    }
                    else {
                        reject({ code: 400, message: "Consultation does not exist.", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//end consultation by patient
export const end_consultation_by_patient = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const check_completed = `SELECT status,(SELECT "consultationId" FROM "consultation" WHERE "appointmentId"= ${_body.appointmentid}) FROM "consultationRequest" WHERE "consultationRequestId"= ${_body.appointmentid}`
                const complete_status = await client.query(check_completed);
                if (complete_status.rows[0].status == 'completed') {
                    call_log(_body.userid, 'ended', 'patient', _body.appointmentid)
                    add_logs('Consultation ended', `patient with id : ${_body.userid} has ended consultation`, 11, _body.userid)
                    resolve({ code: 200, message: "Consultation ended Succesfully!", data: { "consultationId": complete_status.rows[0].consultationId } })
                }
                else {
                    const consultation = `UPDATE consultation SET "consultationEndTimestamp"= ${currentTime}  WHERE "appointmentId"= ${_body.appointmentid} returning "consultationId"`
                    const consultation_records = await client.query(consultation);
                    if (consultation_records) {
                        var status_type = "completed"
                        const end_call = `UPDATE "consultationRequest" SET status=${"'" + status_type + "'"} WHERE "consultationRequestId"= ${_body.appointmentid}`
                        const records = await client.query(end_call);
                        if (records) {
                            call_log(_body.userid, 'ended', 'patient', _body.appointmentid)
                            add_logs('Consultation ended', `patient with id : ${_body.userid} has ended consultation`, 11, _body.userid)
                            resolve({ code: 200, message: "Consultation ended Succesfully!", data: { "consultationId": consultation_records.rows[0].consultationId } })
                        }
                        else {
                            reject({ code: 400, message: "Failed. Please try again.", data: {} });
                        }
                    }
                    else {
                        reject({ code: 400, message: "Consultation does not exist.", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//Past appointments details
export const details_past_appointments = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const query = `SELECT cr."physicianID", cr."consultationRequestId", cr.status,
                cr."appointmentTimestamp", c.consultation_type, 
                c.prescription, cl."clinicName", cl.tax_percentage, pd.qualification, 
                pd.speciality, pd.first_visit_pay as consultation_fee, u.profile_image, 
                u.first_name, u.last_name, p.payment_method_details, p.refund_status,
                ptm."startTimeStamp", ptm."endTimeStamp", ptm.duration FROM "consultationRequest" cr
                LEFT JOIN consultation c ON c."appointmentId" = cr."consultationRequestId"
                LEFT JOIN users u ON u.id = cr."physicianID"
                LEFT JOIN physician_details pd ON pd.physician_id = cr."physicianID"
                LEFT JOIN clinic cl ON cl.clinic_id = u.clinic_id
                LEFT JOIN payment p ON p.consultationrequestid = cr."consultationRequestId"
                LEFT JOIN physiciantimemanagement ptm ON ptm."physicianTimeManagementId" = cr."physicianTimeManagementId"

                WHERE cr."patientID"=${_body.userid} AND cr."consultationRequestId"=${_body.appointmentId}`;
                //console.log(query)
                const past_appointment_details = await client.query(query);
                if (past_appointment_details.rowCount > 0) {
                    past_appointment_details.rows.forEach(element => {
                        var consultation_fee = element.consultation_fee
                        var processing_fee = element.consultation_fee * .02
                        var tax = element.tax_percentage ? element.consultation_fee * (element.tax_percentage / 100) : 0

                        element.consultation_fee = consultation_fee
                        element.processing_fee = processing_fee
                        element.tax = tax
                        element.total = consultation_fee + processing_fee + tax
                        element.payment_method = element.payment_method_details ? JSON.parse(element.payment_method_details).type : ""
                        delete (element.payment_method_details)
                        element.refund_status = (element.refund_status != 'na') ? true : false;
                    });
                    resolve({ code: 200, message: "Past appointments details fetched succssfully", data: past_appointment_details.rows })
                } else {
                    reject({ code: 400, message: "No appointmemnts found.", data: {} });
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//save call logs
export const call_log = (id, status, type, appointmentid) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const query = `INSERT INTO call_logs(user_id,call_status,user_type,updated_on,appointment_id) VALUES (${id},'${status}','${type}',${currentTime},${appointmentid}) RETURNING log_id`;
                const log_added = await client.query(query);
                resolve(true)
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//save call logs
export const disconnected_call_data_save = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `INSERT INTO call_logs(user_id,call_status,user_type,updated_on,appointment_id) VALUES (${body.userid},'disconnected','${body.user_type}',${body.call_end_time},${body.appointmentid}) RETURNING log_id`;
                const log_added = await client.query(query);
                if (log_added) {
                    resolve({ code: 200, message: "Disconnected call details added successfully", data: {} })
                }
                else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//get duration details
export const getDurationDetails = (userid, timestamp) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `SELECT cr."appointmentTimestamp", cr."physicianID", cr."patientID", 
                cr.created_on, cr."consultationRequestId" as "appointmentId", cr.status, cr."requestRejectReason",cr.medical_records_for_consultation,
                c.clinic_id,c."clinicName", pd.qualification, pd.speciality, pd.first_visit_pay,
                u.profile_image, u.first_name, u.last_name, ptm."startTimeStamp", ptm."endTimeStamp",ptm.duration,p.refund_status
                FROM "consultationRequest" cr
                LEFT JOIN users u ON u.id = cr."physicianID"
                LEFT JOIN physician_details pd ON pd.physician_id = cr."physicianID"
                LEFT JOIN clinic c ON c.clinic_id = u.clinic_id
                LEFT JOIN physiciantimemanagement ptm ON ptm."physicianTimeManagementId" = cr."physicianTimeManagementId"
                LEFT JOIN payment p ON p.consultationrequestid = cr."consultationRequestId"
                WHERE cr."patientID"=${userid} AND cr."appointmentTimestamp" < ${timestamp} AND cr.status IN('paymentCompleted', 'onGoing', 'reschduledByPatient')
                ORDER BY created_on DESC`;
                const appointment_details = await client.query(query);
                if (appointment_details.rowCount > 0) {
                    resolve(appointment_details.rows)
                } else {
                    resolve("")
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}