import query from '../query/query';
import { database, expertDb } from '../../config/dbConfig';
import * as dotenv from 'dotenv'
dotenv.config()
import * as jwt from 'jsonwebtoken';
import * as config from '../../config/security-config';
import * as crypto from 'crypto';
import * as password from 'secure-random-password';
import { send_sms } from '../../services/smsService';
import { sendGridEmail } from '../../services/sendGridEmail'
const saltRounds = process.env.SALT_ROUNDS;
import readHtml from '../../services/readHtml';
import * as handlebars from 'handlebars';
import { getUserLiveTokens } from './notificationModel';
import * as bcrypt from 'bcrypt';
import * as security_config from '../../config/security-config';

//Add department manager

export const department_add = (_body) => {
    const otp = Math.floor(100000 + Math.random() * 900000);
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                //create new department
                const department_add = {
                    name: 'department_add',
                    text: query.department_add,
                    values: [_body.clinicId,
                    _body.departmentName, _body.departmentDescription,
                    _body.departmentImages, _body.departmentIndexId, _body.departmentLogo,
                        currentTime, _body.departmentType, _body.userid]
                }
                const department_details = await client.query(department_add);
                if (department_details) {
                    resolve({ code: 200, message: "Department created!", data: department_details.rows[0] })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Find clinic Details
export const get_clinic_details = (departmentId) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                //get clinic details
                const query = `SELECT "clinic_id" from department WHERE "departmentId"=${departmentId}`;
                const clinic_details = await client.query(query)
                if (clinic_details) {
                    resolve(clinic_details.rows[0].clinic_id)
                } else {
                    resolve(null)
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//list departmentIndex

export const list_departmentIndex = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const departmentindex_list = {
                    name: 'departmentindex_list',
                    text: query.departmentindex_list,
                    values: [1]
                }
                const department_index_details = await client.query(departmentindex_list);
                if (department_index_details) {
                    resolve({ code: 200, message: "Department Indices listed!", data: department_index_details.rows })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//list departments by Clinic id

export const list_departments_by_clinic_id = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var departments = [];
            var pagination = "";
            var searchkey = "";
            var searchField = 'd."departmentName"'
            if (_body.search_key) {
                searchkey = " AND LOWER(" + searchField + ") LIKE LOWER('%" + _body.search_key + "%') "
            }
            if (_body.limit != undefined && _body.offset != undefined) {
                pagination = 'LIMIT ' + _body.limit + ' OFFSET ' + _body.offset
            }
            const client = await database().connect()
            const departmentCount = await get_departmentsCount(_body.clinicId, searchkey)
            try {
                const department_list_by_clinic_id = {
                    name: 'department_list_by_clinic_id',
                    text: query.department_list_by_clinic_id + searchkey + ' group by d."departmentId" ORDER BY d.created_on DESC ' + pagination,
                    values: [_body.clinicId, "open"]
                }
                const department_index_details = await client.query(department_list_by_clinic_id);
                if (department_index_details) {
                    department_index_details.rows.forEach(item => {
                        var imageArray = [];
                        var imageFinalArray = [];
                        if (item.departmentImages != null) {
                            var departmentImageModified = item.departmentImages;
                            var intermediateString = departmentImageModified.replace('{', '');
                            var intermediateString2 = intermediateString.replace('}', '');
                            var finalString = intermediateString2.split('"').join('');
                            imageArray = finalString.split(",");
                            imageArray.forEach(item => {
                                imageFinalArray.push(item)
                            });
                        }
                        const departmentDetails = {
                            clinic_id: item.clinic_id,
                            departmentId: item.departmentId,
                            departmentName: item.departmentName,
                            departmentDescription: item.departmentDescription,
                            departmentImages: imageFinalArray,
                            departmentIndexId: item.departmentIndexId,
                            departmentLogo: (item.departmentLogo == null) ? "" : item.departmentLogo,
                            physiciancount: item.physiciancount
                        }
                        departments.push(departmentDetails)
                    })
                    resolve({ code: 200, message: "Departments listed for clinic!", data: { departmentsCount: departmentCount, departments: departments } })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// find departments count in clinic
export const get_departmentsCount = (clinic_Id, searchkey) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                //get clinic details
                const query = `SELECT COUNT(d."departmentId") from department d WHERE d.clinic_id=${clinic_Id} AND d.status='open' ${searchkey}`;
                const clinic_details = await client.query(query)
                if (clinic_details) {
                    resolve(clinic_details.rows[0].count)
                } else {
                    resolve(null)
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// find departments details by id
export const department_details_by_id = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const get_department_details_by_id = {
                    name: 'get_department_details_by_id',
                    text: query.get_department_details_by_id,
                    values: [_body.departmentId, "physician", "completed"]
                }
                const department_index_details = await client.query(get_department_details_by_id);
                if (department_index_details) {
                    var imageArray = [];
                    var imageFinalArray = [];
                    if (department_index_details.rows[0].departmentImages != null) {
                        var departmentImageModified = department_index_details.rows[0].departmentImages;
                        var intermediateString = departmentImageModified.replace('{', '');
                        var intermediateString2 = intermediateString.replace('}', '');
                        var finalString = intermediateString2.split('"').join('');
                        imageArray = finalString.split(",");
                        imageArray.forEach(item => {
                            imageFinalArray.push(item)
                        });
                    }
                    const departmentDetails = {
                        clinic_id: department_index_details.rows[0].clinic_id,
                        departmentId: department_index_details.rows[0].departmentId,
                        departmentName: department_index_details.rows[0].departmentName,
                        departmentDescription: department_index_details.rows[0].departmentDescription,
                        departmentImages: imageFinalArray,
                        departmentIndexId: department_index_details.rows[0].departmentIndexId,
                        departmentLogo: (department_index_details.rows[0].departmentLogo == null) ? "" : department_index_details.rows[0].departmentLogo,
                        physiciancount: department_index_details.rows[0].physiciancount,
                        patientCount: department_index_details.rows[0].patientcount,
                        consultationCount: department_index_details.rows[0].consultationcount
                    }
                    resolve({ code: 200, message: "Departments details listed successfully !", data: departmentDetails })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// edit departments
export const edit_department_by_id = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const edit_department = {
                    name: 'edit_department',
                    text: query.edit_department,
                    values: [_body.departmentName, _body.departmentDescription, _body.departmentImages, _body.departmentIndexId, _body.departmentLogo, currentTime, _body.userid, _body.departmentId]
                }
                const departmentEdited = await client.query(edit_department);
                if (departmentEdited) {
                    resolve({ code: 200, message: "Departments edited successfully !", data: departmentEdited.rows[0] })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// delete department
export const delete_department_by_id = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const queryPhysician = `SELECT count(id) from users u where department_id=${_body.departmentId} AND user_type='physician' AND status::integer=1`;
                const physician_count = await client.query(queryPhysician);
                if (physician_count.rows[0].count > 0) {
                    reject({ code: 400, message: "Failed, There are experts under this speciality", data: {} });
                }
                else {
                    const delete_department = {
                        name: 'delete_department',
                        text: query.delete_department,
                        values: [currentTime, _body.userid, "deleted", _body.departmentId]
                    }
                    const departmentEdited = await client.query(delete_department);
                    if (departmentEdited) {
                        resolve({ code: 200, message: "Departments deleted successfully !", data: departmentEdited.rows[0]})
                    } else {
                        reject({ code: 400, message: "Failed. Please try again.", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}