import query from '../query/query';
import { database } from '../../config/dbConfig';
import { SinkPage } from 'twilio/lib/rest/events/v1/sink';

// add physician available time stamps
export const add_time_slots = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect();
            var timeEntry = "";
            var finalValues = "";
            var days = "";
            try {
                _body.available_dates.forEach(day => {
                    _body.time_slots.forEach(timeSlot => {
                        var start_time_with_date = convertToUTC(day, timeSlot.start_time);
                        var end_time_with_date = convertToUTC(day, timeSlot.end_time);
                        timeEntry = "(" + _body.expertId + "," + day + "," + _body.duration + "," + start_time_with_date + "," + end_time_with_date + "," + currentTime + "," + currentTime + ")";
                        finalValues = finalValues + "," + timeEntry;
                    });
                    days = days + "," + day;
                });
                var status = "('paymentCompleted','reschduledByPatient')"
                const checkAppointments = `SELECT "consultationRequestId" FROM "consultationRequest" WHERE "physicianTimeManagementId" IN (SELECT "physicianTimeManagementId" FROM physiciantimemanagement WHERE "startDay" IN (${_body.available_dates}) AND status=true AND "physicianId"=${_body.expertId} ) AND status IN ${status}`;
                const appointmentsCheck = await client.query(checkAppointments);
                if (appointmentsCheck.rows.length == 0) {
                    const deleteQuery = `UPDATE physiciantimemanagement SET status=false,updated_on=${currentTime} WHERE "startDay" IN (${_body.available_dates}) AND status=true AND "physicianId"=${_body.expertId} RETURNING "physicianTimeManagementId"`
                    const deletetedEntries = await client.query(deleteQuery);
                    const queryValues = finalValues.substring(1);
                    const query = `INSERT INTO physiciantimemanagement("physicianId","startDay",duration,"startTimeStamp","endTimeStamp",created_on,updated_on) values ${queryValues} returning "physicianTimeManagementId"`
                    const user_details = await client.query(query);
                    if (user_details) {
                        resolve({ code: 200, message: "Timeslots added successfully", data: user_details.rows });
                    }
                }
                else {
                    reject({ code: 400, message: "Failed. Appointments scheduled for this day", data: {} });
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// list physician available time stamps
export const list_time_slots = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {

            const client = await database().connect()
            try {
                const list_expert_time_slots = {
                    name: 'list_expert_time_slots',
                    text: query.list_expert_time_slots,
                    values: [_body.expertId, _body.dayTimeStamp]
                }

                const user_details = await client.query(list_expert_time_slots);
                if (user_details) {
                    resolve({ code: 200, message: "Timeslots listed successfully", data: user_details.rows });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// list physician available time stamps
export const convertToUTC = (originalDate, startingTimestamp) => {
    let currentDate = new Date();
    originalDate = new Date(originalDate * 1000).toISOString();
    originalDate=new Date(originalDate);
    var hour = originalDate.getHours() + 5;
    var minutes = originalDate.getMinutes() + 30;
    originalDate.setHours(hour);
    originalDate.setMinutes(minutes);
    startingTimestamp = new Date(startingTimestamp * 1000);
    currentDate.setFullYear(originalDate.getFullYear());
    currentDate.setMonth(originalDate.getMonth());
    if (((startingTimestamp.getHours() + 5) % 24 == 23 && (startingTimestamp.getMinutes() + 30) % 60 < 30) || (startingTimestamp.getHours() + 5) % 24 < 5 || ((startingTimestamp.getHours()) % 24 == 0 && (startingTimestamp.getMinutes()) % 60 == 0)) {
        currentDate.setDate(originalDate.getDate() - 1);
    }
    else {
        currentDate.setDate(originalDate.getDate());
    }
    currentDate.setHours(startingTimestamp.getHours());
    currentDate.setMinutes(startingTimestamp.getMinutes());
    currentDate.setSeconds(0);
    currentDate.setMilliseconds(0);
    return currentDate.getTime() / 1000
}


// edit physician available time stamps
export const edit_time_slots = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var timeEntry = "";
            var finalValues = "";
            var deleteIds = "";
            var editArray = [];
            /** update-muneeb */
            var startTime = 0;
            var endTime = 0;
            /** */
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect()
            try {
                _body.availableTime.forEach(item => {
                    /** update-muneeb */
                    startTime = convertToUTC(_body.dayTimeStamp, item.startTimeStamp);
                    endTime = convertToUTC(_body.dayTimeStamp, item.endTimeStamp);
                    /** */
                    if (!item.physicianTimeManagementId) {
                        timeEntry = "(" + _body.expertId + "," + _body.dayTimeStamp + "," + _body.duration + "," + item.startTimeStamp + "," + item.endTimeStamp + "," + currentTime + "," + currentTime + ")";
                        finalValues = finalValues + "," + timeEntry
                    }
                    if (item.physicianTimeManagementId && !item.startTimeStamp && !item.endTimeStamp) {
                        deleteIds = deleteIds + "," + item.physicianTimeManagementId
                    }
                    if (item.physicianTimeManagementId && item.startTimeStamp && item.endTimeStamp && item.Times) {
                        var slotsToEdit = {
                            physicianTimeManagementId: item.physicianTimeManagementId,
                            startTimeStamp: startTime,//item.startTimeStamp,
                            endTimeStamp: endTime,//item.endTimeStamp,
                            Times: item.Times
                        }
                        editArray.push(slotsToEdit)
                    }
                });
                var status = "('paymentCompleted','reschduledByPatient')"
                if (deleteIds != "") {
                    var idsTodelete = "(" + deleteIds.substring(1) + ")";
                    var deleteStatus = await delete_ids(idsTodelete, status)
                    if (deleteStatus == false) {
                        reject({ code: 400, message: "Unable to delete, appointments scheduled for the slot", data: {} });
                    }
                }
                if (deleteIds == "" || deleteStatus == true) {
                    if (editArray.length > 0) {
                        var editStatus = await edit_ids(editArray, status, _body.duration);
                        if (editStatus == false) {
                            reject({ code: 400, message: "Unable to edit, appointments scheduled for the slot", data: {} });
                        }
                    }
                    if (editArray.length == 0 || editStatus == true) {
                        if (deleteIds != "" && deleteStatus == true) {
                            const deleteQuery = `UPDATE physiciantimemanagement SET status=false,updated_on=${currentTime} WHERE "physicianTimeManagementId" IN ${idsTodelete} RETURNING "physicianTimeManagementId"`
                            const deleted = await client.query(deleteQuery);
                        }
                        if (finalValues != "") {
                            const newValues = finalValues.substring(1);
                            const addQuery = `INSERT INTO physiciantimemanagement("physicianId","startDay",duration,"startTimeStamp","endTimeStamp",created_on,updated_on) values ${newValues} returning "physicianTimeManagementId"`
                            const added = await client.query(addQuery);
                            resolve({ code: 200, message: "Timeslots edited successfully", data: {} });
                        }
                        resolve({ code: 200, message: "Timeslots updated successfully", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const delete_ids = (idsTodelete, status) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const checkExistingBeforeDelete = `SELECT "consultationRequestId" FROM "consultationRequest" WHERE  "physicianTimeManagementId" IN ${idsTodelete} AND status IN ${status} `;
                const appointmentStatus = await client.query(checkExistingBeforeDelete);
                if (appointmentStatus.rows.length == 0) {
                    resolve(true);
                }
                else {
                    resolve(false);
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const edit_ids = (editArray, status, duration) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                editArray.map(async (item) => {
                    const checkExistingBeforeEdit = `SELECT "consultationRequestId","appointmentTimestamp" FROM "consultationRequest" WHERE  "physicianTimeManagementId" = ${item.physicianTimeManagementId} AND status IN ${status}`;
                    const appointmentEditStatus = await client.query(checkExistingBeforeEdit);
                    if (appointmentEditStatus.rows.length > 0) {
                        appointmentEditStatus.rows.forEach(appointmentTime => {
                            var checkExistence = item.Times.includes(appointmentTime.appointmentTimestamp);
                            if (!checkExistence) {
                                resolve(false)
                            }
                        });
                    }
                    if (appointmentEditStatus.rows.length == 0) {
                        const addQuery = `UPDATE physiciantimemanagement SET "startTimeStamp"=${item.startTimeStamp},"endTimeStamp"=${item.endTimeStamp},duration=${duration} WHERE "physicianTimeManagementId" = ${item.physicianTimeManagementId} RETURNING "physicianTimeManagementId"`
                        const edited = await client.query(addQuery);
                        resolve(true)
                    }
                });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// list physician available time stamps
export const view_timeslots_by_range = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {

            const client = await database().connect()
            try {
                const view_timeslots_by_date_range = {
                    name: 'view_timeslots_by_date_range',
                    text: query.view_timeslots_by_date_range,
                    values: [_body.expertId, _body.startDay, _body.endDay]
                }
                const time_slots = await client.query(view_timeslots_by_date_range);
                if (time_slots) {
                    var result = time_slots.rows;
                    resolve({ code: 200, message: "Timeslots listed successfully", data: result });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}
