import query from '../query/query';
import { database, expertDb } from '../../config/dbConfig';
import { ExitStatus, isNamedTupleMember } from 'typescript';
import { send_invite_sms } from '../../services/smsService';
import { sendGridEmail } from '../../services/sendGridEmail';
import { getUserLiveTokens } from './notificationModel';
import { add_logs } from './LogModel';
import { deleteMedicalRecords } from '../../services/blobStorage';
//list patients
export const list_patients = (_body) => {
    return new Promise((resolve, reject) => {
        const patientDetailsArray = [];
        (async () => {
            var searchkey = "";
            var pagination = "";
            if (_body.search_key) {
                searchkey = " AND ((LOWER(u.first_name) LIKE LOWER('%" + _body.search_key + "%')) OR (LOWER(u.last_name) LIKE LOWER('%" + _body.search_key + "%')))"
            }
            if (_body.limit != undefined && _body.offset != undefined) {
                pagination = ' LIMIT ' + _body.limit + ' OFFSET ' + _body.offset
            }
            var condition = 'cr."physicianID"=' + _body.expertId + '' + searchkey
            const patientsCount = await get_patient_count(condition)
            const client = await database().connect()
            try {
                const list_patients_by_expert_id = {
                    name: 'list_patients_by_expert_id',
                    text: query.list_patients_by_expert_id + searchkey + pagination,
                    values: [_body.expertId,"completed"]
                }
                const user_details = await client.query(list_patients_by_expert_id);
                if (user_details) {
                    user_details.rows.forEach(item => {
                        const patientDetails = {
                            patientId: item.id,
                            profile_image: item.profile_image,
                            first_name: item.first_name,
                            last_name: item.last_name,
                            dob: item.dob,
                            gender: item.gender,
                            phone: item.phone,
                            address: JSON.parse(item.location)
                        }
                        patientDetailsArray.push(patientDetails)
                    });
                    resolve({ code: 200, message: "Patients listed successfully", data: { patientCount: patientsCount, patients: patientDetailsArray } });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//check fee change
export const get_patient_count = (condition) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `SELECT COUNT(DISTINCT u.id) as patientcount from users u LEFT JOIN "consultationRequest" cr ON u.id = cr."patientID" WHERE ${condition} AND cr.status='completed'`;
                const count = await client.query(query)
                if (count) {
                    resolve(count.rows[0].patientcount)
                } else {
                    resolve(null)
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//list patients by clinic
export const list_patients_by_clinic = (_body) => {
    return new Promise((resolve, reject) => {
        const patientDetailsArray = [];
        (async () => {
            var searchkey = "";
            var pagination = "";
            var status = "'open'"
            if (_body.search_key) {
                searchkey = " AND ((LOWER(u.first_name) LIKE LOWER('%" + _body.search_key + "%')) OR (LOWER(u.last_name) LIKE LOWER('%" + _body.search_key + "%')))"
            }
            if (_body.limit != undefined && _body.offset != undefined) {
                pagination = ' LIMIT ' + _body.limit + ' OFFSET ' + _body.offset
            }
            var condition = 'cr."departmentId" IN (SELECT "departmentId" FROM department WHERE clinic_id=' + _body.clinicId + ' AND status=' + status + ')' + searchkey
            const patientsCount = await get_patient_count(condition)
            const client = await database().connect()
            try {
                const list_patients_by_clinic_id = {
                    name: 'list_patients_by_clinic_id',
                    text: query.list_patients_by_clinic_id + searchkey + pagination,
                    values: [_body.clinicId, 'open']
                }
                const user_details = await client.query(list_patients_by_clinic_id);
                if (user_details) {
                    user_details.rows.forEach(item => {
                        const patientDetails = {
                            patientId: item.id,
                            profile_image: item.profile_image,
                            first_name: item.first_name,
                            last_name: item.last_name,
                            dob: item.dob,
                            gender: item.gender,
                            phone: item.phone,
                            address: JSON.parse(item.location)
                        }
                        patientDetailsArray.push(patientDetails)
                    });
                    resolve({ code: 200, message: "Patients listed successfully", data: { patientCount: patientsCount, patients: patientDetailsArray } });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//get patient medical profile
export const get_medical_profile = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var primaryConditionsArray = [];
            var secondaryConditionsArray = [];
            var treatmentsArray = [];
            const client = await database().connect();
            try {
                const get_patient_medical_profile = {
                    name: 'get_patient_medical_profile',
                    text: query.list_condition,
                    values: [_body.patientId, 1]
                }
                const user_details = await client.query(get_patient_medical_profile);
                if (user_details) {
                    user_details.rows.forEach(item => {
                        if (item.is_primary == 1) {
                            primaryConditionsArray.push(item.condition)
                        }
                        else if (item.is_primary == 0) {
                            secondaryConditionsArray.push(item.condition)
                        }
                        if (item.treatment != "" || item.treatment != null) {
                            treatmentsArray.push(item.treatment)
                        }
                    });
                    if (primaryConditionsArray.length == 0 && secondaryConditionsArray.length == 0 && treatmentsArray.length == 0) {
                        reject({ code: 400, message: "Failed. No medical profile for this user", data: {} });
                    }
                    else {
                        resolve({ code: 200, message: "Patients medical profile fetched successfully", data: { primaryConditions: primaryConditionsArray, secondaryConditions: secondaryConditionsArray, treatments: treatmentsArray } });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//get patient past appointments
export const get_past_appointments = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const pastAppointments = []
            const client = await database().connect();
            try {
                const get_patient_past_appointments = {
                    name: 'get_patient_past_appointments',
                    text: query.get_patient_past_appointments,
                    values: [_body.patientId, _body.user.userid, 'completed', _body.limit, _body.offset]
                }
                const user_details = await client.query(get_patient_past_appointments);
                if (user_details) {
                    user_details.rows.forEach(item => {
                        var recordArray = [];
                        var recordFinalArray = [];
                        if (item.medical_records_for_consultation != null) {
                            var departmentImageModified = item.medical_records_for_consultation;
                            var intermediateString = departmentImageModified.replace('{', '');
                            var intermediateString2 = intermediateString.replace('}', '');
                            var finalString = intermediateString2.split('"').join('');
                            recordArray = finalString.split(",");
                            recordArray.forEach(item => {
                                recordFinalArray.push(item)
                            });
                        }
                        const appointmentDetails = {
                            consultationId: item.consultationId,
                            expert_first_name: item.expert_first_name,
                            expert_last_name: item.expert_last_name,
                            expert_profile_image: item.expert_profile_image,
                            patient_first_name: item.patientfirstname,
                            patient_last_name: item.patientlastname,
                            patient_dob: item.patientdob,
                            caregiver_first_name: item.caregiverfirstname,
                            caregiver_last_name: item.caregiverlastname,
                            relation_with_patient: item.relationship,
                            first_visit_pay: item.first_visit_pay,
                            consultationStartTimestamp: item.consultationStartTimestamp,
                            consultationEndTimestamp: item.consultationEndTimestamp,
                            consultation_type: item.consultation_type,
                            case_history: item.case_history,
                            presenting_complaint: item.presenting_complaint,
                            treatment_advice: item.treatment_advice,
                            medical_records_for_consultation: recordFinalArray,
                            presription: item.prescription,

                        }
                        pastAppointments.push(appointmentDetails)
                    })
                    resolve({ code: 200, message: "Patient past appointments listed successfully", data: pastAppointments });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//get patient upcoming appointments
export const upcoming_appointments = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const upcomingAppointments = []
            const currentTime = Math.floor(Date.now() / 1000);
            var currentTime1 = new Date();
            var utcDate = Date.UTC(currentTime1.getUTCFullYear(), currentTime1.getUTCMonth(), currentTime1.getUTCDate(),
                currentTime1.getUTCHours(), currentTime1.getUTCMinutes()) / 1000;
            var tempDate = new Date(utcDate * 1000)
            tempDate.setHours(0)
            tempDate.setMinutes(0)
            var originalDate = tempDate;
            var ISTdate = new Date(originalDate).getTime() - (5.5 * 60 * 60 * 1000);
            var appointmentDate = ISTdate / 1000;
            const client = await database().connect();
            var status = "('paymentCompleted','reschduledByPatient','onGoing')"
            try {
                var limit = _body.limit ? _body.limit : 10
                var offset = _body.offset ? _body.offset : 0
                const query = `SELECT cr."consultationRequestId" as "appointmentId", cr."appointmentTimestamp",pm.duration,
                cr.status, cr.disease,
                cr."physicianID", u.first_name, u.last_name, u.gender,pc.caregiverfirstname,pc.caregiverlastname,pc.patientfirstname,pc.patientlastname,pc.patientdob,pc.relationship,
                u.location, u.profile_image, u.dob,cr.medical_records_for_consultation,(SELECT first_visit_pay FROM physician_details WHERE physician_id=cr."physicianID" )
                FROM "consultationRequest" cr
                LEFT JOIN "physiciantimemanagement" pm ON pm."physicianTimeManagementId"=cr."physicianTimeManagementId"
                LEFT JOIN users u ON u.id = cr."physicianID"
                LEFT JOIN patient_caregiver_consent pc ON pc.appointmentid=cr."consultationRequestId"
                WHERE cr."patientID"= ${_body.patientId} AND cr."physicianID"= ${_body.user.userid} AND pm."startDay">=${appointmentDate} AND cr.status IN ${status}
                ORDER BY cr."appointmentTimestamp" DESC
                LIMIT ${limit} OFFSET ${offset}`;
                const appointment_details = await client.query(query);
                if (appointment_details.rows.length > 0) {
                    appointment_details.rows.forEach(item => {
                        var recordArray = [];
                        var recordFinalArray = [];
                        if (item.medical_records_for_consultation != null) {
                            var departmentImageModified = item.medical_records_for_consultation;
                            var intermediateString = departmentImageModified.replace('{', '');
                            var intermediateString2 = intermediateString.replace('}', '');
                            var finalString = intermediateString2.split('"').join('');
                            recordArray = finalString.split(",");
                            recordArray.forEach(item => {
                                recordFinalArray.push(item)
                            });
                        }
                        const appointmentDetails = {
                            appointmentId: item.appointmentId,
                            duration: item.duration,
                            expert_first_name: item.first_name,
                            expert_last_name: item.last_name,
                            expert_gender: item.gender,
                            expert_profile_image: item.profile_image,
                            patient_first_name: item.patientfirstname,
                            patient_last_name: item.patientlastname,
                            patient_dob: item.patientdob,
                            caregiver_first_name: item.caregiverfirstname,
                            caregiver_last_name: item.caregiverlastname,
                            relation_with_patient: item.relationship,
                            first_visit_pay: item.first_visit_pay,
                            appointmentTimestamp: item.appointmentTimestamp,
                            status: item.status,
                            disease: item.disease,
                            medical_records_for_consultation: recordFinalArray,

                        }
                        upcomingAppointments.push(appointmentDetails)
                    })
                    resolve({ code: 200, message: "Patient upcoming appointments listed successfully", data: upcomingAppointments });
                }
                else {
                    reject({ code: 400, message: "No upcoming appointments for this patient", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//get patient data
export const patient_data = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `SELECT id,profile_image,first_name,last_name,dob,gender,phone FROM users WHERE id=${_body.patientId}`;
                const data = await client.query(query)
                if (data) {
                    resolve({ code: 200, message: "Patient data fetched successfully", data: data.rows[0] });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//list medical records of a patient
export const patient_medical_records = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `SELECT records_id, patient_id, record, record_type, created_on, u.first_name, u.last_name 
                FROM medical_records mr
                LEFT JOIN users u ON u.id = mr.patient_id
                WHERE mr.patient_id=${_body.user.userid} AND mr.status=${true}`;
                const medical_records = await client.query(query)
                if (medical_records.rowCount > 0) {
                    var patientFirstName = medical_records.rows[0].first_name
                    var patientLastName = medical_records.rows[0].last_name
                    medical_records.rows.forEach(item => {
                        delete item.first_name;
                        delete item.last_name;
                    })
                    add_logs('Medical records list', `Userid ${_body.user.userid} has accessed patient_medical_records API`, 11, _body.user.userid)
                    resolve({
                        code: 200, message: "Patient medical records fetched successfully", data: {
                            details: medical_records.rows,
                            "patientFirstName": patientFirstName,
                            "patientLastName": patientLastName
                        }
                    });
                } else {
                    //get patient data
                    const query2 = `SELECT u.first_name, u.last_name FROM
                    users u WHERE u.id=${_body.user.userid}`;
                    const user_details = await client.query(query2)
                    resolve({
                        code: 200, message: "No records found", data: {
                            details: [],
                            patientFirstName: user_details.rows[0].first_name,
                            patientLastName: user_details.rows[0].last_name
                        }
                    });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//list medical records of a patient
export const get_patient_medical_data = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `SELECT records_id, patient_id, record, created_on 
                FROM medical_records mr
                WHERE patient_id=${_body.patientId} AND status=${true}`;
                const medical_records = await client.query(query)
                if (medical_records.rowCount > 0) {
                    resolve({ code: 200, message: "Patient medical records fetched successfully", data: medical_records.rows });
                } else {
                    resolve({ code: 200, message: "No records found", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//invite patient
export const invite_patient_by_expert = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                const invite_patient = {
                    name: 'invite_patient',
                    text: query.invite_patient,
                    values: [_body.patientName, _body.phone, _body.email, _body.description, currentTime, currentTime, _body.user.userid]
                }
                const invite_record = await client.query(invite_patient)
                if (invite_record) {
                    var invite_message = `Dear ${_body.patientName}, ${_body.description}`
                    send_invite_sms(invite_message, _body.phone)
                    const mailData = { to: _body.email, templateName: "invite", set_password_url: process.env.FORGOT_PASSWORD_URL, title: "You have been invited", description: _body.description, button_label: "Accept invite", name: _body.patientName }
                    sendGridEmail(mailData)
                    resolve({ code: 200, message: "Invite sent to patient successfully", data: {} });
                }
                else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Add medical reports to consultation
export const medical_reports_add_to_consultation = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                //check patient exists
                const queryPatient = `SELECT id,first_name,last_name,gender from users where id=${_body.userid} AND (user_type='patient' OR user_type='caregiver') AND status='1'`;
                const patient_details = await client.query(queryPatient);
                if (patient_details.rowCount == 0) {
                    reject({ code: 400, message: "patient does not exist.", data: {} });
                } else {
                    const query = `UPDATE "consultationRequest" 
                    SET medical_records_for_consultation='${_body.medical_records}' 
                    WHERE "consultationRequestId"=${_body.consultationRequestId} AND "patientID"=${_body.userid} returning "physicianID"`;
                    const update_records = await client.query(query);
                    if (update_records.rowCount > 0) {
                        if (patient_details.rows[0].gender == 'Male') {
                            var notificationTitle = `Patient ${patient_details.rows[0].first_name} ${patient_details.rows[0].last_name} updated his medical records.`
                        }
                        else {
                            var notificationTitle = `Patient ${patient_details.rows[0].first_name} ${patient_details.rows[0].last_name} updated her medical records.`
                        }
                        const type = "medical_records_upload";
                        const data = { appointmentid: _body.consultationRequestId.toString(), patientid: _body.userid.toString() };
                        getUserLiveTokens(update_records.rows[0].physicianID, notificationTitle, _body.userid, type, data);
                        add_logs('Medical reports save', `Userid ${_body.user.userid} has accessed medical_reports_save API`, 11, _body.user.userid)
                        resolve({ code: 200, message: "Patient medical records updated successfully", data: {} });
                    } else {
                        resolve({ code: 200, message: "No consultations found", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Save medical reports of patient
export const medical_reports_save = (_body) => {
    console.log(_body)
    const currentTime = Math.floor(Date.now() / 1000);
    return new Promise((resolve, reject) => {
        (async () => {
            let promises = []
            const client = await database().connect();
            try {
                if (Array.isArray(_body.medical_records) && _body.medical_records.length > 0) {
                    var medical_records_array = []
                    _body.medical_records.forEach((item, index) => {
                        var medical_records_inputs = `(${_body.userid}, '${item}', ${true}, ${currentTime}, ${currentTime},'${_body.record_types[index]}')`;
                        medical_records_array.push(medical_records_inputs)
                    });
                    const query = `INSERT INTO medical_records(patient_id, record, status, created_on, updated_on,record_type) 
                values ${medical_records_array} 
               RETURNING "records_id"`;
                    const res = await client.query(query)

                    if (res) {
                        resolve({ code: 200, message: "Patient medical records added successfully", data: {} });
                    } else {
                        resolve({ code: 200, message: "No consultations found", data: {} });
                    }
                }
                else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


export const deleteMedicalRecordsFromDb = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `UPDATE medical_records SET status = ${false} WHERE records_id IN (${_body.record_ids}) RETURNING records_id`;
                const res = await client.query(query)
                if (res) {
                    const deleteStatus = await deleteMedicalRecords(_body)
                    resolve({ code: 200, message: "Patient medical records deleted successfully", data: { deleted_record_ids: _body.record_ids } });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const editMedicalRecords = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `UPDATE medical_records SET record_type = '${_body.record_type}' WHERE records_id = ${_body.record_id} RETURNING records_id,record,record_type`;
                const res = await client.query(query)
                if (res) {
                    resolve({ code: 200, message: "Patient medical record edited successfully", data: res.rows[0] });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}