import query from '../query/query';
import { database, expertDb } from '../../config/dbConfig';
import * as dotenv from 'dotenv'
dotenv.config()
import * as jwt from 'jsonwebtoken';
import * as config from '../../config/security-config';
import * as crypto from 'crypto';
import * as password from 'secure-random-password';
import { send_sms } from '../../services/smsService';
import { sendGridEmail } from '../../services/sendGridEmail'
const saltRounds = process.env.SALT_ROUNDS;
import readHtml from '../../services/readHtml';
import * as handlebars from 'handlebars';
import { getUserLiveTokens, getUserLiveTokensByType } from './notificationModel';
import * as bcrypt from 'bcrypt';
import * as security_config from '../../config/security-config';
import { ConversationList } from 'twilio/lib/rest/conversations/v1/conversation';
import { hashfunction } from './ExpertUserModel'
const STRIPE_PRIVATE_KEY = process.env.STRIPE_PRIVATE_KEY
const stripe = require('stripe')(STRIPE_PRIVATE_KEY)
import { add_logs } from './LogModel';

// Initiate payment by patient
export const payment_initiate = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                // Use an existing Customer ID if this is a returning customer.
                const customer = await stripe.customers.create();
                const ephemeralKey = await stripe.ephemeralKeys.create(
                    { customer: customer.id },
                    { apiVersion: '2020-08-27' }
                );
                const paymentIntent = await stripe.paymentIntents.create({
                    amount: Math.round(_body.amount * 100),
                    currency: 'INR',
                    customer: customer.id,
                });
                //store patient consent form details if the user is caregiver
                if (_body.userType == "caregiver") {
                    const consentQuery = `INSERT INTO public.patient_caregiver_consent(
                        appointmentid, patientfirstname, patientlastname, patientdob, caregiverfirstname, caregiverlastname, relationship, created_on, updated_on)
                        VALUES (${_body.appointmentId}, '${_body.patientFirstName}', '${_body.patientLastName}', '${_body.patientDob}', '${_body.careGiverFirstName}', '${_body.careGiverLastName}', '${_body.relationship}', ${currentTime}, ${currentTime});`;
                    var consentDetails = await client.query(consentQuery)
                    if (consentDetails) console.log('consent details saved successfully')
                }
                const query = `INSERT INTO payment(patient_id, consultationrequestid, payment_status, 
                    customer_id, created_on, updated_on)
                VALUES (${_body.user.userid},
                ${_body.appointmentId}, ${false}, '${customer.id}', ${currentTime}, 
                ${currentTime}) RETURNING payment_id`;
                const payment_details = await client.query(query)
                add_logs('Payment', `Userid ${_body.user.userid} has accessed payment_initiate API`, 11, _body.user.userid)
                if (payment_details) {
                    resolve({
                        code: 200, message: "Payment intent created successfully", data: {
                            paymentIntent: paymentIntent.client_secret,
                            ephemeralKey: ephemeralKey.secret,
                            customer: customer.id
                        }
                    });
                }

                else {
                    resolve({
                        code: 200, message: "Payment failed", data: {}
                    });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Initiate payment by patient
export const list_cards_for_patient = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            try {
                const paymentMethods = await stripe.paymentMethods.list({
                    customer: _body.customerId,  //'cus_JfUapTdgTTdxuO',
                    type: 'card',
                });
                /*  const cards = await stripe.customers.listSources(
                     'cus_JfUapTdgTTdxuO',
                     { object: 'card', limit: 3 }
                 ); */
                if (paymentMethods) {
                    resolve({ code: 200, message: "cards listed successfully", data: paymentMethods });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// Hook called on successfull payment
export const success_hook_payment = (_body) => {
    console.log(_body)
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                let { data, type } = _body
                let { previous_attributes, object } = data
                let customer_id = object.customer
                let order_id = object.id
                let amount = object.amount / 100;
                var charge_id = object.charges.data[0].id;
                var payment_method_details = object.charges.data[0].payment_method_details;
                //update the payemnt record of particular customer
                const query = `UPDATE payment SET 
                payment_status=${true}, 
                order_id='${order_id}', charge_id='${charge_id}', amount=${amount},
                payment_method_details='${JSON.stringify(payment_method_details)}' 
                WHERE customer_id='${customer_id}' RETURNING consultationrequestid`;
                var payment_details = await client.query(query);
                if (payment_details) {
                    var appointmentId = payment_details.rows[0].consultationrequestid
                    //update consulatationRequest table for successfull payment
                    const query2 = `UPDATE "consultationRequest" SET payment_status=${true}, status='paymentCompleted' 
                     WHERE "consultationRequestId"=${appointmentId} returning "patientID", "physicianID"`;
                    const update_consultation = await client.query(query2)
                    const query3 = `SELECT first_name,last_name FROM users WHERE id=${update_consultation.rows[0].patientID}`;
                    const patient_details = await client.query(query3)
                    const query4 = `SELECT first_name,last_name,phone FROM users WHERE id=${update_consultation.rows[0].physicianID}`;
                    const physician_details = await client.query(query4)
                    if (update_consultation) {
                        const notificationTitle = `Your have received a new appointment request from ${patient_details.rows[0].first_name} ${patient_details.rows[0].last_name}`
                        const type = "appointment_request";
                        const data = { appointmentid: appointmentId.toString() };
                        const notificationTitle2 = `Your appointment is scheduled with Dr. ${physician_details.rows[0].first_name} ${physician_details.rows[0].last_name}, please join five minutes before the appointment.`
                        const type2 = "appointment_request_acknowledgement";
                        const data2 = { appointmentid: appointmentId.toString() };
                        getUserLiveTokens(update_consultation.rows[0].physicianID, notificationTitle, update_consultation.rows[0].patientID, type, data);
                        getUserLiveTokens(update_consultation.rows[0].patientID, notificationTitle2, update_consultation.rows[0].patientID, type2, data2);
                        if (physician_details.rows[0].phone) {
                            var title = `Hi ${physician_details.rows[0].first_name} ${physician_details.rows[0].last_name}, Your have received a new appointment request from ${patient_details.rows[0].first_name} ${patient_details.rows[0].last_name} on MyHealingMate platform`
                            send_sms(title, physician_details.rows[0].phone, '');
                        }
                        resolve({ code: 200, message: "payment data updated successfully", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Initiate refund request
export const refund_initiate = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const query = `SELECT payment_id, patient_id, order_id, charge_id
                FROM payment where patient_id=${_body.patientID} AND consultationrequestid=${_body.consultationRequestId} AND payment_status=true`;
                const payement_details = await client.query(query)
                if (payement_details.rowCount == 0) {
                    reject({ code: 400, message: "No payments found for the consultationRequestId.", data: {} });
                } else {
                    //check whether the user is manager or not
                    const user_check = `SELECT user_type FROM users where id=${_body.user.userid} `;
                    const user_type = await client.query(user_check)
                    if (user_type.rows[0].user_type == 'manager') {
                        var payment_id = payement_details.rows[0].payment_id
                        var charge_id = payement_details.rows[0].charge_id
                        //TODO: get the amount to be refunded based on the refund type:
                        //if its a expert initiated refund give the full amount
                        //if its a patient initiated refund give the amount after the 
                        //processing fee
                        const fee_check = `SELECT first_visit_pay as fees, cr."physicianID", cr.status
                        from physician_details pd
                        LEFT JOIN "consultationRequest" cr ON cr."physicianID"= pd.physician_id
                        WHERE cr."consultationRequestId"=${_body.consultationRequestId}`;
                        const fee_details = await client.query(fee_check);
                        if (fee_details.rowCount > 0) {
                            var fees = fee_details.rows[0].fees;
                            var cr_status = fee_details.rows[0].status;
                            // var amount_to_refund = fees - (fees * .02);
                              var amount_to_refund = fees - (fees * .10);
                            if (cr_status == 'rejected') {
                                //Full refund
                                var refund = await stripe.refunds.create({
                                    charge: charge_id
                                });
                            } else {
                                //Refund after taking processing fee
                                var refund = await stripe.refunds.create({
                                    charge: charge_id,
                                    amount: Math.round(amount_to_refund*100)
                                });
                            }
                        } else {
                            reject({ code: 400, message: "Doctor fees not found ", data: {} })
                        }
                        if (refund) {
                            //update the record with refund_status 
                            const query1 = `UPDATE payment SET refund_status='refunded' WHERE payment_id=${payment_id}`;
                            const u_payement_details = await client.query(query1)
                            if (u_payement_details.rowCount > 0) {
                                const query2 = `UPDATE "complaints_reported" SET refund_status=${true} WHERE payment_id=${payment_id}`;
                                const refunded_details = await client.query(query2)
                            }
                            const notificationTitle = `Your refund request for Appointment ID: ${_body.consultationRequestId} has been approved by MHM`
                            const type = "help_refund_rejection";
                            const data = { appointmentid: _body.consultationRequestId.toString() };
                            getUserLiveTokens(payement_details.rows[0].patient_id, notificationTitle, payement_details.rows[0].patient_id, type, data);
                            const get_details = `SELECT first_name,last_name,profile_image,id,phone,email FROM users WHERE id= ${payement_details.rows[0].patient_id}`
                            const details = await client.query(get_details);
                            if (details) {
                                var title = `Hi ${details.rows[0].first_name} ${details.rows[0].last_name}, Your refund request for Appointment ID: ${_body.consultationRequestId} has been approved by MHM`
                                if (details.rows[0].phone) {
                                    send_sms(title, details.rows[0].phone, '');
                                }
                                if (details.rows[0].email) {
                                    const mailData = { to: details.rows[0].email, templateName: "mhm_registration", title: `Response to your Refund request (Appointment id: ${_body.appointmentId})`, description: `Your refund request for Appointment ID: ${_body.consultationRequestId} has been approved by MHM` };
                                    sendGridEmail(mailData);
                                }
                            }
                            resolve({ code: 200, message: "Refund initiated successfully", data: {} });
                        }
                    }
                    else {
                        reject({ code: 400, message: "Failed. You are not permited to do this action. ", data: {} })
                    }

                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: `Failed. Please try again. ${e}`, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Initiate refund request
export const refund_request = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect()
            try {
                const checkQuery = `SELECT u.first_name,u.last_name,p.payment_id, p.patient_id, p.order_id, p.charge_id
                FROM payment p LEFT JOIN users u ON u.id=p.patient_id where patient_id=${_body.userid} AND consultationrequestid=${_body.appointmentId} AND p.payment_status='true'`;
                const payment_details = await client.query(checkQuery)
                var payment_id = payment_details.rows[0].payment_id
                if (payment_details.rowCount == 0) {
                    reject({ code: 400, message: "No payments found for the appointmentId.", data: {} });
                } else {
                    if (payment_details.rows[0].payment_id == '' || payment_details.rows[0].payment_id == null) {
                        reject({ code: 400, message: "No payments found for the appointmentId.", data: {} });
                    }
                    if (_body.type == 'refund') {
                        const refundCheckQuery = `SELECT complaint_id FROM complaints_reported WHERE "consultationRequestId"=${_body.appointmentId} AND complaint_type ='refund'`;
                        const refundCheck = await client.query(refundCheckQuery)
                        if (refundCheck.rowCount > 0) {
                            reject({ code: 400, message: "Refund request already submitted", data: {} });
                        }
                        else {
                            const refundQuery = `SELECT payment_id FROM payment WHERE "payment_id"=${payment_id} AND refund_status='refunded'`;
                            const Check = await client.query(refundCheckQuery);
                            var refund_status = (Check.rowCount > 0) ? true : false;
                            const add_complaint = {
                                name: 'add_complaint',
                                text: query.add_complaint,
                                values: [_body.userid, _body.appointmentId, _body.reason, currentTime, _body.type, payment_id, refund_status]
                            }
                            const complaint_details = await client.query(add_complaint)
                            if (complaint_details) {
                                const query1 = `UPDATE payment SET refund_status='requested' WHERE payment_id=${payment_id}`;
                                const u_payement_details = await client.query(query1)
                                var notificationTitleAdmin = `${payment_details.rows[0].first_name} ${payment_details.rows[0].last_name}  has requested for refund.`;
                                var typeAdmin = "refund_request";
                                var dataAdmin = { "complaint_id": complaint_details.rows[0].complaint_id.toString() }
                                getUserLiveTokensByType('manager', notificationTitleAdmin, _body.userid, typeAdmin, dataAdmin);
                                resolve({ code: 200, message: "Refund request done successfully", data: {} });
                            }
                            else {
                                reject({ code: 400, message: "Failed. Please try again.", data: {} })
                            }
                        }
                    }
                    else if (_body.type == 'report') {
                        const refundCheckQuery = `SELECT payment_id FROM payment WHERE "payment_id"=${payment_id} AND refund_status='refunded'`;
                        const refundCheck = await client.query(refundCheckQuery);
                        var refund_status = (refundCheck.rowCount > 0) ? true : false;
                        const add_complaint = {
                            name: 'add_complaint',
                            text: query.add_complaint,
                            values: [_body.userid, _body.appointmentId, _body.reason, currentTime, _body.type, payment_id, refund_status]
                        }
                        const complaint_details = await client.query(add_complaint)
                        if (complaint_details) {
                            const query1 = `UPDATE payment SET refund_status='requested' WHERE payment_id=${payment_id}`;
                            const u_payement_details = await client.query(query1)
                            var notificationTitleAdmin = `${payment_details.rows[0].first_name} ${payment_details.rows[0].last_name}  has requested for refund.`;
                            var typeAdmin = "refund_request";
                            var dataAdmin = { "complaint_id": complaint_details.rows[0].complaint_id.toString() }
                            getUserLiveTokensByType('manager', notificationTitleAdmin, _body.userid, typeAdmin, dataAdmin);
                            resolve({ code: 200, message: "Refund request done successfully", data: {} });
                        }
                        else {
                            reject({ code: 400, message: "Failed. Please try again.", data: {} })
                        }
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: `Failed. Please try again. ${e}`, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


export const send_refund = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const query = `SELECT payment_id, patient_id, order_id, charge_id
                FROM payment where patient_id=${_body.userid} AND consultationrequestid=${_body.consultationRequestId} AND payment_status=true`;
                const payement_details = await client.query(query)
                if (payement_details.rowCount == 0) {
                    reject({ code: 400, message: "No payments found for the consultationRequestId.", data: {} });
                } else {
                    if (payement_details.rows[0].payment_id == "") {
                        reject({ code: 400, message: "Failed, No payment id found", data: {} });
                    }
                    else {
                        var payment_id = payement_details.rows[0].payment_id
                        var charge_id = payement_details.rows[0].charge_id
                        //TODO: get the amount to be refunded based on the refund type:
                        //if its a expert initiated refund give the full amount
                        //if its a patient initiated refund give the amount after the 
                        //processing fee
                        const fee_check = `SELECT first_visit_pay as fees, cr."physicianID", cr.status
                        from physician_details pd
                        LEFT JOIN "consultationRequest" cr ON cr."physicianID"= pd.physician_id
                        WHERE cr."consultationRequestId"=${_body.consultationRequestId}`;
                        const fee_details = await client.query(fee_check);
                        if (fee_details.rowCount > 0) {
                            var fees = fee_details.rows[0].fees;
                            var cr_status = fee_details.rows[0].status;
                            // var amount_to_refund = fees - (fees * .02);
                            var amount_to_refund = fees - (fees * .10);
                            if (cr_status == 'rejected') {
                                //Full refund
                                var refund = await stripe.refunds.create({
                                    charge: charge_id
                                });
                            } else {
                                //Refund after taking processing fee
                                var refund = await stripe.refunds.create({
                                    charge: charge_id,
                                    amount: Math.round(amount_to_refund*100)
                                });
                            }
                        } else {
                            reject({ code: 400, message: "Doctor fees not found ", data: {} })
                        }
                        if (refund) {
                            //update the record with refund_status 
                            const query2 = `UPDATE payment SET refund_status='refunded' WHERE payment_id=${payment_id}`;
                            const u_payement_details = await client.query(query2)
                            if (u_payement_details.rowCount > 0) {
                            }
                            resolve({ code: 200, message: "Refund initiated successfully", data: {} });
                        }
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: `Failed. Please try again. ${e}`, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Hook called on successfull payment
export const success_hook_refund = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                let { data, type } = _body
                let { previous_attributes, object } = data
                let customer_id = object.customer
                let charge_id = object.id
                let amount = object.amount / 100;
                var payment_intent_id = object.payment_intent;
                //TODO: update payment table with the status refunded
                const query = `UPDATE payment SET refund_status='refunded', description='Refund initiated from stripe dashboard'
                WHERE order_id='${payment_intent_id}' AND charge_id='${charge_id}'`;
                const refund_update = await client.query(query)
                if (refund_update) {
                    resolve({ code: 200, message: "refund updated successfully", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again. : " + e, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.:" + e, data: {} })
        })
    })
}

// movw issue to refund
export const issue_to_refund = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const refundCheckQuery = `SELECT payment_id FROM payment WHERE "payment_id"=(SELECT "payment_id" FROM complaints_reported WHERE complaint_id=${_body.complaint_id}) AND refund_status='refunded'`;
                const refundCheck = await client.query(refundCheckQuery);
                var refund_status = (refundCheck.rowCount > 0) ? true : false;
                const query = `UPDATE "complaints_reported" SET complaint_type='refund' , refund_status=${refund_status} WHERE complaint_id=${_body.complaint_id} RETURNING payment_id`;
                const refund_update = await client.query(query)
                if (refund_update) {
                    if (refund_status != true) {
                        const query1 = `UPDATE payment SET refund_status='requested' WHERE payment_id=${refund_update.rows[0].payment_id}`;
                        const u_payement_details = await client.query(query1)
                    }

                    resolve({ code: 200, message: "Issue moved to refunds successfully", data: {} });

                }
                else {
                    reject({ code: 400, message: "Failed. Can't move to refund ", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again. : " + e, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.:" + e, data: {} })
        })
    })
}

// reply to issue
export const reply_issue = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const issue_reply = {
                    name: 'issue_reply',
                    text: query.issue_reply,
                    values: [`${_body.reply}`, _body.complaint_id]
                }
                const refund_update = await client.query(issue_reply)
                if (refund_update) {
                    const get_details = `SELECT first_name,last_name,profile_image,id,phone,email FROM users WHERE id=${refund_update.rows[0].patient_id}`
                    const details = await client.query(get_details);
                    var title = `Hi ${details.rows[0].first_name} ${details.rows[0].last_name}, MHM has responded to your issue on Appointment id: ${refund_update.rows[0].consultationRequestId}. Admin replied; "${_body.reply}"`
                    send_sms(title, details.rows[0].phone, '');
                    const mailData = { to: details.rows[0].email, templateName: "mhm_registration", title: `Response to your issue (Appointment id: ${refund_update.rows[0].consultationRequestId})`, description: `MHM admin replied to your issue for appointment id : ${refund_update.rows[0].consultationRequestId} as follows;<br><br><i>You wrote:</i><br>${refund_update.rows[0].reason}<br><br><i>Admin wrote:</i><br>${_body.reply}` };
                    sendGridEmail(mailData);
                    resolve({ code: 200, message: "Replied to issue successfully", data: {} });
                }
                else {
                    reject({ code: 400, message: "Failed. Can't move to refund ", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again. : " + e, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.:" + e, data: {} })
        })
    })
}

// Reject a refund by clinic admin
export const refund_reject = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (!_body.reason) {
                    reject({ code: 400, message: "Please give the reason to reject the refund", data: {} });
                } else {
                    const query = `UPDATE payment SET refund_status='rejected', 
                    reject_refund_reason='${_body.reason}' WHERE consultationrequestid=${_body.appointmentId}`;
                    const reject_refund_details = await client.query(query)
                    if (reject_refund_details) {
                        const get_details = `SELECT first_name,last_name,profile_image,id,email,phone FROM users WHERE id= (SELECT "patientID" FROM "consultationRequest" WHERE "consultationRequestId"=${_body.appointmentId} )`
                        const details = await client.query(get_details);
                        const notificationTitle = `MHM Admin rejected your refund request for appointment ID: ${_body.appointmentId}`
                        const type = "help_refund_rejection";
                        const data = { appointmentid: _body.appointmentId.toString() };
                        getUserLiveTokens(details.rows[0].id, notificationTitle, details.rows[0].id, type, data);
                        if (details.rows[0].phone) {
                            var title = `Hi ${details.rows[0].first_name} ${details.rows[0].last_name}, MHM Admin rejected your refund request for appointment ID: ${_body.appointmentId} with reason; "${_body.reason}"`
                            send_sms(title, details.rows[0].phone, '');
                        }
                        if (details.rows[0].email) {
                            const mailData = { to: details.rows[0].email, templateName: "mhm_registration", title: `Response to your Refund request (Appointment id: ${_body.appointmentId})`, description: `MHM Admin rejected your refund request for appointment ID: ${_body.appointmentId};<br><br><i>Reply</i><br>"${_body.reason}"` };
                            sendGridEmail(mailData);
                        }
                        resolve({ code: 200, message: "refund rejected successfully", data: {} });
                    } else {
                        reject({ code: 400, message: "Failed. Please try again", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again. : " + e, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.:" + e, data: {} })
        })
    })
}

// View Refund status by patient
export const refund_status_view = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const query = `SELECT cr."physicianID", cr."consultationRequestId", cr.status,
                cr."appointmentTimestamp", pd.qualification, 
                pd.speciality, pd.first_visit_pay as fee, cl."clinicName", cl.tax_percentage, u.profile_image, 
                u.first_name, u.last_name, p.refund_status, p.reject_refund_reason,
                ptm."startTimeStamp", ptm."endTimeStamp", ptm.duration FROM "consultationRequest" cr
                LEFT JOIN consultation c ON c."appointmentId" = cr."consultationRequestId"
                LEFT JOIN users u ON u.id = cr."physicianID"
                LEFT JOIN physician_details pd ON pd.physician_id = cr."physicianID"
                LEFT JOIN clinic cl ON cl.clinic_id = u.clinic_id
                LEFT JOIN payment p ON p.consultationrequestid = cr."consultationRequestId"
                LEFT JOIN physiciantimemanagement ptm ON ptm."physicianTimeManagementId" = cr."physicianTimeManagementId"
                WHERE cr."patientID"=${_body.userid} AND cr."consultationRequestId"=${_body.appointmentId} AND p.refund_status !='na'`;
                //console.log(query)
                const refund_status_view = await client.query(query);
                if (refund_status_view.rowCount > 0) {
                    refund_status_view.rows.forEach(item => {
                        var total_fee = item.tax_percentage ? item.fee + (item.fee * item.tax_percentage / 100) : item.fee;
                        var procesing_fee = item.fee * .02;
                        var total_amount = total_fee + procesing_fee;
                        item.total_amount = total_amount
                        item.procesing_fee = procesing_fee;
                        item.refund_amount = total_amount - procesing_fee;
                    })
                    resolve({ code: 200, message: "refund status fetched successfully", data: refund_status_view.rows });
                } else {
                    resolve({ code: 200, message: "No refund details found for the appointment", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again. : " + e, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.:" + e, data: {} })
        })
    })
}



