import query from '../query/query';
import { database } from '../../config/dbConfig';
import { getUserLiveTokens, getUserLiveTokensByType, send_notification } from './notificationModel';
import { convertCompilerOptionsFromJson } from 'typescript';
import { getUserFromCommentId, getUserFromPostId } from './UserModel';


// Add Comment
export const add_comment = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const add_comment = {
                    name: 'add_comment',
                    text: query.add_comment,
                    values: [_body.parent_id, _body.type, _body.comment, 1, currentTime, _body.userid, true]
                }
                const comment_details = await client.query(add_comment);
                if (_body.pseudo_name) {
                    const notificationTitle = _body.pseudo_name + " commented on your post";
                    const type = "comment";
                    const data = { post_id: _body.parent_id, content: _body.comment }
                    getUserFromPostId(_body.parent_id, notificationTitle, _body.userid, type, data)
                }
                // getUserLiveTokens(_body)
                resolve({ code: 200, message: "Comments has been successfully added", data: comment_details.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Update Comment
export const update_comment = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const update_comment = {
                    name: 'update_comment',
                    text: query.update_comment,
                    values: [_body.comment, currentTime, _body.comment_id]
                }
                const comment_details = await client.query(update_comment);
                resolve({ code: 200, message: "Comment has been successfully updated", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Delete Comment
export const delete_comment = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const delete_comment = {
                    name: 'delete_comment',
                    text: query.delete_comment,
                    values: [currentTime, 0, _body.comment_id]
                }
                const comment_details = await client.query(delete_comment);
                resolve({ code: 200, message: "Comment has been successfully deleted", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// List Comment
export const list_comment = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const type = _body.type ? _body.type : "feeds"
                const limit = _body.limit ? _body.limit : 100
                const offset = _body.offset ? _body.offset : 0
                if (_body.type == 'feeds') {
                    var reactionQuery = `,(SELECT reaction_type from reactions r WHERE r.comment_id=c.id AND r.user_id=${_body.user_id} AND content_type='comment' AND reaction_status=${true})`;
                } else var reactionQuery = ``;

                const query = `SELECT c.id as comment_id, c.parent_id, c.comment,c.type,c.created_date, u.id as user_id, u.pseudo_name, u.profile_image,
                (SELECT COUNT(id) from reactions WHERE comment_id=c.id AND content_type='comment') as reactionCount
                ${reactionQuery} FROM comments as c 
                LEFT JOIN users as u on c.user_id=u.id 
                WHERE c.status='1' AND c.publish_status=true AND parent_id=${_body.parent_id} AND type='${type}'
                ORDER BY c.created_date DESC LIMIT ${limit} OFFSET ${offset}`;
                var comment_details = await client.query(query);
                comment_details.rows.forEach((item, index) => {
                    comment_details.rows[index].isUsersComment = (item.user_id == _body.user_id) ? true : false;
                    comment_details.rows[index].reacted = item.reaction_type ? true : false;
                })
                resolve({ code: 200, message: "Comments details has been successfully collected", data: comment_details.rows });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//check if a user reacted for the comment
export const findCommentReactionDetails = (id, userid) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                let reactDetails = {}
                const react_list = {
                    name: 'react_list',
                    text: query.react_list,
                    values: [id, true]
                }
                var react_details = await client.query(react_list);
                react_details.rows.forEach(item => {
                    reactDetails = {
                        count: item.react_count,
                        isReacted: (item.user_id == userid) ? true : false,
                        reactionType: (item.user_id == userid) ? item.reaction_type : "",
                    }
                });
                resolve(reactDetails)
            } catch (e) {
                console.log(e)
            } finally {
                client.release()
            }
        })()
    })
}

// List Comment for Admin
export const list_comment_for_admin = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (_body.order_by && !_body.search_key) {
                    var with_or_without_sort_search = " ORDER BY " + _body.order_by + " " + _body.order + " LIMIT " + _body.limit + " OFFSET " + _body.offset;
                }
                else if (_body.search_key && _body.order_by) {
                    var with_or_without_sort_search = " AND LOWER(c.comment) LIKE LOWER('%" + _body.search_key + "%') OR LOWER(u.pseudo_name) LIKE LOWER('%" + _body.search_key + "%') ORDER BY " + _body.order_by + " " + _body.order + " LIMIT " + _body.limit + " OFFSET " + _body.offset;
                }
                else if (_body.search_key && !_body.order_by) {
                    var with_or_without_sort_search = " AND LOWER(c.comment) LIKE LOWER('%" + _body.search_key + "%') OR LOWER(u.pseudo_name) LIKE LOWER('%" + _body.search_key + "%') LIMIT " + _body.limit + " OFFSET " + _body.offset;
                }
                else {
                    var with_or_without_sort_search = " LIMIT " + _body.limit + " OFFSET " + _body.offset;
                }
                // if (_body.login_status == 'yes') {
                const list_comment_login = {
                    name: 'list_comment_login',
                    text: query.list_comment_login_admin + with_or_without_sort_search,
                    values: [_body.userid, _body.parent_id]
                }
                const list_comment_login_admin_wop = {
                    name: 'list_comment_login_admin_wop',
                    text: query.list_comment_login_admin_without_parent + with_or_without_sort_search,
                    values: [_body.userid]
                }
                var comment_details = (_body.parent_id) ? await client.query(list_comment_login) : await client.query(list_comment_login_admin_wop);
               
                if (comment_details.rows.length > 0) {
                    resolve({ code: 200, message: "Comments details has been successfully collected", data: { count: comment_details.rows[0].totalcount, data: comment_details.rows } });
                }
                else {
                    resolve({ code: 200, message: "Comments details has been successfully collected", data: { count: 0, data: comment_details.rows } });

                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Add like
export const add_like = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                var status = '';
                const chk_like = {
                    name: 'chk_like',
                    text: query.chk_like,
                    values: [_body.user_id, _body.type_id, _body.type_name]
                }
                const chk_like_status = await client.query(chk_like);
                if (chk_like_status.rows.length == 0) {
                    status = '1';
                    const add_like = {
                        name: 'add_like',
                        text: query.add_like,
                        values: [_body.user_id, status, _body.type_id, _body.type_name, currentTime]
                    }
                    const like_id = await client.query(add_like);
                } else {
                    status = '0';
                    const update_like = {
                        name: 'update_like',
                        text: query.update_like,
                        values: [status, _body.user_id, _body.type_id, _body.type_name, currentTime]
                    }
                    const like_id = await client.query(update_like);
                }
                resolve({ code: 200, message: "Like has been successfully added", data: { "status": status } });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// check like
export const check_like_dislike = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                if (_body.user_id) {
                    var chk_reaction = {
                        name: 'comment_list',
                        text: query.chk_reaction,
                        values: [_body.type_id, _body.user_id]
                    }
                    var reaction_count = await client.query(chk_reaction);
                    if (reaction_count.rows.length == 0) {
                        resolve({ code: 200, message: "Nothing added", data: {} });
                    } else {
                        const user_liked = reaction_count.rows[0].count > 0 ? true : false;
                        const total_likes = reaction_count.rows[1].count;
                        resolve({ code: 200, message: "Success, Please find status", data: { "total_likes": total_likes, "user_liked" : user_liked } });
                    }
                } else {
                    var chk_reaction = {
                        name: 'chk_reaction_nologin',
                        text: query.chk_reaction_nologin,
                        values: [_body.type_id]
                    }
                    var reaction_count = await client.query(chk_reaction);
                    if (reaction_count.rows.length == 0) {
                        resolve({ code: 200, message: "Nothing added", data: {} });
                    } else {
                        resolve({ code: 200, message: "Success, Please find status", data: { "total_likes": reaction_count.rows[0].count } });
                    }
                }
                
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Add reaction for a comment
export const add_reaction_comment = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                checkUserAlreadyReactedComment(_body.userid, _body.comment_id).then(async res => {
                    if (res > 0) {
                        const update_comment_reaction = {
                            name: 'update_comment_reaction',
                            text: query.update_reaction_comment,
                            values: [_body.reaction_type, _body.reaction_status,
                            _body.userid, _body.comment_id, currentTime]
                        }
                        var react_details = await client.query(update_comment_reaction);
                        if (react_details) {
                            resolve({ code: 200, message: "Reaction has been successfully updated", data: react_details.rows[0] })
                        } else {
                            reject({ code: 400, message: "Failed. Please try again.", data: {} });
                        }
                    } else {
                        const add_reaction_comment = {
                            name: 'add_reaction_comment',
                            text: query.add_reaction_comment,
                            values: [_body.reaction_type, true,
                            _body.content_id, _body.content_type,
                            _body.feed_id, _body.comment_id, _body.userid, currentTime]
                        }
                        var react_details = await client.query(add_reaction_comment);
                        if (react_details) {
                            if (_body.pseudo_name) {
                                const notificationTitle = _body.pseudo_name + " reacted to a comment on your post";
                                const notificationTitle1 = _body.pseudo_name + " reacted to your comment";
                                const type = "reaction_on_comment";
                                const data = { post_id: _body.feed_id }
                                getUserFromPostId(_body.feed_id, notificationTitle, _body.userid, type, data);
                                getUserFromCommentId(_body.comment_id, notificationTitle1, _body.userid, type, data);
                            }
                            resolve({ code: 200, message: "Reaction for comment has been successfully added", data: react_details.rows[0] })
                        } else {
                            reject({ code: 400, message: "Failed. Please try again.", data: {} });
                        }
                    }
                })
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


export const checkUserAlreadyReactedComment = (userid, comment_id) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const chk_reaction_comment = {
                    name: 'comment_list',
                    text: query.chk_reaction_comment,
                    values: [comment_id, userid]
                }
                var reaction_count = await client.query(chk_reaction_comment);
                resolve(reaction_count.rows[0].count)
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }

        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//change publish status for comment
export const commentPublishStatusChange = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (_body.publish_status == true) {
                    const comment_publish_status_set = {
                        name: 'comment_publish_status_set',
                        text: query.comment_publish_status_set,
                        values: [_body.publish_status, _body.comment_id, ""]
                    }
                    var results = await client.query(comment_publish_status_set);
                }
                else {
                    const comment_publish_status_set = {
                        name: 'comment_publish_status_set',
                        text: query.comment_publish_status_set,
                        values: [_body.publish_status, _body.comment_id, _body.unpublish_reason]
                    }
                    var results = await client.query(comment_publish_status_set);
                    const notificationTitle = "Admin deleted your comment '" + results.rows[0].comment + "' with the reason ; " + _body.unpublish_reason;
                    const type = "comment_delete";
                    const data = {}
                    getUserFromCommentId(_body.comment_id, notificationTitle, _body.userid, type, data);
                }
                resolve({ code: 200, message: "Comment publish status changed successfully", data: results.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}




