import { count } from "console";

const superagent = require('superagent');

//create tag
export const create_new_tag = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.post(process.env.STRAPI_URL+"tags")
                .send({ tag_name: _body.tag_name })
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Tag added successfully", data: JSON.parse(res.text) });
                    }
                    else {
                        reject({ code: 400, message: "Failed. Please try again.", data: {} })
                    }

                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//delete tag
export const deleteTag = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.del(process.env.STRAPI_URL+"tags/"+ _body.id)
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Tag deleted successfully", data: {} });
                    }
                    else {
                        resolve({ code: 200, message: res.text, data: {} })
                    }
                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//edit tag
export const editTag = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.put(process.env.STRAPI_URL+"tags/" + _body.id)
                .send({ tag_name: _body.tag_name })
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Tag edited successfully", data: JSON.parse(res.text) });
                    }
                    else {
                        resolve({ code: 200, message: JSON.parse(res.text), data: {} })
                    }
                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//publish tag
export const publishTag = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.get(process.env.STRAPI_URL+"tags/publish/" + _body.id)
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Tag Published successfully", data: {} });
                    }
                    else {
                        resolve({ code: 200, message: JSON.parse(res.text), data: {} })
                    }
                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//unpublish tag
export const unpublishTag = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.get(process.env.STRAPI_URL+"tags/unpublish/" + _body.id)
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Tag unpublished successfully", data: {} });
                    }
                    else {
                        resolve({ code: 200, message: JSON.parse(res.text), data: {} })
                    }
                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//list tags
export const listTags = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var sort = "";
            var pagination = "";
            var searchkey = "";
            if (_body.sort_by && _body.sort_order) {
                sort = ',sort:"' + _body.sort_by + ':' + _body.sort_order + '"';
            }
            if (_body.limit && _body.offset) {
                pagination = ',limit:' + _body.limit + ' start:' + _body.offset;
            }
            if (_body.search_key) {
                searchkey = ',where:{tag_name_contains:"%' + _body.search_key + '%"}';
            }
            const res = await superagent.post(process.env.STRAPI_URL+"graphql").send({ query: '{tags(publicationState:PREVIEW,' + searchkey + sort + pagination + '){id tag_name published_at created_at}}' })
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                     
                        resolve({ code: 200, message: "Tags listed successfully", data: JSON.parse(res.text).data  });
                    }
                    else {
                        resolve({ code: 200, message: JSON.parse(res.text), data: {} })
                    }
                   
                });
              
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}
//count tags
export const countTags = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var searchkey = "";
            if (_body.search_key) {
                searchkey = ',where:{tag_name_contains:"%' + _body.search_key + '%"}';
            }
            const response = await superagent.post(process.env.STRAPI_URL+"graphql").send({ query: '{tags(publicationState:PREVIEW,' + searchkey + '){id}}' })
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    console.log("-----------",JSON.parse(res.text).data.tags.length)
                    resolve({ code: 200, message: "Tags counted successfully", data: JSON.parse(res.text).data.tags.length  });
                });  
              
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}


