import { count } from "console";

const superagent = require('superagent');

//create tag
export const create_new_treatment = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.post(process.env.STRAPI_URL+"treatments")
                .send({ treatment_name: _body.treatment_name })
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Treatment added successfully", data: JSON.parse(res.text) });
                    }
                    else {
                        reject({ code: 400, message: "Failed. Please try again.", data: {} })
                    }

                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//delete treatment
export const deleteTreatment = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.del(process.env.STRAPI_URL+"treatments/" + _body.id)
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Treatment deleted successfully", data: {} });
                    }
                    else {
                        resolve({ code: 200, message: res.text, data: {} })
                    }
                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//edit treatment
export const editTreatment = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.put(process.env.STRAPI_URL+"treatments/" + _body.id)
                .send({ treatment_name: _body.treatment_name  })
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Treatment edited successfully", data: JSON.parse(res.text) });
                    }
                    else {
                        resolve({ code: 200, message: JSON.parse(res.text), data: {} })
                    }
                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//publish treatment
export const publishTreatment = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.get(process.env.STRAPI_URL+"treatments/publish/" + _body.id)
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Treatment Published successfully", data: {} });
                    }
                    else {
                        resolve({ code: 200, message: JSON.parse(res.text), data: {} })
                    }
                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//unpublish treatment
export const unpublishTreatment = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const res = await superagent.get(process.env.STRAPI_URL+"treatments/unpublish/" + _body.id)
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                        resolve({ code: 200, message: "Treatment unpublished successfully", data: {} });
                    }
                    else {
                        resolve({ code: 200, message: JSON.parse(res.text), data: {} })
                    }
                });
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}

//list tags
export const listTreatments = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var sort = "";
            var pagination = "";
            var searchkey = "";
            if (_body.sort_by && _body.sort_order) {
                sort = ',sort:"' + _body.sort_by + ':' + _body.sort_order + '"';
            }
            if (_body.limit && _body.offset) {
                pagination = ',limit:' + _body.limit + ' start:' + _body.offset;
            }
            if (_body.search_key) {
                searchkey = ',where:{treatment_name_contains:"%' + _body.search_key + '%"}';
            }
            const res = await superagent.post(process.env.STRAPI_URL+"graphql").send({ query: '{treatments(publicationState:PREVIEW,' + searchkey + sort + pagination + '){id treatment_name published_at created_at}}' })
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    if (res.status == 200) {
                     
                        resolve({ code: 200, message: "Treatments listed successfully", data: JSON.parse(res.text).data  });
                    }
                    else {
                        resolve({ code: 200, message: JSON.parse(res.text), data: {} })
                    }
                   
                });
              
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}
//count tags
export const countTreatments = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var searchkey = "";
            if (_body.search_key) {
                searchkey = ',where:{treatment_name_contains:"%' + _body.search_key + '%"}';
            }
            const response = await superagent.post(process.env.STRAPI_URL+"graphql").send({ query: '{treatments(publicationState:PREVIEW,' + searchkey + '){id}}' })
                .end((err, res) => {
                    if (err) {
                        console.log(err)
                    }
                    resolve({ code: 200, message: "Treatments counted successfully", data: JSON.parse(res.text).data.treatments.length  });
                });  
              
        })
            ().catch(e => {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            })
    })
}


