import query from '../query/query';
import { database } from '../../config/dbConfig';

// Add Roles
export const add_roles = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                await client.query('BEGIN');
                const createRoles = {
                    name: 'create-roles',
                    text: query.create_role,
                    values: [_body.name, _body.description, currentTime]
                }
                const roles = await client.query(createRoles);
                const roleId = roles.rows[0].id;
                const permissions = _body.permissions;
                let promise = [];
                let createPermissions;
                permissions.forEach(element => {
                    createPermissions = {
                        text: query.create_permissions,
                        values: [roleId, element.id, element.create, element.update, element.delete, element.view, element.publish, currentTime],
                    }
                    promise.push(client.query(createPermissions));
                });
                await Promise.all(promise);
                await client.query('COMMIT')
                resolve({ code: 200, message: "Role created successfully", data: {} });
            } catch (e) {
                await client.query('ROLLBACK')
                e.code == 23505 ? reject({ code: 400, message: "Role name already exists", data: {} })
                    : reject({ code: 400, message: "Failed. Please try again.", data: {} })
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Edit Roles
export const edit_roles = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                await client.query('BEGIN');
                const editRoles = {
                    name: 'edit-roles',
                    text: query.edit_role,
                    values: [_body.name, _body.description, _body.id, currentTime]
                }
                await client.query(editRoles);
                let promise = [];
                const permissions = _body.permissions;
                let editPermissions;
                permissions.forEach(element => {
                    editPermissions = {
                        text: query.edit_permissions,
                        values: [element.create, element.update, element.delete, element.view, element.publish, currentTime, _body.id, element.id],
                    }
                    promise.push(client.query(editPermissions));
                });
                await Promise.all(promise);
                await client.query('COMMIT')
                resolve({ code: 200, message: "Role edited successfully", data: {} });
            } catch (e) {
                console.log(e)
                await client.query('ROLLBACK')
                e.code == 23505 ? reject({ code: 400, message: "Role name already exists", data: {} })
                    : reject({ code: 400, message: "Failed. Please try again.", data: {} })
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Delete Role
export const delete_role = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                await client.query('BEGIN');
                const deleteRoles = {
                    name: 'delete-roles',
                    text: query.delete_role,
                    values: [_body.id, currentTime]
                }

                await client.query(deleteRoles);
                const deletePermissions = {
                    name: 'delete-permissions',
                    text: query.delete_permissions,
                    values: [_body.id, currentTime]
                }
                await client.query(deletePermissions);
                await client.query('COMMIT')
                resolve({ code: 200, message: "Role deleted successfully", data: {} });
            } catch (e) {
                console.log(e)
                await client.query('ROLLBACK')
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Get Role
export const get_role = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                await client.query('BEGIN');
                var sort = "";
                if (_body.sort_by && _body.sort_order) {
                    sort += 'ORDER BY '+ _body.sort_by + ' ' + _body.sort_order;
                }
                if(_body.key){
                    var query = `SELECT role_desc as "description",(select count(id) from roles where status = true AND 
                    ((LOWER(role_name) LIKE LOWER('${_body.key}') OR LOWER(role_desc) LIKE LOWER('${_body.key}'))) GROUP BY r.id ) as totalCount ,r.id, 
                    r.role_name as "name",count(u.id) FROM roles r 
                    left join users u on u.role_id = r.id where r.status = true AND (LOWER(role_name) LIKE LOWER('${_body.key}') OR LOWER(role_desc) LIKE LOWER('${_body.key}')) 
                    GROUP BY r.id ${sort}  LIMIT ${_body.limit? _body.limit : 100} OFFSET ${_body.offset? _body.offset : 0};`;
                }else {
                    var query = `SELECT role_desc as "description",(select count(id) from roles where status = true) as totalCount,r.id, r.role_name as "name",count(u.id) FROM roles r 
                    left join users u on u.role_id = r.id WHERE r.status = true 
                    GROUP BY r.id ${sort}  LIMIT ${_body.limit? _body.limit : 100} OFFSET ${_body.offset? _body.offset : 0};`
                }
                const data = await client.query(query);
                const totalCount = data.rows[0]?.totalcount
                await client.query('COMMIT')
                resolve({ code: 200, message: "Roles listed successfully", data: { roles: data.rows, totalCount } });
            } catch (e) {
                await client.query('ROLLBACK')
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Get Role detail
export const get_role_detail = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                await client.query('BEGIN');
                const getRoleDetails = {
                    name: 'get-role-detail',
                    text: query.get_role_detail,
                    values: [_body.id]
                }
                const data = await client.query(getRoleDetails);
                const roleData = data.rows;
                let permissions = [];
                roleData.forEach(element => {
                    permissions.push({
                        id: element.module_id, name: element.module_name, create: element.p_create, view: element.p_view, update: element.p_update, delete: element.p_delete, publish: element.publish
                    })
                })

                let result = {
                    id: roleData[0].id,
                    roleName: roleData[0].role_name,
                    roleDescription: roleData[0].role_desc,
                    permissions
                }
                await client.query('COMMIT')
                resolve({ code: 200, message: "Role detail listed successfully", data: result });
            } catch (e) {
                await client.query('ROLLBACK')
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Get Module
export const get_module = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                await client.query('BEGIN');
                const getModules = {
                    name: 'get-module',
                    text: query.get_module
                }
                const data = await client.query(getModules);

                await client.query('COMMIT')
                resolve({ code: 200, message: "Module listed successfully", data: data.rows });
            } catch (e) {
                console.log(e)
                await client.query('ROLLBACK')
                reject({ code: 400, message: "Failed. Please try again.", data: {} })
            } finally {
                client.release();
            }
        })().catch(e => {
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}