import query from '../query/query';
import { database } from '../../config/dbConfig';
import { send_email } from '../../services/emailService';
import { sendGridEmail } from '../../services/sendGridEmail';

// Add Subscription
export const add_subscription = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                var email = 'admin@myhealingmate.com'
                var subject = 'One user subscribed - MHM';
                if (_body.subs_on == 'email') {
                    const chk_subscription_email = {
                        name: 'chk_subscription_email',
                        text: query.chk_subscription_email,
                        values: [_body.email, 1, _body.type]
                    }
                    const mailData={to:_body.email,templateName:"mhm_registration",title:"New subscription!",description:"New user, "+_body.email +" subscribed in " + _body.type + " category in MyHealingMate platform."}
                    sendGridEmail(mailData)
                    var sub_status = await client.query(chk_subscription_email);
                }
                if (_body.subs_on == 'phone') {
                    const chk_subscription_phone = {
                        name: 'chk_subscription_phone',
                        text: query.chk_subscription_phone,
                        values: [_body.phone, 1, _body.type]
                    }
                    const mailData={to:_body.email,templateName:"mhm_registration",title:"New subscription!",description:"New user, "+_body.email +" subscribed in " + _body.type + "  category in MyHealingMate platform."}
                    sendGridEmail(mailData)
                    var sub_status = await client.query(chk_subscription_phone);
                }
                if (sub_status.rows.length == 0) {
                    const add_subscription = {
                        name: 'add_subscription',
                        text: query.add_subscription,
                        values: [_body.email, _body.phone, _body.expert, _body.community, _body.app, _body.subs_on, _body.type, currentTime]
                    }
                    const like_id = await client.query(add_subscription);
                    resolve({ code: 200, message: "Subscription has been successfully added", data: {} });
                } else {
                    reject({ code: 400, message: "Failed. Already subscribed.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}