import query from '../query/query';
import { database, expertDb } from '../../config/dbConfig';
import * as dotenv from 'dotenv'
dotenv.config()
import * as jwt from 'jsonwebtoken';
import * as config from '../../config/security-config';
import { send_sms } from '../../services/smsService';
import { send_email } from '../../services/emailService';
import { sendGridEmail } from '../../services/sendGridEmail'
import { message, messageTypes } from '../utilities/language';
import * as crypto from 'crypto';
const saltRounds = process.env.SALT_ROUNDS;
import readHtml from '../../services/readHtml';
import * as handlebars from 'handlebars';
import { getUserLiveTokens, getUserLiveTokensByType } from './notificationModel';
import { add_logs } from './LogModel';


const { RtcTokenBuilder, RtmTokenBuilder, RtcRole, RtmRole } = require('agora-access-token')


// Check OTP  d
export const check_otp = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const otp_chk = {
                    name: 'check_otp',
                    text: query.check_otp,
                    values: [_body.otp]
                }
                const user_details = await client.query(otp_chk);
                if (user_details.rows.length > 0) {
                    const user_status_update = {
                        name: 'user_status_update',
                        text: query.user_status_update,
                        values: [1, user_details.rows[0].id]
                    }
                    await client.query(user_status_update);
                    const token = jwt.sign({
                        userid: user_details.rows[0].id
                    }, config.JWT_SECRET, { expiresIn: `${process.env.PATIENT_TOKEN_EXPIRY_TIME}` });
                    resolve({ code: 200, message: "OTP details found", data: { "details": user_details.rows[0], "token": token } });
                } else {
                    reject({ code: 400, message: "OTP details invalid", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// Register User api - d
export const register_user = (_body) => {

    const otp = Math.floor(100000 + Math.random() * 900000);
    const type = _body.type;
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                if (type == 'email') {
                    var from_type = _body.email
                    const user_chk_email = {
                        name: 'user_chk_email',
                        text: query.user_chk_email,
                        values: [_body.email]
                    }
                    var user_status = await client.query(user_chk_email);
                }
                if (type == 'phone') {
                    from_type = _body.phone
                    const user_chk_phone = {
                        name: 'user_chk_phone',
                        text: query.user_chk_phone,
                        values: [_body.phone]
                    }
                    var user_status = await client.query(user_chk_phone);
                }
                if (user_status.rows.length == 0) {
                    if (type == 'phone') {
                        var title = 'Dear User, ' + otp + ' is your myhealingmate Log-in One Time Password. Please do not share this OTP with anyone. Thank you !'
                        send_sms(title, _body.phone, otp)
                    }
                    if (type == 'email') {
                        const mailData = { to: _body.email, templateName: "otp_mail", title: "Registration One Time Password!", description: "A registration request has been made from this email. Please use the following 6-digit OTP to initiate the registration process.", otp: otp }
                        sendGridEmail(mailData)
                    }
                    const user_register = {
                        name: 'user_register',
                        text: query.register_user,
                        values: [_body.email, _body.phone, otp, currentTime, currentTime,'patient']
                    }
                    const user_details = await client.query(user_register);
                    const logData = {
                        topic: 'User Registration - DB',
                        details: { "body": user_register, "type": _body.type, "phone": _body.phone, "email": _body.email },
                        module: 'User',
                        userId: user_details.rows[0].id
                    }
                    const token = jwt.sign({
                        userid: user_details.rows[0].id,
                        //for the expert jwt login
                        userType: "patient"
                    }, config.JWT_SECRET, { expiresIn: `${process.env.PATIENT_TOKEN_EXPIRY_TIME}` });
                    if (_body.firebase_token) {
                        startUserActiveSession(user_details.rows[0].id, _body.firebase_token, "patient");
                    }
                    resolve({ code: 200, message: "User has been successfully registered", data: { "details": user_details.rows[0], "token": token }, logData });
                } else {
                    reject({ code: 400, message: "Failed. User already registered.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// Login User d
export const login_user = (body) => {

    const otp = Math.floor(100000 + Math.random() * 900000);
    const type = body.type;
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (type == 'phone') {
                    var from_type = body.phone
                    const login_user_phone = {
                        name: 'login_user_phone',
                        text: query.login_user_phone,
                        values: [body.phone, 1]
                    }
                    var user_details = await client.query(login_user_phone);
                }
                if (type == 'email') {
                    from_type = body.email
                    const login_user_email = {
                        name: 'login_user_email',
                        text: query.login_user_email,
                        values: [body.email, 1]
                    }
                    var user_details = await client.query(login_user_email);
                }
                if (user_details.rows.length > 0) {
                    if (type == 'phone' && body.phone != '') {
                        var title = 'Dear User, ' + otp + ' is your myhealingmate Log-in One Time Password. Please do not share this OTP with anyone. Thank you !'
                        send_sms(title, body.phone, otp)
                    }
                    if (type == 'email' && body.email !== '') {
                        const mailData = { to: body.email, templateName: "otp_mail", title: "Login One Time Password!", description: "A login request has been made from this email. Please use the following 6-digit OTP to initiate the registration process.", otp: otp }
                        sendGridEmail(mailData)
                    }
                    const user_auth_otp_update = {
                        name: 'user_auth_otp_update',
                        text: query.user_auth_otp_update,
                        values: [otp, user_details.rows[0].id]
                    }
                    await client.query(user_auth_otp_update);
                    const token = jwt.sign({
                        userid: user_details.rows[0].id,
                        emailid: user_details.rows[0].email,
                        phone: user_details.rows[0].phone,
                        user_type: user_details.rows[0].user_type
                    },
                        config.JWT_SECRET, { expiresIn: `${process.env.PATIENT_TOKEN_EXPIRY_TIME}` });
                    if (body.firebase_token) {
                        startUserActiveSession(user_details.rows[0].id, body.firebase_token, "patient");
                    }
                    resolve({ code: 200, message: "User details found", data: { 'details': user_details.rows[0], "token": token } });
                } else {
                    reject({ code: 400, message: "Invalid user. Please try again", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Super admin login
export const super_login = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                //find user details with username, password
                var password_hash = crypto
                    .createHash("md5")
                    .update(_body.password)
                    .digest("hex");
                const login_super_admin = {
                    name: 'login_super_admin',
                    text: query.login_super_admin,
                    values: [_body.email, password_hash, 1]
                }
                var user_details = await client.query(login_super_admin)
                if (user_details.rows.length > 0) {
                    const get_permissions_super_admin = {
                        name: 'get_permissions_admin',
                        text: query.get_user_permission,
                        values: [user_details.rows[0].id]
                    }
                    const data = await client.query(get_permissions_super_admin)
                    const roleData = data.rows;
                    let permissions = [];
                    let post_permissions = [];
                    roleData.forEach(element => {
                        permissions.push({
                            name: element.module_name, create: element.p_create, view: element.p_view, update: element.p_update, delete: element.p_delete, publish: element.publish
                        })
                        if (element.module_name == 'Posts') {
                            post_permissions.push({
                                name: element.module_name, create: element.p_create, view: element.p_view, update: element.p_update, delete: element.p_delete, publish: element.publish
                            })
                        }

                    })
                    if (post_permissions[0].delete == true) {
                        var admin_type = 'post-admin';
                    }
                    else {
                        var admin_type = 'admin';
                    }
                    const token = jwt.sign({
                        userid: user_details.rows[0].id,
                        emailid: user_details.rows[0].email
                    },
                        config.JWT_SECRET, { expiresIn: `${process.env.PATIENT_TOKEN_EXPIRY_TIME}` });
                    if (_body.firebase_token) {
                        startUserActiveSession(user_details.rows[0].id, _body.firebase_token, admin_type);
                    }
                    resolve({
                        code: 200, message: message.SUPER_LOGIN_SUCCESS, data: {
                            'details':
                            {
                                id: user_details.rows[0].id,
                                email: user_details.rows[0].email,
                                phone: user_details.rows[0].phone,
                                first_name: user_details.rows[0].first_name,
                                last_name: user_details.rows[0].last_name,
                                permissions
                            },
                            "token": token
                        }
                    });
                } else {
                    reject({ code: 400, message: message.SUPER_LOGIN_INVALID, data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: message.SUPER_LOGIN_FAILURE, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: message.SUPER_LOGIN_FAILURE, data: {} })
        })
    })
}


// Social Media Login 
export const social_media_login = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                // Check existing user
                const check_email = {
                    name: 'check_email',
                    text: query.login_user_email,
                    values: [_body.email, 1]
                }
                var user_details = await client.query(check_email);
                const existing_user_check = user_details.rows.length;
                if (existing_user_check == 0) {
                    const register_social_user = {
                        name: 'user_save',
                        text: query.register_social_user,
                        values: [_body.email, _body.phone, 1, currentTime, 0,'patient']
                    }
                    var registered_user_details = await client.query(register_social_user);
                    const user_save_social = {
                        name: 'user_save_social',
                        text: query.user_save_social,
                        values: [registered_user_details.rows[0].id, _body.auth_token, _body.login_type, currentTime]
                    }
                    await client.query(user_save_social);
                    const token = jwt.sign({
                        userid: registered_user_details.rows[0].id,
                    },
                        config.JWT_SECRET, { expiresIn: `${process.env.PATIENT_TOKEN_EXPIRY_TIME}` });
                    if (_body.firebase_token) {
                        startUserActiveSession(user_details.rows[0].id, _body.firebase_token, "patient");
                    }
                    resolve({ code: 200, message: "User has been successfully registered", data: { "details": registered_user_details.rows[0], "token": token, "firstlogin": "yes" } });
                }
                else {
                    const check_userid_auth = {
                        name: 'check_userid_auth',
                        text: query.check_userid_auth1,
                        values: [user_details.rows[0].id, _body.login_type]
                    }
                    const check_userid_auth_status = await client.query(check_userid_auth);
                    if (check_userid_auth_status.rows.length == 0) {
                        const user_save_social = {
                            name: 'user_save_social',
                            text: query.user_save_social,
                            values: [user_details.rows[0].id, _body.auth_token, _body.login_type, currentTime]
                        }
                        await client.query(user_save_social);
                    }
                    else {
                        const user_update_social = {
                            name: 'user_update_social',
                            text: query.user_update_social,
                            values: [user_details.rows[0].id, _body.auth_token, _body.login_type, currentTime]
                        }
                        await client.query(user_update_social);
                    }
                    const pseudoname = user_details.rows[0].pseudo_name;
                    const token = jwt.sign({
                        userid: user_details.rows[0].id,
                    },
                        config.JWT_SECRET, { expiresIn: `${process.env.PATIENT_TOKEN_EXPIRY_TIME}` });
                    if (_body.firebase_token) {
                        startUserActiveSession(user_details.rows[0].id, _body.firebase_token, "patient");
                    }
                    resolve({ code: 200, message: "User has been successfully LoggedIn", data: { "details": user_details.rows[0], "token": token, "firstlogin": "no", "pseudo_name": pseudoname } });
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })

    })
}

// Resend OTP
export const resend_otp = (_body) => {
    const otp = Math.floor(100000 + Math.random() * 900000);
    const type = _body.type;
    if (type == 'phone') {
        var title = 'Dear User, ' + otp + ' is your myhealingmate Log-in One Time Password. Please do not share this OTP with anyone. Thank you !'
        send_sms(title, _body.phone, otp)
    }
    if (type == 'email') {
        const mailData = { to: _body.email, templateName: "otp_mail", title: "Login One Time Password!", description: "A login request has been made from this email. Please use the following 6-digit OTP to initiate the registration process.", otp: otp }
        sendGridEmail(mailData)
        // })
    }
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                if (type == 'phone') {
                    var update_otp = {
                        name: 'update_otp_phone',
                        text: query.update_otp_phone,
                        values: [otp, currentTime, _body.phone]
                    }
                }
                if (type == 'email') {
                    var update_otp = {
                        name: 'update_otp_email',
                        text: query.update_otp_email,
                        values: [otp, currentTime, _body.email]
                    }
                }
                const user_details = await client.query(update_otp);
                if (user_details) {
                    resolve({ code: 200, message: "New OTP created successfully", data: user_details.rows[0] });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// Get User Details
export const get_user_list = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                var conditions = "";
                var sort = " ORDER BY " + body.sort_by + " " + body.sort_order;
                var pagination = " LIMIT " + body.limit + " OFFSET " + body.offset;
                var searchkey = " AND (LOWER(pseudo_name) LIKE LOWER('%" + body.search_key + "%') OR LOWER(email) LIKE LOWER('%" + body.search_key + "%'))";
                if (body.search_key && body.sort_order && body.sort_by) {
                    conditions = searchkey + sort + pagination;
                }
                else if (body.sort_by && body.sort_order) {
                    conditions = sort + pagination;
                }
                else if (body.search_key) {
                    conditions = searchkey + pagination;
                }
                if (body.type == 'admin') {
                    const get_admin_users_list = {
                        name: 'get_admin_users_list',
                        text: query.get_admin_users_list + conditions,
                        values: [body.type]
                    }
                    var user_details = await client.query(get_admin_users_list);

                }
                else if ((body.type != 'admin')) {
                    const get_user_list = {
                        name: 'get_user_list',
                        text: query.get_user_list + conditions,
                        values: []
                    }
                    var user_details = await client.query(get_user_list);

                    const get_conditions = {
                        name: 'get_conditions',
                        text: query.get_conditions,
                        values: []
                    }
                    var condition_list = await client.query(get_conditions);
                    var user_full_details = []
                    user_details.rows.forEach((element, index) => {
                        var primary_conditions = []
                        var other_conditions = []
                        var treatments = []
                        condition_list.rows.forEach((item, index) => {
                            if (element.id == item.user_id) {
                                if (item.is_primary == 1) {
                                    primary_conditions.push(item.condition)
                                }
                                if (item.is_primary == 0) {
                                    other_conditions.push(item.condition)
                                }
                                treatments.push(item.treatment)
                            }
                        });
                        user_full_details.push({ id: element.id, email: element.email, phone: element.phone, pseudo_name: element.pseudo_name, gender: element.gender, created_date: element.created_date, dob: element.dob, zip: element.postal_code, status: element.status, primary_conditions: primary_conditions, other_conditions: other_conditions, treatments: treatments });
                    });
                }
                if (user_details.rows.length > 0) {
                    resolve({ code: 200, message: "User details has been successfully fetched", data: { count: user_details.rows[0].totalcount, data: user_full_details } });

                }
                else {
                    resolve({ code: 200, message: "User details has been successfully fetched", data: { count: 0, data: user_full_details } });

                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Block User
export const block_user = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const block_user = {
                    name: 'block_user',
                    text: query.block_user,
                    values: ["0", body.user_id]
                }
                await client.query(block_user);
                resolve({ code: 200, message: "User details has been successfully blocked", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// Delete User
export const delete_user = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const delete_user = {
                    name: 'delete_user',
                    text: query.delete_user,
                    values: ["0", body.user_id]
                }
                await client.query(delete_user);
                resolve({ code: 200, message: "User details has been successfully deleted", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// Create admin User
export const add_admin_users = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const currentTime = Math.floor(Date.now() / 1000);
                const user_chk_email = {
                    name: 'user_chk_email',
                    text: query.user_chk_email,
                    values: [body.email]
                }
                const user_status = await client.query(user_chk_email);
                if (user_status.rows.length != 0) {
                    reject({ code: 400, message: "Email already exists", data: {} });
                    return;
                }
                const resetToken = crypto.randomBytes(32).toString('hex');
                const create_user = {
                    name: 'create_user',
                    text: query.create_admin_user,
                    values: [body.first_name, body.last_name, body.email, currentTime, resetToken, body.role_id]
                }
                await client.query(create_user);
                const mailData = { to: body.email, templateName: "invite_admin", set_password_url: process.env.FORGOT_PASSWORD_URL + resetToken, title: "Welcome to the team!", description: "You are invited to take up the admin responsibility of MyHealingMate content management platform. You will only have limited access according to the assigned responsibility.", button_label: "Set Password" }
                sendGridEmail(mailData)
                resolve({ code: 200, message: "User has been successfully created", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Update admin User
export const update_admin_users = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const currentTime = Math.floor(Date.now() / 1000);
                const check_email = {
                    name: 'check_email',
                    text: query.user_email_ckeck,
                    values: [body.email, 1, body.id, '']
                }
                const user_status = await client.query(check_email);
                if (user_status.rows.length != 0)
                    reject({ code: 400, message: "Email already exists", data: {} })
                const edit_user = {
                    name: 'edit_user',
                    text: query.edit_admin_user,
                    values: [body.first_name, body.last_name, body.email, body.role_id, currentTime, body.id]
                }
                await client.query(edit_user);
                resolve({ code: 200, message: "User has been successfully updated", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Delete admin User
export const delete_admin_user = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const currentTime = Math.floor(Date.now() / 1000);
                const delete_admin_user = {
                    name: 'delete_admin_user',
                    text: query.delete_admin_user,
                    values: [currentTime, body.id]
                }
                const data = await client.query(delete_admin_user);
                resolve({ code: 200, message: "User details has been successfully deleted", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Get admin User list
export const get_admin_user_list = (body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const get_admin_user = {
                    name: 'get_admin_user',
                    text: body.key ? query.get_admin_user_list_search : query.get_admin_user_list,
                    values: body.key ? [body.limit, body.offset, '%' + body.key + '%'] : [body.limit, body.offset]
                }
                const data = await client.query(get_admin_user);
                const totalCount = data.rows.length > 0 && data.rows[0].totalcount;
                resolve({ code: 200, message: "User details has been successfully listed", data: { users: data.rows, totalCount } });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const RTCTokenGenration = (_body) => {
    return new Promise((resolve, reject) => {
        let role = RtcRole.PUBLISHER
        if (!_body.channelName) {
            reject({ code: 400, message: "Channel name is required", data: {} });
        }
        if (!_body.userId) {
            reject({ code: 400, message: "UserId is required", data: {} });
        }
        try {
            var key = RtcTokenBuilder.buildTokenWithUid('2416d8f68b2b4af4be9e7f3396b35f58', 'ad0bc55e176741a0bf1f20048447a951', _body.channelName, _body.userId, role, _body.channel_time);
            console.log(key);
            resolve({ code: 200, message: "Token Generated", data: { "token": key } });
        }
        catch (e) {
            console.log(e);
            reject({ code: 400, message: "Unable to connect Agora server. Please try again.", data: {} });
        }
    })
}


export const change_admin_password = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            console.log(_body)
            if (_body.new_password != _body.confirm_password)
                reject({ code: 400, message: "Passwords doesnt match", data: {} });
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect();
            const new_password_hash = crypto
                .createHash("md5")
                .update(_body.new_password)
                .digest("hex");
            const old_password_hash = crypto
                .createHash("md5")
                .update(_body.old_password)
                .digest("hex");
            try {
                const change_admin_user_password = {
                    name: 'change_admin_password',
                    text: query.change_admin_password,
                    values: [_body.userid, old_password_hash, new_password_hash, currentTime]
                }
                const data = await client.query(change_admin_user_password);
                resolve({ code: 200, message: "User password has been changed successfully", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const reset_admin_password = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            if (_body.new_password != _body.confirm_password)
                reject({ code: 400, message: "Passwords doesnt match", data: {} });
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect();
            const password_hash = crypto
                .createHash("md5")
                .update(_body.new_password)
                .digest("hex");
            try {
                const reset_admin_user_password = {
                    name: 'reset_admin_password',
                    text: query.reset_admin_password,
                    values: [_body.token, password_hash, currentTime]
                }
                const data = await client.query(reset_admin_user_password);
                resolve({ code: 200, message: "User password has been changed successfully", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const forgot_admin_password = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect();
            try {
                const resetToken = crypto.randomBytes(32).toString('hex');
                const update_token = {
                    name: 'update_token',
                    text: query.update_user_token,
                    values: [resetToken, currentTime, _body.email]
                }
                await client.query(update_token);
                const mailData = { to: _body.email, templateName: "invite_admin", set_password_url: process.env.FORGOT_PASSWORD_URL + resetToken, title: "Reset your Password!", description: "We're sending you this mail because you requested a password reset. If u didn't request a password reset you can ignore this mail.", button_label: "Reset Password" }
                sendGridEmail(mailData)
                resolve({ code: 200, message: "Check your email to reset your password", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const check_permission = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect();
            try {
                const get_permissions_super_admin = {
                    name: 'get_permissions_admin',
                    text: query.get_user_permission,
                    values: [_body.userid]
                }
                const data = await client.query(get_permissions_super_admin)
                resolve({ code: 200, message: "Permission fetcched", data });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// add live user
export const startUserActiveSession = (id, token, user_type) => {
    return new Promise((resolve, reject) => {
        let current_time = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const check_live_user = {
                    name: 'check_live_user',
                    text: query.check_live_user,
                    values: [id, token]
                }
                const live_users = await client.query(check_live_user)
                console.log(live_users.rows)
                if (live_users.rows.length == 0) {
                    const add_live_user = {
                        name: 'add_live_user',
                        text: query.add_live_user,
                        values: [id, token, user_type, 1, current_time]
                    }
                    const live_user_added = await client.query(add_live_user)
                    console.log(live_user_added.rows)
                }
                resolve({ code: 200, message: "user active session started", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// remove live user
export const endUserActiveSession = (_body) => {
    return new Promise((resolve, reject) => {
        let current_time = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const remove_live_user = {
                    name: 'remove_live_user',
                    text: query.remove_live_user,
                    values: [_body.userid, _body.firebase_token, 0, current_time]
                }
                const live_user_details = await client.query(remove_live_user);
                resolve({ code: 200, message: "user active session ended", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// get user from post id
export const getUserFromPostId = (post_id, notificationTitle, sender_id, type, data) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const get_user_from_postid = {
                    name: 'get_user_from_postid',
                    text: query.get_user_from_postid,
                    values: [post_id]
                }
                const live_user_details = await client.query(get_user_from_postid);
                if (live_user_details.rows[0].id != sender_id) {
                    getUserLiveTokens(live_user_details.rows[0].id, notificationTitle, sender_id, type, data)
                }
                resolve({ code: 200, message: "user_id fetched", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// get user from coment id
export const getUserFromCommentId = (comment_id, notificationTitle, sender_id, type, data) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const get_user_from_commentid = {
                    name: 'get_user_from_postid',
                    text: query.get_user_from_commentid,
                    values: [comment_id]
                }
                const live_user_details = await client.query(get_user_from_commentid);
                if (live_user_details.rows[0].id != sender_id) {
                    getUserLiveTokens(live_user_details.rows[0].user_id, notificationTitle, sender_id, type, data)
                }
                resolve({ code: 200, message: "user_id fetched", data: {} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Change users status to block/ unblock
export const change_user_status = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const change_user_status = {
                    name: 'change_user_status',
                    text: query.change_user_status,
                    values: [_body.user_id, _body.status]
                }
                const user_details = await client.query(change_user_status);
                if (user_details) {
                    resolve({ code: 200, message: "User status has been successfully changed", data: {} });
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// check existing pseudo_name
export const checkExistingPseudoname = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const check_existing_pseudoname = {
                    name: 'check_existing_pseudoname',
                    text: query.check_existing_pseudoname,
                    values: [_body.pseudo_name]
                }
                const user_details = await client.query(check_existing_pseudoname);
                if (user_details.rows[0].count == 0) {
                    resolve({ code: 200, message: "New pseudo name", data: {} });
                } else {
                    reject({ code: 200, message: "Pseudo name exists", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Get current user status
export const get_user_status = (user_id) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const query = `SELECT status from users where id=${user_id}`
                const user_details = await client.query(query);
                const status = user_details.rows[0].status
                if (user_details) {
                    status ? resolve(status) : resolve(0);
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// User feedback
export const user_feedback = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect()
            try {
                const query = `INSERT INTO feedbacks (user_id, appointment_id, feedback, 
                    feedback_type, created_on, updated_on) VALUES ($1, $2, $3, $4, $5, $6)`;
                const values = [_body.userid, _body.appointment_id, `${_body.feedback}`, `${_body.feedback_type}`, currentTime, currentTime]
                const feedaback_details = await client.query(query, values)
                if (feedaback_details.rowCount > 0) {
                    add_logs('Feedback', `Userid ${_body.user.userid} has accessed Feedback API`, 8, _body.user.userid)
                    resolve({ code: 200, message: "Feedback recorded successfully", data: {} });
                } else {
                    reject({ code: 200, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// all issues reported by patients
export const all_issues_reported = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (_body.searchKey) {
                    var searchCond = `AND (LOWER(u.first_name) LIKE LOWER('%${_body.searchKey}%') OR LOWER(u.last_name) LIKE LOWER('%${_body.searchKey}%') OR LOWER(u2.first_name) LIKE LOWER('%${_body.searchKey}%') OR LOWER(u2.last_name) LIKE LOWER('% ${_body.searchKey}%'))`;
                } else {
                    searchCond = '';
                }
                var condStr = '';
                if (_body.issuesFromDate && _body.issuesToDate) {
                    var FromDateTS = new Date(_body.issuesFromDate).getTime() / 1000
                    var ToDateTS = new Date(_body.issuesToDate).getTime() / 1000
                    condStr = `AND c."reported_on" between ${FromDateTS} AND ${ToDateTS}`
                }
                else if (_body.issuesFromDate) {
                    var DateTS = _body.issuesFromDate;
                    condStr = `AND DATE(to_timestamp(c."reported_on"))=${DateTS}`;
                }
                const countQuery = `SELECT COUNT(c.complaint_id) FROM complaints_reported c  
                LEFT JOIN "consultationRequest" cr ON  c."consultationRequestId" =cr."consultationRequestId"
                LEFT JOIN users u ON c.patient_id= u.id
                LEFT JOIN users u2 ON cr."physicianID"= u2.id
                WHERE c.complaint_type = '${_body.type}'  ${searchCond} ${condStr}`;
                const count = await client.query(countQuery)
                const query = `SELECT c.complaint_id,c."consultationRequestId" as "appointmentId" ,cr."physicianID",c.patient_id,c.reason,c.refund_status,c.reported_on,c.complaint_type,c.payment_id,c.reply_to_issue,u.first_name as patient_first_name, u.last_name as patient_last_name, 
                u2.first_name as expert_first_name, u2.last_name as expert_last_name,cr.status as appointment_status,cr."appointmentTimestamp",p.amount,p.refund_status as refund_approval_status,(SELECT speciality FROM physician_details pd WHERE cr."physicianID"= pd.physician_id),
                (SELECT COUNT(log_id) as "patientJoinCount" FROM call_logs WHERE appointment_id= c."consultationRequestId" AND call_status='started' AND user_type='physician'),(SELECT COUNT(log_id) as "physicianJoinCount" FROM call_logs WHERE appointment_id= c."consultationRequestId" AND call_status='started' AND user_type='patient'),
                (SELECT COUNT(log_id) as "disconnectionCount" FROM call_logs WHERE appointment_id= c."consultationRequestId" AND call_status='disconnected')
                FROM complaints_reported c  
                LEFT JOIN "consultationRequest" cr ON  c."consultationRequestId" =cr."consultationRequestId"
                LEFT JOIN users u ON c.patient_id= u.id
                LEFT JOIN users u2 ON cr."physicianID"= u2.id
                LEFT JOIN payment p ON p.payment_id = c.payment_id
                WHERE c.complaint_type = '${_body.type}' ${searchCond} ${condStr}
                ORDER BY ${_body.sortKey ? _body.sortKey : `c.reported_on`} ${_body.sortOrder ? _body.sortOrder : `DESC`} 
                LIMIT ${_body.limit ? _body.limit : 100} OFFSET ${_body.offset ? _body.offset : 0}`;
                const refund_details = await client.query(query)
        
                    if(_body.type=='refund'){
                        var finalData = []
                        refund_details.rows.forEach(item => {
                            var call_status = ''
                            switch (item.appointment_status) {
                                case 'completed':
                                    if (item.patientJoinCount == 0) {
                                        call_status = 'Patient not joined'
                                    }
                                    else if (item.physicianJoinCount == 0) {
                                        call_status = 'Expert not joined'
                                    }
                                    else if (item.disconnectionCount > 0) {
                                        call_status = 'Consultation interrupted due to network issue'
                                    }
                                    else {
                                        call_status = 'Appointment completed'
                                    }
                                    break;
                                case 'rejected':
                                    call_status = 'Appointment cancelled by Expert'
                                    break;
                                case 'cancelByPatient':
                                    call_status = 'Appointment cancelled by Patient'
                                    break;
                                case 'paymentCompleted':
                                    call_status = 'Patient not joined'
                                    break;
                                default:
                                    call_status = item.appointment_status
                            }
                        var data = {
                            "complaint_id": item.complaint_id,
                            "appointmentId": item.appointmentId,
                            "patient_id": item.patient_id,
                            "reason": item.reason,
                            "refund_status": item.refund_status,
                            "reported_on": item.reported_on,
                            "complaint_type": item.complaint_type,
                            "payment_id": item.payment_id,
                            "patient_first_name": item.patient_first_name,
                            "patient_last_name": item.patient_last_name,
                            "expert_first_name": item.expert_first_name,
                            "expert_last_name": item.expert_last_name,
                            "appointment_status": call_status,
                            "appointmentTimestamp": item.appointmentTimestamp,
                            "amount": item.amount,
                            "refund_approval_status":item.refund_approval_status,
                            "speciality": item.speciality
                        }
                        finalData.push(data)
                    });
                    }
                    if(_body.type=='report'){
                        var finalData = []
                        refund_details.rows.forEach(item => {
                            var call_status = ''
                            switch (item.appointment_status) {
                                case 'completed':
                                    if (item.patientJoinCount == 0) {
                                        call_status = 'Patient not joined'
                                    }
                                    else if (item.physicianJoinCount == 0) {
                                        call_status = 'Expert not joined'
                                    }
                                    else if (item.disconnectionCount > 0) {
                                        call_status = 'Consultation interrupted due to network issue'
                                    }
                                    else {
                                        call_status = 'Appointment completed'
                                    }
                                    break;
                                case 'rejected':
                                    call_status = 'Appointment cancelled by Expert'
                                    break;
                                case 'cancelByPatient':
                                    call_status = 'Appointment cancelled by Patient'
                                    break;
                                case 'paymentCompleted':
                                    call_status = 'Patient not joined'
                                    break;
                                default:
                                    call_status = item.appointment_status
                            }
                            if(item.refund_approval_status=='refunded'){
                                var issue_status = "Refund Issued"
                            }
                            else if(item.reply_to_issue){
                                var issue_status = "Issue Resolved"
                            }
                            else{
                                var issue_status = "Pending"
                            }
                        var data = {
                            "complaint_id": item.complaint_id,
                            "appointmentId": item.appointmentId,
                            "patient_id": item.patient_id,
                            "reason": item.reason,
                            "reported_on": item.reported_on,
                            "complaint_type": item.complaint_type,
                            "payment_id": item.payment_id,
                            "patient_first_name": item.patient_first_name,
                            "patient_last_name": item.patient_last_name,
                            "expert_first_name": item.expert_first_name,
                            "expert_last_name": item.expert_last_name,
                            "appointment_status": call_status,
                            "appointmentTimestamp": item.appointmentTimestamp,
                            "amount": item.amount,
                            "issue_response_status":issue_status,
                            "speciality": item.speciality
                        }
                        finalData.push(data)
                    });
                    }
                    
                if (refund_details.rowCount > 0) {
                    resolve({ code: 200, message: "Issues listed successfully", data: { issueCount: count.rows[0].count, issues: finalData } });
                } else {
                    resolve({ code: 200, message: "No results found", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: `Failed. Please try again. ${e}`, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}




// complaint details by id
export const complaint_details_by_id = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const query = `SELECT c.complaint_id,c."consultationRequestId" as "appointmentId" ,c.patient_id,c.reason,c.refund_status,c.reported_on,c.complaint_type,c.payment_id,u.first_name as patient_first_name, u.last_name as patient_last_name, 
                u2.first_name as expert_first_name, u2.last_name as expert_last_name,cr.status as appointment_status,cr."appointmentTimestamp",(SELECT amount FROM payment p WHERE p.consultationrequestid = cr."consultationRequestId"),(SELECT speciality FROM physician_details pd WHERE cr."physicianID"= pd.physician_id)
                FROM complaints_reported c  
                LEFT JOIN "consultationRequest" cr ON  c."consultationRequestId" =cr."consultationRequestId"
                LEFT JOIN users u ON c.patient_id= u.id
                LEFT JOIN users u2 ON cr."physicianID"= u2.id
                WHERE c.complaint_id = ${_body.complaint_id}`;
                const complaint_details = await client.query(query)
                if (complaint_details.rowCount > 0) {
                    resolve({ code: 200, message: "Complaint details fetched successfully", data: complaint_details.rows[0] });
                } else {
                    resolve({ code: 400, message: "No complaints with this id", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: `Failed. Please try again. ${e}`, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const list_feedbacks_for_admin = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                var searchkey = "";
                 if (_body.search_key) {
                  searchkey = " AND ((LOWER(u.first_name) LIKE LOWER('%" + _body.search_key + "%')) OR (LOWER(eu.first_name) LIKE LOWER('%" + _body.search_key + "%')))"
                }
                const countQuery = `SELECT f.feedback_id,u.first_name,eu.first_name,cr."physicianID" FROM feedbacks f 
                LEFT JOIN users u ON f.user_id=u.id
                LEFT JOIN "consultationRequest" cr ON cr."consultationRequestId"=f.appointment_id
                LEFT JOIN users eu ON cr."physicianID"=eu.id
                 WHERE feedback !='' ${searchkey}`;
                const count = await client.query(countQuery)
                const query = `SELECT f.feedback_id,f.user_id,f.feedback,f.updated_on,f.created_on,f.appointment_id,u.first_name as patient_firstname,u.last_name as patient_last_name,eu.first_name as expert_firstname,eu.last_name as expert_last_name,eu.profile_image as expert_profile_image,cr."physicianID",cr.status as appointment_status,pd.speciality,pd.first_visit_pay as fee,eu.clinic_id,(SELECT c."clinicName" FROM clinic c WHERE c.clinic_id=eu.clinic_id) FROM feedbacks f 
                LEFT JOIN users u ON f.user_id=u.id
                LEFT JOIN "consultationRequest" cr ON cr."consultationRequestId"=f.appointment_id
                LEFT JOIN users eu ON cr."physicianID"=eu.id
                LEFT JOIN physician_details pd ON cr."physicianID"=pd.physician_id
                 WHERE feedback !='' ${searchkey} ORDER BY f.created_on DESC
                LIMIT ${_body.limit ? _body.limit : 100} OFFSET ${_body.offset ? _body.offset : 0}`;
                const feedbacks = await client.query(query)
                if (feedbacks.rowCount > 0) {
                    resolve({ code: 200, message: "feedbacks fetched successfully", data: {count:count.rowCount,data:feedbacks.rows }});
                } else {
                    resolve({ code: 400, message: "No feedbacks added", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: `Failed. Please try again. ${e}`, data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}