import { Console } from 'console';
import { sendFirebaseNotification } from '../../services/firebaseNotification';
import query from '../query/query';
import { database } from '../../config/dbConfig';
import { chk_user_connected } from './ConnectionModel';

// send notification
export const send_notification = (_body) => {
  return new Promise((resolve, reject) => {
    var message = {
      webpush: {
        notification: {
          title: "MyHealingMate",
          body: "test",
          click_action: 'https://mhm-admin.cabotprojects.com/allposts?checkpost=420'
        },
        data: {
          click_action: 'https://mhm-admin.cabotprojects.com/allposts?checkpost=420'
        },
      },
      token: _body.firebase_token

    };
    sendFirebaseNotification(message)
      .then((response) => {
        resolve({ code: 200, message: "Successfully sent message:", data: response });
      })
      .catch((error) => {
        reject({ code: 400, message: "Error sending message", data: error });
      });
  })
}


// get live user tokens
export const getUserLiveTokens = (user_id, notificationTitle, sender_id, type, data) => {
  return new Promise((resolve, reject) => {
    (async () => {
      const client = await database().connect()
      try {
        const get_live_user_tokens = {
          name: 'get_live_user_tokens',
          text: query.get_live_user_tokens,
          values: [user_id, 1]
        }
        const live_user_tokens = await client.query(get_live_user_tokens);
        live_user_tokens.rows.forEach(token => {
          if (token.registration_token_firebase != null) {
            sentEventNotificationMobile(token, notificationTitle, data, type)
          }
        });
        if (type != 'post_success' && type != 'medical_record_upload_reminder' && type != 'appointment_request_acknowledgement' && type != "rejoined_call") {
          saveNotification(sender_id, user_id, notificationTitle, type, data)
        }
        resolve({ code: 200, message: "user live tokens fetched", data: {} });
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      } finally {
        client.release();
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}

// get live user tokens
export const getUserLiveTokensByType = (user_type, notificationTitle, sender_id, type, data) => {
  return new Promise((resolve, reject) => {
    (async () => {
      const client = await database().connect()
      try {
        const get_live_user_tokens_by_type = {
          name: 'get_live_user_tokens_by_type',
          text: query.get_live_user_tokens_by_type,
          values: [user_type, 1]
        }
        const live_user_tokens = await client.query(get_live_user_tokens_by_type);
        const user_ids = []
        live_user_tokens.rows.forEach(token => {
          if (token.registration_token_firebase != null) {
            sentEventNotificationAdmin(token, notificationTitle, data, type)
          }
          user_ids.push(token.user_id)
        });
        const uniqueArray = user_ids.filter(function (item, pos) {
          return user_ids.indexOf(item) == pos;
        })
        uniqueArray.forEach(id => {
          saveNotification(sender_id, id, notificationTitle, type, data)
        })
        resolve({ code: 200, message: "user live tokens fetched", data: {} });
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      } finally {
        client.release();
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}




// send event notification Mobile
export const sentEventNotificationMobile = (token, notificationTitle, data, type) => {
  return new Promise((resolve, reject) => {
    var clickAction = '';
    var webClickAction = '';
    switch (type) {
      case 'connection_request':
        clickAction = 'OPEN_NOTIFICATIONS';
        break;
      case 'connection_response':
        clickAction = 'OPEN_NOTIFICATIONS';
        break;
      case 'incoming_call':
        clickAction = 'OPEN_CALL';
        break;
      case 'rejoined_call':
        clickAction = 'OPEN_CALL';
        webClickAction = `${process.env.EXPERT_APP_URL}/connect/${data.appointmentid}`
        break;
      case 'connection_response':
        clickAction = 'OPEN_NOTIFICATIONS';
        break;
      case 'appointment_request':
        clickAction = 'OPEN_APPOINTMENTS';
        webClickAction = `${process.env.EXPERT_APP_URL}/appointments`
        break;
      case 'appointment_request_acknowledgement':
        clickAction = 'OPEN_APPOINTMENTS';
        break;
      case 'appointment_status':
        clickAction = 'OPEN_APPOINTMENTS';
        break;
      case 'prescription_added':
        clickAction = 'OPEN_PRESCRIPTION';
        break;
      case 'medical_records_upload':
        clickAction = 'OPEN_MEDICAL_RECORDS';
        webClickAction = `${process.env.EXPERT_APP_URL}/patient/history/${data.patientid}`
        break;
      case 'medical_record_upload_reminder':
        clickAction = 'OPEN_MEDICAL_RECORDS';
        break;
      case 'refund_status':
        clickAction = 'OPEN_REJECTED_APPOINTMENTS';
        break;
      case 'help_refund_rejection':
        clickAction = 'HELP_REFUND_REJECTION';
        break;
      case 'incoming_call_from_patient':
        clickAction = 'OPEN_CALL';
        webClickAction = `${process.env.EXPERT_APP_URL}/connect/${data.appointmentid}`
        break;
      case 'appointment_reschedule':
        clickAction = 'OPEN_APPOINTMENTS';
        webClickAction = `${process.env.EXPERT_APP_URL}/appointments`
        break;
      case 'appointment_cancelled':
        clickAction = 'OPEN_APPOINTMENTS';
        webClickAction = `${process.env.EXPERT_APP_URL}/appointments/cancelled`
        break;
      default:
        var clickAction = 'OPEN_POST';
    }

    var message = {
      notification: {
        title: "MyHealingMate",
        body: notificationTitle,
      },
      data: data,
      android: {
        "priority": "high",
        "notification": {
          "click_action": clickAction
        }
      },
      apns: {
        "headers": {
          "apns-priority": "10",
        },
        "payload": {
          "aps": {
            "category": clickAction,
            "content_available": true
          }
        }
      },
      webpush: {
        notification: {
          title: "MyHealingMate",
          body: notificationTitle,
          click_action: webClickAction
        },
        data: data,
      },
      token: token.registration_token_firebase
    };
    sendFirebaseNotification(message)
      .then((response) => {
        resolve({ code: 200, message: "Successfully sent message:", data: response });
      })
      .catch((error) => {
        reject({ code: 400, message: "Error sending message", data: error });
      });
  });
}

// send event notification Admin
export const sentEventNotificationAdmin = (token, notificationTitle, data, type) => {
  return new Promise((resolve, reject) => {
    var webClickAction = '';
    switch (type) {
      case 'abusive_content_alert_to_admin':
        webClickAction = `https://mhm-admin.cabotprojects.com/allposts?checkpost=${data.feed_id}`
        break;
      case 'refund_request':
        webClickAction = `${process.env.CLINIC_ADMIN_APP_URL}/refund/${data.complaint_id}`
        break;
      case 'issue_reported':
        webClickAction = `${process.env.CLINIC_ADMIN_APP_URL}/refund/${data.complaint_id}`
        break;
      default:
        webClickAction = ''
    }
    var message = {
      webpush: {
        notification: {
          title: "MyHealingMate",
          body: notificationTitle,
          click_action: webClickAction
        },
        data: data,
      },
      token: token.registration_token_firebase

    };
    sendFirebaseNotification(message)
      .then((response) => {
        resolve({ code: 200, message: "Successfully sent message:", data: response });
      })
      .catch((error) => {
        reject({ code: 400, message: "Error sending message", data: error });
      });
  });
}


// save notifications
export const saveNotification = (sender_id, receiver_id, notificationTitle, type, data) => {
  return new Promise((resolve, reject) => {
    const currentTime = Math.floor(Date.now() / 1000);
    (async () => {
      const client = await database().connect()

      try {

        const save_notification = {
          name: 'save_notification',
          text: query.save_notification,
          values: [notificationTitle, sender_id, receiver_id, currentTime, type, data, 1, 0]
        }
        const live_user_tokens = await client.query(save_notification);
        resolve({ code: 200, message: "notification saved", data: {} });
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      } finally {
        client.release();
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}

// list notifications
export const listNotifications = (body) => {
  return new Promise((resolve, reject) => {
    (async () => {
      const client = await database().connect()
      try {
        if (body.search_key || body.search_key == "") {
          const list_notifications = {
            name: 'list_notifications',
            text: query.search_notifications,
            values: [body.userid, body.limit, body.offset, "%" + body.search_key + "%"]
          }
          var notification_list = await client.query(list_notifications);
        }
        else {
          const list_notifications = {
            name: 'list_notifications',
            text: query.list_notifications,
            values: [body.userid, body.limit, body.offset]
          }
          var notification_list = await client.query(list_notifications);
        }
        const notifications = []
        notification_list.rows.forEach(element => {
          const today = new Date();
          const api_date = new Date(element.sent_on * 1000);

          const date = (api_date.getMonth() + 1) + '/' + api_date.getDate() + '/' + api_date.getFullYear();
          const month = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
          if (api_date.getDate() % 10 == 1) {
            var postfix = "st"
          }
          else if (api_date.getDate() % 10 == 2) {
            var postfix = "nd"
          }
          else if (api_date.getDate() % 10 == 3) {
            var postfix = "rd"
          }
          else {
            var postfix = "th"
          }
          const dayOfMonth = api_date.getDate() + postfix + " " + month[(api_date.getMonth() + 1)]
          if (api_date.getHours() == 0) {
            var time = "12" + ":" + api_date.getMinutes() + " AM";
          }
          else {
            var time = (api_date.getHours() > 12) ? (api_date.getHours() - 12) + ":" + api_date.getMinutes() + " PM" : api_date.getHours() + ":" + api_date.getMinutes() + " AM";
          }
          if ((today.getMonth() + 1) == (api_date.getMonth() + 1) && today.getDate() == api_date.getDate() && today.getFullYear() == api_date.getFullYear()) {
            notifications.push({ id: element.id, notification: element.notification, type: element.type, data: element.data, profile_image: element.profile_image, sent_on: time, sent_timestamp: element.sent_on, sender_id: element.sender_id, read_status: element.read_status })
          }
          else if (today.getFullYear() == api_date.getFullYear()) {
            notifications.push({ id: element.id, notification: element.notification, type: element.type, data: element.data, profile_image: element.profile_image, sent_on: dayOfMonth, sent_timestamp: element.sent_on, sender_id: element.sender_id, read_status: element.read_status })
          }
          else {
            notifications.push({ id: element.id, notification: element.notification, type: element.type, data: element.data, profile_image: element.profile_image, sent_on: date + " " + time, sent_timestamp: element.sent_on, sender_id: element.sender_id, read_status: element.read_status })

          }
        })
        resolve({ code: 200, message: "notification listed", data: notifications });
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      } finally {
        client.release();
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}

// remove notification after accept or reject connection
export const remove_notification = (_body) => {
  return new Promise((resolve, reject) => {
    (async () => {
      const client = await database().connect();
      try {
        const remove_notification = {
          name: 'remove_notification',
          text: query.remove_notification,
          values: [_body.user_id2, _body.userid, 'connection_request']
        }
        var connect_details = await client.query(remove_notification);
        resolve({ code: 200, message: "notification has been successfully removed", data: {} })
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      } finally {
        client.release();
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}

// read notification
export const readNotification = (_body) => {
  return new Promise((resolve, reject) => {
    (async () => {
      const client = await database().connect();
      try {
        const read_notification = {
          name: 'read_notification',
          text: query.read_notification,
          values: [_body.id]
        }
        var connect_details = await client.query(read_notification);
        resolve({ code: 200, message: "notification read", data: connect_details.rows[0] })
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      } finally {
        client.release();
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}


var cron = require('node-cron');

var task = cron.schedule('00 09 * * *', () => {
  medical_record_upload_reminder()
}, {
  scheduled: true,
  timezone: "Asia/Calcutta"
});

cron.schedule('*/5 * * * *', () => {
  delete_abandoned_slots()
}, {
  scheduled: true,
  timezone: "Asia/Calcutta"
});


// send medical records upload notification
export const medical_record_upload_reminder = () => {
  const currentTime = Math.floor(Date.now() / 1000);
  return new Promise((resolve, reject) => {
    (async () => {
      const client = await database().connect();
      try {
        var status = "('paymentCompleted','reschduledByPatient')"
        const query = `SELECT DISTINCT "patientID" FROM "consultationRequest" WHERE status IN ${status} AND payment_status=true AND medical_records_for_consultation isnull AND "appointmentTimestamp" > ${currentTime} `;
        var connect_details = await client.query(query);
        var userids = '';
        connect_details.rows.forEach((item, index) => {
          if (index == 0) {
            userids = userids + item.patientID;
          }
          else {
            userids = userids + "," + item.patientID;
          }
        });
        const query1 = `SELECT registration_token_firebase FROM user_active_session WHERE user_id IN (${userids}) AND login_status=1;`;
        var tokens = await client.query(query1);
        const notificationTitle = `Reminder to upload medical records, this will help the doctor to  provide you  with better consultation`
        const type = "medical_record_upload_reminder";
        const data = {};
        tokens.rows.forEach(token => {
          if (token.registration_token_firebase != null) {
            sentEventNotificationMobile(token, notificationTitle, data, type)
          }
        });
        resolve({ code: 200, message: "notification sent", data: {} })
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      } finally {
        client.release();
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}

//delete abandoned slots: check on every 5 minutes
export const delete_abandoned_slots = () => {
  return new Promise((resolve, reject) => {
    (async () => {
      const client = await database().connect();
      try {
        console.log("abandoned slot cron")
        const query = `DELETE from "consultationRequest" 
         WHERE status='pending' AND "appointmentTimestamp">extract(epoch from now()) AND created_on < (SELECT extract(epoch from now())-300)`;
        var delete_slots = await client.query(query);
        if (delete_slots) {
          resolve({ code: 200, message: "Deleted abandoned slots successfully", data: {} })
        }
      } catch (e) {
        console.log(e);
        reject({ code: 400, message: "Failed. Please try again.", data: {} });
      } finally {
        client.release();
      }
    })().catch(e => {
      console.log(e)
      reject({ code: 400, message: "Failed. Please try again.", data: {} })
    })
  })
}