import sendResponse from '../../services/response';
import { appointment_book, appointment_book_by_agent,appointment_reschedule, 
    appointment_cancel, appointments_upcoming, rtc_TokenGenration_for_call, 
    add_consultation_notes_by_section, Get_consultation_summary, 
    patient_records_for_consult, expert_start_consultation, 
    patient_start_consultation, expert_reject_appointment, 
    appointments_past, prescription_to_pdf, end_consultation, details_past_appointments, disconnected_call_data_save, end_consultation_by_patient } from '../models/ExpertConsultationModel'

// Book an appointment
export const book_appointment = (req, res) => {
    const body = req.body;
    appointment_book(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Book an appointment by agent
export const book_appointment_by_agent = (req, res) => {
    const body = req.body;
    appointment_book_by_agent(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Reschedule an appointment
export const reschedule_appointment_by_patient = (req, res) => {
    const body = req.body;
    appointment_reschedule(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Cancel an appointment
export const cancel_appointment = (req, res) => {
    const body = req.body;
    appointment_cancel(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Upcoming appointments of patient
export const upcoming_appointments = (req, res) => {
    const body = req.body;
    appointments_upcoming(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Past appointments of patient
export const past_appointments = (req, res) => {
    const body = req.body;
    appointments_past(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// token generation for call
export const RTC_TokenGenration_for_call = (req, res) => {
    const body = req.body;
    rtc_TokenGenration_for_call(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Add consultation notes for patient
export const add_consultation_notes = (req, res) => {
    const body = req.body;
    add_consultation_notes_by_section(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get consultation summary for prescription
export const get_consultation_notes_summary = (req, res) => {
    const body = req.body;
    Get_consultation_summary(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// get patient records for consultation
export const get_patient_records_for_consult = (req, res) => {
    const body = req.body;
    patient_records_for_consult(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// start consultation for Expert
export const start_consultation_expert = (req, res) => {
    const body = req.body;
    expert_start_consultation(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// start consultation for Patient
export const start_consultation_patient = (req, res) => {
    const body = req.body;
    patient_start_consultation(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


// reject Consultation by expert 
export const reject_Consultation_by_expert = (req, res) => {
    const body = req.body;
    expert_reject_appointment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// submit prescription
export const submit_prescription = (req, res) => {
    const body = req.body;
    prescription_to_pdf(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// end consultation
export const end_call = (req, res) => {
    const body = req.body;
    end_consultation(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Past appointment Details
export const past_appointments_details = (req, res) => {
    const body = req.body;
    details_past_appointments(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


// save disconnected call data
export const disconnected_call_data = (req, res) => {
    const body = req.body;
    disconnected_call_data_save(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// end call by patient
export const patient_end_call = (req, res) => {
    const body = req.body;
    end_consultation_by_patient(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}