import sendResponse from '../../services/response';
import {delete_department_by_id, department_add, department_details_by_id, edit_department_by_id, list_departmentIndex, list_departments_by_clinic_id} from '../models/ExpertDepartmentModel'

// add department
export const add_department = (req, res) => {
    const body = req.body;
    if (body.user.user_type == "manager"
    || body.user.user_type == "expert_admin") {
    department_add(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
    }else {
        res.status(403).json({ status: 0, message: "User not authorised to perform this action" })
    }
}

// list departmentIndices
export const list_departmentIndices = (req, res) => {
    const body = req.body;
    list_departmentIndex(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// list departments by clinicId
export const list_departments_by_clinic = (req, res) => {
    const body = req.body;
    list_departments_by_clinic_id(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Get department details by Id
export const get_department_details_by_id = (req, res) => {
    const body = req.body;
    department_details_by_id(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Edit department
export const edit_department = (req, res) => {
    const body = req.body;
    edit_department_by_id(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// delete department
export const delete_department = (req, res) => {
    const body = req.body;
    delete_department_by_id(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}