import sendResponse from '../../services/response';
import { add_time_slots, edit_time_slots, list_time_slots, view_timeslots_by_range } from '../models/ExpertManageTimeModel';

// add physician available time stamps
export const expert_add_time_slots = (req, res) => {
    const body = req.body;
    add_time_slots(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// list timeslots by date
export const expert_list_time_slots_by_date = (req, res) => {
    const body = req.body;
    list_time_slots(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// edit physician available time stamps
export const expert_edit_time_slots = (req, res) => {
    const body = req.body;
    edit_time_slots(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// view timeslots in calemder
export const view_timeslots_in_calender = (req, res) => {
    const body = req.body;
    view_timeslots_by_range(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}