import { add_comment, list_comment, update_comment, 
    delete_comment, add_like, check_like_dislike, 
    list_comment_for_admin, add_reaction_comment, commentPublishStatusChange } from '../models/LikeAndCommentModel';
import sendResponse from '../../services/response';

// Add Comments
export const comment_add = (req, res) => {
    const body = req.body;
    add_comment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// List Comments
export const comment_list = (req, res) => {
    const body = req.body;
    list_comment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// List Comments for Admin
export const comment_list_admin = (req, res) => {
    const body = req.body;
    list_comment_for_admin(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Update Comment
export const comment_update = (req, res) => {
    const body = req.body;
    update_comment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Delete Comment
export const comment_delete = (req, res) => {
    const body = req.body;
    delete_comment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// List condition
export const like_add = (req, res) => {
    const body = req.body;
    add_like(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


// Ckeck Like/Dislike
export const check_like = (req, res) => {
    const body = req.body;
    check_like_dislike(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Add reaction for a comment
export const comment_add_reaction = (req, res) => {
    const body = req.body;
    add_reaction_comment(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Change publish status for a comment
export const comment_publish_status_change = (req, res) => {
    const body = req.body;
    commentPublishStatusChange(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

