import { countTags, create_new_tag,deleteTag,editTag, listTags, publishTag, unpublishTag} from '../models/ManageTagsModel';
import sendResponse from '../../services/response';

//create tag
export const create_tag = (req, res) => {
    const body = req.body;
    create_new_tag(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//delete tag
export const delete_tag = (req, res) => {
    const body = req.body;
    deleteTag(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//edit tag
export const edit_tag = (req, res) => {
    const body = req.body;
    editTag(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//publish tag
export const publish_tag = (req, res) => {
    const body = req.body;
    publishTag(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//unpublish tag
export const unpublish_tag = (req, res) => {
    const body = req.body;
    unpublishTag(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//list tag
export const list_tags = (req, res) => {
    const body = req.body;
    countTags(body).then((countresponse: any) => 
    listTags(body).then((response: any) => sendResponse(res, response.code, 1, response.message,{ count:countresponse.data,data:response.data}, ''))
    .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, '')))
    
}