import sendResponse from '../../services/response';
import {create_new_testimonial,update_testimonial,delete_testimonial_entry,search_testimonial_entries,publish_testimonial_entries,list_testimonial_entries} from '../models/ManageTestimonialsModel'

// create testimonial
export const create_testimonial = (req, res) => {
    const body = req.body;
    create_new_testimonial(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// edit testimonial
export const edit_testimonial = (req, res) => {
    const body = req.body;
    update_testimonial(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// delete testimonial
export const delete_testimonial = (req, res) => {
    const body = req.body;
    delete_testimonial_entry(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


// search testimonial
export const search_testimonial = (req, res) => {
    const body = req.body;
    search_testimonial_entries(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//publish testimonial
export const publish_testimonial = (req, res) => {
    const body = req.body;
    publish_testimonial_entries(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// list testimonial
export const list_testimonials = (req, res) => {
    const body = req.body;
    list_testimonial_entries(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}