import {
    register_user, check_otp, login_user, super_login,
    social_media_login, resend_otp, get_user_list, block_user, delete_user, add_admin_users, update_admin_users,
    delete_admin_user, get_admin_user_list, RTCTokenGenration, change_admin_password, reset_admin_password, forgot_admin_password,
    change_user_status,
    checkExistingPseudoname, user_feedback, all_issues_reported, complaint_details_by_id, list_feedbacks_for_admin,
    getUserFirebaseLiveTokens,user_chatbot_status
} from '../models/UserModel';
import sendResponse from '../../services/response';

// Fetch users
export const check_otp_auth = (req, res) => {
    const body = req.body;
    check_otp(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Register users
export const register = (req, res) => {
    const body = req.body;
    register_user(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// User Login
export const user_login = (req, res) => {
    const body = req.body;
    login_user(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//Super admin login
export const super_admin_login = (req, res) => {
    const body = req.body;
    super_login(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Social media login
export const social_login = (req, res) => {
    const body = req.body;
    social_media_login(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Resend OTP
export const otp_resend = (req, res) => {
    const body = req.body;
    resend_otp(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Resend OTP
export const get_userlist = (req, res) => {
    const body = req.body;
    get_user_list(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Resend OTP
export const blockuser = (req, res) => {
    const body = req.body;
    block_user(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Resend OTP
export const user_delete = (req, res) => {
    const body = req.body;
    delete_user(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


// Create admin user
export const create_admin_users = (req, res) => {
    const body = req.body;
    add_admin_users(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Edit admin user
export const edit_admin_users = (req, res) => {
    const body = req.body;
    update_admin_users(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Delete admin user
export const delete_admin_users = (req, res) => {
    const body = req.query;
    delete_admin_user(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Get admin user
export const get_admin_users = (req, res) => {
    const body = req.query;
    get_admin_user_list(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Agora Connection
export const RTC_TokenGenration = (req, res) => {
    const body = req.body;
    RTCTokenGenration(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Reset password
export const reset_password = (req, res) => {
    const body = req.body;
    reset_admin_password(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Forgot password
export const forgot_password = (req, res) => {
    const body = req.body;
    forgot_admin_password(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Change password
export const change_password = (req, res) => {
    const body = req.body;
    change_admin_password(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

// Block or unblock user
export const block_unblock_user = (req, res) => {
    const body = req.body;
    change_user_status(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//check existing pseudo_name
export const check_existing_pseudoname = (req, res) => {
    const body = req.body;
    checkExistingPseudoname(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//User feedback
export const feedback = (req, res) => {
    const body = req.body;
    user_feedback(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


//issues reported
export const list_all_issues_reported = (req, res) => {
    const body = req.body;
    all_issues_reported(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}


//get complaint details by id
export const get_complaint_details_by_id = (req, res) => {
    const body = req.body;
    complaint_details_by_id(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//get complaint details by id
export const list_feedbacks = (req, res) => {
    const body = req.body;
    list_feedbacks_for_admin(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

//get complaint details by id
export const get_user_firebase_token = (req, res) => {
    const body = req.body;
    getUserFirebaseLiveTokens(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}

export const update_user_chatbot_status = (req, res) => {
    const body = req.body;
    user_chatbot_status(body).then((response: any) => sendResponse(res, response.code, 1, response.message, response.data, ''))
        .catch((error: any) => sendResponse(res, error.code, 0, error.message, error.data, ''))
}