import * as express from 'express';
import {
    register, check_otp_auth, user_login, super_admin_login, social_login,
    otp_resend, get_userlist, blockuser, user_delete, create_admin_users, edit_admin_users,
    delete_admin_users, get_admin_users, RTC_TokenGenration, change_password, reset_password, forgot_password,
    block_unblock_user,
    check_existing_pseudoname,
    feedback,
    list_all_issues_reported,
    get_complaint_details_by_id,
    list_feedbacks,get_user_firebase_token,update_user_chatbot_status
} from './controller/UserController';
import { condition_add, delete_condition, condition_map_list, condition_update } from './controller/ConditionController';
import { like_add, check_like, comment_add, comment_list,
     comment_update, comment_delete, 
     comment_list_admin, comment_add_reaction, comment_publish_status_change } from './controller/LikeAndCommentController';
import { subscription_add } from './controller/SubscriptionController';
import { list_profile, update_user_profile, user_profile,hemlingmate_profile, get_user_privacy, update_user_privacy, profile_percentage, update_user_profile_mw } from './controller/UserProfileController';
import { create_advertisement, edit_advertisement, list_advertisements, search_advertisements, delete_advertisement, publish_advertisement } from './controller/ManageAdvertisementsController';
import { create_tag, delete_tag, edit_tag, list_tags, publish_tag, unpublish_tag } from './controller/ManageTagsController';
import { uploadImage, imageTempUrl, media_upload, get_images, getSESToken } from './controller/BlobStorage';
import { create_testimonial, edit_testimonial, delete_testimonial, search_testimonial, publish_testimonial, list_testimonials } from './controller/ManageTestimonialsController'
import { create_roles, update_roles, delete_roles, get_roles, get_role_details, get_modules } from './controller/RolesController';
import { jwtAuth } from '../middleware/jwt-authenticate';
import {
    create_post, edit_post, delete_post, list_posts,
    add_reaction, share_post, get_all_reactions, global_search,
    post_details,
    content_moderation
} from './controller/FeedsController';
import {
    connect, accept_reject_connection, my_connections,
    member_conditions, member_conditions_filter, member_connections, member_connections_search
} from './controller/ConnectionController'
import { approve_reject_post, report_post, reply_post, 
    view_posts, search_posts, my_posts, admin_global_search, get_post_details_by_id, analytics } from './controller/PostController';
import { decodeJWT } from '../middleware/decodejwt';
import { check_admin_permission } from '../middleware/check_admin_permission';
import { create_treatment, delete_treatment, edit_treatment, list_treatments, publish_treatment, unpublish_treatment } from './controller/ManageTreatmentsController';
import {end_User_ActiveSession, list_notifications, read_notification, send_test_notification} from './controller/notificationController';
import { expertAdmin_signup, expert_changepassword, expert_forgotpassword, expert_signin } from './controller/ExpertUserController'

import { add_department, delete_department, edit_department, get_department_details_by_id, list_departmentIndices, list_departments_by_clinic } from './controller/ExpertDepartmentController'
import { add_clinic, add_manager, edit_clinicDetails, list_clinicDetails } from './controller/ExpertClinicController'
import { add_physician, get_physician_services,get_physician_details_by_id,
    list_experts,get_expert_details, list_experts_by_department,
    list_experts_by_clinic,
    update_expert_bio,
    update_expert_address,
    update_profile_image,
    edit_physician,
    list_physician_available_time,
    delete_physician,
    get_physician_details_by_section,
    list_appointments
} from './controller/ExpertPhysicianController'
import { book_appointment,book_appointment_by_agent, reschedule_appointment_by_patient, 
    cancel_appointment, upcoming_appointments, RTC_TokenGenration_for_call, add_consultation_notes, get_consultation_notes_summary, get_patient_records_for_consult, start_consultation_expert, start_consultation_patient, reject_Consultation_by_expert, past_appointments, past_appointments_details, submit_prescription, end_call, disconnected_call_data, patient_end_call 
 } from './controller/ExpertConusultationController'
 import{ get_patient_data, get_patient_medical_profile, get_patient_past_appointments, 
    list_patients_by_clinic_id, list_patients_by_expert_id, 
    upcoming_appointments_patient_details, get_patient_medical_records, get_patient_medical_records_web, invite_patient,save_medial_reports, add_medical_reports_to_consultation, delete_medical_records, edit_medical_reports } from './controller/ExpertPatientController'
 
import { initiate_payment, initiate_refund, patient_list_cards, 
    payment_success_hook, refund_or_report, instant_refund, 
    refund_success_hook, reject_refund, view_refund_status ,move_issue_to_refund, reply_to_issue } from './controller/ExpertPaymentController'; 
 import {expert_add_time_slots, expert_edit_time_slots, expert_list_time_slots_by_date, view_timeslots_in_calender} from './controller/ExpertManageTimeController';



let router = express.Router();

var apicache = require('apicache');
let cache = apicache.middleware(('5 minutes'))

router.get('/api', (req, res) => {
    res.status(200).json({ status: 1, message: 'API is Working' });
});

router.post('/api/check_otp', check_otp_auth);
router.post('/api/register', register);
router.post('/api/register_profile', jwtAuth, user_profile);
router.post('/api/register_helingmate_profile', jwtAuth, hemlingmate_profile);
router.post('/api/user_login', user_login);
router.post('/api/super_user_login', super_admin_login);
router.post('/api/comment_add', jwtAuth, comment_add);
router.post('/api/comment_publish_status_change', jwtAuth, comment_publish_status_change);
router.post('/api/comment_list', comment_list);
router.post('/api/comment_list_admin', jwtAuth, comment_list_admin);
router.post('/api/social_login', social_login);
router.post('/api/comment_update', jwtAuth, comment_update);
router.post('/api/comment_delete', jwtAuth, comment_delete);
router.post('/api/otp_resend', otp_resend);
router.post('/api/list_profile', jwtAuth, list_profile);
router.post('/api/update_user_profile', jwtAuth, update_user_profile);
router.post('/api/update_user_profile_mw', jwtAuth, update_user_profile_mw);
router.post('/api/condition_add', jwtAuth, condition_add);
router.post('/api/delete_condition', jwtAuth, delete_condition);
router.post('/api/condition_map_list', condition_map_list);
router.post('/api/uploadImage', uploadImage);
router.post('/api/imageTempUrl', imageTempUrl);
router.post('/api/like_add', jwtAuth, like_add);
router.post('/api/subscription_add', subscription_add);
router.post('/api/get_user_privacy', get_user_privacy); 
router.post('/api/update_user_privacy', update_user_privacy);
router.get('/api/profilePercentage', profile_percentage);
router.post('/api/check_like', check_like);
//Manage posts
router.post('/api/create_post',jwtAuth,check_admin_permission('Posts', 'p_create'), create_post);
router.post('/api/edit_post', jwtAuth,check_admin_permission('Posts', 'p_update'), edit_post);
router.post('/api/delete_post', jwtAuth, check_admin_permission('Posts', 'p_delete'), delete_post);
router.post('/api/list_posts', jwtAuth,list_posts);
router.post('/api/add_reaction', jwtAuth, add_reaction);
router.post('/api/share_post', jwtAuth, share_post);
router.post('/api/get_all_reactions', jwtAuth, get_all_reactions);
router.post('/api/global_search', jwtAuth, global_search);

router.post('/api/condition_update', condition_update);
router.post('/api/get_userlist', get_userlist);
router.post('/api/blockuser', blockuser);
router.post('/api/user_delete', user_delete);
router.post('/api/roles', jwtAuth, check_admin_permission('Roles', 'p_create'), create_roles);
router.put('/api/roles', jwtAuth, check_admin_permission('Roles', 'p_update'), update_roles);
router.delete('/api/roles', jwtAuth, check_admin_permission('Roles', 'p_delete'), delete_roles);
router.post('/api/media', media_upload);
router.post('/api/getImages', jwtAuth, get_images);
router.get('/api/roles', jwtAuth, check_admin_permission('Roles', 'p_view'), get_roles);
router.get('/api/roles/:id', jwtAuth, check_admin_permission('Roles', 'p_view'), get_role_details);
router.get('/api/modules', jwtAuth, get_modules);
router.post('/api/adminUsers', jwtAuth, check_admin_permission('Admin users', 'p_create'), create_admin_users);
router.put('/api/adminUsers', jwtAuth, check_admin_permission('Admin users', 'p_update'), edit_admin_users);
router.delete('/api/adminUsers', jwtAuth, check_admin_permission('Admin users', 'p_delete'), delete_admin_users);
router.get('/api/adminUsers', jwtAuth, check_admin_permission('Admin users', 'p_view'), get_admin_users);
//admin module API's
router.post('/api/approve_reject_post', jwtAuth, approve_reject_post);
router.post('/api/report_post', jwtAuth, report_post);
router.post('/api/reply_post', jwtAuth, reply_post);
router.post('/api/view_posts', jwtAuth,check_admin_permission('Posts', 'p_view'), view_posts);
router.post('/api/search_posts', jwtAuth, search_posts);
// manage testimonials
router.post('/api/create_testimonial', jwtAuth, check_admin_permission('Testimonials', 'p_create'),create_testimonial);
router.post('/api/edit_testimonial', jwtAuth, check_admin_permission('Testimonials', 'p_update'), edit_testimonial);
router.post('/api/delete_testimonial', jwtAuth, check_admin_permission('Testimonials', 'p_delete'), delete_testimonial);
router.post('/api/search_testimonial', jwtAuth, search_testimonial);
router.post('/api/publish_testimonial', jwtAuth, check_admin_permission('Testimonials', 'publish'), publish_testimonial);
router.post('/api/list_testimonials', jwtAuth, check_admin_permission('Testimonials', 'p_view'), list_testimonials);
// manage advertisements
router.post('/api/create_advertisement', jwtAuth, check_admin_permission('Advertisements', 'p_create'),create_advertisement);
router.post('/api/edit_advertisement', jwtAuth, check_admin_permission('Advertisements', 'p_update'), edit_advertisement);
router.post('/api/list_advertisements', jwtAuth, check_admin_permission('Advertisements', 'p_view'), list_advertisements);
router.post('/api/search_advertisements', jwtAuth, search_advertisements);
router.post('/api/delete_advertisement', jwtAuth, check_admin_permission('Advertisements', 'p_delete'), delete_advertisement);
router.post('/api/publish_advertisement', jwtAuth, check_admin_permission('Advertisements', 'publish'), publish_advertisement);
// manage tags
router.post('/api/create_tag', jwtAuth, check_admin_permission('Tags', 'p_create'), create_tag);
router.post('/api/delete_tag', jwtAuth, check_admin_permission('Tags', 'p_delete'),delete_tag);
router.post('/api/edit_tag', jwtAuth, check_admin_permission('Tags', 'p_update'),edit_tag);
router.post('/api/publish_tag', jwtAuth, check_admin_permission('Tags', 'publish'), publish_tag);
router.post('/api/unpublish_tag', jwtAuth, check_admin_permission('Tags', 'publish'), unpublish_tag);
router.post('/api/list_tags', list_tags);
//connections
router.post('/api/connect', jwtAuth, connect);
router.post('/api/accept_reject_connection', jwtAuth, accept_reject_connection);
router.post('/api/my_connections', jwtAuth, my_connections);
router.post('/api/member_conditions', jwtAuth, member_conditions);
router.post('/api/member_conditions_filter', jwtAuth, member_conditions_filter);
router.post('/api/member_connections', jwtAuth, member_connections);
router.post('/api/member_connections_search', jwtAuth, member_connections_search);


router.post('/api/chat_connection_request', RTC_TokenGenration);
router.post('/api/change_password', jwtAuth, change_password);
router.post('/api/forgot_password', forgot_password);
router.post('/api/reset_password', reset_password);

// manage treatments
router.post('/api/create_treatment', jwtAuth, check_admin_permission('Treatments', 'p_create'), create_treatment);
router.post('/api/edit_treatment', jwtAuth, check_admin_permission('Treatments', 'p_update'),edit_treatment);
router.post('/api/delete_treatment', jwtAuth, check_admin_permission('Treatments', 'p_delete'), delete_treatment);
router.post('/api/list_treatments', list_treatments);
router.post('/api/unpublish_treatment',jwtAuth, check_admin_permission('Treatments', 'publish'), unpublish_treatment);
router.post('/api/publish_treatment',jwtAuth, check_admin_permission('Treatments', 'publish'), publish_treatment);
router.post('/api/comment_add_reaction', jwtAuth, comment_add_reaction);
router.post('/api/my_posts', jwtAuth, my_posts);
router.post('/api/admin_global_search', jwtAuth, admin_global_search);
router.post('/api/get_post_details_by_id', jwtAuth, get_post_details_by_id);
router.post('/api/analytics', jwtAuth, analytics);

// router.post('/api/send_test_notification', send_test_notification);

//notification setup
// router.post('/api/startUserActiveSession', jwtAuth,start_User_ActiveSession);
router.post('/api/endUserActiveSession', jwtAuth,end_User_ActiveSession);
router.post('/api/send_test_notification',send_test_notification);
router.post('/api/list_notifications', jwtAuth,list_notifications);
router.post('/api/read_notification', jwtAuth,read_notification);
router.post('/api/block_unblock_user', jwtAuth, check_admin_permission('Users', 'p_delete'), block_unblock_user);
router.post('/api/check_existing_pseudoname', jwtAuth,check_existing_pseudoname);

// Expert consult APIs
router.post('/api/expertAdmin_signup',expertAdmin_signup);
router.post('/api/expert_signin',expert_signin);
router.post('/api/add_clinic',add_clinic);
router.post('/api/add_manager', jwtAuth,add_manager);
router.post('/api/add_department', jwtAuth,add_department);
router.post('/api/list_clinicDetails',jwtAuth,list_clinicDetails);
router.post('/api/edit_clinicDetails',jwtAuth,edit_clinicDetails);
router.post('/api/add_physician',jwtAuth,add_physician);
router.post('/api/get_physician_services',jwtAuth,get_physician_services);
router.post('/api/list_experts',jwtAuth,list_experts);
router.post('/api/expert_forgotpassword',expert_forgotpassword);
router.post('/api/expert_changepassword',expert_changepassword);
router.post('/api/get_physician_details_by_id',jwtAuth,get_physician_details_by_id);
router.post('/api/list_expert_details',jwtAuth, get_expert_details);
router.post('/api/list_experts_by_department',jwtAuth,list_experts_by_department);
router.get('/api/list_departmentIndices',jwtAuth,list_departmentIndices);
router.post('/api/list_departments_by_clinic',jwtAuth,list_departments_by_clinic);
router.post('/api/list_experts_by_clinic',jwtAuth,list_experts_by_clinic);
router.post('/api/book_appointment',jwtAuth, book_appointment);
router.post('/api/book_appointment_by_agent',jwtAuth, book_appointment_by_agent);
router.post('/api/reschedule_appointment_by_patient',jwtAuth,reschedule_appointment_by_patient);
router.post('/api/cancel_appointment_by_patient',jwtAuth,cancel_appointment);
router.post('/api/past_appointments_by_patient',jwtAuth, past_appointments);
router.post('/api/upcoming_appointments_by_patient',jwtAuth, upcoming_appointments);
router.post('/api/update_expert_bio',jwtAuth,update_expert_bio);
router.post('/api/update_expert_address',jwtAuth,update_expert_address);
router.post('/api/update_profile_image',jwtAuth,update_profile_image);
router.post('/api/edit_physician',jwtAuth,edit_physician);
router.post('/api/delete_physician',jwtAuth,delete_physician);
router.post('/api/list_physician_available_time',jwtAuth,list_physician_available_time);
router.post('/api/list_patients_by_expert_id',jwtAuth,list_patients_by_expert_id);
router.post('/api/get_physician_details_by_section',jwtAuth,get_physician_details_by_section);
router.post('/api/get_department_details_by_id',jwtAuth,get_department_details_by_id);
router.post('/api/edit_department',jwtAuth,edit_department);
router.post('/api/delete_department',jwtAuth,delete_department);
router.post('/api/list_patients_by_clinic_id',jwtAuth,list_patients_by_clinic_id);
router.post('/api/call_connection_request', RTC_TokenGenration_for_call);
router.post('/api/expert_add_time_slots',jwtAuth,expert_add_time_slots);
router.post('/api/list_appointments_by_physician',jwtAuth,list_appointments);
router.post('/api/expert_list_time_slots_by_date',jwtAuth,expert_list_time_slots_by_date);
router.post('/api/get_patient_medical_profile',jwtAuth,get_patient_medical_profile);
router.post('/api/get_patient_past_appointments',jwtAuth,get_patient_past_appointments);
router.post('/api/add_consultation_notes',jwtAuth,add_consultation_notes);
router.post('/api/get_consultation_notes_summary', jwtAuth,get_consultation_notes_summary);
router.post('/api/get_patient_records_for_consult', jwtAuth,get_patient_records_for_consult);
router.post('/api/initiate_payment', jwtAuth, initiate_payment);
router.post('/api/upcoming_appointments_patient_details',jwtAuth,upcoming_appointments_patient_details);
router.post('/api/get_patient_data',jwtAuth,get_patient_data);
router.post('/api/patient_list_cards',jwtAuth, patient_list_cards);
router.post('/api/expert_edit_time_slots',jwtAuth, expert_edit_time_slots);
router.post('/api/get_patient_medical_records', jwtAuth, get_patient_medical_records);
router.post('/api/payment_success_hook', payment_success_hook);
router.post('/api/get_patient_medical_records_web', jwtAuth,get_patient_medical_records_web);
router.post('/api/view_timeslots_in_calender' ,jwtAuth,view_timeslots_in_calender);
router.post('/api/post_details' ,jwtAuth, post_details);
router.post('/api/start_consultation_expert',jwtAuth,start_consultation_expert);
router.post('/api/start_consultation_patient',jwtAuth,start_consultation_patient);
router.post('/api/reject_Consultation_by_expert',jwtAuth,reject_Consultation_by_expert);
router.post('/api/invite_patient',jwtAuth,invite_patient);
router.post('/api/save_medial_reports',jwtAuth,save_medial_reports);
router.post('/api/feedback',jwtAuth, feedback);
router.post('/api/getSESToken',jwtAuth, getSESToken);
router.post('/api/delete_medical_records',jwtAuth, delete_medical_records);
router.post('/api/refund_or_report',jwtAuth, refund_or_report);
router.post('/api/submit_prescription',submit_prescription);
router.post('/api/end_call',jwtAuth,end_call);
router.post('/api/approve_refund',jwtAuth, initiate_refund);
router.post('/api/add_medical_reports_to_consultation',jwtAuth,add_medical_reports_to_consultation);
router.post('/api/instant_refund',jwtAuth, instant_refund);
router.post('/api/list_all_issues_reported',jwtAuth,list_all_issues_reported);
router.post('/api/end_call_by_patient',jwtAuth,patient_end_call);
router.post('/api/past_appointments_details',jwtAuth, past_appointments_details);
router.post('/api/get_complaint_details_by_id',jwtAuth,get_complaint_details_by_id);
router.post('/api/disconnected_call_data',jwtAuth,disconnected_call_data);
router.post('/api/edit_medical_reports',jwtAuth,edit_medical_reports);
router.post('/api/refund_success_hook',refund_success_hook);
router.post('/api/move_issue_to_refund',jwtAuth,move_issue_to_refund);
router.post('/api/reply_to_issue',reply_to_issue);
router.post('/api/reject_refund',jwtAuth, reject_refund);
router.post('/api/view_refund_status',jwtAuth, view_refund_status);
router.post('/api/list_feedbacks', jwtAuth,list_feedbacks);
router.post('/api/user_firebase_token', jwtAuth,get_user_firebase_token);
router.post('/api/user_chatbot_status', jwtAuth,update_user_chatbot_status);

router.post('/api/content_moderation', jwtAuth,content_moderation);

router.post('/api/auth-apple-signin', async (req, res) => {
    try {
		console.log(req);
        const url = `${process.env.MARKETING_WEBSITE_URL}/sign-in`
		return res.send(
		`<script>
			 const APPLE_SIGN_IN_DATA =${JSON.stringify(req.body)}
				if (window.opener) {
					window.opener.postMessage(APPLE_SIGN_IN_DATA, '${url}')
					 window.close();
				}
		</script>`
		)
	} catch (error) {
		// handle error
		console.log(error)
	}
})

router.post('/api/auth-apple-signup', async (req, res) => {
    try {
		console.log(req);
        const url = `${process.env.MARKETING_WEBSITE_URL}/sign-up`
		return res.send(
		`<script>
			 const APPLE_SIGN_IN_DATA =${JSON.stringify(req.body)}
				if (window.opener) {
					window.opener.postMessage(APPLE_SIGN_IN_DATA, '${url}')
					 window.close();
				}
		</script>`
		)
	} catch (error) {
		// handle error
		console.log(error)
	}
})


export = router;


