import { blobStorageUploadImage, blobStorageTempUrl, mediaUploadBlobStorage, getSESToken, deleteMedicalRecords } from '../../services/blobStorage';
import { v4 as uuidv4 } from 'uuid';

export let blobStorageUpload = (body) => {
    return new Promise((resolve, reject) => {
        let promiseArray = [];
        body.uploadData.forEach(element => {
            element.containerName = body.containerName;
            promiseArray.push(blobStorageUploadImage(element));
        });
        Promise.all(promiseArray).then((result: any) => {
            resolve({ code: 200, status: 1, message: 'Image uploaded', data: {} });
        }).catch(error => {
            reject({ code: 400, status: 0, message: 'Error', data: error })
        })

    })
}


export let blobStorage_TempUrl = (body) => {
    return new Promise((resolve, reject) => {
        blobStorageTempUrl(body).then((result: any) => {
            resolve({ code: 200, status: 1, message: 'Temp URL', data: result });
        }).catch(error => {
            reject({ code: 400, status: 0, message: 'Error', data: error })
        })
    })
}

export let mediaUpload = (req) => {
    return new Promise((resolve, reject) => {
        let promiseArray = [];
        const files = req.files ? req.files.file : "";
        const currentTime = Math.floor(Date.now() / 1000);
        var blobNames = []
        
        if (!files) {
            reject({ code: 400, status: 0, message: 'Please select a file', data: {} })
        } else if (files && Array.isArray(files)) {
            files.forEach((element, index) => {
                var filename = uuidv4();
                const blobName = 'feeds/' + filename + '_' + currentTime + '.' + element.name.split('.')[(element.name.split('.').length) - 1];
                blobNames.push(blobName)
                promiseArray.push(mediaUploadBlobStorage(element, req.body.containerName, blobName));
            });
        } else {
            var filename = uuidv4();
            const blobName = 'feeds/' + filename + '_' + currentTime + '.' + files.name.split('.')[(files.name.split('.').length) - 1];
            blobNames.push(blobName)
            promiseArray.push(mediaUploadBlobStorage(files, req.body.containerName, blobName));
        }

        Promise.all(promiseArray).then((result: any) => {
            resolve({ code: 200, status: 1, message: 'Image uploaded', data: { blobNames } });
        }).catch(error => {
            reject({ code: 400, status: 0, message: 'Error', data: error })
        })
    })
}

export let get_image_url = (body) => {
    return new Promise((resolve, reject) => {
        let promise = [];
        body.imageNames.forEach(element => {
            promise.push(blobStorageTempUrl({ blobName: element, containerName: process.env.PRIVATE_CONTAINER }))
        });
        Promise.all(promise).then((result: any) => {
            resolve({ code: 200, status: 1, message: 'Temp URL', data: result });
        }).catch(error => {
            reject({ code: 400, status: 0, message: 'Error', data: error })
        })
    })
}

//Get SES token to upload medical records
export let get_ses_token = (body) => {
    return new Promise((resolve, reject) => {
        getSESToken(body).then((result: any) => {
            resolve({ code: 200, status: 1, message: 'Token generated successfully', data: result });
        }).catch(error => {
            reject({ code: 400, status: 0, message: 'Error', data: error })
        })
    })
}


//Delete medical records of patient
export let medical_records_delete = (_body) => {
    return new Promise((resolve, reject) => {
        deleteMedicalRecords(_body).then((result: any) => {
            resolve({ code: 200, status: 1, message: 'Medical Record deleted successfully', data: result });
        }).catch(error => {
            reject({ code: 400, status: 0, message: 'Error', data: error })
        })
    })
}
