import query from '../query/query';
import { database, expertDb } from '../../config/dbConfig';
import * as dotenv from 'dotenv'
dotenv.config()
import * as jwt from 'jsonwebtoken';
import * as config from '../../config/security-config';
import * as crypto from 'crypto';
import * as password from 'secure-random-password';
import { send_sms } from '../../services/smsService';
import { sendGridEmail } from '../../services/sendGridEmail'
const saltRounds = process.env.SALT_ROUNDS;
import readHtml from '../../services/readHtml';
import * as handlebars from 'handlebars';
import { getUserLiveTokens } from './notificationModel';
import * as bcrypt from 'bcrypt';
import * as security_config from '../../config/security-config';
import { hashfunction } from './ExpertUserModel';
import { get_clinic_details } from './ExpertDepartmentModel'
import { add_logs } from './LogModel';

//Add Physician to departement

export const physician_add = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const expert_user_chk_email_or_phone = {
                    name: 'expert_user_chk_email_or_phone',
                    text: query.expert_user_chk_email_or_phone,
                    values: [_body.email, _body.phone, 'physician']
                }
                var user_status = await client.query(expert_user_chk_email_or_phone);
                if (user_status.rows.length != 0) {
                    reject({ code: 400, message: "Physician email or Phone already exists", data: {} });
                }
                else {
                    const clinicId = await get_clinic_details(_body.departmentId)
                    //add new physician to the department
                    let password_gen = password.randomPassword({ length: 20, characters: [password.lower, password.upper, password.digits] })
                    hashfunction(password_gen).then(async (result: any) => {
                        const expert_user_register = {
                            name: 'expert_user_register',
                            text: query.expert_user_register,
                            values: [_body.email, _body.firstName,
                            _body.lastName, _body.gender, _body.dob,
                            _body.phone, 'physician', currentTime, result.hash, 1,
                            _body.firstName, clinicId, _body.departmentId, _body.profile_image]
                        }
                        const user_details = await client.query(expert_user_register);
                        const userId = user_details.rows[0].id

                        //insert to physician_details table
                        const add_expert_details = {
                            name: 'add_expert_details',
                            text: query.add_expert_details,
                            values: [userId, _body.registraionNumber, _body.registraionCouncil, _body.registraionYear, _body.speciality, _body.medicalSchool, _body.experience, _body.qualification, _body.address1, _body.address2, _body.state, _body.pincode, _body.firstVisitPay, _body.followUpPay, _body.expertDocument, _body.consultationDuration]
                        }
                        await client.query(add_expert_details)

                        _body.services.forEach(async (service) => {
                            const add_expert_services = {
                                name: 'add_expert_services',
                                text: query.add_expert_services,
                                values: [service.id, userId, _body.userid]
                            }
                            await client.query(add_expert_services)
                        });

                        const mailData = { to: _body.email, templateName: "invite_admin", set_password_url: process.env.EXPERT_PHYSICIAN_SET_PASSWORD_URL + password_gen + '&id=' + userId, title: "Welcome to the team!", description: "You are invited to take up the Physician responsibility of MyHealingMate expert platform. ", button_label: "Set Password" }
                        sendGridEmail(mailData)
                        resolve({ code: 200, message: "Physician created successfully", data: user_details.rows[0] });
                    })
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//List of physician services 

export const physician_services = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const userQuery = `SELECT id,service_offered from service`;
                const user_details = await client.query(userQuery);
                resolve({
                    code: 200, message: "services list", data: { services: user_details.rows }
                });

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//List Physicians

export const physician_list = (_body) => {
    console.log(_body)
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            let physicians = []
            try {
                //TODO:find distance between the user and the physician
                //get current user lat and long
                const userQuery = `SELECT latitude,longitude from users WHERE id=${_body.userid}`;
                const user_details = await client.query(userQuery);
                if (user_details && user_details.rowCount > 0) {
                    var latitude = user_details.rows[0].latitude;
                    var longitude = user_details.rows[0].longitude;
                }
                const query = `select a.service_offered , u.id as userId, u.id as physicianId,
                u.first_name, u.last_name, u.email, u.latitude, u.longitude,
                u.profile_image,pd.medical_school, pd.experience, pd.qualification, pd.first_visit_pay as fees,
                pd.speciality,d."service_type",d."departmentId", d."departmentName",
                c."clinic_id", c."clinicName",c.latitude, c.longitude,
                distance(${latitude}, ${longitude}, c.latitude, c.longitude) as distance
                from users u
                LEFT JOIN physician_details pd ON u.id=pd.physician_id
                LEFT JOIN clinic c ON u.clinic_id=c."clinic_id"
                LEFT JOIN department d ON d."departmentId"=u.department_id
                LEFT JOIN (select ps.physician_dtl_id ,array_agg(s.service_offered) as service_offered
                FROM physician_service ps, service s
                where s.id = ps.service_id
                group by ps.physician_dtl_id)a on (u.id = a.physician_dtl_id )
                WHERE user_type='physician' AND u.status='1'`;
                const physician_details = await client.query(query)
                if (physician_details) {
                    //prepare the data format
                    physician_details.rows.forEach(item => {
                        const userDetails = {
                            profile_image: item.profile_image,
                            firstName: item.first_name,
                            lastName: item.last_name,
                            email: item.email,
                            userId: item.userid,
                            physicianId: item.physicianid,
                            medicalSchool: item.medical_school,
                            qualification: item.qualification,
                            experience: item.experience,
                            fees: item.fees,
                            distance: item.distance ? (parseInt(item.distance) / 0.62137).toFixed(2) + " km away" : "",
                            departmentId: item.departmentId,
                            departmentName: item.departmentName,
                            speciality: item.speciality,
                            clinicId: item.clinic_id,
                            clinicName: item.clinicName,
                            serviceOffered: item.service_offered,
                            serviceType: item.service_type

                        }
                        physicians.push(userDetails)
                    })
                    add_logs('Expert list', `Userid ${_body.user.userid} has accessed Expers list API`, 11, _body.user.userid)
                    resolve({
                        code: 200, message: "Experts listed successfully", data: {
                            physicianCount: physicians.length,
                            physician: physicians
                        }
                    });
                } else {
                    resolve({
                        code: 200, message: "No experts found", data: {}
                    });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const fetch_physician_details = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const query = `SELECT u.profile_image, u.first_name, u.last_name,pd.bio, 
                pd.experience, pd.qualification, pd.first_visit_pay as fees, 
                pd.speciality, c."clinic_id", c."clinicName",
                c.latitude, c.longitude, c.address from users u
                LEFT JOIN physician_details pd ON u.id=pd.physician_id
                LEFT JOIN clinic c ON u.clinic_id=c."clinic_id"
                WHERE u.id=${_body.expertId}`;
                const physician_details = await client.query(query);
                add_logs('Expert details', `Userid ${_body.user.userid} has accessed Expers detals API`, 11, _body.user.userid)
                if (physician_details && physician_details.rowCount > 0) {
                    resolve({
                        code: 200, message: "Expert profile listed successfully",
                        data: physician_details.rows[0]
                    });
                } else {
                    resolve({
                        code: 200, message: "No expert found", data: {}
                    });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// get physician details by id

export const physician_details_by_id = (_body) => {
    return new Promise((resolve, reject) => {
        let physicianData = [];
        (async () => {
            const client = await database().connect()
            try {
                const physician_details_by_id = {
                    name: 'physician_details_by_id',
                    text: query.physician_details_by_id,
                    values: [_body.userId]
                }
                const user_details = await client.query(physician_details_by_id);
                if (user_details.rows.length > 0) {
                    const userQuery = `SELECT "departmentName" from department WHERE "departmentId"=${user_details.rows[0].department_id}`;
                    const department_name = await client.query(userQuery);
                    user_details.rows.forEach(item => {
                        const userDetailsFinal = {
                            profile_image: item.profile_image,
                            firstName: item.first_name,
                            lastName: item.last_name,
                            dob: item.dob,
                            gender: item.gender,
                            bio: item.bio,
                            registraionNumber: item.registraion_number,
                            registraionCouncil: item.registraion_council,
                            registraionYear: item.registraion_year,
                            qualification: item.qualification,
                            medicalSchool: item.medical_school,
                            specialisation: department_name.rows[0].departmentName,
                            speciality: item.speciality,
                            department_name: department_name.rows[0].departmentName,
                            departmentId: user_details.rows[0].department_id,
                            experience: item.experience,
                            email: item.email,
                            phone: item.phone,
                            address1: item.address_line1,
                            address2: item.address_line2,
                            state: item.state_name,
                            pincode: item.pincode,
                            expert_document: item.expert_document,
                            firstVisitPay: item.first_visit_pay,
                            followUpPay: item.follow_up_pay,
                            mhm_service_fee_percent: item.mhm_tax_percentage,
                            tax_percentage: item.tax_percentage,
                            consultationDuration: item.consultation_duration
                        }
                        physicianData.push(userDetailsFinal)
                    });

                    resolve({ code: 200, message: "physician details listed successfully", data: physicianData });
                }
                else {
                    resolve({ code: 200, message: "Something went wrong", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// list experts by department id

export const list_experts_by_department_id = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var searchkey = "";
            const physiciansCount = await get_physiciansCount(_body.departmentId, searchkey, 'department_id')
            const client = await database().connect()
            try {
                const list_experts_by_department = {
                    name: 'list_experts_by_department',
                    text: query.list_experts_by_department,
                    values: [_body.departmentId, 1, 'physician', _body.limit, _body.offset]
                }
                const user_details = await client.query(list_experts_by_department);
                if (user_details.rows.length > 0) {
                    resolve({ code: 200, message: "physician details listed successfully", data: { expertsCount: physiciansCount, experts: user_details.rows } });
                }
                else {
                    resolve({ code: 200, message: "Something went wrong", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// Search Experts
export const search_expert = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                //get current user lat and long
                const userQuery = `SELECT latitude,longitude from users WHERE id=${_body.userid}`;
                const user_details = await client.query(userQuery);
                if (user_details && user_details.rowCount > 0) {
                    var latitude = user_details.rows[0].latitude;
                    var longitude = user_details.rows[0].longitude;
                }
                const query = `SELECT u.id as userId, u.id as physicianId, 
                first_name, last_name, email, u.latitude, u.longitude, u.profile_image,
                pd.medical_school, pd.experience, pd.qualification, pd.first_visit_pay as fees,
                d."departmentId", d."departmentName", c."clinic_id", c."clinicName",c.latitude, c.longitude,
                distance(${latitude}, ${longitude}, c.latitude, c.longitude) as distance
                from users u
                LEFT JOIN physician_details pd ON u.id=pd.physician_id
                LEFT JOIN clinic c ON u.clinic_id=c."clinic_id"
                LEFT JOIN department d ON d."departmentId"=u.department_id
                WHERE LOWER(u.first_name) LIKE LOWER('%${_body.search_string}%') OR LOWER(d."departmentName") LIKE LOWER('%${_body.search_string}%')`;
                const physician_details = await client.query(query);
                if (physician_details && physician_details.rowCount > 0) {
                    resolve({
                        code: 200, message: "Expert search completed successfully",
                        data: physician_details.rows
                    });
                } else {
                    resolve({
                        code: 200, message: "No expert found", data: {}
                    });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// list experts by department id

export const list_experts_by_clinic_id = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var searchkey = "";
            if (_body.search_key) {
                searchkey = " AND ((LOWER(first_name) LIKE LOWER('%" + _body.search_key + "%')) OR (LOWER(last_name) LIKE LOWER('%" + _body.search_key + "%')))"
            }
            const physiciansCount = await get_physiciansCount(_body.clinicId, searchkey, 'clinic_id')
            const client = await database().connect()
            try {
                const list_experts_by_clinic = {
                    name: 'list_experts_by_clinic',
                    text: query.list_experts_by_clinic + searchkey + ' ORDER BY created_date DESC LIMIT ' + _body.limit + ' OFFSET ' + _body.offset,
                    values: [_body.clinicId, 'physician']
                }
                const user_details = await client.query(list_experts_by_clinic);
                if (user_details.rows.length > 0) {
                    resolve({ code: 200, message: "physician details listed successfully", data: { expertsCount: physiciansCount, experts: user_details.rows } });
                }
                else {
                    resolve({ code: 200, message: "Failed. No experts found", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// find departments count in clinic
export const get_physiciansCount = (clinic_or_department_Id, searchkey, type) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                //get clinic details
                const query = `SELECT COUNT(id) from users WHERE ${type}=${clinic_or_department_Id} AND status::integer=1 ${searchkey} and user_type='physician' `;
                const details = await client.query(query)
                if (details) {
                    resolve(details.rows[0].count)
                } else {
                    resolve(null)
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// add expert bio and signature

export const add_expert_bio_details = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (_body.bio == "" && _body.sign != "") {
                    var expert_bio_add = {
                        name: 'expert_bio_add',
                        text: query.expert_sign_add,
                        values: [_body.expertId, _body.sign]
                    }
                }
                else if (_body.sign == "" && _body.bio != "") {
                    var expert_bio_add = {
                        name: 'expert_bio_add',
                        text: query.expert_bio_add,
                        values: [_body.expertId, _body.bio]
                    }
                }
                else if (_body.sign != "" && _body.bio != "") {
                    var expert_bio_add = {
                        name: 'expert_bio_add',
                        text: query.expert_bio_sign_add,
                        values: [_body.expertId, _body.bio, _body.sign]
                    }
                }
                const user_details = await client.query(expert_bio_add);
                if (user_details.rows.length > 0) {
                    resolve({ code: 200, message: "Expert bio updated successfully", data: user_details.rows[0] });
                }
                else {
                    resolve({ code: 200, message: "Something went wrong", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// edit expert bio and signature
export const edit_expert_bio_details = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const expert_bio_add = {
                    name: 'expert_bio_add',
                    text: query.expert_bio_add,
                    values: [_body.expertId, _body.bio, _body.sign]
                }
                const user_details = await client.query(expert_bio_add);
                if (user_details.rows.length > 0) {
                    resolve({ code: 200, message: "Expert bio updated successfully", data: user_details.rows[0] });
                }
                else {
                    resolve({ code: 200, message: "Something went wrong", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// update expert address
export const update_expertAddress = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const expert_address_edit = {
                    name: 'expert_address_edit',
                    text: query.expert_address_edit,
                    values: [_body.expertId, _body.address_line1, _body.address_line2, _body.state_name, _body.pincode]
                }
                const user_details = await client.query(expert_address_edit);
                if (user_details.rows.length > 0) {
                    resolve({ code: 200, message: "Expert address updated successfully", data: user_details.rows[0] });
                }
                else {
                    resolve({ code: 200, message: "Something went wrong", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// update expert profile image
export const update_profileImage = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const update_profile_image = {
                    name: 'update_profile_image',
                    text: query.update_profile_image,
                    values: [_body.expertId, _body.profile_image]
                }
                const user_details = await client.query(update_profile_image);
                if (user_details.rows.length > 0) {
                    resolve({ code: 200, message: "Expert profile image updated successfully", data: user_details.rows[0] });
                }
                else {
                    resolve({ code: 200, message: "Something went wrong", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Add Physician to departement

export const physician_edit = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const expert_user_email_check = {
                    name: 'expert_user_email_check',
                    text: query.expert_user_email_check,
                    values: [_body.email, 1, _body.expertId, 'physician']
                }
                const expert_user_phone_ckeck = {
                    name: 'expert_user_phone_check',
                    text: query.expert_user_phone_check,
                    values: [_body.phone, 1, _body.expertId, 'physician']
                }
                // // Check email duplicate
                const user_email = await client.query(expert_user_email_check);
                // // Check phone duplicate
                const user_phone = await client.query(expert_user_phone_ckeck);
                if (user_email.rows.length > 0) {
                    reject({ code: 400, message: "Failed. Email Address already exists.", data: {} });
                } else if (user_phone.rows.length > 0) {
                    reject({ code: 400, message: "Failed. Phone Number already exists.", data: {} });
                } else {
                    const feeChange = await check_fee_change(_body.expertId, _body.email, _body.firstVisitPay, _body.followUpPay)
                    const clinicId = await get_clinic_details(_body.departmentId)
                    const expert_user_physician_edit = {
                        name: 'expert_user_physician_edit',
                        text: query.expert_user_physician_edit,
                        values: [_body.email, _body.firstName,
                        _body.lastName, _body.gender, _body.dob,
                        _body.phone, currentTime, clinicId, _body.departmentId, _body.profile_image, _body.expertId, 1]
                    }
                    const user_details = await client.query(expert_user_physician_edit);
                    if (user_details) {
                        const edit_expert_details = {
                            name: 'edit_expert_details',
                            text: query.edit_expert_details,
                            values: [_body.registraionNumber, _body.registraionCouncil, _body.registraionYear, _body.speciality, _body.medicalSchool, _body.experience, _body.qualification, _body.address1, _body.address2, _body.state, _body.pincode, _body.firstVisitPay, _body.followUpPay, _body.expert_document, _body.expertId, _body.consultationDuration]
                        }
                        const user_details_medical = await client.query(edit_expert_details)
                        if (user_details_medical && _body.services.length > 0) {
                            // delete existing service and add new services 
                            const userQuery = `DELETE FROM physician_service WHERE physician_dtl_id=${_body.expertId}`;
                            await client.query(userQuery);
                            _body.services.forEach(async (service) => {
                                const add_expert_services = {
                                    name: 'add_expert_services',
                                    text: query.add_expert_services,
                                    values: [service.id, _body.expertId, _body.userid]
                                }
                                await client.query(add_expert_services)
                            });

                            resolve({ code: 200, message: "Physician details updated successfully", data: { expertId: user_details_medical.rows[0].physician_id } });
                        }
                    }


                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//check fee change
export const check_fee_change = (expertId, email, firstVisitPay, followUpPay) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const query = `SELECT first_visit_pay,follow_up_pay from physician_details WHERE physician_id=${expertId}`;
                const fee_details = await client.query(query)
                if (fee_details) {
                    if (fee_details.rows[0].first_visit_pay != firstVisitPay || fee_details.rows[0].follow_up_pay != followUpPay) {
                        const mailData = { to: email, templateName: "mhm_registration", title: "Remuneration Change", description: "This mail is to inform you that your remuneration has been revised as follows; First visit fee : " + firstVisitPay + ". This is subject to deductions for taxes and other withholdings as required by law and the policies of the clinic." };
                        sendGridEmail(mailData);
                    }
                    resolve(fee_details.rows[0])
                } else {
                    resolve(null)

                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// List physician Available times
export const physician_available_time_list = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                //check physician exists
                const queryPhysician = `SELECT u.id from users u where u.id=${_body.physicianId} AND user_type='physician'`;
                const physician_details = await client.query(queryPhysician);
                if (physician_details.rowCount == 0) {
                    reject({ code: 400, message: "physician does not exist.", data: {} });
                } else {
                    let myList = []
                    let output = []
                    let promises = []
                    var condStr = _body.dateTimeStamp ? `AND ptm."startDay"='${_body.dateTimeStamp}'` : "";
                    const query = `SELECT ptm."physicianTimeManagementId", ptm."startDay",
                ptm."duration", ptm."startTimeStamp", ptm."endTimeStamp"  
                FROM physiciantimemanagement ptm 
                WHERE ptm."physicianId"=${_body.physicianId} 
                AND ptm.status= ${true} ${condStr}`;
                    const available_times = await client.query(query)
                    if (available_times.rowCount === 0) {
                        reject({ code: 400, message: "Physician available time not available.", data: {} });
                    } else if (available_times.rowCount > 0) {
                        available_times.rows.forEach(async item => {
                            //check if already a booking request done
                            promises.push(chkConsultationBooked(item.physicianTimeManagementId))

                            if (!myList.includes(item.physicianTimeManagementId)) {
                                let intermediate = {
                                    "startDay": item.startDay,
                                    "timestamp": []
                                }
                                available_times.rows.forEach(item2 => {
                                    //startDay and endDay compare if its on sameday
                                    var start1 = new Date(item.startDay * 1000);
                                    var start1Date = start1.toISOString().toString().split("T")[0]

                                    var start2 = new Date(item2.startDay * 1000);
                                    var start2Date = start2.toISOString().toString().split("T")[0]
                                    if (start1Date == start2Date) {
                                        intermediate['timestamp'].push({
                                            physicianTimeManagementId: item2.physicianTimeManagementId,
                                            "duration": item2.duration,
                                            startTimeStamp: item2.startTimeStamp,
                                            endTimeStamp: item2.endTimeStamp
                                        })
                                        myList.push(item2.physicianTimeManagementId)
                                    }
                                });
                                output.push(intermediate)
                            }
                        })
                        const results = await Promise.all(promises)
                        var merged = [].concat.apply([], results);
                        merged = merged.filter((value, index, array) => {
                            return array.indexOf(value) == index;
                        });
                        add_logs('Expert available time', `Userid ${_body.user.userid} has accessed physician_available_time_list API`, 11, _body.user.userid)
                        resolve({ code: 200, message: "Physician available times listed successfully", data: { availableTimeStamps: output, bookedTimeStamps: merged } });
                    } else {
                        reject({ code: 400, message: "Failed. Please try again.", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//delete physician
export const physician_delete = (_body) => {
    return new Promise((resolve, reject) => {
        var status = "('onGoing', 'reschduledByPatient', 'paymentCompleted')";
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const queryConsultation = `SELECT count("patientID") FROM "consultationRequest" where "physicianID"=${_body.expertId} AND "appointmentTimestamp" > ${currentTime} AND status IN ${status}`;
                const consultation_count = await client.query(queryConsultation);
                if (consultation_count.rows[0].count > 0) {
                    reject({ code: 400, message: "Failed, There are consultations scheduled/ Ongoing for this expert", data: {} });
                }
                else {
                    const expert_user_physician_delete = {
                        name: 'expert_user_physician_delete',
                        text: query.expert_user_physician_delete,
                        values: [_body.expertId, 0]
                    }
                    const user_details = await client.query(expert_user_physician_delete);
                    if (user_details) {
                        resolve({ code: 200, message: "Deleted expert successfully", data: user_details.rows[0] });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// get physician details by section

export const physician_details_by_section = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (_body.section == "professional_details") {
                    var physician_details_by_id = {
                        name: 'physician_professional_details_by_id',
                        text: query.physician_professional_details_by_id,
                        values: [_body.userId]
                    }
                }
                else if (_body.section == "address_details") {
                    var physician_details_by_id = {
                        name: 'physician_address_details_by_id',
                        text: query.physician_address_details_by_id,
                        values: [_body.userId]
                    }
                }
                else if (_body.section == "payment_details") {
                    var physician_details_by_id = {
                        name: 'physician_payment_details_by_id',
                        text: query.physician_payment_details_by_id,
                        values: [_body.userId]
                    }
                }
                const user_details = await client.query(physician_details_by_id);
                if (user_details.rows) {
                    if (_body.section == "professional_details") {
                        const userQuery = `SELECT "departmentName" from department WHERE "departmentId"=${user_details.rows[0].department_id}`;
                        const department_name = await client.query(userQuery);
                        const professionalDetails = {
                            profile_image: user_details.rows[0].profile_image,
                            firstName: user_details.rows[0].first_name,
                            lastName: user_details.rows[0].last_name,
                            dob: user_details.rows[0].dob,
                            gender: user_details.rows[0].gender,
                            registraionNumber: user_details.rows[0].registraion_number,
                            registraionCouncil: user_details.rows[0].registraion_council,
                            registraionYear: user_details.rows[0].registraion_year,
                            qualification: user_details.rows[0].qualification,
                            medicalSchool: user_details.rows[0].medical_school,
                            specialisation: user_details.rows[0].speciality,
                            speciality: department_name.rows[0].departmentName,
                            department_name: department_name.rows[0].departmentName,
                            experience: user_details.rows[0].experience,
                            email: user_details.rows[0].email,
                            phone: user_details.rows[0].phone,
                            bio: user_details.rows[0].bio,
                            sign: user_details.rows[0].sign,
                        }
                        resolve({ code: 200, message: "physician professional details listed successfully", data: professionalDetails });
                    }
                    else if (_body.section == "address_details") {
                        const addressDetails = {
                            address_line1: user_details.rows[0].address_line1,
                            address_line2: user_details.rows[0].address_line2,
                            state_name: user_details.rows[0].state_name,
                            pincode: user_details.rows[0].pincode,
                        }
                        resolve({ code: 200, message: "physician address details listed successfully", data: addressDetails });
                    }
                    else if (_body.section == "payment_details") {
                        const paymentDetails = {
                            firstVisitPay: user_details.rows[0].first_visit_pay,
                            followUpPay: user_details.rows[0].follow_up_pay,
                            mhm_service_fee_percent: user_details.rows[0].mhm_tax_percentage,
                            tax_percentage: user_details.rows[0].tax_percentage
                        }
                        resolve({ code: 200, message: "physician payment details listed successfully", data: paymentDetails });
                    }
                }
                else {
                    resolve({ code: 200, message: "Something went wrong", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//List all appointments fro physician with filter
export const appointments_list = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (_body.searchKey) {
                    var searchCond = "AND ((LOWER(u.first_name) LIKE LOWER('%" + _body.searchKey + "%')) OR (LOWER(u.last_name) LIKE LOWER('%" + _body.searchKey + "%')))"
                } else var searchCond = ""
                //check physician exists
                const queryPhysician = `SELECT u.id from users u where u.id=${_body.physicianId} AND user_type='physician'`;
                const physician_details = await client.query(queryPhysician);
                if (physician_details.rowCount == 0) {
                    reject({ code: 400, message: "physician does not exist.", data: {} });
                } else {
                    var currentTime1 = new Date();
                    var utcDate = Date.UTC(currentTime1.getUTCFullYear(), currentTime1.getUTCMonth(), currentTime1.getUTCDate(),
                        currentTime1.getUTCHours(), currentTime1.getUTCMinutes()) / 1000;
                    var tempDate = new Date(utcDate * 1000)
                    tempDate.setHours(0)
                    tempDate.setMinutes(0)
                    var originalDate = tempDate;
                    var ISTdate = new Date(originalDate).getTime() - (5.5 * 60 * 60 * 1000);
                    var appointmentDate = ISTdate / 1000;
                    const currentTime = Math.floor(Date.now() / 1000);
                    if (_body.appointmentFilter) {
                        var appointmentFilter = _body.appointmentFilter
                    } else if (_body.appointmentFromDate && _body.appointmentToDate) {
                        appointmentFilter = "DATE_RANGE";
                        var FromDateTS = new Date(_body.appointmentFromDate).getTime() / 1000
                        var ToDateTS = new Date(_body.appointmentToDate).getTime() / 1000

                    } else if (_body.appointmentFromDate) {
                        var customDate = _body.appointmentFromDate;
                        appointmentFilter = "DATE";
                    }
                    var orderStr = `ORDER BY cr."appointmentTimestamp" ASC`
                    switch (appointmentFilter) {
                        case "TODAY":
                            var condStr = `AND ptm."startDay"=${appointmentDate} AND cr.status NOT IN ('cancelByPatient', 'rejected', 'completed', 'pending')`;
                            break;
                        case "UPCOMING":
                            var condStr = `AND cr."appointmentTimestamp">  ${currentTime} AND ptm."startDay"!=${appointmentDate} AND cr.status NOT IN ('cancelByPatient', 'rejected', 'pending')`;
                            break;
                        case "CANCELLED":
                            var condStr = `AND cr.status IN ('cancelByPatient', 'rejected')`;
                            orderStr = `ORDER BY cr.updated_on DESC`
                            break;
                        case "PAST":
                            var condStr = `AND cr."appointmentTimestamp"< ${currentTime} AND cr.status NOT IN ('cancelByPatient', 'rejected', 'pending')`;
                            orderStr = `ORDER BY cr."appointmentTimestamp" DESC`
                            break;
                        case "DATE_RANGE":
                            var condStr = `AND cr."appointmentTimestamp" between ${FromDateTS} AND ${ToDateTS}`;
                            break;
                        case "DATE":
                            var condStr = `AND DATE(to_timestamp(ptm."startDay"))='${customDate}'`;
                            break;
                        default: var condStr = ``;
                            break;
                    }
                    var limit = _body.limit ? _body.limit : 10
                    var offset = _body.offset ? _body.offset : 0
                    let full_count;

                    const query = `SELECT cr."consultationRequestId" as appointmentId, cr."appointmentTimestamp",
                cr."consultationRequestId", cr.status, cr.disease,cr.consultation_type ,cr.consent_to_share_information,cr.service_type,              
                p.first_name || ' ' || p.last_name  as doctor_name, p.email as doctor_email, p.phone  as doctor_phone,
                ptm."startDay", ptm."duration", ptm."startTimeStamp", ptm."endTimeStamp",
                cr."patientID", u.first_name, u.last_name, u.gender,
                u.location, u.profile_image, u.dob, c.condition, count(*) OVER() AS full_count
                FROM "consultationRequest" cr
                LEFT JOIN physiciantimemanagement ptm ON ptm."physicianTimeManagementId" = cr."physicianTimeManagementId"
                LEFT JOIN users u ON u.id = cr."patientID"
                LEFT JOIN conditions c ON c.user_id = cr."patientID"
                left join users p on cr."physicianID"  = p.id
                WHERE cr."physicianID"=  ${_body.physicianId} ${condStr} ${searchCond}  AND c.is_primary=1
                ${orderStr}
                LIMIT ${limit} OFFSET ${offset} `;

                    var appointment_details = await client.query(query);
                    if (appointment_details) {
                        appointment_details.rows.forEach(item => {
                            item.location = (item.location) ? JSON.parse(item.location).region : "Not available"
                            full_count = item.full_count
                            delete item.full_count
                        })
                        resolve({ code: 200, message: "Appoiintments listed successfully", data: { count: full_count, appointments: appointment_details.rows } });
                    } else {
                        reject({ code: 400, message: "Failed. Please try again.", data: {} });
                    }
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const chkConsultationBooked = (physicianTimeManagementId) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                let booked = []
                const query = `SELECT "appointmentTimestamp", "physicianTimeManagementId", status 
                FROM "consultationRequest" WHERE "physicianTimeManagementId"=${physicianTimeManagementId} 
                AND (status='paymentCompleted' OR status='reschduledByPatient' OR status='onGoing')`;
                var isConsultationBooked = await client.query(query);
                if (isConsultationBooked.rowCount > 0) {
                    isConsultationBooked.rows.forEach(bookedItems => {
                        booked.push(bookedItems.appointmentTimestamp)
                    })
                }
                resolve(booked)
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}
