import query from '../query/query';
import { database, expertDb } from '../../config/dbConfig';
import * as dotenv from 'dotenv'
dotenv.config()
import * as jwt from 'jsonwebtoken';
import * as config from '../../config/security-config';
import * as crypto from 'crypto';
import * as password from 'secure-random-password';
import { send_sms } from '../../services/smsService';
import { sendGridEmail } from '../../services/sendGridEmail'
const saltRounds = process.env.SALT_ROUNDS;
import readHtml from '../../services/readHtml';
import * as handlebars from 'handlebars';
import { getUserLiveTokens } from './notificationModel';
import * as bcrypt from 'bcrypt';
import * as security_config from '../../config/security-config';
import { startUserActiveSession } from './UserModel';
import { add_logs } from './LogModel';

// hashing password

export const hashfunction = (password) => {
    return new Promise((resolve, reject) => {
        bcrypt.genSalt(Number(security_config.SALT_ROUNDS), (err, salt) => {
            if (err) {
                reject("Bcrypt genSalt Error")
            }
            else {
                bcrypt.hash(password, salt, (err, hash) => {
                    if (err) {
                        reject("Bcrypt hash Error")
                    }
                    else {
                        resolve({ salt: salt, hash: hash })
                    }
                });
            }
        });
    })
}

// expert admin signup

export const expert_admin_signup = (_body) => {
    const otp = Math.floor(100000 + Math.random() * 900000);
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const expert_user_chk_email_or_phone = {
                    name: 'expert_user_chk_email_or_phone',
                    text: query.expert_user_chk_email_or_phone,
                    values: [_body.email, _body.phone, 'expert_admin']
                }
                var user_status = await client.query(expert_user_chk_email_or_phone);
                if (user_status.rows.length == 0) {
                    let password_gen = password.randomPassword({ length: 20, characters: [password.lower, password.upper, password.digits] })
                    let random_password = hashfunction(password_gen).then(async (result: any) => {
                        const expert_user_register = {
                            name: 'expert_user_register',
                            text: query.expert_user_register,
                            values: [_body.email, _body.firstName, _body.lastName, _body.gender, _body.dob, _body.phone, 'expert_admin', currentTime, result.hash, 1, 'expert_admin', null, null, "profileimage.jpg"]
                        }
                        const user_details = await client.query(expert_user_register);
                        const mailData = { to: _body.email, templateName: "invite_admin", set_password_url: process.env.FORGOT_PASSWORD_URL + password_gen, title: "Welcome to the team!", description: "You are invited to take up the Super admin responsibility of MyHealingMate clinic management platform. ", button_label: "Set Password" }
                        sendGridEmail(mailData)
                        resolve({ code: 200, message: "User has been successfully registered", data: user_details.rows[0] });
                    })
                } else {
                    reject({ code: 400, message: "Failed. User already registered.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// expert user sign in

export let expertSignin = (body) => {
    return new Promise(async (resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const expert_sign_in = {
                    name: 'expert_sign_in',
                    text: query.expert_sign_in,
                    values: [body.email, body.userType, 1]
                }
                var user_status = await client.query(expert_sign_in);
                if(body.userType=='physician'){
                    const getDuration = `SELECT consultation_duration FROM physician_details WHERE physician_id=${user_status.rows[0].id}`;
                    var duration = await client.query(getDuration);
                }
                const token = jwt.sign({
                    userid: user_status.rows[0].id,
                    user_type: user_status.rows[0].user_type,
                    emailid: user_status.rows[0].email,
                    phone: user_status.rows[0].phone,
                }, config.JWT_SECRET, { expiresIn: `${process.env.EXPERT_TOKEN_EXPIRY_TIME}` });
                let userData = {
                    "userId": user_status.rows[0].id,
                    "userType": user_status.rows[0].user_type,
                    "emailId": user_status.rows[0].email,
                    "firstName": user_status.rows[0].first_name,
                    "lastName": user_status.rows[0].last_name,
                    "gender": user_status.rows[0].gender,
                    "clinicId": user_status.rows[0].clinic_id,
                    "profile_image": user_status.rows[0].profile_image,
                    "login_count":user_status.rows[0].login_count,
                    "consultationDuration":(user_status.rows[0].user_type=='physician')?duration.rows[0].consultation_duration:'na',
                    "token": token
                };
                if (user_status.rows.length > 0) {
                    bcrypt.compare(body.password, user_status.rows[0].password).then(async(compareResult: any) => {
                        if (!compareResult) {
                            reject({ code: 400, message: "Incorrect Password", data: {} });
                        }
                        else {
                            const passwordQuery = `UPDATE users SET login_count=${(user_status.rows[0].login_count)+1} WHERE id=${user_status.rows[0].id}`;
                            const password = await client.query(passwordQuery);
                            if (body.firebase_token) {
                                startUserActiveSession(user_status.rows[0].id, body.firebase_token, body.userType);
                            }
                            add_logs('Web Signin', `Userid ${user_status.rows[0].id} has signed in`, 11, user_status.rows[0].id)
                            resolve({ code: 200, message: "succesfully signed in", data: userData });
                        }
                    })
                }
                else {
                    reject({ code: 400, message: "User does not exist", data: {} });
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })

}

// expert forgot password

export let expertForgotPassword = (body) => {
    return new Promise(async (resolve, reject) => {
        (async () => {
            const client = await database().connect()
            const currentTime = Math.floor(Date.now() / 1000);
            try {
                const expert_user_check = {
                    name: 'expert_user_check',
                    text: query.expert_user_check,
                    values: [body.email, body.userType, 1]
                }
                var user_status = await client.query(expert_user_check);
                if (user_status.rows.length > 0) {
                    let password_gen = password.randomPassword({ length: 20, characters: [password.lower, password.upper, password.digits] })
                    let random_password = hashfunction(password_gen).then(async (result: any) => {
                        const expert_change_password = {
                            name: 'expert_change_password',
                            text: query.expert_change_password,
                            values: [body.email, body.userType, 1, result.hash, currentTime]
                        }
                        
                        const user_details = await client.query(expert_change_password);
                        if(body.userType=='manager'){
                            var mailData = { to: body.email, templateName: "invite_admin", set_password_url: process.env.EXPERT_ADMIN_SET_PASSWORD_URL + password_gen+'&id='+user_details.rows[0].id, title: "Password Reset!", description: "A request has been received to change the password for your account.", button_label: "Set Password" }
                        }
                        else if(body.userType=='physician'){
                            var mailData = { to: body.email, templateName: "invite_admin", set_password_url: process.env.EXPERT_PHYSICIAN_SET_PASSWORD_URL + password_gen+'&id='+user_details.rows[0].id, title: "Password Reset!", description: "A request has been received to change the password for your account.", button_label: "Set Password" }
                        }
                        sendGridEmail(mailData)
                        add_logs('Forgot Password', `Userid ${user_status.rows[0].id} has requested for password change`, 11, user_status.rows[0].id)
                        resolve({ code: 200, message: "Password reset mail sent", data: {} });
                    })
                }
                else {
                    reject({ code: 400, message: "User does not exist", data: {} });
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })

}

// expert change password

export let expertChangePassword = (body) => {
    return new Promise(async (resolve, reject) => {
        (async () => {
            const currentTime = Math.floor(Date.now() / 1000);
            const client = await database().connect()
            try {
                const passwordQuery = `SELECT password FROM users WHERE id=${body.userid}`
                const password = await client.query(passwordQuery);
                if (password.rows.length > 0) {
                    bcrypt.compare(body.currentPassword, password.rows[0].password).then((compareResult: any) => {
                        if (!compareResult) {
                            reject({ code: 400, message: "Failed, Current Password Incorrect", data: {} });
                        }
                        else {
                            if (body.newPassword != body.confirmPassword) {
                                resolve({ code: 200, message: "The new password and confirmation password do not match.", data: {} });
                            }
                            else if (body.currentPassword == body.newPassword) {
                                resolve({ code: 200, message: "It seems you have entered same password as old password!!!", data: {} });
                            }
                            else {
                                let hashed_password = hashfunction(body.newPassword).then(async (result: any) => {
                                    const expert_change_password_id = {
                                        name: 'expert_change_password_id',
                                        text: query.expert_change_password_id,
                                        values: [body.userid, 1, result.hash, currentTime]
                                    }
                                    const user_details = await client.query(expert_change_password_id);
                                    if (user_details.rows.length > 0) {
                                        add_logs('Change Password', `Userid ${body.userid} has requested for password change`, 11, body.userid)
                                        resolve({ code: 200, message: "Password changed succesfully", data: {} });
                                    }
                                    else {
                                        reject({ code: 400, message: "No such user", data: {} });
                                    }
                                })
                            }
                        }
                    })
                }
                else {
                    reject({ code: 400, message: "User does not exist", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })

}