import query from '../query/query';
import { database, pool } from '../../config/dbConfig';
import * as dotenv from 'dotenv'
dotenv.config()
import { chk_connection_status } from './ConnectionModel'
import { getUserFromPostId } from './UserModel';
import { getUserLiveTokens, getUserLiveTokensByType, getUsersHelingmateLiveTokens } from './notificationModel';
import { list_comment } from './LikeAndCommentModel';
import { add_logs } from './LogModel';
const request = require('request')
//Add post

export const add_post = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            add_logs('Create Post', `Create post initiated by ${_body.userid} `, 11, _body.userid)
            try {
                const add_post = {
                    name: 'add_post',
                    text: query.add_post,
                    values: [_body.userid, _body.community_id,
                    _body.content, _body.feeling, _body.image,
                    _body.featured, _body.type, currentTime, true, _body.content_privacy ? _body.content_privacy : "Public"]
                }
                var post_details = await client.query(add_post);
                add_logs('Create Post', `post created with id : ${post_details.rows[0].id}`, 11, _body.userid)
                if (post_details) {
                        const notificationTitle = "Post has been successfully added";
                        const type = "post_success";
                        const data = { post_id: post_details.rows[0].id.toString() };
                        getUserLiveTokens(_body.userid, notificationTitle, _body.userid, type, data);

                    /* Send notification to healing mates if post successfull - Start  */
                    const type_notification = 'notify_post_helingmate';
                    const helingmateNotificationTitle = "New Post has been Published";
                    getUsersHelingmateLiveTokens(_body.userid, helingmateNotificationTitle, type_notification, data);

                    /* Send notification to healing mates if post successfull - End   */

                    add_logs('Create Post', `${_body.userid} created post succesfully`, 11, _body.userid)
                    resolve({ code: 200, message: "Post has been successfully added", data: post_details.rows[0] })
                } else {
                    add_logs('Create Post', `Create post by ${_body.userid} has Failed`, 11, _body.userid)
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }

            } catch (e) {
                console.log(e);
                add_logs('Create Post', `Create post by ${_body.userid} has Failed due to ${e}`, 11, _body.userid)
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Edit Post
export const post_edit = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                // let promises = [];
                // promises.push(
                //     moderateContent(_body.content).then(result => {
                //         return result;
                //     })
                // )
                // const results = await Promise.all(promises)
                const update_post = {
                    name: 'update_post',
                    text: query.update_post,
                    values: [_body.post_id, _body.userid, _body.community_id,
                    _body.content, _body.feeling, _body.image,
                    _body.featured, _body.type, currentTime, _body.content_privacy ? _body.content_privacy : "Public"]
                }
                var post_details = await client.query(update_post);
                if (post_details) {
                    // const termCount = results[0].Terms !== null && results[0].Terms ? results[0].Terms.length : 0
                    // if (results[0].reviewRecommended && termCount > 0) {
                    //     const notificationTitle = "Abusive contents found, your post will be reviewed by admin";
                    //     const notificationTitleAdmin = "Abusive contents found for a post";
                    //     const type = "abusive_content_alert_to_user";
                    //     const typeAdmin = "abusive_content_alert_to_admin";
                    //     const data = { post_id: post_details.rows[0].id.toString() };
                    //     const dataAdmin = {
                    //         "feed_id": post_details.rows[0].id.toString(),
                    //         "share_count": "0",
                    //         "content": results[0].AutoCorrectedText,
                    //         "feeling": "",
                    //         "media": _body.image.toString(),
                    //         "created_date": currentTime.toString(),
                    //         "pseudo_name": "",
                    //         "profile_image": "",
                    //         "isUsersPost": "false",
                    //         "current_user_image": "",
                    //         "comments": "",
                    //         "commentCount": "0",
                    //         "reactCount": "0",
                    //         "isReacted": "false",
                    //         "reactionType": "",
                    //         "click_action": `${process.env.COMMUNITY_ADMIN_APP}/allposts?checkpost=${post_details.rows[0].id.toString()}`
                    //     }
                    //     getUserLiveTokens(_body.userid, notificationTitle, _body.userid, type, data);
                    //     getUserLiveTokensByType('admin', notificationTitleAdmin, _body.userid, typeAdmin, dataAdmin);
                    // }
                    // else {
                        const notificationTitle = "Post has been successfully added";
                        const type = "post_success";
                        const data = { post_id: post_details.rows[0].id.toString() };
                        getUserLiveTokens(_body.userid, notificationTitle, _body.userid, type, data);
                    // }
                    resolve({ code: 200, message: "Post has been successfully updated", data: post_details.rows[0] })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Delete Post
export const post_delete = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const delete_post = {
                    name: 'delete_post',
                    text: query.delete_post,
                    values: [0, _body.post_id]
                }
                const post_details = await client.query(delete_post);
                if (post_details.rowCount > 0) {
                    resolve({ code: 200, message: "Post has been successfully deleted", data: {} });
                } else {
                    reject({ code: 400, message: "Failed. No post found.", data: {} })
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


//List posts
export const post_list = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            //const client = await database().connect();
            try {
                let promises = []
                let promises2 = []
                let promises3 = []
                let promises4 = []
                //get first 5 feeds first
                if (_body.user_id) {
                    var feed_list = {
                        name: 'list_post',
                        text: query.feed_list_user,
                        values: [_body.limit, _body.offset, true, _body.user_id]
                    }
                } else {
                    var feed_list = {
                        name: 'list_post',
                        text: query.feed_list,
                        values: [_body.limit, _body.offset, true]
                    }
                }

                var feed_details = await pool.query(feed_list);
                feed_details.rows.forEach(async (item, index) => {
                    promises.push(
                        findFeedDetails(item.id, pool).then(res => {
                            return res;
                        })
                    )
                    promises2.push(
                        findCommentDetails(item.id, pool).then(res => {
                            return res;
                        })
                    )
                    promises3.push(
                        findReactionDetails(item.id, _body.userid, pool).then(res => {
                            return res;
                        })
                    )
                })
                if (_body.userid) {
                    promises4.push(
                        findUserDetails(_body.userid, pool).then(res => {
                            return res;
                        })
                    )
                    var results4 = await Promise.all(promises4);
                }

                const results = await Promise.all(promises);
                const results2 = await Promise.all(promises2);
                const results3 = await Promise.all(promises3);
                results2.forEach((item, index) => {
                    results[index].isUsersPost = (results[index].user_id === _body.userid) ? true : false;
                    results[index].current_user_image = results4 ? results4[0] : ""
                    //results[index].commentCount = item.length
                    if (item && item.length > 0) {
                        results[index].commentCount = parseInt(item[0].totalcount)
                    } else results[index].commentCount = 0
                    item.forEach(element => {
                        delete (element.totalcount)
                    });
                    results[index].comments = item
                    results[index].reactCount = Object.keys(results3[index]).length === 0 ? "0" : results3[index].count;
                    results[index].isReacted = Object.keys(results3[index]).length === 0 ? false : results3[index].isReacted
                    results[index].reactionType = Object.keys(results3[index]).length === 0 ? "" : results3[index].reactionType
                    delete (results[index].user_id)
                })
                resolve({ code: 200, message: "Posts has been successfully fetched", data: { azureUrl: process.env.BLOB_STORAGE_PUBLIC_URL, results } });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const findFeedDetails = (id, client) => {
    return new Promise((resolve, reject) => {
        (async () => {
            try {
                //find feed details 
                const feed_list2 = {
                    name: 'feed_list2',
                    text: query.feed_list2,
                    values: [id]
                }
                var feed_details2 = await client.query(feed_list2);
                resolve(feed_details2.rows[0])
            } catch (e) {
                console.log(e)
            } finally {
            }
        })()
    })
}

export const findCommentDetails = (id, client) => {
    return new Promise((resolve, reject) => {
        (async () => {
            try {
                const comment_list = {
                    name: 'comment_list',
                    text: query.comment_list,
                    values: [id]
                }
                var comment_details = await client.query(comment_list);
                resolve(comment_details.rows)
            } catch (e) {
                console.log(e)
            } finally {
            }
        })()
    })
}


export const findReactionDetails = (id, userid, client) => {
    return new Promise((resolve, reject) => {
        (async () => {
            try {
                let reactDetails = {}
                const react_list = {
                    name: 'react_list',
                    text: query.react_list,
                    values: [id, true]
                }
                var react_details = await client.query(react_list);
                react_details.rows.forEach(item => {
                    reactDetails = {
                        count: item.react_count,
                        isReacted: (item.user_id == userid) ? true : false,
                        reactionType: (item.user_id == userid) ? item.reaction_type : "",
                    }
                });
                resolve(reactDetails)
            } catch (e) {
                console.log(e)
            } finally {

            }
        })()
    })
}

export const findUserDetails = (userid, client) => {
    return new Promise((resolve, reject) => {
        (async () => {

            try {
                const user_details = {
                    name: 'user_details',
                    text: query.get_user_profile,
                    values: [userid]
                }
                var user_details_result = await client.query(user_details);
                resolve(user_details_result.rows[0].profile_image)
            } catch (e) {
                console.log(e)
            } finally {
            }
        })()
    })
}

//Add reaction
export const reaction_add = (_body) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                checkUserAlreadyReacted(_body.userid, _body.feed_id).then(async res => {
                    if (res > 0) {
                        const update_reaction = {
                            name: 'update_reaction',
                            text: query.update_reaction,
                            values: [_body.reaction_type, _body.reaction_status,
                            _body.feed_id, _body.userid, currentTime]
                        }
                        var react_details = await client.query(update_reaction);
                        if (react_details) {
                            resolve({ code: 200, message: "Reaction has been successfully updated", data: react_details.rows[0] })
                        } else {
                            reject({ code: 400, message: "Failed. Please try again.", data: {} });
                        }
                    } else {
                        const add_reaction = {
                            name: 'add_reaction',
                            text: query.add_reaction,
                            values: [_body.reaction_type, true,
                            _body.content_id, _body.content_type,
                            _body.feed_id, _body.userid, currentTime]
                        }
                        var react_details = await client.query(add_reaction);
                        if (react_details) {
                            if (_body.pseudo_name) {
                                const notificationTitle = _body.pseudo_name + " reacted to your post";
                                const type = "reaction";
                                const data = { post_id: _body.feed_id }
                                getUserFromPostId(_body.feed_id, notificationTitle, _body.userid, type, data)
                            }
                            resolve({ code: 200, message: "Reaction has been successfully added", data: react_details.rows[0] })
                        } else {
                            reject({ code: 400, message: "Failed. Please try again.", data: {} });
                        }
                    }
                })
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })

}

export const checkUserAlreadyReacted = (userid, content_id) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const chk_reaction = {
                    name: 'comment_list',
                    text: query.chk_reaction,
                    values: [content_id, userid]
                }
                var reaction_count = await client.query(chk_reaction);
                resolve(reaction_count.rows[0].count)
            } catch (e) {
                console.log(e)
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const post_share = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                const post_share = {
                    name: 'post_share',
                    text: query.post_share,
                    values: [_body.feed_id]
                }
                var post_details = await client.query(post_share);
                if (post_details) {
                    if (_body.pseudo_name) {
                        const notificationTitle = _body.pseudo_name + " shared your post";
                        const type = "share";
                        const data = { post_id: _body.feed_id.toString() }
                        getUserFromPostId(_body.feed_id, notificationTitle, _body.userid, type, data)
                    }
                    resolve({ code: 200, message: "Post has been successfully shared", data: {} })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const all_reactions = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            var totalCounts = {}
            let finalArray = []
            let support = []
            let help = []
            let applause = []
            const client = await database().connect();
            try {
                const get_reactions = {
                    name: 'get_reactions',
                    text: query.get_reactions,
                    values: [_body.feed_id]
                }
                var react_details = await client.query(get_reactions);
                react_details.rows.forEach((item) => {
                    if (item.reaction_type == 'applause') {
                        applause.push(item)
                    } else if (item.reaction_type == 'support') {
                        support.push(item)
                    } else if (item.reaction_type == 'help') {
                        help.push(item)
                    }
                    totalCounts = {
                        support_count: item.support_count,
                        help_count: item.help_count,
                        applause_count: item.applause_count,
                    }
                    delete (item.support_count)
                    delete (item.help_count)
                    delete (item.applause_count)
                })
                finalArray.push({
                    userDetails: react_details.rows,
                    support: support,
                    help: help,
                    applause: applause,
                    totalCounts
                });
                if (react_details) {
                    resolve({ code: 200, message: "Reaction has been successfully fetched", data: finalArray })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const search_global = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            let postDetails = []
            let members = []
            let communities = []
            let experts = []
            const client = await database().connect();
            try {
                let search_string = _body.search_string.trim();
                search_string = `'%${search_string}%'`;
                let cond_search_string = toTitleCase(_body.search_string.trim())
                cond_search_string = `'%${cond_search_string}%'`;
                const query = `SELECT f.id as feed_id, f.content, f.type, f.community_id, f.feeling, f.image, f.share_count,f.created_date, f.content_privacy,f.user_id as owner_id,
                u.id as user_id, u.user_type, u.first_name, u.last_name,u.pseudo_name, u.profile_image, u.nationality, u.location, (SELECT count(*) FROM comments c WHERE c.parent_id=f.id) AS comment_count, (SELECT count(*) FROM reactions r WHERE r.feed_id=f.id AND content_type='article') AS reaction_count,
                pd.experience, pd.qualification, pd.first_visit_pay as fees, 
                pd.speciality, c."clinic_id", c."clinicName", c.address,
                (SELECT SUM(status) as status from(SELECT status FROM connections WHERE user_id1=u.id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=u.id) as connected),
                (SELECT u.pseudo_name FROM users u WHERE u.id = f.user_id AND u.id=${_body.userid}) as is_users_post,
                (SELECT reaction_type FROM reactions r WHERE r.feed_id=f.id AND r.reaction_status=true AND r.user_id=${_body.userid} AND content_type='article') AS reaction_type from feeds f 
                LEFT JOIN users u ON f.user_id = u.id
                LEFT JOIN department d ON d."departmentId" = u.department_id
                LEFT JOIN physician_details pd ON u.id=pd.physician_id
                LEFT JOIN clinic c ON u.clinic_id=c."clinic_id" WHERE (LOWER(f.content) LIKE LOWER(${search_string})
                OR LOWER(u.pseudo_name) LIKE LOWER(${search_string})
                OR LOWER(pd.speciality) LIKE LOWER(${search_string}))
                AND feed_status=true AND f.approve_status=true ORDER BY f.created_date DESC LIMIT 15`;
                var search_details = await client.query(query);
                const myHealingMates = await get_myhealingmates(_body.userid)
                var healingmates=[_body.userid];
                var membersArray=healingmates.concat(myHealingMates)
                const post_details_search: any = search_details.rows.filter((element) => {
                    return((element.content_privacy != "My Healing Mates")||(element.content_privacy == "My Healing Mates"&&membersArray.includes(element.owner_id)))         
                })
                post_details_search.forEach((item, index) => {
                    postDetails.push({
                        feed_id: item.feed_id,
                        content: item.content,
                        image: item.image,
                        created_date: item.created_date,
                        username: item.first_name + " " + item.last_name,
                        pseudo_name: item.pseudo_name,
                        profile_image: item.profile_image,
                        share_count: item.share_count,
                        comment_count: item.comment_count,
                        reaction_count: item.reaction_count,
                        isUsersPost: item.is_users_post && item.is_users_post != null ? true : false,
                        isReacted: item.reaction_type && item.reaction_type != null ? true : false,
                        reactionType: item.reaction_type && item.reaction_type != null ? item.reaction_type : ""
                    })
                    
                    if (item.user_type == "physician") {
                        experts.push({
                            id: item.user_id,
                            first_name: item.first_name,
                            last_name: item.last_name,
                            pseudo_name: item.pseudo_name,
                            profile_image: item.profile_image,
                            location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                            connected: item.status ? parseInt(item.status) : 0,
                            physicianId: item.id,
                            medicalSchool: item.medical_school,
                            qualification: item.qualification,
                            speciality: item.speciality,
                            experience: item.experience,
                            fees: item.fees,
                            departmentId: item.departmentId,
                            departmentName: item.departmentName,
                            clinicId: item.clinic_id,
                            clinicName: item.clinicName
                        })
                    }else{
                        members.push({
                            id: item.user_id,
                            first_name: item.first_name,
                            last_name: item.last_name,
                            pseudo_name: item.pseudo_name,
                            profile_image: item.profile_image,
                            location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                            connected: item.status ? parseInt(item.status) : 0
                        })
                    }
                    
                })
                //independant users search
                const queryU = `SELECT u.id, u.pseudo_name, u.user_type, u.first_name, u.last_name, u.profile_image, u.location,
                pd.experience, pd.qualification, pd.first_visit_pay as fees, 
                pd.speciality, c."clinic_id", c."clinicName",c.address,
                (SELECT SUM(status) as connected from(SELECT status FROM connections WHERE user_id1=u.id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=u.id) as connected)
                FROM users u 
                LEFT JOIN department d ON d."departmentId" = u.department_id 
                LEFT JOIN physician_details pd ON u.id=pd.physician_id
                LEFT JOIN clinic c ON u.clinic_id=c."clinic_id"
                 WHERE (LOWER(u.pseudo_name) LIKE LOWER(${search_string}) OR LOWER(pd.speciality) LIKE LOWER(${search_string})) 
                 AND u.id != ${_body.userid} AND u.pseudo_name !='admin'`;
                var user_search_details = await client.query(queryU);
                if (user_search_details && user_search_details.rows.length > 0) {
                    user_search_details.rows.forEach((item, index) => {
                        if (item.user_type == "physician") {
                            experts.push({
                                id: item.user_id,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                pseudo_name: item.pseudo_name,
                                profile_image: item.profile_image,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                connected: item.status ? parseInt(item.status) : 0,
                                physicianId: item.id,
                                medicalSchool: item.medical_school,
                                qualification: item.qualification,
                                speciality: item.speciality,
                                experience: item.experience,
                                fees: item.fees,
                                departmentId: item.departmentId,
                                departmentName: item.departmentName,
                                clinicId: item.clinic_id,
                                clinicName: item.clinicName
                            })
                        }else{
                            members.push({
                                id: item.id,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                pseudo_name: item.pseudo_name,
                                profile_image: item.profile_image,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                connected: item.connected ? parseInt(item.connected) : 0
                            })
                        }
                    })
                }

                //conditions search
                const queryCondition = `SELECT u.id, u.pseudo_name, u.user_type, u.first_name, u.last_name, u.profile_image, u.location,
                pd.experience, pd.qualification, pd.first_visit_pay as fees, 
                pd.speciality, c."clinic_id", c."clinicName",c.address,
                (SELECT SUM(status) as connected from(SELECT status FROM connections WHERE user_id1=u.id AND user_id2=${_body.userid} UNION ALL SELECT status FROM connections WHERE user_id1=${_body.userid} AND user_id2=u.id) as connected),
                con.condition, con.user_id
                FROM conditions con 
                LEFT JOIN users u ON u.id=con.user_id
                LEFT JOIN department d ON d."departmentId" = u.department_id 
                LEFT JOIN physician_details pd ON u.id=pd.physician_id
                LEFT JOIN clinic c ON u.clinic_id=c."clinic_id"
                WHERE LOWER(con.condition) LIKE LOWER(${cond_search_string})
                 AND u.id != ${_body.userid} AND u.pseudo_name !='admin'`;
                var user_search_details = await client.query(queryCondition);
                if (user_search_details && user_search_details.rows.length > 0) {
                    user_search_details.rows.forEach((item, index) => {
                        if (item.user_type == "physician") {
                            experts.push({
                                id: item.user_id,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                pseudo_name: item.pseudo_name,
                                profile_image: item.profile_image,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                connected: item.status ? parseInt(item.status) : 0,
                                physicianId: item.id,
                                medicalSchool: item.medical_school,
                                qualification: item.qualification,
                                speciality: item.speciality,
                                experience: item.experience,
                                fees: item.fees,
                                departmentId: item.departmentId,
                                departmentName: item.departmentName,
                                clinicId: item.clinic_id,
                                clinicName: item.clinicName,
                                condition: item.condition,
                            })
                        }else{
                            members.push({
                                id: item.id,
                                first_name: item.first_name,
                                last_name: item.last_name,
                                pseudo_name: item.pseudo_name,
                                profile_image: item.profile_image,
                                location: (item.location == "" || item.location == "{}" || item.location == null) ? item.location : JSON.parse(item.location).city,
                                connected: item.connected ? parseInt(item.connected) : 0,
                                condition: item.condition
                            })
                        }
                    })
                }


                //remove duplicates
                let ids = members.map(o => o.id)
                var uniqueMembers = members.filter(({ id }, index) => !ids.includes(id, index + 1))
                //remove current user from membersList
                uniqueMembers = uniqueMembers.filter(item => item.id != _body.userid)
                //remove community duplicates
                let com_ids = communities.map(o => o.id)
                let uniqueCommunities = communities.filter(({ id }, index) => !com_ids.includes(id, index + 1))
                let finalArray = {
                    posts: postDetails,
                    members: uniqueMembers,
                    communities: uniqueCommunities,
                    experts: experts
                }
                if (search_details) {
                    resolve({ code: 200, message: "Search has been successfully completed", data: finalArray })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

function moderateContent(content) {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                //review content using content moderator
                var options = {
                    url: process.env.CONTENT_MODERATOR_ENDPOINT,
                    method: 'POST',
                    headers: {
                        'Content-Type': 'text/plain',
                        'Ocp-Apim-Subscription-Key': process.env.OCP_APIM_SUBSCRIPTION_KEY,
                    },
                    body: content
                }
                request(options, (err, response, body) => {
                    if (err) {
                        console.log(err);
                        add_logs('Create Post', `Azure content moderation failed due to ${err}`, 11, '')
                        reject(err)
                    } else {
                        const result = JSON.parse(body)
                        console.log("azure response: ",result)
                         add_logs('Create Post', `Azure content moderation response 1: ${result["OriginalText"]}`, 11, '')
                        if (result["Classification"]) {
                            resolve({
                                reviewRecommended: result["Classification"]["ReviewRecommended"],
                                AutoCorrectedText: result["AutoCorrectedText"],
                                OriginalText: result["OriginalText"],
                                Terms: result["Terms"]
                            })
                        } else {
                            resolve({
                                reviewRecommended: false,
                                AutoCorrectedText: content,
                                OriginalText: content
                            })
                        }

                    }
                })
            } catch (e) {
                add_logs('Create Post', `Create post Failed due to content moderation error. Post content :${content}`, 11, '')
                console.log(e)
            } finally {
                client.release()
            }
        })()
    })
}

//New code refactored feeds API
export const feeds = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                //for my post check user_id in request
                if (_body.user_id) {
                    var userQuery = `AND f.user_id=${_body.user_id}`
                }
                const query = `SELECT f.id as feed_id,f.share_count, f.content, f.feeling, f.image as media,f.created_date,f.content_privacy,f.user_id as owner_id,
                --post details
                (SELECT COUNT(*) FROM reactions r WHERE r.feed_id=f.id AND r.reaction_status=true AND r.content_type='article') AS reactCount,
                (SELECT COUNT(*) FROM comments c WHERE c.parent_id=f.id AND c.status='1' AND c.publish_status=true AND type='feeds') AS commentCount,
                (SELECT u.pseudo_name FROM users u WHERE f.user_id=u.id) as pseudo_name,
                (SELECT u.profile_image FROM users u WHERE f.user_id=u.id) as profile_image,
                --comment details
                (SELECT comment FROM comments c WHERE c.parent_id=f.id AND c.publish_status=true AND c.status='1' ORDER BY c.created_date DESC LIMIT 1),
                u2.pseudo_name as commented_by, u2.profile_image as commented_profile_image,
                (SELECT c.created_date FROM comments c WHERE c.parent_id=f.id AND c.status='1' AND c.publish_status=true ORDER BY c.created_date DESC LIMIT 1) as comment_created_date,
                --current user detaills
                (SELECT u.profile_image FROM users u WHERE u.id=${_body.userid}) as current_user_image,
                (SELECT u.pseudo_name FROM users u WHERE u.id = f.user_id AND u.id=${_body.userid}) as is_users_post,
                (SELECT reaction_type FROM reactions r WHERE r.feed_id=f.id AND r.reaction_status=true AND r.user_id=${_body.userid} AND content_type='article' LIMIT 1) AS reaction_type
                FROM feeds f 
                LEFT JOIN users u2 ON u2.id = (
                    SELECT user_id FROM comments c WHERE c.parent_id=f.id AND c.status='1' AND c.publish_status=true ORDER BY c.created_date DESC LIMIT 1
                )
                WHERE f.feed_status=true AND f.approve_status=true ${userQuery ? userQuery : ""}
                GROUP BY f.id,u2.pseudo_name,u2.profile_image
                ORDER BY f.created_date DESC
                LIMIT ${_body.limit ? _body.limit : 5} OFFSET ${_body.offset ? _body.offset : 0}`;
                var feed_details = await client.query(query);
                feed_details.rows.forEach((item, index) => {
                    if (item.comment) {
                        feed_details.rows[index].comments = [{
                            "comment": item.comment,
                            "created_date": item.comment_created_date,
                            "pseudo_name": item.commented_by,
                            "profile_image": item.commented_profile_image
                        }]
                    } else {
                        feed_details.rows[index].comments = []
                    }
                    feed_details.rows[index].reactCount = item.reactcount;
                    feed_details.rows[index].commentCount = parseInt(item.commentcount);
                    feed_details.rows[index].isUsersPost = item.is_users_post && item.is_users_post != null ? true : false;
                    /* feed_details.rows[index].isReacted = false;
                    feed_details.rows[index].reactionType = ""; */
                    feed_details.rows[index].isReacted = item.reaction_type ? true : false;
                    feed_details.rows[index].reactionType = item.reaction_type ? item.reaction_type : "";
                    delete item.reactcount;
                    delete item.commentcount;
                    delete item.comment;
                    delete item.comment_created_date;
                    delete item.commented_by;
                    delete item.commented_profile_image;
                    delete item.is_users_post;
                    delete item.reaction_type;
                })
                const myHealingMates = await get_myhealingmates(_body.userid)
                var healingmates=[_body.userid];
                var membersArray=healingmates.concat(myHealingMates)
                console.log("membersArray",membersArray)
                const newArray=feed_details.rows.filter((element) => {
                    return((element.content_privacy != "My Healing Mates")||(element.content_privacy == "My Healing Mates"&&membersArray.includes(element.owner_id)))         
                })
                if (feed_details) {
                    resolve({ code: 200, message: "Posts has been successfully fetched", data: { azureUrl: process.env.BLOB_STORAGE_PUBLIC_URL, results: newArray } })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//Post details dedicated API
export const details_post = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                let promises = []
                const query = `SELECT f.id as feed_id,f.share_count, f.content, f.feeling, f.image as media,f.created_date,
                --post details
                (SELECT COUNT(*) FROM reactions r WHERE r.feed_id=f.id AND r.reaction_status=true AND r.content_type='article') AS reactCount,
                (SELECT COUNT(*) FROM comments c WHERE c.parent_id=f.id AND c.status='1' AND c.publish_status=true) AS commentCount,
                (SELECT u.pseudo_name FROM users u WHERE f.user_id=u.id) as pseudo_name,
                (SELECT u.profile_image FROM users u WHERE f.user_id=u.id) as profile_image,
                --current user detaills
                (SELECT u.profile_image FROM users u WHERE u.id=${_body.userid}) as current_user_image,
                (SELECT u.pseudo_name FROM users u WHERE u.id = f.user_id AND u.id=${_body.userid}) as is_users_post,
                (SELECT reaction_type FROM reactions r WHERE r.feed_id=f.id AND r.reaction_status=true AND r.user_id=${_body.userid} AND content_type='article') AS reaction_type
                FROM feeds f 
                LEFT JOIN users u2 ON u2.id = (
                    SELECT user_id FROM comments c WHERE c.parent_id=f.id AND c.status='1' AND c.publish_status=true ORDER BY c.created_date DESC LIMIT 1
                )
                WHERE f.feed_status=true AND f.approve_status=true AND f.id=${_body.feed_id}
                GROUP BY f.id,u2.pseudo_name,u2.profile_image`;
                var feed_details = await client.query(query);
                feed_details.rows.forEach((item, index) => {
                    var params = {
                        type : "feeds",
                        limit : 5,
                        offset : 0,
                        user_id : _body.userid,
                        parent_id : item.feed_id,
                    }
                    promises.push(list_comment(params))
                    feed_details.rows[index].reactCount = item.reactcount;
                    feed_details.rows[index].commentCount = parseInt(item.commentcount);
                    feed_details.rows[index].isUsersPost = item.is_users_post && item.is_users_post != null ? true : false;
                    feed_details.rows[index].isReacted = item.reaction_type ? true : false;
                    feed_details.rows[index].reactionType = item.reaction_type ? item.reaction_type : "";
                    delete item.reactcount;
                    delete item.commentcount;
                    delete item.comment;
                    delete item.comment_created_date;
                    delete item.commented_by;
                    delete item.commented_profile_image;
                    delete item.is_users_post;
                    delete item.reaction_type;
                })

                const resultComments = await Promise.all(promises)
                if(resultComments.length > 0){
                    feed_details.rows[0]["comments"] = resultComments[0].data
                }
                
                if (feed_details) {
                    resolve({ code: 200, message: "Post has been successfully fetched", data: { azureUrl: process.env.BLOB_STORAGE_PUBLIC_URL, results: feed_details.rows } })
                } else {
                    reject({ code: 400, message: "Failed. Please try again.", data: {} });
                }
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

export const moderate_post_content=(_body)=> {
    return new Promise((resolve, reject) => {
         const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect();
            try {
                //review content using content moderator
                const query=`SELECT  content,image from feeds WHERE id=${_body.post_id}`
                var feed_details = await client.query(query);
                if(feed_details&&feed_details.rows[0].content!=""){
                    const content=feed_details.rows[0].content;
                    const image=feed_details.rows[0].image;
                    var options = {
                    url: process.env.CONTENT_MODERATOR_ENDPOINT,
                    method: 'POST',
                    headers: {
                        'Content-Type': 'text/plain',
                        'Ocp-Apim-Subscription-Key': process.env.OCP_APIM_SUBSCRIPTION_KEY,
                    },
                    body: content
                }
                  request(options, (err, response, body) => {
                    if (err) {
                        reject({ code: 400, message: "Failed. Content moderation failed", data: {} })
                    } else {
                        const result = JSON.parse(body)
                        console.log("azure response: ",result)
                    if(result["Classification"] && result["Classification"]["ReviewRecommended"]){
                        const notificationTitle = "Thank you for your posting on MyHealingMate. Your post will be reviewed and content not in line with MyHealingMate community guidelines will be removed.";
                        const notificationTitleAdmin = "Abusive contents found for a post";
                        const type = "abusive_content_alert_to_user";
                        const typeAdmin = "abusive_content_alert_to_admin";
                        const data = { post_id: _body.post_id.toString() };
                        const dataAdmin = {
                            "feed_id": _body.post_id.toString(),
                            "share_count": "0",
                            "content": content.toString(),
                            "feeling": "",
                            "media": image.toString(),
                            "created_date": currentTime.toString(),
                            "pseudo_name": "",
                            "profile_image": "",
                            "isUsersPost": "false",
                            "current_user_image": "",
                            "comments": "",
                            "commentCount": "0",
                            "reactCount": "0",
                            "isReacted": "false",
                            "reactionType": "",
                            "click_action": `${process.env.COMMUNITY_ADMIN_APP}/allposts?checkpost=${_body.post_id}`
                        }
                         console.log("dataAdmin: ",dataAdmin)
                         console.log("data: ",data)
                        getUserLiveTokens(_body.userid, notificationTitle, _body.userid, type, data);
                        getUserLiveTokensByType('admin', notificationTitleAdmin, _body.userid, typeAdmin, dataAdmin);
                        resolve({ code: 200, message: "Abusive contents found in post", data: {feed_id:_body.post_id}})
                    }
                     resolve({ code: 200, message: "Abusive contents not found in post", data: {feed_id:_body.post_id}})
                    }
                })
                }
               resolve({ code: 200, message: "Abusive contents not found in post", data: {feed_id:_body.post_id}})
              
            } catch (e) {
                console.log(e)
            } finally {
                client.release()
            }
        })()
    })
}

//check fee change
export const get_myhealingmates = (userid) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect();
            try {
                var connectedMembers=[]
                const query = `SELECT c.user_id1, c.user_id2 FROM connections c
    LEFT JOIN users u ON c.user_id2 = u.id OR (u.id=c.user_id1 AND c.status=1)
    WHERE c.status=1  AND (c.user_id1=${userid} OR c.user_id2=${userid}) AND u.id!=${userid}`;
                const connect_details = await client.query(query)
                if(connect_details.rowCount>0){
 connect_details.rows.forEach(element => {
                    if (element.user_id1 == userid) {
                        element.friend_id = element.user_id2
                    } else {element.friend_id = element.user_id1}
                    connectedMembers.push(element.friend_id)
                })
                }
                resolve(connectedMembers)
            } catch (e) {
                console.log(e);
                reject(connectedMembers);
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

//transform first letter to uppercase
const toTitleCase = str => str.replace(/(^\w|\s\w)/g, m => m.toUpperCase());
