import query from '../query/query';
import { database } from '../../config/dbConfig';


// Add Logs
export const add_logs = (log_name, details, module, user_id) => {
    return new Promise((resolve, reject) => {
        const currentTime = Math.floor(Date.now() / 1000);
        (async () => {
            const client = await database().connect()
            try {
                const add_mhm_logs = {
                    name: 'add_mhm_logs',
                    text: query.add_mhm_logs,
                    values: [log_name, details, user_id, module, currentTime]
                }
                const sa = await client.query(add_mhm_logs);
                resolve("logs added")
            } catch (e) { 
                console.log(e)
            } finally {
                client.release();
            }
        })().catch(e => {
        })
    })
}
