import query from '../query/query';
import { database } from '../../config/dbConfig';

// add advertisement
export const create_new_advertisement = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const add_advertisement = {
                    name: 'add_advertisement',
                    text: query.add_advertisement,
                    values: [_body.company_name, _body.created_on, _body.publish_status, _body.description, _body.media, _body.thumbnail, _body.media_type, 1, _body.userid]
                }
                const comment_details = await client.query(add_advertisement);
                resolve({ code: 200, message: "Advertisement added successfully", data: comment_details.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// edit advertisement
export const update_advertisement = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const update_advertisement = {
                    name: 'update_advertisement',
                    text: query.update_advertisement,
                    values: [_body.description, _body.media, _body.thumbnail, _body.media_type, _body.created_on, _body.id, _body.company_name, _body.publish_status, _body.userid]
                }
                const comment_details = await client.query(update_advertisement);
                resolve({ code: 200, message: "Advertisement updated successfully", data: comment_details.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// list advertisements
export const list_advertisement_entries = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (_body.order_by && _body.order) {
                    var list_advertisements_query = query.list_advertisements + " ORDER BY LOWER(" + _body.order_by + ") " + _body.order + " LIMIT " + _body.limit + " OFFSET " + _body.offset;
                }
                else {
                    var list_advertisements_query = query.list_advertisements + " LIMIT " + _body.limit + " OFFSET " + _body.offset;
                }
                const list_advertisements = {
                    name: 'list_advertisements',
                    text: list_advertisements_query,
                    values: []
                }
                const count_advertisements = {
                    name: 'count_advertisements',
                    text: query.count_advertisements,
                    values: []
                }
                const advertisements = await client.query(list_advertisements);
                const advertisements_count = await client.query(count_advertisements);
                resolve({ code: 200, message: "Advertisements listed Successfully" , data: {count:advertisements_count.rows[0].count,data:advertisements.rows}});
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}


// edit advertisement
export const delete_advertisement_entry = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const delete_advertisement = {
                    name: 'delete_advertisement',
                    text: query.delete_advertisement,
                    values: [_body.id, 0, _body.userid]
                }
                const comment_details = await client.query(delete_advertisement);
                resolve({ code: 200, message: "Advertisement deleted successfully", data: comment_details.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// search advertisement
export const search_advertisement_entries = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const search_advertisements = {
                    name: 'search_advertisements',
                    text: query.search_advertisements,
                    values: ['%' + _body.key + '%']
                }
                const search_results = await client.query(search_advertisements);
                if (search_results.rows.length > 0) {
                    resolve({ code: 200, message: "Search Successful", data: search_results.rows });
                }
                else {
                    resolve({ code: 200, message: "No search results", data: "" });
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// publish advertisement
export const publish_advertisement_entry = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const publish_advertisement = {
                    name: 'publish_advertisement',
                    text: query.publish_advertisement,
                    values: [_body.id, _body.userid]
                }
                const search_results = await client.query(publish_advertisement);
                resolve({ code: 200, message: "Advertisement published Successfully", data: search_results.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

