import query from '../query/query';
import { database } from '../../config/dbConfig';

// add testimonial
export const create_new_testimonial = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const add_testimonial = {
                    name: 'add_testimonial',
                    text: query.add_testimonial,
                    values: [_body.author_name, _body.created_on, _body.publish_status, _body.description, _body.media, _body.thumbnail, _body.media_type, 1, _body.userid]
                }
                const comment_details = await client.query(add_testimonial);
                resolve({ code: 200, message: "Testimonial added successfully", data: comment_details.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// edit testimonial
export const update_testimonial = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const update_testimonial = {
                    name: 'update_testimonial',
                    text: query.update_testimonial,
                    values: [_body.description, _body.media, _body.thumbnail, _body.media_type, _body.created_on, _body.id, _body.author_name, _body.publish_status, _body.userid]
                }
                const comment_details = await client.query(update_testimonial);
                resolve({ code: 200, message: "Testimonial updated successfully", data: comment_details.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// edit testimonial
export const delete_testimonial_entry = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const delete_testimonial = {
                    name: 'delete_testimonial',
                    text: query.delete_testimonial,
                    values: [_body.id, 0, _body.userid]
                }
                const comment_details = await client.query(delete_testimonial);
                resolve({ code: 200, message: "Testimonial deleted successfully", data: comment_details.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// search testimonial
export const search_testimonial_entries = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const search_testimonial = {
                    name: 'search_testimonial',
                    text: query.search_testimonial,
                    values: ['%' + _body.key + '%']
                }
                console.log(_body)
                const search_results = await client.query(search_testimonial);
                if (search_results.rows.length > 0) {
                    resolve({ code: 200, message: "Search Successful", data: search_results.rows });
                }
                else {
                    resolve({ code: 200, message: "No search results", data: "" });
                }

            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// publish testimonial
export const publish_testimonial_entries = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                const publish_testimonial = {
                    name: 'publish_testimonial',
                    text: query.publish_testimonial,
                    values: [_body.id, _body.userid]
                }
                console.log(_body)
                const search_results = await client.query(publish_testimonial);
                resolve({ code: 200, message: "Testimonial published Successfully", data: search_results.rows[0] });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

// list testimonials
export const list_testimonial_entries = (_body) => {
    return new Promise((resolve, reject) => {
        (async () => {
            const client = await database().connect()
            try {
                if (_body.order_by && _body.order) {
                    var list_testimonial_query = query.list_testimonials + " ORDER BY LOWER(" + _body.order_by + ") " + _body.order + " LIMIT " + _body.limit + " OFFSET " + _body.offset;
                }
                else {
                    var list_testimonial_query = query.list_testimonials + " LIMIT " + _body.limit + " OFFSET " + _body.offset;
                }
                console.log(list_testimonial_query)
                const list_testimonials = {
                    name: 'list_testimonials',
                    text: list_testimonial_query,
                    values: []
                }
                const count_testimonials = {
                    name: 'count_testimonials',
                    text: query.count_testimonials,
                    values: []
                }
                console.log(list_testimonials)
                const testimonials = await client.query(list_testimonials);
                const testimonials_count = await client.query(count_testimonials);
                resolve({ code: 200, message: "Testimonials listed Successfully",data: {count:testimonials_count.rows[0].count,data:testimonials.rows} });
            } catch (e) {
                console.log(e);
                reject({ code: 400, message: "Failed. Please try again.", data: {} });
            } finally {
                client.release();
            }
        })().catch(e => {
            console.log(e)
            reject({ code: 400, message: "Failed. Please try again.", data: {} })
        })
    })
}

